/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.Serializable;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class PassThroughTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -1673997634240223449L;
    protected final int firstAffectedOrdinate;
    protected final int numTrailingOrdinates;
    protected final MathTransform subTransform;
    private PassThroughTransform inverse;

    protected PassThroughTransform(int firstAffectedOrdinate, MathTransform subTransform, int numTrailingOrdinates) {
        if (firstAffectedOrdinate < 0) {
            throw new IllegalArgumentException(Errors.format(58, "firstAffectedOrdinate", firstAffectedOrdinate));
        }
        if (numTrailingOrdinates < 0) {
            throw new IllegalArgumentException(Errors.format(58, "numTrailingOrdinates", numTrailingOrdinates));
        }
        if (subTransform instanceof PassThroughTransform) {
            PassThroughTransform passThrough = (PassThroughTransform)subTransform;
            this.firstAffectedOrdinate = passThrough.firstAffectedOrdinate + firstAffectedOrdinate;
            this.numTrailingOrdinates = passThrough.numTrailingOrdinates + numTrailingOrdinates;
            this.subTransform = passThrough.subTransform;
        } else {
            this.firstAffectedOrdinate = firstAffectedOrdinate;
            this.numTrailingOrdinates = numTrailingOrdinates;
            this.subTransform = subTransform;
        }
    }

    public static MathTransform create(int firstAffectedOrdinate, MathTransform subTransform, int numTrailingOrdinates) {
        int dimension;
        if (firstAffectedOrdinate < 0) {
            throw new IllegalArgumentException(Errors.format(58, "firstAffectedOrdinate", firstAffectedOrdinate));
        }
        if (numTrailingOrdinates < 0) {
            throw new IllegalArgumentException(Errors.format(58, "numTrailingOrdinates", numTrailingOrdinates));
        }
        if (firstAffectedOrdinate == 0 && numTrailingOrdinates == 0) {
            return subTransform;
        }
        if (subTransform.isIdentity() && (dimension = subTransform.getSourceDimensions()) == subTransform.getTargetDimensions()) {
            return IdentityTransform.create(firstAffectedOrdinate + dimension + numTrailingOrdinates);
        }
        if (subTransform instanceof LinearTransform) {
            GeneralMatrix matrix = PassThroughTransform.toGMatrix(((LinearTransform)subTransform).getMatrix());
            matrix = PassThroughTransform.expand(matrix, firstAffectedOrdinate, numTrailingOrdinates, 1);
            return ProjectiveTransform.create(matrix);
        }
        return new PassThroughTransform(firstAffectedOrdinate, subTransform, numTrailingOrdinates);
    }

    public MathTransform getSubTransform() {
        return this.subTransform;
    }

    public int[] getModifiedCoordinates() {
        int[] index = new int[this.subTransform.getSourceDimensions()];
        for (int i = 0; i < index.length; ++i) {
            index[i] = i + this.firstAffectedOrdinate;
        }
        return index;
    }

    @Override
    public int getSourceDimensions() {
        return this.firstAffectedOrdinate + this.subTransform.getSourceDimensions() + this.numTrailingOrdinates;
    }

    @Override
    public int getTargetDimensions() {
        return this.firstAffectedOrdinate + this.subTransform.getTargetDimensions() + this.numTrailingOrdinates;
    }

    @Override
    public boolean isIdentity() {
        return this.subTransform.isIdentity();
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int subDimSource = this.subTransform.getSourceDimensions();
        int subDimTarget = this.subTransform.getTargetDimensions();
        int srcStep = this.numTrailingOrdinates;
        int dstStep = this.numTrailingOrdinates;
        if (srcPts == dstPts && srcOff < dstOff) {
            int dimSource = this.getSourceDimensions();
            int dimTarget = this.getTargetDimensions();
            srcOff += numPts * dimSource;
            dstOff += numPts * dimTarget;
            srcStep -= 2 * dimSource;
            dstStep -= 2 * dimTarget;
        }
        while (--numPts >= 0) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, this.firstAffectedOrdinate);
            this.subTransform.transform(srcPts, srcOff += this.firstAffectedOrdinate, dstPts, dstOff += this.firstAffectedOrdinate, 1);
            System.arraycopy(srcPts, srcOff += subDimSource, dstPts, dstOff += subDimTarget, this.numTrailingOrdinates);
            srcOff += srcStep;
            dstOff += dstStep;
        }
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int subDimSource = this.subTransform.getSourceDimensions();
        int subDimTarget = this.subTransform.getTargetDimensions();
        int srcStep = this.numTrailingOrdinates;
        int dstStep = this.numTrailingOrdinates;
        if (srcPts == dstPts && srcOff < dstOff) {
            int dimSource = this.getSourceDimensions();
            int dimTarget = this.getTargetDimensions();
            srcOff += numPts * dimSource;
            dstOff += numPts * dimTarget;
            srcStep -= 2 * dimSource;
            dstStep -= 2 * dimTarget;
        }
        while (--numPts >= 0) {
            System.arraycopy(srcPts, srcOff, dstPts, dstOff, this.firstAffectedOrdinate);
            this.subTransform.transform(srcPts, srcOff += this.firstAffectedOrdinate, dstPts, dstOff += this.firstAffectedOrdinate, 1);
            System.arraycopy(srcPts, srcOff += subDimSource, dstPts, dstOff += subDimTarget, this.numTrailingOrdinates);
            srcOff += srcStep;
            dstOff += dstStep;
        }
    }

    @Override
    public Matrix derivative(DirectPosition point) throws TransformException {
        int nSkipped = this.firstAffectedOrdinate + this.numTrailingOrdinates;
        int transDim = this.subTransform.getSourceDimensions();
        int pointDim = point.getDimension();
        if (pointDim != transDim + nSkipped) {
            throw new MismatchedDimensionException(Errors.format(94, "point", pointDim, transDim + nSkipped));
        }
        GeneralDirectPosition subPoint = new GeneralDirectPosition(transDim);
        for (int i = 0; i < transDim; ++i) {
            subPoint.ordinates[i] = point.getOrdinate(i + this.firstAffectedOrdinate);
        }
        return PassThroughTransform.expand(PassThroughTransform.toGMatrix(this.subTransform.derivative((DirectPosition)subPoint)), this.firstAffectedOrdinate, this.numTrailingOrdinates, 0);
    }

    private static GeneralMatrix expand(GeneralMatrix subMatrix, int firstAffectedOrdinate, int numTrailingOrdinates, int affine) {
        int nSkipped = firstAffectedOrdinate + numTrailingOrdinates;
        int numRow = subMatrix.getNumRow() - affine;
        int numCol = subMatrix.getNumCol() - affine;
        GeneralMatrix matrix = new GeneralMatrix(numRow + nSkipped + affine, numCol + nSkipped + affine);
        matrix.setZero();
        for (int j = 0; j < firstAffectedOrdinate; ++j) {
            matrix.setElement(j, j, 1.0);
        }
        subMatrix.copySubMatrix(0, 0, numRow, numCol, firstAffectedOrdinate, firstAffectedOrdinate, matrix);
        int offset = numCol - numRow;
        int numRowOut = numRow + nSkipped;
        for (int j = numRowOut - numTrailingOrdinates; j < numRowOut; ++j) {
            matrix.setElement(j, j + offset, 1.0);
        }
        if (affine != 0) {
            subMatrix.copySubMatrix(0, numCol, numRow, affine, firstAffectedOrdinate, numCol + nSkipped, matrix);
            subMatrix.copySubMatrix(numRow, 0, affine, numCol, numRow + nSkipped, firstAffectedOrdinate, matrix);
            subMatrix.copySubMatrix(numRow, numCol, affine, affine, numRow + nSkipped, numCol + nSkipped, matrix);
        }
        return matrix;
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            this.inverse = new PassThroughTransform(this.firstAffectedOrdinate, this.subTransform.inverse(), this.numTrailingOrdinates);
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    public int hashCode() {
        int code = 1480877863 + this.firstAffectedOrdinate + 37 * this.numTrailingOrdinates;
        if (this.subTransform != null) {
            code ^= this.subTransform.hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            PassThroughTransform that = (PassThroughTransform)object;
            return this.firstAffectedOrdinate == that.firstAffectedOrdinate && this.numTrailingOrdinates == that.numTrailingOrdinates && Utilities.equals(this.subTransform, that.subTransform);
        }
        return false;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        formatter.append(this.firstAffectedOrdinate);
        if (this.numTrailingOrdinates != 0) {
            formatter.append(this.numTrailingOrdinates);
            formatter.setInvalidWKT(PassThroughTransform.class);
        }
        formatter.append(this.subTransform);
        return "PASSTHROUGH_MT";
    }
}

