/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.hbase;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureWriter;
import org.locationtech.geomesa.hbase.data.EmptyPlan;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreFactory$;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.hbase.data.ScanPlan;
import org.locationtech.geomesa.hbase.jobs.GeoMesaHBaseInputFormat;
import org.locationtech.geomesa.index.api.FilterStrategy;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.spark.DataStoreConnector$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.SpatialRDD$;
import org.locationtech.geomesa.spark.SpatialRDDProvider;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.io.CloseQuietly$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u00015\u0011q\u0003\u0013\"bg\u0016\u001c\u0006/\u0019;jC2\u0014F\t\u0012)s_ZLG-\u001a:\u000b\u0005\r!\u0011!\u00025cCN,'BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003+Yi\u0011\u0001B\u0005\u0003/\u0011\u0011!c\u00159bi&\fGN\u0015#E!J|g/\u001b3fe\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\u0006=\u0001!\teH\u0001\u000bG\u0006t\u0007K]8dKN\u001cHC\u0001\u0011$!\ty\u0011%\u0003\u0002#!\t9!i\\8mK\u0006t\u0007\"\u0002\u0013\u001e\u0001\u0004)\u0013A\u00029be\u0006l7\u000f\u0005\u0003'W5\"T\"A\u0014\u000b\u0005!J\u0013\u0001B;uS2T\u0011AK\u0001\u0005U\u00064\u0018-\u0003\u0002-O\t\u0019Q*\u00199\u0011\u00059\ndBA\b0\u0013\t\u0001\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003eM\u0012aa\u0015;sS:<'B\u0001\u0019\u0011!\t)\u0004(D\u00017\u0015\t9\u0014&\u0001\u0002j_&\u0011\u0011H\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\u0006w\u0001!\t\u0001P\u0001\u0004e\u0012$G#B\u001fA\u0017J3\u0006CA\u000b?\u0013\tyDA\u0001\u0006Ta\u0006$\u0018.\u00197S\t\u0012CQ!\u0011\u001eA\u0002\t\u000bAaY8oMB\u00111)S\u0007\u0002\t*\u0011\u0011)\u0012\u0006\u0003\r\u001e\u000ba\u0001[1e_>\u0004(B\u0001%\u000b\u0003\u0019\t\u0007/Y2iK&\u0011!\n\u0012\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b1S\u0004\u0019A'\u0002\u0005M\u001c\u0007C\u0001(Q\u001b\u0005y%BA\u0003H\u0013\t\tvJ\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0003Tu\u0001\u0007A+\u0001\u0005egB\u000b'/Y7t!\u0011qS+L\u0017\n\u00051\u001a\u0004\"B,;\u0001\u0004A\u0016!C8sS\u001e\fV/\u001a:z!\tIf,D\u0001[\u0015\tYF,\u0001\u0003eCR\f'BA/\u000b\u0003!9Wm\u001c;p_2\u001c\u0018BA0[\u0005\u0015\tV/\u001a:z\u0011\u0015\t\u0007\u0001\"\u0003c\u0003M\u0019wN\u001c<feR\u001c6-\u00198U_N#(/\u001b8h)\ti3\rC\u0003eA\u0002\u0007Q-\u0001\u0003tG\u0006t\u0007C\u00014k\u001b\u00059'B\u00015j\u0003\u0019\u0019G.[3oi*\u00111!R\u0005\u0003?\u001eDQ\u0001\u001c\u0001\u0005\u00025\fAa]1wKR1a.]A\u0002\u0003\u000f\u0001\"aD8\n\u0005A\u0004\"\u0001B+oSRDQaO6A\u0002I\u00042a];x\u001b\u0005!(BA\u001eP\u0013\t1HOA\u0002S\t\u0012\u0003\"\u0001_@\u000e\u0003eT!A_>\u0002\rMLW\u000e\u001d7f\u0015\taX0A\u0004gK\u0006$XO]3\u000b\u0005yT\u0011aB8qK:<\u0017n]\u0005\u0004\u0003\u0003I(!D*j[BdWMR3biV\u0014X\r\u0003\u0004\u0002\u0006-\u0004\r\u0001V\u0001\u0015oJLG/\u001a#bi\u0006\u001cFo\u001c:f!\u0006\u0014\u0018-\\:\t\r\u0005%1\u000e1\u0001.\u000359(/\u001b;f)f\u0004XMT1nK\"9\u0011Q\u0002\u0001\u0005\u0002\u0005=\u0011AC;og\u00064WmU1wKR9a.!\u0005\u0002\u0014\u0005U\u0001BB\u001e\u0002\f\u0001\u0007!\u000fC\u0004\u0002\u0006\u0005-\u0001\u0019\u0001+\t\u000f\u0005%\u00111\u0002a\u0001[\u0001")
public class HBaseSpatialRDDProvider
implements SpatialRDDProvider {
    public boolean canProcess(Map<String, Serializable> params) {
        return HBaseDataStoreFactory$.MODULE$.canProcess(params);
    }

    public SpatialRDD rdd(Configuration conf, SparkContext sc, scala.collection.immutable.Map<String, String> dsParams, Query origQuery) {
        ObjectRef sft$lzy = ObjectRef.zero();
        ObjectRef qps$lzy = ObjectRef.zero();
        ObjectRef transform$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        HBaseDataStore ds = (HBaseDataStore)DataStoreConnector$.MODULE$.loadingMap().get(dsParams);
        try {
            SpatialRDD spatialRDD;
            if (ds == null || this.org$locationtech$geomesa$spark$hbase$HBaseSpatialRDDProvider$$sft$1(origQuery, ds, sft$lzy, bitmap$0) == null || this.qps$1(origQuery, ds, qps$lzy, bitmap$0).isEmpty() || this.qps$1(origQuery, ds, qps$lzy, bitmap$0).forall((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(HBaseQueryPlan x$3) {
                    return x$3 instanceof EmptyPlan;
                }
            })) {
                spatialRDD = SpatialRDD$.MODULE$.apply(sc.emptyRDD(ClassTag$.MODULE$.apply(SimpleFeature.class)), (SimpleFeatureType)QueryHints$.MODULE$.RichHints(origQuery.getHints()).getTransformSchema().getOrElse((Function0)new scala.Serializable(this, origQuery, ds, sft$lzy, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseSpatialRDDProvider $outer;
                    private final Query origQuery$1;
                    private final HBaseDataStore ds$1;
                    private final ObjectRef sft$lzy$1;
                    private final VolatileByteRef bitmap$0$1;

                    public final SimpleFeatureType apply() {
                        return this.$outer.org$locationtech$geomesa$spark$hbase$HBaseSpatialRDDProvider$$sft$1(this.origQuery$1, this.ds$1, this.sft$lzy$1, this.bitmap$0$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.origQuery$1 = origQuery$1;
                        this.ds$1 = ds$1;
                        this.sft$lzy$1 = sft$lzy$1;
                        this.bitmap$0$1 = bitmap$0$1;
                    }
                }));
            } else {
                RDD rDD;
                if (this.qps$1(origQuery, ds, qps$lzy, bitmap$0).lengthCompare(1) == 0 && ((HBaseQueryPlan)this.qps$1(origQuery, ds, qps$lzy, bitmap$0).head()).tables().lengthCompare(1) == 0) {
                    rDD = this.org$locationtech$geomesa$spark$hbase$HBaseSpatialRDDProvider$$queryPlanToRDD$1((HBaseQueryPlan)this.qps$1(origQuery, ds, qps$lzy, bitmap$0).head(), conf, sc, origQuery, ds, sft$lzy, transform$lzy, bitmap$0);
                } else {
                    Seq expanded = (Seq)this.qps$1(origQuery, ds, qps$lzy, bitmap$0).flatMap((Function1)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Seq<HBaseQueryPlan> apply(HBaseQueryPlan x0$1) {
                            HBaseQueryPlan hBaseQueryPlan;
                            block4: {
                                Seq seq;
                                block3: {
                                    block2: {
                                        hBaseQueryPlan = x0$1;
                                        if (!(hBaseQueryPlan instanceof ScanPlan)) break block2;
                                        ScanPlan scanPlan = (ScanPlan)hBaseQueryPlan;
                                        seq = (Seq)scanPlan.tables().map((Function1)new scala.Serializable(this, scanPlan){
                                            public static final long serialVersionUID = 0L;
                                            private final ScanPlan x2$1;

                                            public final ScanPlan apply(TableName t) {
                                                Seq x$5 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TableName[]{t}));
                                                FilterStrategy x$6 = this.x2$1.copy$default$1();
                                                Seq x$7 = this.x2$1.copy$default$3();
                                                Seq x$8 = this.x2$1.copy$default$4();
                                                Function1 x$9 = this.x2$1.copy$default$5();
                                                return this.x2$1.copy(x$6, x$5, x$7, x$8, x$9);
                                            }
                                            {
                                                this.x2$1 = x2$1;
                                            }
                                        }, Seq$.MODULE$.canBuildFrom());
                                        break block3;
                                    }
                                    if (!(hBaseQueryPlan instanceof EmptyPlan)) break block4;
                                    EmptyPlan emptyPlan = (EmptyPlan)hBaseQueryPlan;
                                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EmptyPlan[]{emptyPlan}));
                                }
                                return seq;
                            }
                            throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected query plan type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{hBaseQueryPlan})));
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    rDD = sc.union((Seq)expanded.map((Function1)new scala.Serializable(this, conf, sc, origQuery, ds, sft$lzy, transform$lzy, bitmap$0){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ HBaseSpatialRDDProvider $outer;
                        private final Configuration conf$1;
                        private final SparkContext sc$1;
                        private final Query origQuery$1;
                        private final HBaseDataStore ds$1;
                        private final ObjectRef sft$lzy$1;
                        private final ObjectRef transform$lzy$1;
                        private final VolatileByteRef bitmap$0$1;

                        public final RDD<SimpleFeature> apply(HBaseQueryPlan x$4) {
                            return this.$outer.org$locationtech$geomesa$spark$hbase$HBaseSpatialRDDProvider$$queryPlanToRDD$1(x$4, new Configuration(this.conf$1), this.sc$1, this.origQuery$1, this.ds$1, this.sft$lzy$1, this.transform$lzy$1, this.bitmap$0$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.conf$1 = conf$1;
                            this.sc$1 = sc$1;
                            this.origQuery$1 = origQuery$1;
                            this.ds$1 = ds$1;
                            this.sft$lzy$1 = sft$lzy$1;
                            this.transform$lzy$1 = transform$lzy$1;
                            this.bitmap$0$1 = bitmap$0$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(SimpleFeature.class));
                }
                RDD rdd2 = rDD;
                spatialRDD = SpatialRDD$.MODULE$.apply(rdd2, (SimpleFeatureType)this.transform$1(origQuery, transform$lzy, bitmap$0).getOrElse((Function0)new scala.Serializable(this, origQuery, ds, sft$lzy, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseSpatialRDDProvider $outer;
                    private final Query origQuery$1;
                    private final HBaseDataStore ds$1;
                    private final ObjectRef sft$lzy$1;
                    private final VolatileByteRef bitmap$0$1;

                    public final SimpleFeatureType apply() {
                        return this.$outer.org$locationtech$geomesa$spark$hbase$HBaseSpatialRDDProvider$$sft$1(this.origQuery$1, this.ds$1, this.sft$lzy$1, this.bitmap$0$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.origQuery$1 = origQuery$1;
                        this.ds$1 = ds$1;
                        this.sft$lzy$1 = sft$lzy$1;
                        this.bitmap$0$1 = bitmap$0$1;
                    }
                }));
            }
            return spatialRDD;
        }
        finally {
            if (ds != null) {
                ds.dispose();
            }
        }
    }

    public String org$locationtech$geomesa$spark$hbase$HBaseSpatialRDDProvider$$convertScanToString(org.apache.hadoop.hbase.client.Query scan) {
        org.apache.hadoop.hbase.client.Query query;
        block4: {
            String string;
            block3: {
                block2: {
                    query = scan;
                    if (!(query instanceof Get)) break block2;
                    Get get = (Get)query;
                    string = Base64.encodeBytes((byte[])ProtobufUtil.toGet((Get)get).toByteArray());
                    break block3;
                }
                if (!(query instanceof Scan)) break block4;
                Scan scan2 = (Scan)query;
                string = Base64.encodeBytes((byte[])ProtobufUtil.toScan((Scan)scan2).toByteArray());
            }
            return string;
        }
        throw new MatchError((Object)query);
    }

    /*
     * WARNING - void declaration
     */
    public void save(RDD<SimpleFeature> rdd2, scala.collection.immutable.Map<String, String> writeDataStoreParams, String writeTypeName) {
        HBaseDataStore ds = (HBaseDataStore)DataStoreConnector$.MODULE$.loadingMap().get(writeDataStoreParams);
        try {
            Predef$.MODULE$.require(ds.getSchema(writeTypeName) != null, (Function0)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Feature type must exist before calling save.  Call createSchema on the DataStore first.";
                }
            });
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.dispose();
            throw throwable;
        }
        ds.dispose();
        this.unsafeSave(rdd2, writeDataStoreParams, writeTypeName);
    }

    public void unsafeSave(RDD<SimpleFeature> rdd2, scala.collection.immutable.Map<String, String> writeDataStoreParams, String writeTypeName) {
        rdd2.foreachPartition((Function1)new scala.Serializable(this, writeDataStoreParams, writeTypeName){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map writeDataStoreParams$1;
            private final String writeTypeName$1;

            /*
             * WARNING - void declaration
             */
            public final void apply(Iterator<SimpleFeature> iter) {
                HBaseDataStore ds = (HBaseDataStore)DataStoreConnector$.MODULE$.loadingMap().get((Object)this.writeDataStoreParams$1);
                SimpleFeatureWriter featureWriter = ds.getFeatureWriterAppend(this.writeTypeName$1, Transaction.AUTO_COMMIT);
                try {
                    iter.foreach((Function1)new scala.Serializable(this, featureWriter){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureWriter featureWriter$1;

                        public final void apply(SimpleFeature rawFeature) {
                            FeatureUtils$.MODULE$.copyToWriter((FeatureWriter)this.featureWriter$1, rawFeature, true);
                            this.featureWriter$1.write();
                        }
                        {
                            this.featureWriter$1 = featureWriter$1;
                        }
                    });
                }
                catch (Throwable throwable) {
                    void var2_2;
                    void var3_3;
                    CloseQuietly$.MODULE$.apply((Object)var3_3);
                    var2_2.dispose();
                    throw throwable;
                }
                CloseQuietly$.MODULE$.apply((Object)featureWriter);
                ds.dispose();
            }
            {
                this.writeDataStoreParams$1 = writeDataStoreParams$1;
                this.writeTypeName$1 = writeTypeName$1;
            }
        });
    }

    private final SimpleFeatureType sft$lzycompute$1(Query origQuery$1, HBaseDataStore ds$1, ObjectRef sft$lzy$1, VolatileByteRef bitmap$0$1) {
        HBaseSpatialRDDProvider hBaseSpatialRDDProvider = this;
        synchronized (hBaseSpatialRDDProvider) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                sft$lzy$1.elem = ds$1.getSchema(origQuery$1.getTypeName());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (SimpleFeatureType)sft$lzy$1.elem;
        }
    }

    public final SimpleFeatureType org$locationtech$geomesa$spark$hbase$HBaseSpatialRDDProvider$$sft$1(Query origQuery$1, HBaseDataStore ds$1, ObjectRef sft$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.sft$lzycompute$1(origQuery$1, ds$1, sft$lzy$1, bitmap$0$1) : (SimpleFeatureType)sft$lzy$1.elem;
    }

    private final Seq qps$lzycompute$1(Query origQuery$1, HBaseDataStore ds$1, ObjectRef qps$lzy$1, VolatileByteRef bitmap$0$1) {
        HBaseSpatialRDDProvider hBaseSpatialRDDProvider = this;
        synchronized (hBaseSpatialRDDProvider) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                origQuery$1.getHints().put((Object)QueryHints$.MODULE$.LOOSE_BBOX(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                qps$lzy$1.elem = ds$1.getQueryPlan(origQuery$1, ds$1.getQueryPlan$default$2(), ds$1.getQueryPlan$default$3());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (Seq)qps$lzy$1.elem;
        }
    }

    private final Seq qps$1(Query origQuery$1, HBaseDataStore ds$1, ObjectRef qps$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.qps$lzycompute$1(origQuery$1, ds$1, qps$lzy$1, bitmap$0$1) : (Seq)qps$lzy$1.elem;
    }

    private final Option transform$lzycompute$1(Query origQuery$1, ObjectRef transform$lzy$1, VolatileByteRef bitmap$0$1) {
        HBaseSpatialRDDProvider hBaseSpatialRDDProvider = this;
        synchronized (hBaseSpatialRDDProvider) {
            if ((byte)(bitmap$0$1.elem & 4) == 0) {
                transform$lzy$1.elem = QueryHints$.MODULE$.RichHints(origQuery$1.getHints()).getTransformSchema();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 4);
            }
            return (Option)transform$lzy$1.elem;
        }
    }

    private final Option transform$1(Query origQuery$1, ObjectRef transform$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 4) == 0 ? this.transform$lzycompute$1(origQuery$1, transform$lzy$1, bitmap$0$1) : (Option)transform$lzy$1.elem;
    }

    public final RDD org$locationtech$geomesa$spark$hbase$HBaseSpatialRDDProvider$$queryPlanToRDD$1(HBaseQueryPlan qp, Configuration conf, SparkContext sc$1, Query origQuery$1, HBaseDataStore ds$1, ObjectRef sft$lzy$1, ObjectRef transform$lzy$1, VolatileByteRef bitmap$0$1) {
        RDD rDD;
        if (qp instanceof EmptyPlan) {
            rDD = sc$1.emptyRDD(ClassTag$.MODULE$.apply(SimpleFeature.class));
        } else {
            GeoMesaConfigurator$.MODULE$.setSchema(conf, this.org$locationtech$geomesa$spark$hbase$HBaseSpatialRDDProvider$$sft$1(origQuery$1, ds$1, sft$lzy$1, bitmap$0$1));
            GeoMesaConfigurator$.MODULE$.setSerialization(conf);
            GeoMesaConfigurator$.MODULE$.setIndexIn(conf, qp.filter().index());
            GeoMesaConfigurator$.MODULE$.setTable(conf, ((TableName)qp.tables().head()).getNameAsString());
            this.transform$1(origQuery$1, transform$lzy$1, bitmap$0$1).foreach((Function1)new scala.Serializable(this, conf){
                public static final long serialVersionUID = 0L;
                private final Configuration conf$2;

                public final void apply(SimpleFeatureType x$1) {
                    GeoMesaConfigurator$.MODULE$.setTransformSchema(this.conf$2, x$1);
                }
                {
                    this.conf$2 = conf$2;
                }
            });
            Seq scans = (Seq)qp.scans().map((Function1)new scala.Serializable(this, qp){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HBaseSpatialRDDProvider $outer;
                private final HBaseQueryPlan qp$1;

                public final String apply(Scan scan) {
                    scan.setAttribute("scan.attributes.table.name", ((TableName)this.qp$1.tables().head()).getName());
                    return this.$outer.org$locationtech$geomesa$spark$hbase$HBaseSpatialRDDProvider$$convertScanToString((org.apache.hadoop.hbase.client.Query)scan);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.qp$1 = qp$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
            conf.setStrings("hbase.mapreduce.scans", (String[])scans.toArray(ClassTag$.MODULE$.apply(String.class)));
            rDD = sc$1.newAPIHadoopRDD(conf, GeoMesaHBaseInputFormat.class, Text.class, SimpleFeature.class).map((Function1)new scala.Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SimpleFeature apply(Tuple2<Text, SimpleFeature> x$2) {
                    return (SimpleFeature)x$2._2();
                }
            }, ClassTag$.MODULE$.apply(SimpleFeature.class));
        }
        return rDD;
    }
}

