/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.jobs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.MultiTableInputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.hbase.data.HBaseConnectionPool$;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex$;
import org.locationtech.geomesa.hbase.index.HBaseIndexAdapter;
import org.locationtech.geomesa.hbase.jobs.HBaseGeoMesaRecordReader;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u00015\u0011qcR3p\u001b\u0016\u001c\u0018\r\u0013\"bg\u0016Le\u000e];u\r>\u0014X.\u0019;\u000b\u0005\r!\u0011\u0001\u00026pENT!!\u0002\u0004\u0002\u000b!\u0014\u0017m]3\u000b\u0005\u001dA\u0011aB4f_6,7/\u0019\u0006\u0003\u0013)\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019A\u0003\u0003B\b\u00171yi\u0011\u0001\u0005\u0006\u0003#I\t\u0011\"\\1qe\u0016$WoY3\u000b\u0005M!\u0012A\u00025bI>|\u0007O\u0003\u0002\u0016\u0015\u00051\u0011\r]1dQ\u0016L!a\u0006\t\u0003\u0017%s\u0007/\u001e;G_Jl\u0017\r\u001e\t\u00033qi\u0011A\u0007\u0006\u00037I\t!![8\n\u0005uQ\"\u0001\u0002+fqR\u0004\"a\b\u0014\u000e\u0003\u0001R!!\t\u0012\u0002\rMLW\u000e\u001d7f\u0015\t\u0019C%A\u0004gK\u0006$XO]3\u000b\u0005\u0015R\u0011aB8qK:<\u0017n]\u0005\u0003O\u0001\u0012QbU5na2,g)Z1ukJ,\u0007CA\u00151\u001b\u0005Q#BA\u0016-\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tic&\u0001\u0005usB,7/\u00194f\u0015\u0005y\u0013aA2p[&\u0011\u0011G\u000b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u00034\u0001\u0011\u0005A'\u0001\u0004=S:LGO\u0010\u000b\u0002kA\u0011a\u0007A\u0007\u0002\u0005!9\u0001\b\u0001b\u0001\n\u0003I\u0014\u0001\u00033fY\u0016<\u0017\r^3\u0016\u0003i\u0002\"a\u000f \u000e\u0003qR!!E\u001f\u000b\u0005\u0015\u0011\u0012BA =\u0005UiU\u000f\u001c;j)\u0006\u0014G.Z%oaV$hi\u001c:nCRDa!\u0011\u0001!\u0002\u0013Q\u0014!\u00033fY\u0016<\u0017\r^3!\u0011%\u0019\u0005\u00011AA\u0002\u0013\u0005A)A\u0002tMR,\u0012!\u0012\t\u0003?\u0019K!a\u0012\u0011\u0003#MKW\u000e\u001d7f\r\u0016\fG/\u001e:f)f\u0004X\rC\u0005J\u0001\u0001\u0007\t\u0019!C\u0001\u0015\u000691O\u001a;`I\u0015\fHCA&R!\tau*D\u0001N\u0015\u0005q\u0015!B:dC2\f\u0017B\u0001)N\u0005\u0011)f.\u001b;\t\u000fIC\u0015\u0011!a\u0001\u000b\u0006\u0019\u0001\u0010J\u0019\t\rQ\u0003\u0001\u0015)\u0003F\u0003\u0011\u0019h\r\u001e\u0011\t\u0013Y\u0003\u0001\u0019!a\u0001\n\u00039\u0016!\u0002;bE2,W#\u0001-\u0011\u0005ecV\"\u0001.\u000b\u0005m#\u0011!B5oI\u0016D\u0018BA/[\u0005EA%)Y:f\u0013:$W\r_!eCB$XM\u001d\u0005\n?\u0002\u0001\r\u00111A\u0005\u0002\u0001\f\u0011\u0002^1cY\u0016|F%Z9\u0015\u0005-\u000b\u0007b\u0002*_\u0003\u0003\u0005\r\u0001\u0017\u0005\u0007G\u0002\u0001\u000b\u0015\u0002-\u0002\rQ\f'\r\\3!\u0011\u0015)\u0007\u0001\"\u0003g\u0003\u0011Ig.\u001b;\u0015\u0005-;\u0007\"\u00025e\u0001\u0004I\u0017\u0001B2p]\u001a\u0004\"A\u001b7\u000e\u0003-T!\u0001\u001b\n\n\u00055\\'!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003p\u0001\u0011\u0005\u0003/A\u0005hKR\u001c\u0006\u000f\\5ugR\u0011\u0011\u000f \t\u0004e^LX\"A:\u000b\u0005Q,\u0018\u0001B;uS2T\u0011A^\u0001\u0005U\u00064\u0018-\u0003\u0002yg\n!A*[:u!\ty!0\u0003\u0002|!\tQ\u0011J\u001c9viN\u0003H.\u001b;\t\u000but\u0007\u0019\u0001@\u0002\u000f\r|g\u000e^3yiB\u0011qb`\u0005\u0004\u0003\u0003\u0001\"A\u0003&pE\u000e{g\u000e^3yi\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0011AE2sK\u0006$XMU3d_J$'+Z1eKJ$b!!\u0003\u0002\u0010\u0005M\u0001#B\b\u0002\faq\u0012bAA\u0007!\ta!+Z2pe\u0012\u0014V-\u00193fe\"9\u0011\u0011CA\u0002\u0001\u0004I\u0018!B:qY&$\bbB?\u0002\u0004\u0001\u0007\u0011Q\u0003\t\u0004\u001f\u0005]\u0011bAA\r!\t\u0011B+Y:l\u0003R$X-\u001c9u\u0007>tG/\u001a=u\u0001")
public class GeoMesaHBaseInputFormat
extends InputFormat<Text, SimpleFeature>
implements LazyLogging {
    private final MultiTableInputFormat delegate;
    private SimpleFeatureType sft;
    private HBaseIndexAdapter table;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        GeoMesaHBaseInputFormat geoMesaHBaseInputFormat = this;
        synchronized (geoMesaHBaseInputFormat) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public MultiTableInputFormat delegate() {
        return this.delegate;
    }

    public SimpleFeatureType sft() {
        return this.sft;
    }

    public void sft_$eq(SimpleFeatureType x$1) {
        this.sft = x$1;
    }

    public HBaseIndexAdapter table() {
        return this.table;
    }

    public void table_$eq(HBaseIndexAdapter x$1) {
        this.table = x$1;
    }

    private void init(Configuration conf) {
        if (this.sft() == null) {
            this.sft_$eq(GeoMesaConfigurator$.MODULE$.getSchema(conf));
            this.table_$eq((HBaseIndexAdapter)HBaseFeatureIndex$.MODULE$.index(GeoMesaConfigurator$.MODULE$.getIndexIn(conf)));
            this.delegate().setConf(conf);
            HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
            HBaseConnectionPool$.MODULE$.configureSecurity(conf);
            conf.set("hbase.mapreduce.inputtable", GeoMesaConfigurator$.MODULE$.getTable(conf));
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<InputSplit> getSplits(JobContext context) {
        void var2_2;
        BoxedUnit boxedUnit;
        this.init(context.getConfiguration());
        List splits = this.delegate().getSplits(context);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Got {} splits", new Object[]{BoxesRunTime.boxToInteger((int)splits.size())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    public RecordReader<Text, SimpleFeature> createRecordReader(InputSplit split, TaskAttemptContext context) {
        this.init(context.getConfiguration());
        RecordReader rr = this.delegate().createRecordReader(split, context);
        Option ecql = GeoMesaConfigurator$.MODULE$.getFilter(context.getConfiguration()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeoMesaHBaseInputFormat $outer;

            public final Filter apply(String x$1) {
                return FastFilterFactory$.MODULE$.toFilter(this.$outer.sft(), x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Option transform = GeoMesaConfigurator$.MODULE$.getTransformSchema(context.getConfiguration());
        return new HBaseGeoMesaRecordReader(this.table(), this.sft(), (Option<Filter>)ecql, (Option<SimpleFeatureType>)transform, (RecordReader<ImmutableBytesWritable, Result>)rr, true);
    }

    public GeoMesaHBaseInputFormat() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.delegate = new MultiTableInputFormat();
    }
}

