/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.jobs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.geotools.data.DataStoreFinder;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseFeature;
import org.locationtech.geomesa.hbase.data.HBaseFeature$;
import org.locationtech.geomesa.hbase.jobs.HBaseIndexFileMapper$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0001\u0003\u00015\u0011A\u0003\u0013\"bg\u0016Le\u000eZ3y\r&dW-T1qa\u0016\u0014(BA\u0002\u0005\u0003\u0011QwNY:\u000b\u0005\u00151\u0011!\u00025cCN,'BA\u0004\t\u0003\u001d9Wm\\7fg\u0006T!!\u0003\u0006\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b5!\u0019ya\u0003\u0007\u0010)]5\t\u0001C\u0003\u0002\u0012%\u0005IQ.\u00199sK\u0012,8-\u001a\u0006\u0003'Q\ta\u0001[1e_>\u0004(BA\u000b\u000b\u0003\u0019\t\u0007/Y2iK&\u0011q\u0003\u0005\u0002\u0007\u001b\u0006\u0004\b/\u001a:\u0011\u0005eaR\"\u0001\u000e\u000b\u0005m\u0011\u0012AA5p\u0013\ti\"D\u0001\u0005Xe&$\u0018M\u00197f!\tyb%D\u0001!\u0015\t\t#%\u0001\u0004tS6\u0004H.\u001a\u0006\u0003G\u0011\nqAZ3biV\u0014XM\u0003\u0002&\u0015\u00059q\u000e]3oO&\u001c\u0018BA\u0014!\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKB\u0011\u0011\u0006L\u0007\u0002U)\u00111d\u000b\u0006\u0003\u000bII!!\f\u0016\u0003-%kW.\u001e;bE2,')\u001f;fg^\u0013\u0018\u000e^1cY\u0016\u0004\"a\f\u001a\u000e\u0003AR!!M\u0016\u0002\r\rd\u0017.\u001a8u\u0013\t\u0019\u0004GA\u0002QkR\u0004\"!\u000e\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005eR\u0014\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003m\n1aY8n\u0013\tidGA\u0006MCjLHj\\4hS:<\u0007\"B \u0001\t\u0003\u0001\u0015A\u0002\u001fj]&$h\bF\u0001B!\t\u0011\u0005!D\u0001\u0003\u0011%!\u0005\u00011AA\u0002\u0013%Q)\u0001\u0002egV\ta\t\u0005\u0002H\u00156\t\u0001J\u0003\u0002J\t\u0005!A-\u0019;b\u0013\tY\u0005J\u0001\bI\u0005\u0006\u001cX\rR1uCN#xN]3\t\u00135\u0003\u0001\u0019!a\u0001\n\u0013q\u0015A\u00023t?\u0012*\u0017\u000f\u0006\u0002P+B\u0011\u0001kU\u0007\u0002#*\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\n!QK\\5u\u0011\u001d1F*!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0011\u0019A\u0006\u0001)Q\u0005\r\u0006\u0019Am\u001d\u0011\t\u0013i\u0003\u0001\u0019!a\u0001\n\u0013Y\u0016aA:giV\tA\f\u0005\u0002 ;&\u0011a\f\t\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0007\"\u00031\u0001\u0001\u0004\u0005\r\u0011\"\u0003b\u0003\u001d\u0019h\r^0%KF$\"a\u00142\t\u000fY{\u0016\u0011!a\u00019\"1A\r\u0001Q!\nq\u000bAa\u001d4uA!Ia\r\u0001a\u0001\u0002\u0004%IaZ\u0001\u0007oJLG/\u001a:\u0016\u0003!\u0004B\u0001U5l]&\u0011!.\u0015\u0002\n\rVt7\r^5p]F\u0002\"a\u00127\n\u00055D%\u0001\u0004%CCN,g)Z1ukJ,\u0007cA8xu:\u0011\u0001/\u001e\b\u0003cRl\u0011A\u001d\u0006\u0003g2\ta\u0001\u0010:p_Rt\u0014\"\u0001*\n\u0005Y\f\u0016a\u00029bG.\fw-Z\u0005\u0003qf\u00141aU3r\u0015\t1\u0018\u000b\u0005\u00020w&\u0011A\u0010\r\u0002\t\u001bV$\u0018\r^5p]\"Ia\u0010\u0001a\u0001\u0002\u0004%Ia`\u0001\u000boJLG/\u001a:`I\u0015\fHcA(\u0002\u0002!9a+`A\u0001\u0002\u0004A\u0007bBA\u0003\u0001\u0001\u0006K\u0001[\u0001\boJLG/\u001a:!\u0011-\tI\u0001\u0001a\u0001\u0002\u0004%I!a\u0003\u0002\u000f]\u0014\u0018\r\u001d9feV\u0011\u0011Q\u0002\t\u0005!&t2\u000eC\u0006\u0002\u0012\u0001\u0001\r\u00111A\u0005\n\u0005M\u0011aC<sCB\u0004XM]0%KF$2aTA\u000b\u0011%1\u0016qBA\u0001\u0002\u0004\ti\u0001\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0015BA\u0007\u0003!9(/\u00199qKJ\u0004\u0003bCA\u000f\u0001\u0001\u0007\t\u0019!C\u0005\u0003?\t\u0001BZ3biV\u0014Xm]\u000b\u0003\u0003C\u00012aDA\u0012\u0013\r\t)\u0003\u0005\u0002\b\u0007>,h\u000e^3s\u0011-\tI\u0003\u0001a\u0001\u0002\u0004%I!a\u000b\u0002\u0019\u0019,\u0017\r^;sKN|F%Z9\u0015\u0007=\u000bi\u0003C\u0005W\u0003O\t\t\u00111\u0001\u0002\"!A\u0011\u0011\u0007\u0001!B\u0013\t\t#A\u0005gK\u0006$XO]3tA!Y\u0011Q\u0007\u0001A\u0002\u0003\u0007I\u0011BA\u0010\u0003\u001d)g\u000e\u001e:jKND1\"!\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002<\u0005YQM\u001c;sS\u0016\u001cx\fJ3r)\ry\u0015Q\b\u0005\n-\u0006]\u0012\u0011!a\u0001\u0003CA\u0001\"!\u0011\u0001A\u0003&\u0011\u0011E\u0001\tK:$(/[3tA!Y\u0011Q\t\u0001A\u0002\u0003\u0007I\u0011BA\u0010\u0003\u00191\u0017-\u001b7fI\"Y\u0011\u0011\n\u0001A\u0002\u0003\u0007I\u0011BA&\u0003)1\u0017-\u001b7fI~#S-\u001d\u000b\u0004\u001f\u00065\u0003\"\u0003,\u0002H\u0005\u0005\t\u0019AA\u0011\u0011!\t\t\u0006\u0001Q!\n\u0005\u0005\u0012a\u00024bS2,G\r\t\u0005\n\u0003+\u0002!\u0019!C\u0005\u0003/\nQAY=uKN,\u0012\u0001\u000b\u0005\b\u00037\u0002\u0001\u0015!\u0003)\u0003\u0019\u0011\u0017\u0010^3tA!9\u0011q\f\u0001\u0005B\u0005\u0005\u0014!B:fiV\u0004HcA(\u0002d!A\u0011QMA/\u0001\u0004\t9'A\u0004d_:$X\r\u001f;\u0011\t\u0005%\u0014q\u0010\b\u0004\u0005\u0006-taBA7\u0005!\u0005\u0011qN\u0001\u0015\u0011\n\u000b7/Z%oI\u0016Dh)\u001b7f\u001b\u0006\u0004\b/\u001a:\u0011\u0007\t\u000b\tH\u0002\u0004\u0002\u0005!\u0005\u00111O\n\u0005\u0003c\n)\bE\u0002Q\u0003oJ1!!\u001fR\u0005\u0019\te.\u001f*fM\"9q(!\u001d\u0005\u0002\u0005uDCAA8\u000b\u001d\t\t)!\u001d\u0001\u0003\u0007\u0013!\"T1q\u0007>tG/\u001a=u!\rq\u0011QQ\u0005\u0004\u0003\u000f3\"aB\"p]R,\u0007\u0010\u001e\u0005\t\u0003\u0017\u000b\t\b\"\u0001\u0002\u000e\u0006I1m\u001c8gS\u001e,(/\u001a\u000b\f\u001f\u0006=\u0015\u0011TAY\u0003k\u000bI\f\u0003\u0005\u0002\u0012\u0006%\u0005\u0019AAJ\u0003\rQwN\u0019\t\u0004\u001f\u0005U\u0015bAAL!\t\u0019!j\u001c2\t\u0011\u0005m\u0015\u0011\u0012a\u0001\u0003;\u000ba\u0001]1sC6\u001c\b\u0003CAP\u0003K\u000bY+a+\u000f\u0007A\u000b\t+C\u0002\u0002$F\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAT\u0003S\u00131!T1q\u0015\r\t\u0019+\u0015\t\u0005\u0003?\u000bi+\u0003\u0003\u00020\u0006%&AB*ue&tw\r\u0003\u0005\u00024\u0006%\u0005\u0019AAV\u0003!!\u0018\u0010]3OC6,\u0007\u0002CA\\\u0003\u0013\u0003\r!a+\u0002\u000b%tG-\u001a=\t\u0011\u0005m\u0016\u0011\u0012a\u0001\u0003{\u000baa\\;uaV$\b\u0003BA`\u0003\u000bl!!!1\u000b\u0007\u0005\r'#\u0001\u0002gg&!\u0011qYAa\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005-\u0007\u0001\"\u0011\u0002N\u000691\r\\3b]V\u0004HcA(\u0002P\"A\u0011QMAe\u0001\u0004\t9\u0007C\u0004\u0002T\u0002!\t%!6\u0002\u00075\f\u0007\u000fF\u0004P\u0003/\fY.a8\t\u000f\u0005e\u0017\u0011\u001ba\u00011\u0005\u00191.Z=\t\u000f\u0005u\u0017\u0011\u001ba\u0001=\u0005)a/\u00197vK\"A\u0011QMAi\u0001\u0004\t9\u0007")
public class HBaseIndexFileMapper
extends Mapper<Writable, SimpleFeature, ImmutableBytesWritable, Put>
implements LazyLogging {
    private HBaseDataStore ds;
    private SimpleFeatureType sft;
    private Function1<HBaseFeature, Seq<Mutation>> writer;
    private Function1<SimpleFeature, HBaseFeature> wrapper;
    private Counter features;
    private Counter org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$entries;
    private Counter failed;
    private final ImmutableBytesWritable org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$bytes;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static void configure(Job job, scala.collection.immutable.Map<String, String> map2, String string, String string2, Path path) {
        HBaseIndexFileMapper$.MODULE$.configure(job, map2, string, string2, path);
    }

    private Logger logger$lzycompute() {
        HBaseIndexFileMapper hBaseIndexFileMapper = this;
        synchronized (hBaseIndexFileMapper) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private HBaseDataStore ds() {
        return this.ds;
    }

    private void ds_$eq(HBaseDataStore x$1) {
        this.ds = x$1;
    }

    private SimpleFeatureType sft() {
        return this.sft;
    }

    private void sft_$eq(SimpleFeatureType x$1) {
        this.sft = x$1;
    }

    private Function1<HBaseFeature, Seq<Mutation>> writer() {
        return this.writer;
    }

    private void writer_$eq(Function1<HBaseFeature, Seq<Mutation>> x$1) {
        this.writer = x$1;
    }

    private Function1<SimpleFeature, HBaseFeature> wrapper() {
        return this.wrapper;
    }

    private void wrapper_$eq(Function1<SimpleFeature, HBaseFeature> x$1) {
        this.wrapper = x$1;
    }

    private Counter features() {
        return this.features;
    }

    private void features_$eq(Counter x$1) {
        this.features = x$1;
    }

    public Counter org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$entries() {
        return this.org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$entries;
    }

    private void org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$entries_$eq(Counter x$1) {
        this.org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$entries = x$1;
    }

    private Counter failed() {
        return this.failed;
    }

    private void failed_$eq(Counter x$1) {
        this.failed = x$1;
    }

    public ImmutableBytesWritable org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$bytes() {
        return this.org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$bytes;
    }

    public void setup(Mapper.Context context) {
        Some some;
        Seq seq;
        Some some2;
        scala.collection.immutable.Map params = GeoMesaConfigurator$.MODULE$.getDataStoreOutParams(context.getConfiguration());
        this.ds_$eq((HBaseDataStore)DataStoreFinder.getDataStore((java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)params)));
        Predef$.MODULE$.require(this.ds() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Could not find data store - check your configuration and hbase-site.xml";
            }
        });
        this.sft_$eq(this.ds().getSchema(GeoMesaConfigurator$.MODULE$.getFeatureTypeOut(context.getConfiguration())));
        Predef$.MODULE$.require(this.sft() != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Could not find schema - check your configuration";
            }
        });
        Option option = GeoMesaConfigurator$.MODULE$.getIndicesOut(context.getConfiguration());
        if (option instanceof Some && !(some2 = Seq$.MODULE$.unapplySeq(seq = (Seq)(some = (Some)option).x())).isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(1) == 0) {
            GeoMesaFeatureIndex geoMesaFeatureIndex;
            String idx = (String)((SeqLike)some2.get()).apply(0);
            GeoMesaFeatureIndex index = geoMesaFeatureIndex = this.ds().manager().index(idx);
            this.writer_$eq((Function1<HBaseFeature, Seq<Mutation>>)index.writer(this.sft(), (GeoMesaDataStore)this.ds()));
            this.wrapper_$eq((Function1<SimpleFeature, HBaseFeature>)HBaseFeature$.MODULE$.wrapper(this.sft()));
            this.features_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Written()));
            this.org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$entries_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), "entries"));
            this.failed_$eq(context.getCounter(GeoMesaOutputFormat.Counters$.MODULE$.Group(), GeoMesaOutputFormat.Counters$.MODULE$.Failed()));
            return;
        }
        throw new IllegalArgumentException("Could not find write index - check your configuration");
    }

    public void cleanup(Mapper.Context context) {
        this.ds().dispose();
    }

    public void map(Writable key, SimpleFeature value, Mapper.Context context) {
        try {
            HBaseFeature feature = (HBaseFeature)this.wrapper().apply((Object)value);
            ((Seq)this.writer().apply((Object)feature)).foreach((Function1)new Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HBaseIndexFileMapper $outer;
                private final Mapper.Context context$1;

                public final void apply(Put put) {
                    this.$outer.org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$bytes().set(put.getRow());
                    this.context$1.write((Object)this.$outer.org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$bytes(), (Object)put);
                    this.$outer.org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$entries().increment(1L);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }
            });
            this.features().increment(1L);
        }
        catch (Throwable throwable) {
            BoxedUnit boxedUnit;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error writing feature ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Option$.MODULE$.apply((Object)value).orNull(Predef$.MODULE$.$conforms())})), e);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.failed().increment(1L);
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        }
    }

    public HBaseIndexFileMapper() {
        LazyLogging.class.$init$((LazyLogging)this);
        this.org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$bytes = new ImmutableBytesWritable();
    }
}

