#! /usr/bin/env bash
#
# Copyright (c) 2013-2016 Commonwealth Computer Research, Inc.
# All rights reserved. This program and the accompanying materials
# are made available under the terms of the Apache License, Version 2.0 which
# accompanies this distribution and is available at
# http://www.opensource.org/licenses/apache2.0.php.
#

jline_version="2.12.1"

# Load common functions and setup
if [ -z "${GEOMESA_HBASE_HOME}" ]; then
  export GEOMESA_HBASE_HOME="$(cd "`dirname "$0"`"/..; pwd)"
fi
. $GEOMESA_HBASE_HOME/bin/common-functions.sh

install_dir="${1:-${GEOMESA_HBASE_HOME}/lib}"

# Resource download location
base_url="${GEOMESA_MAVEN_URL:-https://search.maven.org/remotecontent?filepath=}"

declare -a urls=(
  "${base_url}jline/jline/${jline_version}/jline-${jline_version}.jar"
)

echo "Warning: JLine is BSD licensed and free to use and distribute, however, the provenance of the code could not be established by the Eclipse Foundation, and thus it is not distributed with GeoMesa. However, you may download it yourself."

downloadUrls "$install_dir" urls[@]
