_geomesa-hbase(){
  local cur prev;
  COMPREPLY=();
  cur="${COMP_WORDS[COMP_CWORD]}";
  prev="${COMP_WORDS[COMP_CWORD-1]}";

  if [[ "${COMP_WORDS[1]}" == "help" ]]; then
    COMPREPLY=( $(compgen -W "bulk-ingest bulk-load create-schema delete-catalog delete-features describe-schema explain export get-sft-config get-type-names ingest keywords manage-partitions playback remove-schema stats-analyze stats-bounds stats-count stats-top-k stats-histogram version-remote convert configure classpath env gen-avro-schema help scala-console version" ${cur}));
    return 0;
  fi;

  case ${COMP_CWORD} in
    1)
      COMPREPLY=( $(compgen -W "bulk-ingest bulk-load create-schema delete-catalog delete-features describe-schema explain export get-sft-config get-type-names ingest keywords manage-partitions playback remove-schema stats-analyze stats-bounds stats-count stats-top-k stats-histogram version-remote convert configure classpath env gen-avro-schema help scala-console version" ${cur}));
      ;;
    [2-9] | [1-9][0-9])
      if [[ "${cur}" =~ ^-[a-zA-Z-]?+$ ]]; then
        case ${COMP_WORDS[1]} in
                    bulk-ingest)
              COMPREPLY=( $(compgen -W "--no-remote-filters --split-max-size --secure --converter --force --spec --input-format --feature-name --src-list --zookeepers --authorizations --output --no-tracking --threads --run-mode --index --catalog" -- ${cur}));
              return 0;
              ;;
                  bulk-load)
              COMPREPLY=( $(compgen -W "--validate --zookeepers --input --index --catalog --secure --authorizations --feature-name" -- ${cur}));
              return 0;
              ;;
                  create-schema)
              COMPREPLY=( $(compgen -W "--spec --zookeepers --compression --feature-name --catalog --no-remote-filters --secure --authorizations --use-shared-tables --dtg" -- ${cur}));
              return 0;
              ;;
                  delete-catalog)
              COMPREPLY=( $(compgen -W "--authorizations --secure --catalog --zookeepers --force" -- ${cur}));
              return 0;
              ;;
                  delete-features)
              COMPREPLY=( $(compgen -W "--zookeepers --secure --cql --feature-name --authorizations --catalog" -- ${cur}));
              return 0;
              ;;
                  describe-schema)
              COMPREPLY=( $(compgen -W "--feature-name --catalog --authorizations --zookeepers --no-remote-filters --secure" -- ${cur}));
              return 0;
              ;;
                  explain)
              COMPREPLY=( $(compgen -W "--hints --authorizations --cql --secure --feature-name --no-remote-filters --zookeepers --index --attributes --catalog" -- ${cur}));
              return 0;
              ;;
                  export)
              COMPREPLY=( $(compgen -W "--zookeepers --attributes --hints --authorizations --cql --output-format --secure --no-remote-filters --index --no-header --max-features --feature-name --output --gzip --catalog" -- ${cur}));
              return 0;
              ;;
                  get-sft-config)
              COMPREPLY=( $(compgen -W "--catalog --zookeepers --concise --exclude-user-data --feature-name --no-remote-filters --secure --format --authorizations" -- ${cur}));
              return 0;
              ;;
                  get-type-names)
              COMPREPLY=( $(compgen -W "--no-remote-filters --catalog --secure --authorizations --zookeepers" -- ${cur}));
              return 0;
              ;;
                  ingest)
              COMPREPLY=( $(compgen -W "--no-remote-filters --split-max-size --secure --converter --force --spec --input-format --feature-name --src-list --zookeepers --authorizations --no-tracking --threads --run-mode --catalog" -- ${cur}));
              return 0;
              ;;
                  keywords)
              COMPREPLY=( $(compgen -W "--feature-name --list --remove --catalog --secure --authorizations --removeAll --add --zookeepers" -- ${cur}));
              return 0;
              ;;
                  manage-partitions)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  playback)
              COMPREPLY=( $(compgen -W "--hints --cql --attributes --output-format --dtg --authorizations --interval --no-remote-filters --secure --no-header --catalog --gzip --max-features --output --zookeepers --step-window --rate --feature-name" -- ${cur}));
              return 0;
              ;;
                  remove-schema)
              COMPREPLY=( $(compgen -W "--pattern --force --catalog --authorizations --feature-name --zookeepers --secure" -- ${cur}));
              return 0;
              ;;
                  stats-analyze)
              COMPREPLY=( $(compgen -W "--authorizations --no-remote-filters --catalog --zookeepers --feature-name --secure" -- ${cur}));
              return 0;
              ;;
                  stats-bounds)
              COMPREPLY=( $(compgen -W "--attributes --catalog --no-cache --no-remote-filters --secure --cql --authorizations --feature-name --zookeepers" -- ${cur}));
              return 0;
              ;;
                  stats-count)
              COMPREPLY=( $(compgen -W "--no-remote-filters --no-cache --authorizations --cql --catalog --secure --zookeepers --feature-name" -- ${cur}));
              return 0;
              ;;
                  stats-top-k)
              COMPREPLY=( $(compgen -W "--cql --no-cache --attributes --secure --no-remote-filters --zookeepers --feature-name --authorizations --catalog" -- ${cur}));
              return 0;
              ;;
                  stats-histogram)
              COMPREPLY=( $(compgen -W "--cql --feature-name --attributes --secure --no-remote-filters --authorizations --bins --no-cache --catalog --zookeepers" -- ${cur}));
              return 0;
              ;;
                  version-remote)
              COMPREPLY=( $(compgen -W "--secure --zookeepers --authorizations --catalog" -- ${cur}));
              return 0;
              ;;
                  convert)
              COMPREPLY=( $(compgen -W "--max-features --cql --output-format --no-header --converter --output --gzip --feature-name --spec --hints" -- ${cur}));
              return 0;
              ;;
                  configure)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  classpath)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  env)
              COMPREPLY=( $(compgen -W "--concise --converters --list-sfts --describe-sfts --exclude-user-data --format --sfts --list-converters --describe-converters" -- ${cur}));
              return 0;
              ;;
                  gen-avro-schema)
              COMPREPLY=( $(compgen -W "--feature-name --spec" -- ${cur}));
              return 0;
              ;;
                  help)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  scala-console)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
                  version)
              COMPREPLY=( $(compgen -W "" -- ${cur}));
              return 0;
              ;;
              esac;
      else
        compopt -o filenames -o nospace;
        COMPREPLY=( $(compgen -f "$2") );
      fi;
      return 0;
      ;;
    *)
      COMPREPLY=();
      ;;
  esac;
};
complete -F _geomesa-hbase geomesa-hbase;
complete -F _geomesa-hbase bin/geomesa-hbase;


       