/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.metadata.iso.extent.GeographicBoundingBoxImpl;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.Command;
import org.geotools.referencing.DefaultAuthorityFactory;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DefaultEllipsoidalCS;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.projection.LambertAzimuthalEqualArea;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.PolarStereographic;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.util.CRSUtilities;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.UnsupportedImplementationException;
import org.geotools.util.Version;
import org.geotools.util.factory.Factory;
import org.geotools.util.factory.FactoryNotFoundException;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.TransformException;

public final class CRS {
    static final Logger LOGGER = Logging.getLogger(CRS.class);
    static volatile AtomicBoolean FORCED_LON_LAT = null;
    private static final Hints FORCE_LONGITUDE_FIRST_AXIS_ORDER = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
    private static CRSAuthorityFactory defaultFactory;
    private static CRSAuthorityFactory xyFactory;
    private static volatile CoordinateOperationFactory strictFactory;
    private static volatile CoordinateOperationFactory lenientFactory;
    private static SoftValueHashMap<String, CoordinateReferenceSystem> defaultCache;
    private static SoftValueHashMap<String, CoordinateReferenceSystem> xyCache;

    private CRS() {
    }

    public static synchronized CRSAuthorityFactory getAuthorityFactory(boolean longitudeFirst) throws FactoryRegistryException {
        CRSAuthorityFactory factory;
        CRSAuthorityFactory cRSAuthorityFactory = factory = longitudeFirst ? xyFactory : defaultFactory;
        if (factory == null) {
            try {
                CRS.updateForcedLonLat();
                factory = new DefaultAuthorityFactory(longitudeFirst);
                if (longitudeFirst) {
                    xyFactory = factory;
                } else {
                    defaultFactory = factory;
                }
            }
            catch (NoSuchElementException exception) {
                throw new FactoryNotFoundException(null, (Throwable)exception);
            }
        }
        return factory;
    }

    private static void updateForcedLonLat() {
        boolean forcedLonLat = false;
        try {
            forcedLonLat = Boolean.getBoolean("org.geotools.referencing.forceXY") || Boolean.TRUE.equals(Hints.getSystemDefault((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER));
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to determine if we are in forced lon/lat mode", e);
        }
        FORCED_LON_LAT = new AtomicBoolean(forcedLonLat);
    }

    private static boolean isForcedLonLat() {
        if (FORCED_LON_LAT == null) {
            CRS.updateForcedLonLat();
        }
        return FORCED_LON_LAT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CoordinateOperationFactory getCoordinateOperationFactory(boolean lenient) {
        CoordinateOperationFactory factory;
        CoordinateOperationFactory coordinateOperationFactory = factory = lenient ? lenientFactory : strictFactory;
        if (factory != null) return factory;
        Class<CRS> clazz = CRS.class;
        synchronized (CRS.class) {
            CoordinateOperationFactory coordinateOperationFactory2 = factory = lenient ? lenientFactory : strictFactory;
            if (factory != null) return factory;
            Hints hints = GeoTools.getDefaultHints();
            if (lenient) {
                hints.put((Object)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE);
            }
            factory = ReferencingFactoryFinder.getCoordinateOperationFactory(hints);
            if (lenient) {
                lenientFactory = factory;
            } else {
                strictFactory = factory;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return factory;
        }
    }

    public static Version getVersion(String authority) throws FactoryRegistryException {
        Factory factory;
        Object candidate = ReferencingFactoryFinder.getCRSAuthorityFactory(authority, null);
        HashSet<Factory> guard = new HashSet<Factory>();
        while (candidate instanceof Factory && guard.add(factory = (Factory)candidate)) {
            Map hints = factory.getImplementationHints();
            Object version = hints.get(Hints.VERSION);
            if (version instanceof Version) {
                return (Version)version;
            }
            candidate = hints.get(Hints.CRS_AUTHORITY_FACTORY);
        }
        return null;
    }

    public static Set<String> getSupportedCodes(String authority) {
        return DefaultAuthorityFactory.getSupportedCodes(authority);
    }

    public static Set<String> getSupportedAuthorities(boolean returnAliases) {
        return DefaultAuthorityFactory.getSupportedAuthorities(returnAliases);
    }

    public static CoordinateReferenceSystem decode(String code) throws NoSuchAuthorityCodeException, FactoryException {
        return CRS.decode(code, false);
    }

    public static CoordinateReferenceSystem decode(String code, boolean longitudeFirst) throws NoSuchAuthorityCodeException, FactoryException {
        code = code.trim().toUpperCase();
        CoordinateReferenceSystem result = longitudeFirst ? (CoordinateReferenceSystem)defaultCache.get((Object)code) : (CoordinateReferenceSystem)xyCache.get((Object)code);
        if (result == null) {
            result = CRS.getAuthorityFactory(longitudeFirst).createCoordinateReferenceSystem(code);
            if (longitudeFirst) {
                defaultCache.put((Object)code, (Object)result);
            } else {
                xyCache.put((Object)code, (Object)result);
            }
        }
        return result;
    }

    public static CoordinateReferenceSystem parseWKT(String wkt) throws FactoryException {
        return ReferencingFactoryFinder.getCRSFactory(null).createFromWKT(wkt);
    }

    public static Envelope getEnvelope(CoordinateReferenceSystem crs) {
        GeographicBoundingBox bounds;
        Extent domainOfValidity;
        GeneralEnvelope envelope = null;
        GeneralEnvelope merged = null;
        if (crs != null && (domainOfValidity = crs.getDomainOfValidity()) != null) {
            for (GeographicExtent extent : domainOfValidity.getGeographicElements()) {
                if (Boolean.FALSE.equals(extent.getInclusion()) || !(extent instanceof BoundingPolygon)) continue;
                for (Geometry geometry : ((BoundingPolygon)extent).getPolygons()) {
                    CoordinateReferenceSystem sourceCRS;
                    Envelope candidate = geometry.getEnvelope();
                    if (candidate == null || (sourceCRS = candidate.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(sourceCRS, crs)) continue;
                    if (envelope == null) {
                        envelope = candidate;
                        continue;
                    }
                    if (merged == null) {
                        envelope = merged = new GeneralEnvelope(envelope);
                    }
                    merged.add(envelope);
                }
            }
        }
        if (envelope == null && (bounds = CRS.getGeographicBoundingBox(crs)) != null && !Boolean.FALSE.equals(bounds.getInclusion())) {
            envelope = merged = new GeneralEnvelope(new double[]{bounds.getWestBoundLongitude(), bounds.getSouthBoundLatitude()}, new double[]{bounds.getEastBoundLongitude(), bounds.getNorthBoundLatitude()});
            SingleCRS targetCRS = CRS.getHorizontalCRS(crs);
            GeographicCRS sourceCRS = CRSUtilities.getStandardGeographicCRS2D((CoordinateReferenceSystem)targetCRS);
            merged.setCoordinateReferenceSystem((CoordinateReferenceSystem)sourceCRS);
            try {
                envelope = CRS.transform(envelope, (CoordinateReferenceSystem)targetCRS);
            }
            catch (TransformException exception) {
                envelope = null;
                CRS.unexpectedException("getEnvelope", (Exception)((Object)exception));
            }
            merged.setCoordinateReferenceSystem((CoordinateReferenceSystem)targetCRS);
        }
        return envelope;
    }

    public static GeographicBoundingBox getGeographicBoundingBox(CoordinateReferenceSystem crs) {
        Extent domainOfValidity;
        GeographicBoundingBox bounds = null;
        GeographicBoundingBoxImpl merged = null;
        if (crs != null && (domainOfValidity = crs.getDomainOfValidity()) != null) {
            for (GeographicExtent extent : domainOfValidity.getGeographicElements()) {
                if (!(extent instanceof GeographicBoundingBox)) continue;
                GeographicBoundingBox candidate = (GeographicBoundingBox)extent;
                if (bounds == null) {
                    bounds = candidate;
                    continue;
                }
                if (merged == null) {
                    merged = new GeographicBoundingBoxImpl(bounds);
                    bounds = merged;
                }
                merged.add(candidate);
            }
        }
        return bounds;
    }

    public static SingleCRS getHorizontalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof SingleCRS) {
            CoordinateSystem cs = crs.getCoordinateSystem();
            int dimension = cs.getDimension();
            if (dimension == 2) {
                CoordinateReferenceSystem base = crs;
                while (base instanceof GeneralDerivedCRS) {
                    base = ((GeneralDerivedCRS)base).getBaseCRS();
                }
                if (base instanceof GeographicCRS) {
                    return (SingleCRS)crs;
                }
                if (base.getCoordinateSystem() instanceof CartesianCS) {
                    return (SingleCRS)crs;
                }
            } else if (dimension >= 3 && crs instanceof GeographicCRS) {
                CoordinateSystemAxis axis0 = null;
                CoordinateSystemAxis axis1 = null;
                int count = 0;
                block9: for (int i = 0; i < dimension; ++i) {
                    CoordinateSystemAxis axis = cs.getAxis(i);
                    if (!DefaultCoordinateSystemAxis.isCompassDirection(axis.getDirection())) continue;
                    switch (count++) {
                        case 0: {
                            axis0 = axis;
                            continue block9;
                        }
                        case 1: {
                            axis1 = axis;
                            continue block9;
                        }
                    }
                }
                if (count == 2) {
                    GeographicCRS horizontalCRS;
                    EllipsoidalCS horizontalCS;
                    GeodeticDatum datum = ((GeographicCRS)crs).getDatum();
                    Map<String, ?> properties = CRSUtilities.changeDimensionInName((IdentifiedObject)cs, "3D", "2D");
                    try {
                        horizontalCS = ReferencingFactoryFinder.getCSFactory(null).createEllipsoidalCS(properties, axis0, axis1);
                    }
                    catch (FactoryException e) {
                        Logging.recoverableException(CRS.class, (String)"getHorizontalCRS", (Throwable)e);
                        horizontalCS = new DefaultEllipsoidalCS(properties, axis0, axis1);
                    }
                    properties = CRSUtilities.changeDimensionInName((IdentifiedObject)crs, "3D", "2D");
                    try {
                        horizontalCRS = ReferencingFactoryFinder.getCRSFactory(null).createGeographicCRS(properties, datum, horizontalCS);
                    }
                    catch (FactoryException e) {
                        Logging.recoverableException(CRS.class, (String)"getHorizontalCRS", (Throwable)e);
                        horizontalCRS = new DefaultGeographicCRS(properties, datum, horizontalCS);
                    }
                    return horizontalCRS;
                }
            }
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                SingleCRS candidate = CRS.getHorizontalCRS(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static ProjectedCRS getProjectedCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof ProjectedCRS) {
            return (ProjectedCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                ProjectedCRS candidate = CRS.getProjectedCRS(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static MapProjection getMapProjection(CoordinateReferenceSystem crs) {
        ProjectedCRS projectedCRS = CRS.getProjectedCRS(crs);
        if (projectedCRS == null) {
            return null;
        }
        Projection conversion = projectedCRS.getConversionFromBase();
        MathTransform mt = conversion.getMathTransform();
        return CRS.unrollProjection(mt);
    }

    private static MapProjection unrollProjection(MathTransform mt) {
        if (mt instanceof MapProjection) {
            return (MapProjection)mt;
        }
        if (mt instanceof ConcatenatedTransform) {
            ConcatenatedTransform ct = (ConcatenatedTransform)mt;
            MapProjection result = CRS.unrollProjection(ct.transform1);
            if (result == null) {
                result = CRS.unrollProjection(ct.transform2);
            }
            return result;
        }
        return null;
    }

    public static VerticalCRS getVerticalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof VerticalCRS) {
            return (VerticalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                VerticalCRS candidate = CRS.getVerticalCRS(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static TemporalCRS getTemporalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof TemporalCRS) {
            return (TemporalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                TemporalCRS candidate = CRS.getTemporalCRS(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem crs) {
        Datum datum = CRSUtilities.getDatum(crs);
        if (datum instanceof GeodeticDatum) {
            return ((GeodeticDatum)datum).getEllipsoid();
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS cp = (CompoundCRS)crs;
            for (CoordinateReferenceSystem c : cp.getCoordinateReferenceSystems()) {
                Ellipsoid candidate = CRS.getEllipsoid(c);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static boolean equalsIgnoreMetadata(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 instanceof AbstractIdentifiedObject && object2 instanceof AbstractIdentifiedObject) {
            return ((AbstractIdentifiedObject)object1).equals((AbstractIdentifiedObject)object2, false);
        }
        return object1 != null && object1.equals(object2);
    }

    public static boolean isTransformationRequired(CoordinateReferenceSystem source, CoordinateReferenceSystem target) throws FactoryException {
        if (source == null || target == null) {
            return false;
        }
        if (source instanceof DefaultEngineeringCRS && ((DefaultEngineeringCRS)source).isWildcard()) {
            return false;
        }
        if (target instanceof DefaultEngineeringCRS && ((DefaultEngineeringCRS)target).isWildcard()) {
            return false;
        }
        if (CRS.equalsIgnoreMetadata(source, target)) {
            return false;
        }
        MathTransform mathTransform = CRS.findMathTransform(source, target);
        return !mathTransform.isIdentity();
    }

    public static String toSRS(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return null;
        }
        if (CRS.isForcedLonLat() && CRS.getAxisOrder(crs, false) == AxisOrder.NORTH_EAST) {
            try {
                Integer code = CRS.lookupEpsgCode(crs, false);
                if (code != null) {
                    return "urn:ogc:def:crs:EPSG::" + code;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to determine EPSG code", e);
            }
        }
        if (crs == DefaultGeographicCRS.WGS84) {
            return "CRS:84";
        }
        Set identifiers = crs.getIdentifiers();
        if (identifiers.isEmpty()) {
            ReferenceIdentifier name = crs.getName();
            if (name != null) {
                return name.toString();
            }
            return null;
        }
        for (ReferenceIdentifier identifier : crs.getIdentifiers()) {
            String srs = identifier.toString();
            if (!srs.contains("EPSG:") && !srs.contains("CRS:")) continue;
            return srs;
        }
        ReferenceIdentifier name = crs.getName();
        if (name != null && (name.toString().contains("EPSG:") || name.toString().contains("CRS:"))) {
            return name.toString();
        }
        return ((ReferenceIdentifier)identifiers.iterator().next()).toString();
    }

    public static String toSRS(CoordinateReferenceSystem crs, boolean codeOnly) {
        if (crs == null) {
            return null;
        }
        String srsName = CRS.toSRS(crs);
        if (codeOnly && srsName != null) {
            int index = srsName.lastIndexOf(58);
            if (index > 0) {
                srsName = srsName.substring(index + 1).trim();
            }
            return srsName;
        }
        return srsName;
    }

    public static String lookupIdentifier(IdentifiedObject object, boolean fullScan) throws FactoryException {
        AbstractAuthorityFactory xyFactory = (AbstractAuthorityFactory)CRS.getAuthorityFactory(true);
        IdentifiedObjectFinder finder = xyFactory.getIdentifiedObjectFinder(object.getClass());
        finder.setFullScanAllowed(fullScan);
        return finder.findIdentifier(object);
    }

    public static String lookupIdentifier(Citation authority, CoordinateReferenceSystem crs, boolean fullScan) throws FactoryException {
        ReferenceIdentifier id = AbstractIdentifiedObject.getIdentifier((IdentifiedObject)crs, authority);
        if (id != null) {
            return id.getCode();
        }
        for (CRSAuthorityFactory factory : ReferencingFactoryFinder.getCRSAuthorityFactories(FORCE_LONGITUDE_FIRST_AXIS_ORDER)) {
            if (!Citations.identifierMatches((Citation)factory.getAuthority(), (Citation)authority) || factory == null || !(factory instanceof AbstractAuthorityFactory)) continue;
            AbstractAuthorityFactory f = (AbstractAuthorityFactory)factory;
            IdentifiedObjectFinder finder = f.getIdentifiedObjectFinder(crs.getClass());
            finder.setFullScanAllowed(fullScan);
            String code = finder.findIdentifier((IdentifiedObject)crs);
            if (code == null) continue;
            return code;
        }
        return null;
    }

    public static Integer lookupEpsgCode(CoordinateReferenceSystem crs, boolean fullScan) throws FactoryException {
        String identifier = CRS.lookupIdentifier(Citations.EPSG, crs, fullScan);
        if (identifier != null) {
            int split = identifier.lastIndexOf(58);
            String code = identifier.substring(split + 1);
            try {
                return Integer.parseInt(code);
            }
            catch (NumberFormatException e) {
                throw new FactoryException(Errors.format((int)67, (Object)identifier), (Throwable)e);
            }
        }
        return null;
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        return CRS.findMathTransform(sourceCRS, targetCRS, false);
    }

    public static MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws FactoryException {
        if (CRS.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
            return IdentityTransform.create(sourceCRS.getCoordinateSystem().getDimension());
        }
        CoordinateOperationFactory operationFactory = CRS.getCoordinateOperationFactory(lenient);
        return operationFactory.createOperation(sourceCRS, targetCRS).getMathTransform();
    }

    public static GeneralEnvelope transform(Envelope envelope, CoordinateReferenceSystem targetCRS) throws TransformException {
        CoordinateReferenceSystem sourceCRS;
        if (envelope != null && targetCRS != null && (sourceCRS = envelope.getCoordinateReferenceSystem()) != null) {
            if (!CRS.equalsIgnoreMetadata(sourceCRS, targetCRS)) {
                CoordinateOperation operation;
                CoordinateOperationFactory factory = CRS.getCoordinateOperationFactory(true);
                try {
                    operation = factory.createOperation(sourceCRS, targetCRS);
                }
                catch (FactoryException exception) {
                    throw new TransformException(Errors.format((int)33), (Throwable)exception);
                }
                if (!operation.getMathTransform().isIdentity()) {
                    envelope = CRS.transform(operation, envelope);
                } else if (!CRS.equalsIgnoreMetadata(envelope.getCoordinateReferenceSystem(), targetCRS)) {
                    GeneralEnvelope tx = new GeneralEnvelope(envelope);
                    tx.setCoordinateReferenceSystem(targetCRS);
                    envelope = tx;
                }
            }
            assert (CRS.equalsIgnoreMetadata(envelope.getCoordinateReferenceSystem(), targetCRS));
        }
        return GeneralEnvelope.toGeneralEnvelope(envelope);
    }

    public static GeneralEnvelope transform(MathTransform transform, Envelope envelope) throws TransformException {
        return CRS.transform(transform, envelope, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static GeneralEnvelope transform(MathTransform transform, Envelope envelope, GeneralDirectPosition targetPt) throws TransformException {
        int n;
        if (envelope == null) {
            return null;
        }
        if (transform.isIdentity()) {
            GeneralEnvelope e = new GeneralEnvelope(envelope);
            e.setCoordinateReferenceSystem(null);
            if (targetPt != null) {
                int i = envelope.getDimension();
                while (--i >= 0) {
                    targetPt.setOrdinate(i, e.getMedian(i));
                }
            }
            return e;
        }
        int sourceDim = transform.getSourceDimensions();
        if (envelope.getDimension() != sourceDim) {
            throw new MismatchedDimensionException(Errors.format((int)93, (Object)sourceDim, (Object)envelope.getDimension()));
        }
        int coordinateNumber = 0;
        GeneralEnvelope transformed = null;
        if (targetPt == null) {
            targetPt = new GeneralDirectPosition(transform.getTargetDimensions());
        }
        GeneralDirectPosition sourcePt = new GeneralDirectPosition(sourceDim);
        int i = sourceDim;
        while (--i >= 0) {
            sourcePt.setOrdinate(i, envelope.getMinimum(i));
        }
        block9: while (true) {
            if (targetPt != transform.transform((DirectPosition)sourcePt, (DirectPosition)targetPt)) {
                throw new UnsupportedImplementationException(transform.getClass());
            }
            if (transformed != null) {
                transformed.add(targetPt);
            } else {
                transformed = new GeneralEnvelope(targetPt, targetPt);
            }
            n = ++coordinateNumber;
            int i2 = sourceDim;
            block10: while (true) {
                if (--i2 < 0) {
                    return transformed;
                }
                switch (n % 5) {
                    case 0: {
                        sourcePt.setOrdinate(i2, envelope.getMinimum(i2));
                        n /= 5;
                        continue block10;
                    }
                    case 1: {
                        sourcePt.setOrdinate(i2, envelope.getMaximum(i2));
                        continue block9;
                    }
                    case 2: {
                        sourcePt.setOrdinate(i2, (envelope.getMinimum(i2) + envelope.getMedian(i2)) / 2.0);
                        continue block9;
                    }
                    case 3: {
                        sourcePt.setOrdinate(i2, (envelope.getMedian(i2) + envelope.getMaximum(i2)) / 2.0);
                        continue block9;
                    }
                    case 4: {
                        sourcePt.setOrdinate(i2, envelope.getMedian(i2));
                        continue block9;
                    }
                }
                break;
            }
            break;
        }
        throw new AssertionError(n);
    }

    public static GeneralEnvelope transform(CoordinateOperation operation, Envelope envelope) throws TransformException {
        MapProjection targetProjection;
        ParameterValue fn;
        double originY;
        ParameterValue fe;
        double originX;
        DirectPosition2D origin;
        CoordinateReferenceSystem targetCRS;
        CoordinateSystem cs;
        CoordinateReferenceSystem crs;
        if (envelope == null) {
            return null;
        }
        CoordinateReferenceSystem sourceCRS = operation.getSourceCRS();
        if (sourceCRS != null && (crs = envelope.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(crs, sourceCRS)) {
            throw new MismatchedReferenceSystemException(Errors.format((int)92));
        }
        MathTransform mt = operation.getMathTransform();
        GeneralDirectPosition centerPt = new GeneralDirectPosition(mt.getTargetDimensions());
        GeneralEnvelope transformed = CRS.transform(mt, envelope, centerPt);
        if (sourceCRS != null && (cs = sourceCRS.getCoordinateSystem()) != null) {
            GeneralDirectPosition sourcePt = null;
            DirectPosition targetPt = null;
            int dimension = cs.getDimension();
            for (int i = 0; i < dimension; ++i) {
                boolean b2;
                CoordinateSystemAxis axis = cs.getAxis(i);
                if (axis == null) continue;
                double min = envelope.getMinimum(i);
                double max = envelope.getMaximum(i);
                double v1 = axis.getMinimumValue();
                double v2 = axis.getMaximumValue();
                boolean b1 = v1 > min && v1 < max;
                boolean bl = b2 = v2 > min && v2 < max;
                if (!b1 && !b2) continue;
                if (sourcePt == null) {
                    sourcePt = new GeneralDirectPosition(dimension);
                    for (int j = 0; j < dimension; ++j) {
                        sourcePt.setOrdinate(j, envelope.getMedian(j));
                    }
                }
                if (b1) {
                    sourcePt.setOrdinate(i, v1);
                    targetPt = mt.transform((DirectPosition)sourcePt, targetPt);
                    transformed.add(targetPt);
                }
                if (b2) {
                    sourcePt.setOrdinate(i, v2);
                    targetPt = mt.transform((DirectPosition)sourcePt, targetPt);
                    transformed.add(targetPt);
                }
                sourcePt.setOrdinate(i, envelope.getMedian(i));
            }
        }
        if ((targetCRS = operation.getTargetCRS()) == null) {
            return transformed;
        }
        GeneralEnvelope generalEnvelope = CRS.toGeneralEnvelope(envelope);
        MapProjection sourceProjection = CRS.getMapProjection(sourceCRS);
        if ((sourceProjection instanceof PolarStereographic || sourceProjection instanceof LambertAzimuthalEqualArea) && CRS.isPole(origin = new DirectPosition2D(originX = (fe = sourceProjection.getParameterValues().parameter(MapProjection.AbstractProvider.FALSE_EASTING.getName().getCode())).doubleValue(), originY = (fn = sourceProjection.getParameterValues().parameter(MapProjection.AbstractProvider.FALSE_NORTHING.getName().getCode())).doubleValue()), sourceCRS)) {
            DirectPosition uc;
            if (generalEnvelope.contains(origin)) {
                if (targetCRS instanceof GeographicCRS) {
                    DirectPosition lowerCorner = transformed.getLowerCorner();
                    if (CRS.getAxisOrder(targetCRS) == AxisOrder.NORTH_EAST) {
                        lowerCorner.setOrdinate(1, -180.0);
                        transformed.add(lowerCorner);
                        lowerCorner.setOrdinate(1, 180.0);
                        transformed.add(lowerCorner);
                    } else {
                        lowerCorner.setOrdinate(0, -180.0);
                        transformed.add(lowerCorner);
                        lowerCorner.setOrdinate(0, 180.0);
                        transformed.add(lowerCorner);
                    }
                } else {
                    DirectPosition lc = transformed.getLowerCorner();
                    uc = transformed.getUpperCorner();
                    for (int j = -180; j < 180; ++j) {
                        CRS.expandEnvelopeByLongitude(j, lc, transformed, targetCRS);
                        CRS.expandEnvelopeByLongitude(j, uc, transformed, targetCRS);
                    }
                }
            } else {
                if (generalEnvelope.getMinimum(0) < originX && generalEnvelope.getMaximum(0) > originX) {
                    DirectPosition lc = generalEnvelope.getLowerCorner();
                    lc.setOrdinate(0, originX);
                    mt.transform(lc, lc);
                    transformed.add(lc);
                    uc = generalEnvelope.getUpperCorner();
                    uc.setOrdinate(0, originX);
                    mt.transform(uc, uc);
                    transformed.add(uc);
                }
                if (generalEnvelope.getMinimum(1) < originY && generalEnvelope.getMaximum(1) > originY) {
                    DirectPosition lc = generalEnvelope.getLowerCorner();
                    lc.setOrdinate(1, originY);
                    mt.transform(lc, lc);
                    transformed.add(lc);
                    uc = generalEnvelope.getUpperCorner();
                    uc.setOrdinate(1, originY);
                    mt.transform(uc, uc);
                    transformed.add(uc);
                }
            }
        }
        if ((targetProjection = CRS.getMapProjection(targetCRS)) instanceof PolarStereographic && sourceCRS instanceof GeographicCRS) {
            CoordinateSystem sourceCS = sourceCRS.getCoordinateSystem();
            for (int i = 0; i < sourceCS.getDimension(); ++i) {
                CoordinateSystemAxis axis = sourceCS.getAxis(i);
                if (!CRS.equalsIgnoreMetadata(DefaultCoordinateSystemAxis.LONGITUDE, axis)) continue;
                double minLon = envelope.getMinimum(i);
                double maxLon = envelope.getMaximum(i);
                if (!(maxLon - minLon >= 360.0)) continue;
                DirectPosition lower = generalEnvelope.getLowerCorner();
                DirectPosition upper = generalEnvelope.getUpperCorner();
                DirectPosition2D dest = new DirectPosition2D();
                for (int lon = -180; lon <= 180; lon += 90) {
                    lower.setOrdinate(i, (double)lon);
                    mt.transform(lower, (DirectPosition)dest);
                    transformed.add(dest);
                    upper.setOrdinate(i, (double)lon);
                    mt.transform(upper, (DirectPosition)dest);
                    transformed.add(dest);
                }
            }
        }
        transformed.setCoordinateReferenceSystem(targetCRS);
        CoordinateSystem targetCS = targetCRS.getCoordinateSystem();
        if (targetCS == null) {
            return transformed;
        }
        DirectPosition sourcePt = null;
        GeneralDirectPosition targetPt = null;
        int dimension = targetCS.getDimension();
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis axis = targetCS.getAxis(i);
            if (axis == null) continue;
            boolean testMax = false;
            do {
                double extremum;
                double d = extremum = testMax ? axis.getMaximumValue() : axis.getMinimumValue();
                if (Double.isInfinite(extremum) || Double.isNaN(extremum)) continue;
                if (targetPt == null) {
                    try {
                        mt = mt.inverse();
                    }
                    catch (NoninvertibleTransformException exception) {
                        if (dimension >= mt.getSourceDimensions()) {
                            CRS.unexpectedException("transform", (Exception)((Object)exception));
                        }
                        return transformed;
                    }
                    targetPt = new GeneralDirectPosition(mt.getSourceDimensions());
                    for (int j = 0; j < dimension; ++j) {
                        targetPt.setOrdinate(j, centerPt.getOrdinate(j));
                    }
                }
                targetPt.setOrdinate(i, extremum);
                try {
                    sourcePt = mt.transform(targetPt, sourcePt);
                }
                catch (Exception e) {
                    continue;
                }
                if (!generalEnvelope.contains(sourcePt)) continue;
                transformed.add(targetPt);
            } while (testMax = !testMax);
            if (targetPt == null) continue;
            targetPt.setOrdinate(i, centerPt.getOrdinate(i));
        }
        if (targetProjection != null) {
            CRS.getProjectionCenterLonLat(targetCRS, centerPt);
            if (CRS.isPole(centerPt, DefaultGeographicCRS.WGS84)) {
                try {
                    Envelope geoEnvelope;
                    MathTransform geoToTarget;
                    if (sourceCRS instanceof GeographicCRS) {
                        geoToTarget = CRS.findMathTransform(sourceCRS, targetCRS);
                        geoEnvelope = envelope;
                    } else {
                        MathTransform mtWgs84 = CRS.findMathTransform(sourceCRS, DefaultGeographicCRS.WGS84);
                        geoToTarget = CRS.findMathTransform(DefaultGeographicCRS.WGS84, targetCRS);
                        geoEnvelope = CRS.transform(mtWgs84, envelope, null);
                    }
                    CRS.expandEnvelopeOnExtremePoints(centerPt, transformed, geoToTarget, geoEnvelope);
                    if (targetProjection instanceof PolarStereographic || targetProjection instanceof LambertAzimuthalEqualArea) {
                        centerPt.setOrdinate(0, CRS.rollLongitude(centerPt.getOrdinate(0) - 90.0));
                        CRS.expandEnvelopeOnExtremePoints(centerPt, transformed, geoToTarget, geoEnvelope);
                        centerPt.setOrdinate(0, CRS.rollLongitude(centerPt.getOrdinate(0) - 90.0));
                        CRS.expandEnvelopeOnExtremePoints(centerPt, transformed, geoToTarget, geoEnvelope);
                        centerPt.setOrdinate(0, CRS.rollLongitude(centerPt.getOrdinate(0) - 90.0));
                        CRS.expandEnvelopeOnExtremePoints(centerPt, transformed, geoToTarget, geoEnvelope);
                    }
                }
                catch (FactoryException | TransformException e) {
                    LOGGER.log(Level.FINE, "Failed to transform from source to WGS84 to further enlarge the envelope on extreme points, proceeding without expansion", e);
                }
            }
        }
        return transformed;
    }

    private static double rollLongitude(double x) {
        double rolled = x - (double)((int)(x + Math.signum(x) * 180.0) / 360) * 360.0;
        return rolled;
    }

    private static void expandEnvelopeOnExtremePoints(GeneralDirectPosition centerPt, GeneralEnvelope transformed, MathTransform geoToTarget, Envelope geoEnvelope) throws TransformException {
        double centerLat;
        GeneralDirectPosition workPoint = new GeneralDirectPosition(centerPt.getDimension());
        double centerLon = centerPt.getOrdinate(0);
        double minLon = geoEnvelope.getMinimum(0);
        double maxLon = geoEnvelope.getMaximum(0);
        double minLat = geoEnvelope.getMinimum(1);
        double maxLat = geoEnvelope.getMaximum(1);
        if (minLon <= centerLon && centerLon <= maxLon) {
            CRS.includeTransformedPoint(transformed, geoToTarget, workPoint, centerLon, minLat);
            CRS.includeTransformedPoint(transformed, geoToTarget, workPoint, centerLon, maxLat);
        }
        if (minLat <= (centerLat = centerPt.getOrdinate(1)) && centerLat <= maxLat) {
            CRS.includeTransformedPoint(transformed, geoToTarget, workPoint, minLon, centerLat);
            CRS.includeTransformedPoint(transformed, geoToTarget, workPoint, maxLon, centerLat);
        }
    }

    private static void includeTransformedPoint(GeneralEnvelope envelope, MathTransform mt, GeneralDirectPosition workPoint, double x, double y) throws TransformException {
        workPoint.setOrdinate(0, x);
        workPoint.setOrdinate(1, y);
        mt.transform((DirectPosition)workPoint, (DirectPosition)workPoint);
        envelope.add(workPoint);
    }

    private static GeneralDirectPosition getProjectionCenterLonLat(CoordinateReferenceSystem crs, GeneralDirectPosition centerPt) {
        centerPt.setOrdinate(0, 0.0);
        centerPt.setOrdinate(1, 0.0);
        MapProjection projection = CRS.getMapProjection(crs);
        if (projection == null) {
            return centerPt;
        }
        for (GeneralParameterValue gpv : projection.getParameterValues().values()) {
            if (!(gpv instanceof ParameterValue)) continue;
            ParameterValue pv = (ParameterValue)gpv;
            ReferenceIdentifier pvName = pv.getDescriptor().getName();
            if (MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN.getName().equals(pvName)) {
                centerPt.setOrdinate(1, pv.doubleValue());
                continue;
            }
            if (MapProjection.AbstractProvider.LATITUDE_OF_CENTRE.getName().equals(pvName)) {
                centerPt.setOrdinate(1, pv.doubleValue());
                continue;
            }
            if (MapProjection.AbstractProvider.LONGITUDE_OF_CENTRE.getName().equals(pvName)) {
                centerPt.setOrdinate(0, pv.doubleValue());
                continue;
            }
            if (!MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().equals(pvName)) continue;
            centerPt.setOrdinate(0, pv.doubleValue());
        }
        return centerPt;
    }

    private static boolean isPole(DirectPosition point, CoordinateReferenceSystem crs) {
        GeographicCRS geographic;
        DirectPosition2D result;
        block5: {
            result = new DirectPosition2D();
            try {
                ProjectedCRS projectedCRS = CRS.getProjectedCRS(crs);
                if (projectedCRS != null) {
                    geographic = projectedCRS.getBaseCRS();
                    MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)projectedCRS, (CoordinateReferenceSystem)geographic);
                    mt.transform(point, (DirectPosition)result);
                    break block5;
                }
                if (crs instanceof GeographicCRS) {
                    result = point;
                    geographic = (GeographicCRS)crs;
                    break block5;
                }
                return false;
            }
            catch (MismatchedDimensionException | FactoryException | TransformException e) {
                return false;
            }
        }
        double EPS = 1.0E-6;
        if (CRS.getAxisOrder((CoordinateReferenceSystem)geographic) == AxisOrder.NORTH_EAST) {
            return Math.abs(result.getOrdinate(0) - 90.0) < 1.0E-6 || Math.abs(result.getOrdinate(0) + 90.0) < 1.0E-6;
        }
        return Math.abs(result.getOrdinate(1) - 90.0) < 1.0E-6 || Math.abs(result.getOrdinate(1) + 90.0) < 1.0E-6;
    }

    private static void expandEnvelopeByLongitude(double longitude, DirectPosition input, GeneralEnvelope transformed, CoordinateReferenceSystem sourceCRS) {
        try {
            MathTransform mt = CRS.findMathTransform(sourceCRS, DefaultGeographicCRS.WGS84);
            DirectPosition2D pos = new DirectPosition2D(sourceCRS);
            mt.transform(input, (DirectPosition)pos);
            pos.setOrdinate(0, longitude);
            mt.inverse().transform((DirectPosition)pos, (DirectPosition)pos);
            transformed.add(pos);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINER, "Tried to expand target envelope to include longitude " + longitude + " but failed. This is not necesseraly and issue, this is a best effort attempt to handle the polar stereographic pole singularity during reprojection", e);
        }
    }

    private static GeneralEnvelope toGeneralEnvelope(Envelope envelope) {
        GeneralEnvelope generalEnvelope = envelope instanceof GeneralEnvelope ? (GeneralEnvelope)envelope : new GeneralEnvelope(envelope);
        return generalEnvelope;
    }

    public static Rectangle2D transform(MathTransform2D transform, Rectangle2D envelope, Rectangle2D destination) throws TransformException {
        return CRS.transform(transform, envelope, destination, new Point2D.Double());
    }

    private static Rectangle2D transform(MathTransform2D transform, Rectangle2D envelope, Rectangle2D destination, Point2D.Double point) throws TransformException {
        if (envelope == null) {
            return null;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        for (int i = 0; i <= 8; ++i) {
            point.x = (i & 1) == 0 ? envelope.getMinX() : envelope.getMaxX();
            point.y = (i & 2) == 0 ? envelope.getMinY() : envelope.getMaxY();
            switch (i) {
                case 5: 
                case 6: {
                    point.x = envelope.getCenterX();
                    break;
                }
                case 8: {
                    point.x = envelope.getCenterX();
                }
                case 4: 
                case 7: {
                    point.y = envelope.getCenterY();
                }
            }
            if (point != transform.transform((Point2D)point, (Point2D)point)) {
                throw new UnsupportedImplementationException(transform.getClass());
            }
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (!(point.y > ymax)) continue;
            ymax = point.y;
        }
        if (destination != null) {
            destination.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
        } else {
            destination = XRectangle2D.createFromExtremums(xmin, ymin, xmax, ymax);
        }
        assert (destination == envelope || !(destination instanceof Rectangle2D.Double) && !(destination instanceof Rectangle2D.Float) || XRectangle2D.equalsEpsilon(destination, CRS.transform((MathTransform)transform, (Envelope)new Envelope2D(null, envelope)).toRectangle2D())) : destination;
        return destination;
    }

    public static Rectangle2D transform(CoordinateOperation operation, Rectangle2D envelope, Rectangle2D destination) throws TransformException {
        if (envelope == null) {
            return null;
        }
        GeneralEnvelope result = CRS.transform(operation, (Envelope)new GeneralEnvelope(envelope));
        if (destination == null) {
            return result.toRectangle2D();
        }
        destination.setFrame(result.getMinimum(0), result.getMinimum(1), result.getSpan(0), result.getSpan(1));
        return destination;
    }

    static void unexpectedException(String methodName, Exception exception) {
        Logging.unexpectedException(CRS.class, (String)methodName, (Throwable)exception);
    }

    public static void reset(String aspects) {
        StringTokenizer tokens = new StringTokenizer(aspects, ", \t\n\r\f");
        while (tokens.hasMoreTokens()) {
            String aspect = tokens.nextToken().trim();
            boolean all = aspect.equalsIgnoreCase("all");
            if (all || aspect.equalsIgnoreCase("plugins")) {
                ReferencingFactoryFinder.reset();
                ReferencingFactoryFinder.scanForPlugins();
            }
            if (!all && !aspect.equalsIgnoreCase("warnings")) continue;
            MapProjection.resetWarnings();
        }
        xyCache.clear();
        defaultCache.clear();
        FORCED_LON_LAT = null;
        defaultFactory = null;
        xyFactory = null;
        strictFactory = null;
        lenientFactory = null;
    }

    public static void cleanupThreadLocals() {
        DefaultMathTransformFactory.cleanupThreadLocals();
        Formattable.cleanupThreadLocals();
    }

    public static AxisOrder getAxisOrder(CoordinateReferenceSystem crs) {
        return CRS.getAxisOrder(crs, false);
    }

    public static AxisOrder getAxisOrder(CoordinateReferenceSystem crs, boolean useBaseGeoCRS) {
        CoordinateSystem cs = null;
        if (crs instanceof ProjectedCRS) {
            cs = !useBaseGeoCRS ? crs.getCoordinateSystem() : ((ProjectedCRS)crs).getBaseCRS().getCoordinateSystem();
        } else if (crs instanceof GeographicCRS) {
            cs = crs.getCoordinateSystem();
        } else {
            return AxisOrder.INAPPLICABLE;
        }
        int dimension = cs.getDimension();
        int longitudeDim = -1;
        int latitudeDim = -1;
        for (int i = 0; i < dimension; ++i) {
            AxisDirection dir = cs.getAxis(i).getDirection().absolute();
            if (dir.equals((Object)AxisDirection.EAST)) {
                longitudeDim = i;
            }
            if (!dir.equals((Object)AxisDirection.NORTH)) continue;
            latitudeDim = i;
        }
        if (longitudeDim >= 0 && latitudeDim >= 0) {
            if (longitudeDim < latitudeDim) {
                return AxisOrder.EAST_NORTH;
            }
            return AxisOrder.NORTH_EAST;
        }
        return AxisOrder.INAPPLICABLE;
    }

    public static void main(String[] args) {
        Command.execute(args);
    }

    static {
        defaultCache = new SoftValueHashMap();
        xyCache = new SoftValueHashMap();
        GeoTools.addChangeListener((ChangeListener)new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent e) {
                Class<CRS> clazz = CRS.class;
                synchronized (CRS.class) {
                    defaultFactory = null;
                    xyFactory = null;
                    strictFactory = null;
                    lenientFactory = null;
                    xyCache.clear();
                    defaultCache.clear();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    public static enum AxisOrder {
        EAST_NORTH,
        NORTH_EAST,
        INAPPLICABLE;

        public static AxisOrder LON_LAT;
        public static AxisOrder LAT_LON;

        static {
            LON_LAT = EAST_NORTH;
            LAT_LON = NORTH_EAST;
        }
    }
}

