/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.FeatureBuilder;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;

public class ComplexFeatureBuilder
extends FeatureBuilder<FeatureType, Feature> {
    Map<Name, ArrayList<Property>> values = new HashMap<Name, ArrayList<Property>>();
    AttributeDescriptor ad = null;

    public ComplexFeatureBuilder(FeatureType featureType) {
        this(featureType, CommonFactoryFinder.getFeatureFactory(null));
    }

    protected ComplexFeatureBuilder(FeatureType featureType, FeatureFactory factory) {
        super(featureType, factory);
    }

    public ComplexFeatureBuilder(AttributeDescriptor ad) {
        this(ad, CommonFactoryFinder.getFeatureFactory(null));
    }

    protected ComplexFeatureBuilder(AttributeDescriptor ad, FeatureFactory factory) {
        super((FeatureType)ad.getType(), factory);
        this.ad = ad;
    }

    @Override
    public Feature buildFeature(String id) {
        id = id == null ? FeatureBuilder.createDefaultFeatureId() : id;
        for (PropertyDescriptor propertyDescriptor : this.featureType.getDescriptors()) {
            Name name = propertyDescriptor.getName();
            if (!this.values.containsKey(name)) {
                this.values.put(name, new ArrayList());
            }
            List properties = this.values.get(name);
            int minOccurs = propertyDescriptor.getMinOccurs();
            int numberOfProperties = properties.size();
            if (numberOfProperties >= minOccurs) continue;
            if (propertyDescriptor.isNillable() && AttributeDescriptor.class.isAssignableFrom(propertyDescriptor.getClass())) {
                do {
                    AttributeImpl nullProperty = new AttributeImpl(propertyDescriptor.getType().getBinding().cast(null), (AttributeDescriptor)propertyDescriptor, null);
                    properties.add(nullProperty);
                } while (++numberOfProperties < minOccurs);
                continue;
            }
            throw new IllegalStateException(String.format("Failed to build feature '%s'; its property '%s' requires at least %s occurrence(s) but number of occurrences was %s.", this.featureType.getName(), name, minOccurs, numberOfProperties));
        }
        ArrayList properties = new ArrayList();
        for (Name key : this.values.keySet()) {
            properties.addAll(this.values.get(key));
        }
        this.values.clear();
        if (this.ad != null) {
            return this.factory.createFeature(properties, this.ad, id);
        }
        return this.factory.createFeature(properties, this.featureType, id);
    }

    public void append(Name name, Property value) {
        ArrayList<Object> valueList;
        PropertyDescriptor propertyDescriptor = this.featureType.getDescriptor(name);
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("The name '%s' is not a valid descriptor name for the type '%s'.", name, this.featureType.getName()));
        }
        Class expectedClass = propertyDescriptor.getType().getBinding();
        if (value != null) {
            Class providedClass = value.getType().getBinding();
            if (!providedClass.equals(expectedClass) && !expectedClass.isAssignableFrom(providedClass)) {
                throw new IllegalArgumentException(String.format("The value provided contains an object of '%s' but the method expects an object of '%s'.", providedClass, expectedClass));
            }
        } else {
            value = propertyDescriptor.isNillable() ? (Property)expectedClass.cast(null) : (Property)expectedClass.cast(null);
        }
        if (this.values.containsKey(name)) {
            valueList = this.values.get(name);
            int maxOccurs = propertyDescriptor.getMaxOccurs();
            if (valueList.size() == maxOccurs) {
                throw new IndexOutOfBoundsException(String.format("You can't add another object with the name of '%s' because you already have the maximum number (%s) allowed by the property descriptor.", name, maxOccurs));
            }
        } else {
            valueList = new ArrayList();
            this.values.put(name, valueList);
        }
        valueList.add(value);
    }
}

