/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.data;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Connection;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.locationtech.geomesa.hbase.data.HBaseConnectionPool;
import org.locationtech.geomesa.hbase.data.HBaseConnectionPool$;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreFactory$;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreParams$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.utils.audit.AuditLogger$;
import org.locationtech.geomesa.utils.audit.AuditProvider;
import org.locationtech.geomesa.utils.audit.AuditWriter;
import org.locationtech.geomesa.utils.audit.NoOpAuditProvider$;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.GeoMesaParam;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u00115c\u0001B\u0001\u0003\u00015\u0011Q\u0003\u0013\"bg\u0016$\u0015\r^1Ti>\u0014XMR1di>\u0014\u0018P\u0003\u0002\u0004\t\u0005!A-\u0019;b\u0015\t)a!A\u0003iE\u0006\u001cXM\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f-u\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/mi\u0011\u0001\u0007\u0006\u0003\u0007eQ!A\u0007\u0006\u0002\u0011\u001d,w\u000e^8pYNL!\u0001\b\r\u0003'\u0011\u000bG/Y*u_J,g)Y2u_JL8\u000b]5\u0011\u0005y)S\"A\u0010\u000b\u0005\u0001\n\u0013\u0001D:dC2\fGn\\4hS:<'B\u0001\u0012$\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0013\u0002\u0007\r|W.\u0003\u0002'?\tYA*\u0019>z\u0019><w-\u001b8h\u0011\u0015A\u0003\u0001\"\u0001*\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002,\u00015\t!\u0001C\u0003.\u0001\u0011\u0005c&\u0001\nde\u0016\fG/\u001a(fo\u0012\u000bG/Y*u_J,GCA\u00183!\t9\u0002'\u0003\u000221\tIA)\u0019;b'R|'/\u001a\u0005\u0006g1\u0002\r\u0001N\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\tUB$\bR\u0007\u0002m)\u0011qGE\u0001\u0005kRLG.\u0003\u0002:m\t\u0019Q*\u00199\u0011\u0005m\neB\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k\u0014A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\u001f\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d\u0013\u0012AA5p\u0013\tIeI\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003L\u0001\u0011\u0005C*A\bde\u0016\fG/\u001a#bi\u0006\u001cFo\u001c:f)\tyS\nC\u00034\u0015\u0002\u0007A\u0007C\u0003P\u0001\u0011E\u0001+\u0001\u0006hKR\u001c\u0015\r^1m_\u001e$\"AO)\t\u000bMr\u0005\u0019\u0001\u001b\t\u000bM\u0003A\u0011\u0003+\u0002\u001d\t,\u0018\u000e\u001c3ECR\f7\u000b^8sKR\u0019Q\u000b\u00178\u0011\u0005-2\u0016BA,\u0003\u00059A%)Y:f\t\u0006$\u0018m\u0015;pe\u0016DQ!\u0017*A\u0002i\u000b!bY8o]\u0016\u001cG/[8o!\tY6N\u0004\u0002]S:\u0011Q\f\u001b\b\u0003=\u001et!a\u00184\u000f\u0005\u0001,gBA1e\u001b\u0005\u0011'BA2\r\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002\n\u0015%\u0011q\u0001C\u0005\u0003\u000b\u0019I!a\u0001\u0003\n\u0005)\u0014\u0011a\u0005%CCN,7i\u001c8oK\u000e$\u0018n\u001c8Q_>d\u0017B\u00017n\u0005E\u0019uN\u001c8fGRLwN\\,sCB\u0004XM\u001d\u0006\u0003U\nAQa\u001c*A\u0002A\faaY8oM&<\u0007cA9\u0002R:\u0011AL]\u0004\u0006g\nA\t\u0001^\u0001\u0016\u0011\n\u000b7/\u001a#bi\u0006\u001cFo\u001c:f\r\u0006\u001cGo\u001c:z!\tYSOB\u0003\u0002\u0005!\u0005ao\u0005\u0003vojl\u0002C\u0001\u001fy\u0013\tIXH\u0001\u0004B]f\u0014VM\u001a\t\u0004w\u0006-ab\u0001?\u0002\u00069\u0019Q0!\u0001\u000f\u0005ys\u0018BA@\u0007\u0003\u0015Ig\u000eZ3y\u0013\rQ\u00121\u0001\u0006\u0003\u007f\u001aIA!a\u0002\u0002\n\u00059r)Z8NKN\fG)\u0019;b'R|'/\u001a$bGR|'/\u001f\u0006\u00045\u0005\r\u0011\u0002BA\u0007\u0003\u001f\u0011AcR3p\u001b\u0016\u001c\u0018\rR1uCN#xN]3J]\u001a|'\u0002BA\u0004\u0003\u0013Aa\u0001K;\u0005\u0002\u0005MA#\u0001;\t\u0013\u0005]QO1A\u0005\u0002\u0005e\u0011!\u0006%CCN,w)Z8NKN\f\u0007K]5oG&\u0004\u0018\r\\\u000b\u0003\u00037\u00012aDA\u000f\u0013\t\u0011\u0005\u0003\u0003\u0005\u0002\"U\u0004\u000b\u0011BA\u000e\u0003YA%)Y:f\u000f\u0016|W*Z:b!JLgnY5qC2\u0004\u0003\"CA\u0013k\n\u0007I\u0011AA\r\u0003IA%)Y:f\u000f\u0016|W*Z:b\u0017\u0016LH+\u00192\t\u0011\u0005%R\u000f)A\u0005\u00037\t1\u0003\u0013\"bg\u0016<Um\\'fg\u0006\\U-\u001f+bE\u0002B\u0011\"!\fv\u0005\u0004%\t!a\f\u0002%\r{gNZ5h!\u0006$\b\u000e\u0015:pa\u0016\u0014H/_\u000b\u0003\u0003c\u0001B!a\r\u0002J9!\u0011QGA\"\u001d\u0011\t9$!\u0010\u000f\u0007y\u000bI$C\u0002\u0002<\u0019\tQ!\u001e;jYNLA!a\u0010\u0002B\u0005!1m\u001c8g\u0015\r\tYDB\u0005\u0005\u0003\u000b\n9%A\fHK>lUm]1TsN$X-\u001c)s_B,'\u000f^5fg*!\u0011qHA!\u0013\u0011\tY%!\u0014\u0003\u001dMK8\u000f^3n!J|\u0007/\u001a:us*!\u0011QIA$\u0011!\t\t&\u001eQ\u0001\n\u0005E\u0012aE\"p]\u001aLw\rU1uQB\u0013x\u000e]3sif\u0004\u0003\"CA+k\n\u0007I\u0011AA\u0018\u0003Q\u0011V-\\8uK\u001aKG\u000e^3s!J|\u0007/\u001a:us\"A\u0011\u0011L;!\u0002\u0013\t\t$A\u000bSK6|G/\u001a$jYR,'\u000f\u0015:pa\u0016\u0014H/\u001f\u0011\t\u0013\u0005uSO1A\u0005\u0002\u0005=\u0012a\u0005*f[>$X-\u0011:s_^\u0004&o\u001c9feRL\b\u0002CA1k\u0002\u0006I!!\r\u0002)I+Wn\u001c;f\u0003J\u0014xn\u001e)s_B,'\u000f^=!\u0011%\t)'\u001eb\u0001\n\u0003\nI\"A\u0006ESN\u0004H.Y=OC6,\u0007\u0002CA5k\u0002\u0006I!a\u0007\u0002\u0019\u0011K7\u000f\u001d7bs:\u000bW.\u001a\u0011\t\u0013\u00055TO1A\u0005B\u0005e\u0011a\u0003#fg\u000e\u0014\u0018\u000e\u001d;j_:D\u0001\"!\u001dvA\u0003%\u00111D\u0001\r\t\u0016\u001c8M]5qi&|g\u000e\t\u0005\n\u0003k*(\u0019!C!\u0003o\nQ\u0002U1sC6,G/\u001a:J]\u001a|WCAA=!\u0015a\u00141PA@\u0013\r\ti(\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\u0019\u0005\u0003\u0003\u000by\t\u0005\u0004\u0002\u0004\u0006\u001d\u00151R\u0007\u0003\u0003\u000bS1AGA!\u0013\u0011\tI)!\"\u0003\u0019\u001d+w.T3tCB\u000b'/Y7\u0011\t\u00055\u0015q\u0012\u0007\u0001\t1\t\t*a%\u0002\u0002\u0003\u0005)\u0011AAQ\u0005\ryFE\r\u0005\t\u0003++\b\u0015!\u0003\u0002\u0018\u0006q\u0001+\u0019:b[\u0016$XM]%oM>\u0004\u0003#\u0002\u001f\u0002|\u0005e\u0005\u0007BAN\u0003?\u0003b!a!\u0002\b\u0006u\u0005\u0003BAG\u0003?#A\"!%\u0002\u0014\u0006\u0005\t\u0011!B\u0001\u0003C\u000bB!a)\u0002*B\u0019A(!*\n\u0007\u0005\u001dVHA\u0004O_RD\u0017N\\4\u0011\u0007q\nY+C\u0002\u0002.v\u00121!\u00118z\u0011)\t\t,\u001eb\u0001\n\u00031\u0011\u0011D\u0001\u0013\u0005&<G+\u00192mKB\u000b'/Y7DQ\u0016\u001c7\u000e\u0003\u0005\u00026V\u0004\u000b\u0011BA\u000e\u0003M\u0011\u0015n\u001a+bE2,\u0007+\u0019:b[\u000eCWmY6!\u0011\u001d\tI,\u001eC!\u0003w\u000b!bY1o!J|7-Z:t)\u0011\ti,a1\u0011\u0007q\ny,C\u0002\u0002Bv\u0012qAQ8pY\u0016\fg\u000eC\u00044\u0003o\u0003\r!!21\t\u0005\u001d\u00171\u001a\t\u0006kaR\u0014\u0011\u001a\t\u0005\u0003\u001b\u000bY\r\u0002\u0007\u0002N\u0006\r\u0017\u0011!A\u0001\u0006\u0003\tyMA\u0002`IM\n2!a)E\r\u0019\t\u0019.\u001e!\u0002V\n!\u0002JQ1tK\u0012\u000bG/Y*u_J,7i\u001c8gS\u001e\u001c\u0012\"!5x\u0003/\fi.a9\u0011\u0007m\fI.\u0003\u0003\u0002\\\u0006=!AF$f_6+7/\u0019#bi\u0006\u001cFo\u001c:f\u0007>tg-[4\u0011\u0007q\ny.C\u0002\u0002bv\u0012q\u0001\u0015:pIV\u001cG\u000fE\u0002=\u0003KL!!S\u001f\t\u0017\u0005%\u0018\u0011\u001bBK\u0002\u0013\u0005\u00111^\u0001\bG\u0006$\u0018\r\\8h+\u0005Q\u0004BCAx\u0003#\u0014\t\u0012)A\u0005u\u0005A1-\u0019;bY><\u0007\u0005C\u0006\u0002t\u0006E'Q3A\u0005\u0002\u0005U\u0018\u0001\u0004:f[>$XMR5mi\u0016\u0014XCAA_\u0011-\tI0!5\u0003\u0012\u0003\u0006I!!0\u0002\u001bI,Wn\u001c;f\r&dG/\u001a:!\u0011-\ti0!5\u0003\u0016\u0004%\t!!>\u0002\u001b\u001d,g.\u001a:bi\u0016\u001cF/\u0019;t\u0011-\u0011\t!!5\u0003\u0012\u0003\u0006I!!0\u0002\u001d\u001d,g.\u001a:bi\u0016\u001cF/\u0019;tA!Y!QAAi\u0005+\u0007I\u0011\u0001B\u0004\u0003\u0015\tW\u000fZ5u+\t\u0011I\u0001E\u0003=\u0005\u0017\u0011y!C\u0002\u0003\u000eu\u0012aa\u00149uS>t\u0007\u0003\u0003\u001f\u0003\u0012\tU!q\u0004\u001e\n\u0007\tMQH\u0001\u0004UkBdWm\r\t\u0005\u0005/\u0011Y\"\u0004\u0002\u0003\u001a)!!QAA!\u0013\u0011\u0011iB!\u0007\u0003\u0017\u0005+H-\u001b;Xe&$XM\u001d\t\u0005\u0005/\u0011\t#\u0003\u0003\u0003$\te!!D!vI&$\bK]8wS\u0012,'\u000fC\u0006\u0003(\u0005E'\u0011#Q\u0001\n\t%\u0011AB1vI&$\b\u0005C\u0006\u0003,\u0005E'Q3A\u0005\u0002\t5\u0012\u0001D9vKJLH\u000b\u001b:fC\u0012\u001cXC\u0001B\u0018!\ra$\u0011G\u0005\u0004\u0005gi$aA%oi\"Y!qGAi\u0005#\u0005\u000b\u0011\u0002B\u0018\u00035\tX/\u001a:z)\"\u0014X-\u00193tA!Y!1HAi\u0005+\u0007I\u0011\u0001B\u001f\u00031\tX/\u001a:z)&lWm\\;u+\t\u0011y\u0004E\u0003=\u0005\u0017\u0011\t\u0005E\u0002=\u0005\u0007J1A!\u0012>\u0005\u0011auN\\4\t\u0017\t%\u0013\u0011\u001bB\tB\u0003%!qH\u0001\u000ecV,'/\u001f+j[\u0016|W\u000f\u001e\u0011\t\u0017\t5\u0013\u0011\u001bBK\u0002\u0013\u0005!QF\u0001\u0019[\u0006D(+\u00198hKN\u0004VM]#yi\u0016tG-\u001a3TG\u0006t\u0007b\u0003B)\u0003#\u0014\t\u0012)A\u0005\u0005_\t\u0011$\\1y%\u0006tw-Z:QKJ,\u0005\u0010^3oI\u0016$7kY1oA!Y!QKAi\u0005+\u0007I\u0011AA{\u0003%awn\\:f\u0005\n{\u0007\u0010C\u0006\u0003Z\u0005E'\u0011#Q\u0001\n\u0005u\u0016A\u00037p_N,'IQ8yA!Y!QLAi\u0005+\u0007I\u0011AA{\u0003\u001d\u0019\u0017m\u00195j]\u001eD1B!\u0019\u0002R\nE\t\u0015!\u0003\u0002>\u0006A1-Y2iS:<\u0007\u0005C\u0006\u0003f\u0005E'Q3A\u0005\u0002\t\u001d\u0014\u0001D1vi\"\u0004&o\u001c<jI\u0016\u0014XC\u0001B5!\u0015a$1\u0002B6!\u0011\u0011iGa\u001d\u000e\u0005\t=$b\u0001B9\r\u0005A1/Z2ve&$\u00180\u0003\u0003\u0003v\t=$AF!vi\"|'/\u001b>bi&|gn\u001d)s_ZLG-\u001a:\t\u0017\te\u0014\u0011\u001bB\tB\u0003%!\u0011N\u0001\u000eCV$\b\u000e\u0015:pm&$WM\u001d\u0011\t\u0017\tu\u0014\u0011\u001bBK\u0002\u0013\u0005!qP\u0001\u000fG>\u0004(o\\2fgN|'/\u0016:m+\t\u0011\t\tE\u0003=\u0005\u0017\u0011\u0019\t\u0005\u0003\u0003\u0006\nMUB\u0001BD\u0015\u0011\u0011IIa#\u0002\u0005\u0019\u001c(\u0002\u0002BG\u0005\u001f\u000ba\u0001[1e_>\u0004(b\u0001BI\u0015\u00051\u0011\r]1dQ\u0016LAA!&\u0003\b\n!\u0001+\u0019;i\u0011-\u0011I*!5\u0003\u0012\u0003\u0006IA!!\u0002\u001f\r|\u0007O]8dKN\u001cxN]+sY\u0002B1B!(\u0002R\nU\r\u0011\"\u0001\u0003 \u0006Ia.Y7fgB\f7-Z\u000b\u0003\u0005C\u0003B\u0001\u0010B\u0006u!Y!QUAi\u0005#\u0005\u000b\u0011\u0002BQ\u0003)q\u0017-\\3ta\u0006\u001cW\r\t\u0005\bQ\u0005EG\u0011\u0001BU)i\u0011YKa,\u00032\nM&Q\u0017B\\\u0005s\u0013YL!0\u0003@\n\u0005'1\u0019Bc!\u0011\u0011i+!5\u000e\u0003UDq!!;\u0003(\u0002\u0007!\b\u0003\u0005\u0002t\n\u001d\u0006\u0019AA_\u0011!\tiPa*A\u0002\u0005u\u0006\u0002\u0003B\u0003\u0005O\u0003\rA!\u0003\t\u0011\t-\"q\u0015a\u0001\u0005_A\u0001Ba\u000f\u0003(\u0002\u0007!q\b\u0005\t\u0005\u001b\u00129\u000b1\u0001\u00030!A!Q\u000bBT\u0001\u0004\ti\f\u0003\u0005\u0003^\t\u001d\u0006\u0019AA_\u0011!\u0011)Ga*A\u0002\t%\u0004\u0002\u0003B?\u0005O\u0003\rA!!\t\u0011\tu%q\u0015a\u0001\u0005CC!B!3\u0002R\u0006\u0005I\u0011\u0001Bf\u0003\u0011\u0019w\u000e]=\u00155\t-&Q\u001aBh\u0005#\u0014\u0019N!6\u0003X\ne'1\u001cBo\u0005?\u0014\tOa9\t\u0013\u0005%(q\u0019I\u0001\u0002\u0004Q\u0004BCAz\u0005\u000f\u0004\n\u00111\u0001\u0002>\"Q\u0011Q Bd!\u0003\u0005\r!!0\t\u0015\t\u0015!q\u0019I\u0001\u0002\u0004\u0011I\u0001\u0003\u0006\u0003,\t\u001d\u0007\u0013!a\u0001\u0005_A!Ba\u000f\u0003HB\u0005\t\u0019\u0001B \u0011)\u0011iEa2\u0011\u0002\u0003\u0007!q\u0006\u0005\u000b\u0005+\u00129\r%AA\u0002\u0005u\u0006B\u0003B/\u0005\u000f\u0004\n\u00111\u0001\u0002>\"Q!Q\rBd!\u0003\u0005\rA!\u001b\t\u0015\tu$q\u0019I\u0001\u0002\u0004\u0011\t\t\u0003\u0006\u0003\u001e\n\u001d\u0007\u0013!a\u0001\u0005CC!Ba:\u0002RF\u0005I\u0011\u0001Bu\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa;+\u0007i\u0012io\u000b\u0002\u0003pB!!\u0011\u001fB~\u001b\t\u0011\u0019P\u0003\u0003\u0003v\n]\u0018!C;oG\",7m[3e\u0015\r\u0011I0P\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u007f\u0005g\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0019\t!!5\u0012\u0002\u0013\u000511A\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019)A\u000b\u0003\u0002>\n5\bBCB\u0005\u0003#\f\n\u0011\"\u0001\u0004\u0004\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004BCB\u0007\u0003#\f\n\u0011\"\u0001\u0004\u0010\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAB\tU\u0011\u0011IA!<\t\u0015\rU\u0011\u0011[I\u0001\n\u0003\u00199\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\re!\u0006\u0002B\u0018\u0005[D!b!\b\u0002RF\u0005I\u0011AB\u0010\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIY*\"a!\t+\t\t}\"Q\u001e\u0005\u000b\u0007K\t\t.%A\u0005\u0002\r]\u0011AD2paf$C-\u001a4bk2$He\u000e\u0005\u000b\u0007S\t\t.%A\u0005\u0002\r\r\u0011AD2paf$C-\u001a4bk2$H\u0005\u000f\u0005\u000b\u0007[\t\t.%A\u0005\u0002\r\r\u0011AD2paf$C-\u001a4bk2$H%\u000f\u0005\u000b\u0007c\t\t.%A\u0005\u0002\rM\u0012aD2paf$C-\u001a4bk2$H%\r\u0019\u0016\u0005\rU\"\u0006\u0002B5\u0005[D!b!\u000f\u0002RF\u0005I\u0011AB\u001e\u0003=\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE\nTCAB\u001fU\u0011\u0011\tI!<\t\u0015\r\u0005\u0013\u0011[I\u0001\n\u0003\u0019\u0019%A\bd_BLH\u0005Z3gCVdG\u000fJ\u00193+\t\u0019)E\u000b\u0003\u0003\"\n5\bBCB%\u0003#\f\t\u0011\"\u0011\u0002\u001a\u0005i\u0001O]8ek\u000e$\bK]3gSbD!b!\u0014\u0002R\u0006\u0005I\u0011\u0001B\u0017\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011)\u0019\t&!5\u0002\u0002\u0013\u000511K\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tIk!\u0016\t\u0015\r]3qJA\u0001\u0002\u0004\u0011y#A\u0002yIEB!ba\u0017\u0002R\u0006\u0005I\u0011IB/\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAB0!\u0019\u0019\tga\u001a\u0002*6\u001111\r\u0006\u0004\u0007Kj\u0014AC2pY2,7\r^5p]&!1\u0011NB2\u0005!IE/\u001a:bi>\u0014\bBCB7\u0003#\f\t\u0011\"\u0001\u0004p\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002>\u000eE\u0004BCB,\u0007W\n\t\u00111\u0001\u0002*\"Q1QOAi\u0003\u0003%\tea\u001e\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\f\t\u0015\rm\u0014\u0011[A\u0001\n\u0003\u001ai(\u0001\u0005u_N#(/\u001b8h)\t\tY\u0002\u0003\u0006\u0004\u0002\u0006E\u0017\u0011!C!\u0007\u0007\u000ba!Z9vC2\u001cH\u0003BA_\u0007\u000bC!ba\u0016\u0004\u0000\u0005\u0005\t\u0019AAU\u000f%\u0019I)^A\u0001\u0012\u0003\u0019Y)\u0001\u000bI\u0005\u0006\u001cX\rR1uCN#xN]3D_:4\u0017n\u001a\t\u0005\u0005[\u001biIB\u0005\u0002TV\f\t\u0011#\u0001\u0004\u0010N11QRBI\u0003G\u0004Rda%\u0004\u001aj\ni,!0\u0003\n\t=\"q\bB\u0018\u0003{\u000biL!\u001b\u0003\u0002\n\u0005&1V\u0007\u0003\u0007+S1aa&>\u0003\u001d\u0011XO\u001c;j[\u0016LAaa'\u0004\u0016\n\u0011\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u00193\u0011\u001dA3Q\u0012C\u0001\u0007?#\"aa#\t\u0015\rm4QRA\u0001\n\u000b\u001ai\b\u0003\u0006\u0004&\u000e5\u0015\u0011!CA\u0007O\u000bQ!\u00199qYf$\"Da+\u0004*\u000e-6QVBX\u0007c\u001b\u0019l!.\u00048\u000ee61XB_\u0007\u007fCq!!;\u0004$\u0002\u0007!\b\u0003\u0005\u0002t\u000e\r\u0006\u0019AA_\u0011!\tipa)A\u0002\u0005u\u0006\u0002\u0003B\u0003\u0007G\u0003\rA!\u0003\t\u0011\t-21\u0015a\u0001\u0005_A\u0001Ba\u000f\u0004$\u0002\u0007!q\b\u0005\t\u0005\u001b\u001a\u0019\u000b1\u0001\u00030!A!QKBR\u0001\u0004\ti\f\u0003\u0005\u0003^\r\r\u0006\u0019AA_\u0011!\u0011)ga)A\u0002\t%\u0004\u0002\u0003B?\u0007G\u0003\rA!!\t\u0011\tu51\u0015a\u0001\u0005CC!ba1\u0004\u000e\u0006\u0005I\u0011QBc\u0003\u001d)h.\u00199qYf$Baa2\u0004PB)AHa\u0003\u0004JBQBha3;\u0003{\u000biL!\u0003\u00030\t}\"qFA_\u0003{\u0013IG!!\u0003\"&\u00191QZ\u001f\u0003\u000fQ+\b\u000f\\32e!Q1\u0011[Ba\u0003\u0003\u0005\rAa+\u0002\u0007a$\u0003\u0007\u0003\u0006\u0004V\u000e5\u0015\u0011!C\u0005\u0007/\f1B]3bIJ+7o\u001c7wKR\ta\u0002C\u0004\u0004\\V$\ta!8\u0002%\t,\u0018\u000e\u001c3BkRD7\u000f\u0015:pm&$WM\u001d\u000b\u0007\u0005W\u001ayna<\t\u000fe\u001bI\u000e1\u0001\u0004bB!11]Bv\u001b\t\u0019)O\u0003\u0003\u0004h\u000e%\u0018AB2mS\u0016tGOC\u0002\u0006\u0005\u0017KAa!<\u0004f\nQ1i\u001c8oK\u000e$\u0018n\u001c8\t\rM\u001aI\u000e1\u00015\u0011\u001d\u0019\u0019\u0010\u0001C\t\u0003k\f!C^1mS\u0012\fG/Z\"p]:,7\r^5p]\"91q\u001f\u0001\u0005B\re\u0018aC5t\u0003Z\f\u0017\u000e\\1cY\u0016$\"!!0\t\u000f\ru\b\u0001\"\u0011\u0004\u0000\u0006qq-\u001a;ESN\u0004H.Y=OC6,G#\u0001\u001e\t\u000f\u0011\r\u0001\u0001\"\u0011\u0004\u0000\u0006qq-\u001a;EKN\u001c'/\u001b9uS>t\u0007b\u0002C\u0004\u0001\u0011\u0005C\u0011B\u0001\u0012O\u0016$\b+\u0019:b[\u0016$XM]:J]\u001a|GC\u0001C\u0006!\u0015a\u00141\u0010C\u0007!\u0011!y\u0001\"\b\u000f\t\u0011EA\u0011\u0004\b\u0005\t'!9BD\u0002a\t+I!A\u0007\u0006\n\u0005\rI\u0012b\u0001C\u000e1\u0005\tB)\u0019;b\u0003\u000e\u001cWm]:GC\u000e$xN]=\n\t\u0011}A\u0011\u0005\u0002\u0006!\u0006\u0014\u0018-\u001c\u0006\u0004\t7A\u0002bBA]\u0001\u0011\u0005CQ\u0005\u000b\u0005\u0003{#9\u0003\u0003\u00044\tG\u0001\r\u0001\u000e\u0005\b\tW\u0001A\u0011\tC\u0017\u0003Y9W\r^%na2,W.\u001a8uCRLwN\u001c%j]R\u001cHC\u0001C\u0018a\u0011!\t\u0004\"\u0013\u0011\rUBD1\u0007C$!\u0011!)\u0004\"\u0011\u000f\t\u0011]BQH\u0007\u0003\tsQ1\u0001b\u000f\u0013\u0003\r\tw\u000f^\u0005\u0005\t\u007f!I$\u0001\bSK:$WM]5oO\"Kg\u000e^:\n\t\u0011\rCQ\t\u0002\u0004\u0017\u0016L(\u0002\u0002C \ts\u0001B!!$\u0005J\u0011aA1\nC\u0015\u0003\u0003\u0005\tQ!\u0001\u0002\"\n\u0019q\fJ\u0019")
public class HBaseDataStoreFactory
implements DataStoreFactorySpi,
LazyLogging {
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static AuthorizationsProvider buildAuthsProvider(Connection connection, Map<String, Serializable> map) {
        return HBaseDataStoreFactory$.MODULE$.buildAuthsProvider(connection, map);
    }

    public static GeoMesaParam<?>[] ParameterInfo() {
        return HBaseDataStoreFactory$.MODULE$.ParameterInfo();
    }

    public static String Description() {
        return HBaseDataStoreFactory$.MODULE$.Description();
    }

    public static String DisplayName() {
        return HBaseDataStoreFactory$.MODULE$.DisplayName();
    }

    public static GeoMesaSystemProperties.SystemProperty RemoteArrowProperty() {
        return HBaseDataStoreFactory$.MODULE$.RemoteArrowProperty();
    }

    public static GeoMesaSystemProperties.SystemProperty RemoteFilterProperty() {
        return HBaseDataStoreFactory$.MODULE$.RemoteFilterProperty();
    }

    public static GeoMesaSystemProperties.SystemProperty ConfigPathProperty() {
        return HBaseDataStoreFactory$.MODULE$.ConfigPathProperty();
    }

    public static String HBaseGeoMesaKeyTab() {
        return HBaseDataStoreFactory$.MODULE$.HBaseGeoMesaKeyTab();
    }

    public static String HBaseGeoMesaPrincipal() {
        return HBaseDataStoreFactory$.MODULE$.HBaseGeoMesaPrincipal();
    }

    private Logger logger$lzycompute() {
        HBaseDataStoreFactory hBaseDataStoreFactory = this;
        synchronized (hBaseDataStoreFactory) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) {
        return this.createDataStore(params);
    }

    public DataStore createDataStore(Map<String, Serializable> params) {
        BoxedUnit boxedUnit;
        HBaseConnectionPool.ConnectionWrapper connection = HBaseConnectionPool$.MODULE$.getConnection(params, this.validateConnection());
        String catalog = this.getCatalog(params);
        boolean remoteFilters = BoxesRunTime.unboxToBoolean((Object)HBaseDataStoreParams$.MODULE$.RemoteFilteringParam().lookupOpt(params).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Boolean x$1) {
                return x$1;
            }
        }).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(HBaseDataStoreFactory$.MODULE$.RemoteFilterProperty().get())).toBoolean();
            }
        }));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Using {} filtering", new Object[]{remoteFilters ? "remote" : "local"});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Boolean generateStats = (Boolean)HBaseDataStoreParams$.MODULE$.GenerateStatsParam().lookup(params);
        None$ audit = Predef$.MODULE$.Boolean2boolean((Boolean)HBaseDataStoreParams$.MODULE$.AuditQueriesParam().lookup(params)) ? new Some((Object)new Tuple3((Object)AuditLogger$.MODULE$, Option$.MODULE$.apply((Object)AuditProvider.Loader.load(params)).getOrElse((Function0)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final NoOpAuditProvider$ apply() {
                return NoOpAuditProvider$.MODULE$;
            }
        }), (Object)"hbase")) : None$.MODULE$;
        Integer queryThreads = (Integer)HBaseDataStoreParams$.MODULE$.QueryThreadsParam().lookup(params);
        Option queryTimeout = HBaseDataStoreParams$.MODULE$.QueryTimeoutParam().lookupOpt(params).map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Duration x$2) {
                return x$2.toMillis();
            }
        });
        Integer maxRangesPerExtendedScan = (Integer)HBaseDataStoreParams$.MODULE$.MaxRangesPerExtendedScanParam().lookup(params);
        Boolean looseBBox = (Boolean)HBaseDataStoreParams$.MODULE$.LooseBBoxParam().lookup(params);
        Boolean caching = (Boolean)HBaseDataStoreParams$.MODULE$.CachingParam().lookup(params);
        None$ authsProvider = Predef$.MODULE$.Boolean2boolean((Boolean)HBaseDataStoreParams$.MODULE$.EnableSecurityParam().lookup(params)) ? new Some((Object)HBaseDataStoreFactory$.MODULE$.buildAuthsProvider(connection.connection(), params)) : None$.MODULE$;
        Option coprocessorUrl2 = HBaseDataStoreParams$.MODULE$.CoprocessorUrlParam().lookupOpt(params);
        Option ns = HBaseDataStoreParams$.MODULE$.NamespaceParam().lookupOpt(params);
        HBaseDataStoreConfig config = new HBaseDataStoreConfig(catalog, remoteFilters, Predef$.MODULE$.Boolean2boolean(generateStats), (Option<Tuple3<AuditWriter, AuditProvider, String>>)audit, Predef$.MODULE$.Integer2int(queryThreads), (Option<Object>)queryTimeout, Predef$.MODULE$.Integer2int(maxRangesPerExtendedScan), Predef$.MODULE$.Boolean2boolean(looseBBox), Predef$.MODULE$.Boolean2boolean(caching), (Option<AuthorizationsProvider>)authsProvider, (Option<Path>)coprocessorUrl2, (Option<String>)ns);
        HBaseDataStore ds = this.buildDataStore(connection, config);
        GeoMesaDataStore$.MODULE$.initRemoteVersion((GeoMesaDataStore)ds);
        return ds;
    }

    public String getCatalog(Map<String, Serializable> params) {
        return (String)HBaseDataStoreParams$.MODULE$.HBaseCatalogParam().lookup(params);
    }

    public HBaseDataStore buildDataStore(HBaseConnectionPool.ConnectionWrapper connection, HBaseDataStoreConfig config) {
        return new HBaseDataStore(connection, config);
    }

    public boolean validateConnection() {
        return true;
    }

    public boolean isAvailable() {
        return true;
    }

    public String getDisplayName() {
        return HBaseDataStoreFactory$.MODULE$.DisplayName();
    }

    public String getDescription() {
        return HBaseDataStoreFactory$.MODULE$.Description();
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return (DataAccessFactory.Param[])Predef$.MODULE$.refArrayOps((Object[])HBaseDataStoreFactory$.MODULE$.ParameterInfo()).$colon$plus(HBaseDataStoreParams$.MODULE$.NamespaceParam(), ClassTag$.MODULE$.apply(DataAccessFactory.Param.class));
    }

    public boolean canProcess(Map<String, Serializable> params) {
        return HBaseDataStoreFactory$.MODULE$.canProcess(params);
    }

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return null;
    }

    public HBaseDataStoreFactory() {
        LazyLogging.class.$init$((LazyLogging)this);
    }

    public static class HBaseDataStoreConfig
    implements GeoMesaDataStoreFactory.GeoMesaDataStoreConfig,
    Product,
    scala.Serializable {
        private final String catalog;
        private final boolean remoteFilter;
        private final boolean generateStats;
        private final Option<Tuple3<AuditWriter, AuditProvider, String>> audit;
        private final int queryThreads;
        private final Option<Object> queryTimeout;
        private final int maxRangesPerExtendedScan;
        private final boolean looseBBox;
        private final boolean caching;
        private final Option<AuthorizationsProvider> authProvider;
        private final Option<Path> coprocessorUrl;
        private final Option<String> namespace;

        public String catalog() {
            return this.catalog;
        }

        public boolean remoteFilter() {
            return this.remoteFilter;
        }

        public boolean generateStats() {
            return this.generateStats;
        }

        public Option<Tuple3<AuditWriter, AuditProvider, String>> audit() {
            return this.audit;
        }

        public int queryThreads() {
            return this.queryThreads;
        }

        public Option<Object> queryTimeout() {
            return this.queryTimeout;
        }

        public int maxRangesPerExtendedScan() {
            return this.maxRangesPerExtendedScan;
        }

        public boolean looseBBox() {
            return this.looseBBox;
        }

        public boolean caching() {
            return this.caching;
        }

        public Option<AuthorizationsProvider> authProvider() {
            return this.authProvider;
        }

        public Option<Path> coprocessorUrl() {
            return this.coprocessorUrl;
        }

        public Option<String> namespace() {
            return this.namespace;
        }

        public HBaseDataStoreConfig copy(String catalog, boolean remoteFilter, boolean generateStats, Option<Tuple3<AuditWriter, AuditProvider, String>> audit, int queryThreads, Option<Object> queryTimeout, int maxRangesPerExtendedScan, boolean looseBBox, boolean caching, Option<AuthorizationsProvider> authProvider, Option<Path> coprocessorUrl2, Option<String> namespace) {
            return new HBaseDataStoreConfig(catalog, remoteFilter, generateStats, audit, queryThreads, queryTimeout, maxRangesPerExtendedScan, looseBBox, caching, authProvider, coprocessorUrl2, namespace);
        }

        public String copy$default$1() {
            return this.catalog();
        }

        public boolean copy$default$2() {
            return this.remoteFilter();
        }

        public boolean copy$default$3() {
            return this.generateStats();
        }

        public Option<Tuple3<AuditWriter, AuditProvider, String>> copy$default$4() {
            return this.audit();
        }

        public int copy$default$5() {
            return this.queryThreads();
        }

        public Option<Object> copy$default$6() {
            return this.queryTimeout();
        }

        public int copy$default$7() {
            return this.maxRangesPerExtendedScan();
        }

        public boolean copy$default$8() {
            return this.looseBBox();
        }

        public boolean copy$default$9() {
            return this.caching();
        }

        public Option<AuthorizationsProvider> copy$default$10() {
            return this.authProvider();
        }

        public Option<Path> copy$default$11() {
            return this.coprocessorUrl();
        }

        public Option<String> copy$default$12() {
            return this.namespace();
        }

        public String productPrefix() {
            return "HBaseDataStoreConfig";
        }

        public int productArity() {
            return 12;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 11: {
                    object = this.namespace();
                    break;
                }
                case 10: {
                    object = this.coprocessorUrl();
                    break;
                }
                case 9: {
                    object = this.authProvider();
                    break;
                }
                case 8: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.caching());
                    break;
                }
                case 7: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.looseBBox());
                    break;
                }
                case 6: {
                    object = BoxesRunTime.boxToInteger((int)this.maxRangesPerExtendedScan());
                    break;
                }
                case 5: {
                    object = this.queryTimeout();
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToInteger((int)this.queryThreads());
                    break;
                }
                case 3: {
                    object = this.audit();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.generateStats());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.remoteFilter());
                    break;
                }
                case 0: {
                    object = this.catalog();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof HBaseDataStoreConfig;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.catalog()));
            n = Statics.mix((int)n, (int)(this.remoteFilter() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.generateStats() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.audit()));
            n = Statics.mix((int)n, (int)this.queryThreads());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.queryTimeout()));
            n = Statics.mix((int)n, (int)this.maxRangesPerExtendedScan());
            n = Statics.mix((int)n, (int)(this.looseBBox() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.caching() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.authProvider()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.coprocessorUrl()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.namespace()));
            return Statics.finalizeHash((int)n, (int)12);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof HBaseDataStoreConfig)) return false;
            boolean bl = true;
            if (!bl) return false;
            HBaseDataStoreConfig hBaseDataStoreConfig = (HBaseDataStoreConfig)x$1;
            String string = this.catalog();
            String string2 = hBaseDataStoreConfig.catalog();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.remoteFilter() != hBaseDataStoreConfig.remoteFilter()) return false;
            if (this.generateStats() != hBaseDataStoreConfig.generateStats()) return false;
            Option<Tuple3<AuditWriter, AuditProvider, String>> option = this.audit();
            Option<Tuple3<AuditWriter, AuditProvider, String>> option2 = hBaseDataStoreConfig.audit();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (this.queryThreads() != hBaseDataStoreConfig.queryThreads()) return false;
            Option<Object> option3 = this.queryTimeout();
            Option<Object> option4 = hBaseDataStoreConfig.queryTimeout();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (this.maxRangesPerExtendedScan() != hBaseDataStoreConfig.maxRangesPerExtendedScan()) return false;
            if (this.looseBBox() != hBaseDataStoreConfig.looseBBox()) return false;
            if (this.caching() != hBaseDataStoreConfig.caching()) return false;
            Option<AuthorizationsProvider> option5 = this.authProvider();
            Option<AuthorizationsProvider> option6 = hBaseDataStoreConfig.authProvider();
            if (option5 == null) {
                if (option6 != null) {
                    return false;
                }
            } else if (!option5.equals(option6)) return false;
            Option<Path> option7 = this.coprocessorUrl();
            Option<Path> option8 = hBaseDataStoreConfig.coprocessorUrl();
            if (option7 == null) {
                if (option8 != null) {
                    return false;
                }
            } else if (!option7.equals(option8)) return false;
            Option<String> option9 = this.namespace();
            Option<String> option10 = hBaseDataStoreConfig.namespace();
            if (option9 == null) {
                if (option10 != null) {
                    return false;
                }
            } else if (!option9.equals(option10)) return false;
            if (!hBaseDataStoreConfig.canEqual(this)) return false;
            return true;
        }

        public HBaseDataStoreConfig(String catalog, boolean remoteFilter, boolean generateStats, Option<Tuple3<AuditWriter, AuditProvider, String>> audit, int queryThreads, Option<Object> queryTimeout, int maxRangesPerExtendedScan, boolean looseBBox, boolean caching, Option<AuthorizationsProvider> authProvider, Option<Path> coprocessorUrl2, Option<String> namespace) {
            this.catalog = catalog;
            this.remoteFilter = remoteFilter;
            this.generateStats = generateStats;
            this.audit = audit;
            this.queryThreads = queryThreads;
            this.queryTimeout = queryTimeout;
            this.maxRangesPerExtendedScan = maxRangesPerExtendedScan;
            this.looseBBox = looseBBox;
            this.caching = caching;
            this.authProvider = authProvider;
            this.coprocessorUrl = coprocessorUrl2;
            this.namespace = namespace;
            Product.class.$init$((Product)this);
        }
    }
}

