/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.data;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.KeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.hbase.coprocessor.GeoMesaCoprocessor$;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseArrowAggregator;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseArrowAggregator$;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseBinAggregator;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseBinAggregator$;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseDensityAggregator;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseDensityAggregator$;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseStatsAggregator;
import org.locationtech.geomesa.hbase.coprocessor.aggregators.HBaseStatsAggregator$;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreFactory$;
import org.locationtech.geomesa.hbase.data.HBaseIndexAdapter$;
import org.locationtech.geomesa.hbase.data.HBaseIndexAdapter$$anonfun$clearTables$1$;
import org.locationtech.geomesa.hbase.data.HBaseIndexAdapter$HBaseIndexWriter$;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.hbase.filters.CqlTransformFilter$;
import org.locationtech.geomesa.hbase.filters.S2HBaseFilter;
import org.locationtech.geomesa.hbase.filters.S2HBaseFilter$;
import org.locationtech.geomesa.hbase.filters.S3HBaseFilter;
import org.locationtech.geomesa.hbase.filters.S3HBaseFilter$;
import org.locationtech.geomesa.hbase.filters.Z2HBaseFilter;
import org.locationtech.geomesa.hbase.filters.Z2HBaseFilter$;
import org.locationtech.geomesa.hbase.filters.Z3HBaseFilter;
import org.locationtech.geomesa.hbase.filters.Z3HBaseFilter$;
import org.locationtech.geomesa.hbase.package$HBaseSystemProperties$;
import org.locationtech.geomesa.hbase.utils.HBaseVersions$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.api.IndexAdapter;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.WritableFeature$;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.index.conf.ColumnGroups;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.filters.S2Filter$;
import org.locationtech.geomesa.index.filters.S3Filter$;
import org.locationtech.geomesa.index.filters.Z2Filter$;
import org.locationtech.geomesa.index.filters.Z3Filter$;
import org.locationtech.geomesa.index.index.id.IdIndex$;
import org.locationtech.geomesa.index.index.s2.S2Index;
import org.locationtech.geomesa.index.index.s2.package;
import org.locationtech.geomesa.index.index.s3.S3Index;
import org.locationtech.geomesa.index.index.s3.package;
import org.locationtech.geomesa.index.index.z2.Z2Index;
import org.locationtech.geomesa.index.index.z2.package;
import org.locationtech.geomesa.index.index.z3.Z3Index;
import org.locationtech.geomesa.index.index.z3.package;
import org.locationtech.geomesa.index.iterators.StatsScan;
import org.locationtech.geomesa.index.planning.LocalQueryRunner;
import org.locationtech.geomesa.index.utils.Reprojection;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.io.CloseWithLogging$;
import org.locationtech.geomesa.utils.io.FlushWithLogging$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.text.StringSerialization$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ParIterableLike;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileByteRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\rmd\u0001B\u0001\u0003\u00015\u0011\u0011\u0003\u0013\"bg\u0016Le\u000eZ3y\u0003\u0012\f\u0007\u000f^3s\u0015\t\u0019A!\u0001\u0003eCR\f'BA\u0003\u0007\u0003\u0015A'-Y:f\u0015\t9\u0001\"A\u0004hK>lWm]1\u000b\u0005%Q\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qA\u0003\t\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007UQB$D\u0001\u0017\u0015\t9\u0002$A\u0002ba&T!!\u0007\u0004\u0002\u000b%tG-\u001a=\n\u0005m1\"\u0001D%oI\u0016D\u0018\tZ1qi\u0016\u0014\bCA\u000f\u001f\u001b\u0005\u0011\u0011BA\u0010\u0003\u00059A%)Y:f\t\u0006$\u0018m\u0015;pe\u0016\u0004\"!\t\u0015\u000e\u0003\tR!a\t\u0013\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u00152\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u001d\n1aY8n\u0013\tI#EA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\tW\u0001\u0011\t\u0011)A\u00059\u0005\u0011Am\u001d\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=\u0002\u0004CA\u000f\u0001\u0011\u0015YC\u00061\u0001\u001d\u0011\u0015\u0011\u0004\u0001\"\u00114\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\tQ:$J\u0016\t\u0003\u001fUJ!A\u000e\t\u0003\tUs\u0017\u000e\u001e\u0005\u00063E\u0002\r\u0001\u000f\u0019\u0004syB\u0005\u0003B\u000b;y\u001dK!a\u000f\f\u0003'\u001d+w.T3tC\u001a+\u0017\r^;sK&sG-\u001a=\u0011\u0005urD\u0002\u0001\u0003\n\u007f]\n\t\u0011!A\u0003\u0002\u0001\u00131a\u0018\u00132#\t\tE\t\u0005\u0002\u0010\u0005&\u00111\t\u0005\u0002\b\u001d>$\b.\u001b8h!\tyQ)\u0003\u0002G!\t\u0019\u0011I\\=\u0011\u0005uBE!C%8\u0003\u0003\u0005\tQ!\u0001A\u0005\ryFE\r\u0005\u0006\u0017F\u0002\r\u0001T\u0001\na\u0006\u0014H/\u001b;j_:\u00042aD'P\u0013\tq\u0005C\u0001\u0004PaRLwN\u001c\t\u0003!Ns!aD)\n\u0005I\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!A\u0015\t\t\r]\u000bD\u00111\u0001Y\u0003\u0019\u0019\b\u000f\\5ugB\u0019q\"W.\n\u0005i\u0003\"\u0001\u0003\u001fcs:\fW.\u001a \u0011\u0007q#wM\u0004\u0002^E:\u0011a,Y\u0007\u0002?*\u0011\u0001\rD\u0001\u0007yI|w\u000e\u001e \n\u0003EI!a\u0019\t\u0002\u000fA\f7m[1hK&\u0011QM\u001a\u0002\u0004'\u0016\f(BA2\u0011!\ry\u0001N[\u0005\u0003SB\u0011Q!\u0011:sCf\u0004\"aD6\n\u00051\u0004\"\u0001\u0002\"zi\u0016DQA\u001c\u0001\u0005B=\f1B]3oC6,G+\u00192mKR\u0019A\u0007\u001d:\t\u000bEl\u0007\u0019A(\u0002\t\u0019\u0014x.\u001c\u0005\u0006g6\u0004\raT\u0001\u0003i>DQ!\u001e\u0001\u0005BY\fA\u0002Z3mKR,G+\u00192mKN$\"\u0001N<\t\u000ba$\b\u0019A=\u0002\rQ\f'\r\\3t!\raFm\u0014\u0005\u0006w\u0002!\t\u0005`\u0001\fG2,\u0017M\u001d+bE2,7\u000fF\u00025{zDQ\u0001\u001f>A\u0002eDaa >A\u0002\u0005\u0005\u0011A\u00029sK\u001aL\u0007\u0010E\u0002\u0010\u001b\u001eDq!!\u0002\u0001\t\u0003\n9!A\bde\u0016\fG/Z)vKJL\b\u000b\\1o)\u0011\tI!a\u0004\u0011\u0007u\tY!C\u0002\u0002\u000e\t\u0011a\u0002\u0013\"bg\u0016\fV/\u001a:z!2\fg\u000e\u0003\u0005\u0002\u0012\u0005\r\u0001\u0019AA\n\u0003!\u0019HO]1uK\u001eL\b\u0003BA\u000b\u0003[qA!a\u0006\u0002,9!\u0011\u0011DA\u0015\u001d\u0011\tY\"a\n\u000f\t\u0005u\u0011Q\u0005\b\u0005\u0003?\t\u0019CD\u0002_\u0003CI\u0011aC\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005e1\u0011BA\f\u0019\u0013\t\u0019g#\u0003\u0003\u00020\u0005E\"!D)vKJL8\u000b\u001e:bi\u0016<\u0017P\u0003\u0002d-!9\u0011Q\u0007\u0001\u0005B\u0005]\u0012\u0001D2sK\u0006$Xm\u0016:ji\u0016\u0014H\u0003CA\u001d\u0007K\u0019Ic!\u0010\u0011\t\u0005m\"Q\b\b\u0004;\u0005uraBA \u0005!\u0005\u0011\u0011I\u0001\u0012\u0011\n\u000b7/Z%oI\u0016D\u0018\tZ1qi\u0016\u0014\bcA\u000f\u0002D\u00191\u0011A\u0001E\u0001\u0003\u000b\u001aR!a\u0011\u000f\u0003\u000f\u00022!IA%\u0013\r\tYE\t\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw\rC\u0004.\u0003\u0007\"\t!a\u0014\u0015\u0005\u0005\u0005\u0003BCA*\u0003\u0007\u0012\r\u0011\"\u0003\u0002V\u0005IB-[:ue&\u0014W\u000f^3e\u0015\u0006\u0014h*Y7f!\u0006$H/\u001a:o+\t\t9\u0006\u0005\u0003\u0002Z\u0005\u001dTBAA.\u0015\u0011\ti&a\u0018\u0002\u000bI,w-\u001a=\u000b\t\u0005\u0005\u00141M\u0001\u0005kRLGN\u0003\u0002\u0002f\u0005!!.\u0019<b\u0013\u0011\tI'a\u0017\u0003\u000fA\u000bG\u000f^3s]\"I\u0011QNA\"A\u0003%\u0011qK\u0001\u001bI&\u001cHO]5ckR,GMS1s\u001d\u0006lW\rU1ui\u0016\u0014h\u000e\t\u0005\u000b\u0003c\n\u0019E1A\u0005\u0002\u0005M\u0014A\u00033ve\u0006\u0014\u0017\u000e\\5usV\u0011\u0011Q\u000f\t\u0005\u0003o\n9)\u0004\u0002\u0002z)!\u00111PA?\u0003\u0019\u0019G.[3oi*\u0019Q!a \u000b\t\u0005\u0005\u00151Q\u0001\u0007Q\u0006$wn\u001c9\u000b\u0007\u0005\u0015%\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u0013\u000bIH\u0001\u0006EkJ\f'-\u001b7jifD\u0011\"!$\u0002D\u0001\u0006I!!\u001e\u0002\u0017\u0011,(/\u00192jY&$\u0018\u0010\t\u0005\t\u0003#\u000b\u0019\u0005\"\u0001\u0002\u0014\u0006a1o\u001c:u\u0003:$W*\u001a:hKR!\u0011QSA`!\u0019\t9*!'\u0002\u001e6\u0011\u0011qL\u0005\u0005\u00037\u000byF\u0001\u0003MSN$\b\u0003BAP\u0003ssA!!)\u00024:!\u00111UAX\u001d\u0011\t)+!,\u000f\t\u0005\u001d\u00161\u0016\b\u0005\u0003?\tI+C\u0002\u0002\u0006*IA!!!\u0002\u0004&\u0019Q!a \n\t\u0005E\u0016QP\u0001\u0007M&dG/\u001a:\n\t\u0005U\u0016qW\u0001\u0014\u001bVdG/\u001b*poJ\u000bgnZ3GS2$XM\u001d\u0006\u0005\u0003c\u000bi(\u0003\u0003\u0002<\u0006u&\u0001\u0003*poJ\u000bgnZ3\u000b\t\u0005U\u0016q\u0017\u0005\t\u0003\u0003\fy\t1\u0001\u0002D\u00061!/\u00198hKN\u0004B\u0001\u00183\u0002FB!\u0011qOAd\u0013\u0011\tI-!\u001f\u0003\tM\u001b\u0017M\u001c\u0004\b\u0003\u001b\f\u0019\u0005AAh\u0005YA%)Y:f%\u0016\u001cX\u000f\u001c;t)>4U-\u0019;ve\u0016\u001c8\u0003BAf\u0003#\u0004b!a5\u0002Z\u0006}g\u0002BA\f\u0003+L1!a6\u0017\u0003%\tV/\u001a:z!2\fg.\u0003\u0003\u0002\\\u0006u'AF%oI\u0016D(+Z:vYR\u001cHk\u001c$fCR,(/Z:\u000b\u0007\u0005]g\u0003\u0005\u0003\u0002x\u0005\u0005\u0018\u0002BAr\u0003s\u0012aAU3tk2$\bbCAt\u0003\u0017\u0014\t\u0011)A\u0005\u0003S\faaX5oI\u0016D\bGBAv\u0003_\f)\u0010\u0005\u0004\u0016u\u00055\u00181\u001f\t\u0004{\u0005=HaCAy\u0003K\f\t\u0011!A\u0003\u0002\u0001\u00131a\u0018\u00137!\ri\u0014Q\u001f\u0003\f\u0003o\f)/!A\u0001\u0002\u000b\u0005\u0001IA\u0002`I]B1\"a?\u0002L\n\u0005\t\u0015!\u0003\u0002~\u0006!ql\u001d4u!\u0011\tyP!\u0004\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0005\u000b\taa]5na2,'\u0002\u0002B\u0004\u0005\u0013\tqAZ3biV\u0014XMC\u0002\u0003\f)\tqa\u001c9f]\u001eL7/\u0003\u0003\u0003\u0010\t\u0005!!E*j[BdWMR3biV\u0014X\rV=qK\"9Q&a3\u0005\u0002\tMAC\u0002B\u000b\u00053\u00119\u0003\u0005\u0003\u0003\u0018\u0005-WBAA\"\u0011!\t9O!\u0005A\u0002\tm\u0001G\u0002B\u000f\u0005C\u0011)\u0003\u0005\u0004\u0016u\t}!1\u0005\t\u0004{\t\u0005BaCAy\u00053\t\t\u0011!A\u0003\u0002\u0001\u00032!\u0010B\u0013\t-\t9P!\u0007\u0002\u0002\u0003\u0005)\u0011\u0001!\t\u0011\u0005m(\u0011\u0003a\u0001\u0003{Dq!LAf\t\u0003\u0011Y\u0003\u0006\u0002\u0003\u0016!A!qFAf\t\u0003\u0012\t$A\u0003baBd\u0017\u0010\u0006\u0003\u00034\te\u0002\u0003BA\u0000\u0005kIAAa\u000e\u0003\u0002\ti1+[7qY\u00164U-\u0019;ve\u0016D\u0001Ba\u000f\u0003.\u0001\u0007\u0011q\\\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0007\u000f\t}\u00121\t\u0001\u0003B\t\u0001\u0002JQ1tK&sG-\u001a=Xe&$XM]\n\u0005\u0005{\u0011\u0019\u0005\u0005\u0004\u0003F\t-#\u0011\u000b\b\u0005\u0003/\u00119%C\u0002\u0003JY\tA\"\u00138eKb\fE-\u00199uKJLAA!\u0014\u0003P\ty!)Y:f\u0013:$W\r_,sSR,'OC\u0002\u0003JY\u00012!\u0006B*\u0013\r\u0011)F\u0006\u0002\u0010/JLG/\u00192mK\u001a+\u0017\r^;sK\"I1F!\u0010\u0003\u0002\u0003\u0006I\u0001\b\u0005\u000e\u00057\u0012iD!A!\u0002\u0013\u0011iFa\u001c\u0002\u000f%tG-[2fgB!A\f\u001aB0a\u0019\u0011\tG!\u001a\u0003lA1QC\u000fB2\u0005S\u00022!\u0010B3\t-\u00119G!\u0017\u0002\u0002\u0003\u0005)\u0011\u0001!\u0003\u0007}#\u0003\bE\u0002>\u0005W\"1B!\u001c\u0003Z\u0005\u0005\t\u0011!B\u0001\u0001\n\u0019q\fJ\u001d\n\t\tm#1\n\u0005\f\u0005g\u0012iD!A!\u0002\u0013\u0011)(A\u0004xe\u0006\u0004\b/\u001a:\u0011\r\t]$Q\u0010B)\u001d\u0011\t9B!\u001f\n\u0007\tmd#A\bXe&$\u0018M\u00197f\r\u0016\fG/\u001e:f\u0013\u0011\u0011yH!!\u0003\u001d\u0019+\u0017\r^;sK^\u0013\u0018\r\u001d9fe*\u0019!1\u0010\f\t\u0013-\u0013iD!A!\u0002\u0013a\u0005bB\u0017\u0003>\u0011\u0005!q\u0011\u000b\u000b\u0005\u0013\u0013YI!$\u0003\u001e\n}\u0005\u0003\u0002B\f\u0005{Aaa\u000bBC\u0001\u0004a\u0002\u0002\u0003B.\u0005\u000b\u0003\rAa$\u0011\tq#'\u0011\u0013\u0019\u0007\u0005'\u00139Ja'\u0011\rUQ$Q\u0013BM!\ri$q\u0013\u0003\f\u0005O\u0012i)!A\u0001\u0002\u000b\u0005\u0001\tE\u0002>\u00057#1B!\u001c\u0003\u000e\u0006\u0005\t\u0011!B\u0001\u0001\"A!1\u000fBC\u0001\u0004\u0011)\b\u0003\u0004L\u0005\u000b\u0003\r\u0001\u0014\u0005\u000b\u0005G\u0013iD1A\u0005\n\t\u0015\u0016!\u00032bi\u000eD7+\u001b>f+\t\u00119\u000b\u0005\u0003\u0010\u001b\n%\u0006cA\b\u0003,&\u0019!Q\u0016\t\u0003\t1{gn\u001a\u0005\n\u0005c\u0013i\u0004)A\u0005\u0005O\u000b!BY1uG\"\u001c\u0016N_3!\u0011)\u0011)L!\u0010C\u0002\u0013%!qW\u0001\t[V$\u0018\r^8sgV\u0011!\u0011\u0018\t\u0005\u001f!\u0014Y\f\u0005\u0003\u0002x\tu\u0016\u0002\u0002B`\u0003s\u0012qBQ;gM\u0016\u0014X\rZ'vi\u0006$xN\u001d\u0005\n\u0005\u0007\u0014i\u0004)A\u0005\u0005s\u000b\u0011\"\\;uCR|'o\u001d\u0011\t\u0015\t\u001d'Q\ba\u0001\n\u0013\u0011I-A\u0001j+\t\u0011Y\rE\u0002\u0010\u0005\u001bL1Aa4\u0011\u0005\rIe\u000e\u001e\u0005\u000b\u0005'\u0014i\u00041A\u0005\n\tU\u0017!B5`I\u0015\fHc\u0001\u001b\u0003X\"Q!\u0011\u001cBi\u0003\u0003\u0005\rAa3\u0002\u0007a$\u0013\u0007C\u0005\u0003^\nu\u0002\u0015)\u0003\u0003L\u0006\u0011\u0011\u000e\t\u0005\t\u0005C\u0014i\u0004\"\u0015\u0003d\u0006)qO]5uKR9AG!:\u0003h\nm\b\u0002\u0003B\u0004\u0005?\u0004\rA!\u0015\t\u0011\t%(q\u001ca\u0001\u0005W\faA^1mk\u0016\u001c\b\u0003B\bi\u0005[\u0004DAa<\u0003xB1\u0011Q\u0003By\u0005kLAAa=\u00022\tY!k\\<LKf4\u0016\r\\;f!\ri$q\u001f\u0003\f\u0005s\u00149/!A\u0001\u0002\u000b\u0005\u0001I\u0001\u0003`IE\u0002\u0004\u0002\u0003B\u007f\u0005?\u0004\rAa@\u0002\rU\u0004H-\u0019;f!\ry1\u0011A\u0005\u0004\u0007\u0007\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0007\u000f\u0011i\u0004\"\u0015\u0004\n\u00051A-\u001a7fi\u0016$R\u0001NB\u0006\u0007\u001bA\u0001Ba\u0002\u0004\u0006\u0001\u0007!\u0011\u000b\u0005\t\u0005S\u001c)\u00011\u0001\u0004\u0010A!q\u0002[B\ta\u0011\u0019\u0019ba\u0006\u0011\r\u0005U!\u0011_B\u000b!\ri4q\u0003\u0003\f\u00073\u0019i!!A\u0001\u0002\u000b\u0005\u0001I\u0001\u0003`IE\n\u0004\u0002CB\u000f\u0005{!\tea\b\u0002\u000b\u0019dWo\u001d5\u0015\u0003QB\u0001ba\t\u0003>\u0011\u00053qD\u0001\u0006G2|7/\u001a\u0005\t\u0007O\t\u0019\u00041\u0001\u0002~\u0006\u00191O\u001a;\t\u0011\tm\u00131\u0007a\u0001\u0007W\u0001B\u0001\u00183\u0004.A21qFB\u001a\u0007s\u0001b!\u0006\u001e\u00042\r]\u0002cA\u001f\u00044\u0011Y1QGB\u0015\u0003\u0003\u0005\tQ!\u0001A\u0005\ryF\u0005\u000e\t\u0004{\reBaCB\u001e\u0007S\t\t\u0011!A\u0003\u0002\u0001\u00131a\u0018\u00136\u0011!Y\u00151\u0007I\u0001\u0002\u0004a\u0005bBB!\u0001\u0011E11I\u0001\u000fG>tg-[4ve\u0016\u001c6-\u00198t))\t\u0019m!\u0012\u0004J\r531\f\u0005\t\u0007\u000f\u001ay\u00041\u0001\u0002D\u0006qqN]5hS:\fGNU1oO\u0016\u001c\bbBB&\u0007\u007f\u0001\raZ\u0001\nG>dg)Y7jYfD\u0001ba\u0014\u0004@\u0001\u00071\u0011K\u0001\bM&dG/\u001a:t!\u0011aFma\u0015\u0011\t\rU3qK\u0007\u0003\u0003oKAa!\u0017\u00028\n1a)\u001b7uKJD\u0001b!\u0018\u0004@\u0001\u0007!q`\u0001\fG>\u0004(o\\2fgN|'\u000fC\u0004\u0004b\u0001!Iaa\u0019\u0002\u0019]\f\u0017\u000e\u001e$peR\u000b'\r\\3\u0015\u000bQ\u001a)ga\u001c\t\u0011\r\u001d4q\fa\u0001\u0007S\nQ!\u00193nS:\u0004B!a\u001e\u0004l%!1QNA=\u0005\u0015\tE-\\5o\u0011!\u0019\tha\u0018A\u0002\rM\u0014!\u0002;bE2,\u0007\u0003BB;\u0007oj!!! \n\t\re\u0014Q\u0010\u0002\n)\u0006\u0014G.\u001a(b[\u0016\u0004")
public class HBaseIndexAdapter
implements IndexAdapter<HBaseDataStore>,
StrictLogging {
    public final HBaseDataStore org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds;
    private final Logger logger;
    private final ColumnGroups groups;
    private final Option<Object> tableNameLimit;

    public static List<MultiRowRangeFilter.RowRange> sortAndMerge(Seq<Scan> seq) {
        return HBaseIndexAdapter$.MODULE$.sortAndMerge(seq);
    }

    public static Durability durability() {
        return HBaseIndexAdapter$.MODULE$.durability();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ColumnGroups groups() {
        return this.groups;
    }

    public Option<Object> tableNameLimit() {
        return this.tableNameLimit;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$groups_$eq(ColumnGroups x$1) {
        this.groups = x$1;
    }

    public void org$locationtech$geomesa$index$api$IndexAdapter$_setter_$tableNameLimit_$eq(Option x$1) {
        this.tableNameLimit = x$1;
    }

    public Option<String> createWriter$default$3() {
        return IndexAdapter.class.createWriter$default$3((IndexAdapter)this);
    }

    public void createTable(GeoMesaFeatureIndex<?, ?> index, Option<String> partition, Function0<Seq<byte[]>> splits) {
        TableName name = TableName.valueOf((String)index.configureTableName(partition, this.tableNameLimit()));
        WithClose$.MODULE$.apply((Object)this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.connection().getAdmin(), (Function1)new Serializable(this, index, splits, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseIndexAdapter $outer;
            public final GeoMesaFeatureIndex index$1;
            private final Function0 splits$1;
            public final TableName name$1;

            public final void apply(Admin admin) {
                VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
                if (!admin.tableExists(this.name$1)) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Creating table {}", new Object[]{this.name$1});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Configuration conf = admin.getConfiguration();
                    Option compression = Option$.MODULE$.apply(this.index$1.sft().getUserData().get(SimpleFeatureTypes.Configs$.MODULE$.TableCompression())).collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$createTable$1 $outer;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            String string;
                            A1 A1 = x1;
                            if (A1 instanceof String && new StringOps(Predef$.MODULE$.augmentString(string = (String)A1)).toBoolean()) {
                                BoxedUnit boxedUnit;
                                String string2;
                                V v = this.$outer.index$1.sft().getUserData().get(SimpleFeatureTypes.Configs$.MODULE$.TableCompressionType());
                                if (v == null) {
                                    string2 = "gz";
                                } else {
                                    if (!(v instanceof String)) throw new MatchError(v);
                                    String string3 = (String)v;
                                    string2 = string3.toLowerCase(Locale.US);
                                }
                                String compressionType = string2;
                                if (this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$$outer().logger().underlying().isDebugEnabled()) {
                                    this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$$outer().logger().underlying().debug("Setting compression '{}' on table {} for feature {}", new Object[]{compressionType, this.$outer.name$1, this.$outer.index$1.sft().getTypeName()});
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                                object = Compression.getCompressionAlgorithmByName((String)compressionType);
                                return (B1)object;
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Object x1) {
                            String string;
                            Object object = x1;
                            boolean bl = object instanceof String && new StringOps(Predef$.MODULE$.augmentString(string = (String)object)).toBoolean();
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    HTableDescriptor descriptor = new HTableDescriptor(this.name$1);
                    this.$outer.groups().apply(this.index$1.sft()).foreach((Function1)new Serializable(this, compression, descriptor){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$createTable$1 $outer;
                        private final Option compression$1;
                        private final HTableDescriptor descriptor$1;

                        public final void apply(Tuple2<byte[], SimpleFeatureType> x0$1) {
                            Tuple2<byte[], SimpleFeatureType> tuple2 = x0$1;
                            if (tuple2 != null) {
                                byte[] k = (byte[])tuple2._1();
                                HColumnDescriptor column = new HColumnDescriptor(k);
                                column.setBloomFilterType(BloomType.NONE);
                                this.compression$1.foreach((Function1)new Serializable(this, column){
                                    public static final long serialVersionUID = 0L;
                                    private final HColumnDescriptor column$1;

                                    public final HColumnDescriptor apply(Compression.Algorithm x$1) {
                                        return this.column$1.setCompressionType(x$1);
                                    }
                                    {
                                        this.column$1 = column$1;
                                    }
                                });
                                String string = this.$outer.index$1.name();
                                String string2 = IdIndex$.MODULE$.name();
                                Object object = !(string != null ? !string.equals(string2) : string2 != null) ? BoxedUnit.UNIT : column.setDataBlockEncoding(DataBlockEncoding.FAST_DIFF);
                                HBaseVersions$.MODULE$.addFamily(this.descriptor$1, column);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.compression$1 = compression$1;
                            this.descriptor$1 = descriptor$1;
                        }
                    });
                    if (this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.config().remoteFilter()) {
                        ObjectRef coprocessorUrl$lzy = ObjectRef.zero();
                        Option installed = Option$.MODULE$.apply((Object)conf.get("hbase.coprocessor.user.region.classes"));
                        Set names = (Set)installed.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Set<String> apply(String x$2) {
                                return Predef$.MODULE$.refArrayOps((Object[])x$2.split(":")).toSet();
                            }
                        }).getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Set<String> apply() {
                                return Predef$.MODULE$.Set().empty();
                            }
                        });
                        org.locationtech.geomesa.hbase.coprocessor.package$.MODULE$.AllCoprocessors().foreach((Function1)new Serializable(this, conf, descriptor, coprocessorUrl$lzy, names, bitmap$0){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$createTable$1 $outer;
                            private final Configuration conf$1;
                            private final HTableDescriptor descriptor$1;
                            private final ObjectRef coprocessorUrl$lzy$1;
                            private final Set names$1;
                            private final VolatileByteRef bitmap$0$1;

                            public final void apply(Class<? extends Coprocessor> c) {
                                if (!this.names$1.contains((Object)c.getCanonicalName())) {
                                    this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$addCoprocessor$1(c, this.descriptor$1, this.conf$1, this.coprocessorUrl$lzy$1, this.bitmap$0$1);
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.conf$1 = conf$1;
                                this.descriptor$1 = descriptor$1;
                                this.coprocessorUrl$lzy$1 = coprocessorUrl$lzy$1;
                                this.names$1 = names$1;
                                this.bitmap$0$1 = bitmap$0$1;
                            }
                        });
                    }
                    try {
                        admin.createTableAsync(descriptor, (byte[][])((TraversableOnce)this.splits$1.apply()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))));
                    }
                    catch (TableExistsException tableExistsException) {}
                }
                this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$waitForTable(admin, this.name$1);
            }

            public /* synthetic */ HBaseIndexAdapter org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$$outer() {
                return this.$outer;
            }

            private final Option coprocessorUrl$lzycompute$1(Configuration conf$1, ObjectRef coprocessorUrl$lzy$1, VolatileByteRef bitmap$0$1) {
                $anonfun$createTable$1 var4_4 = this;
                synchronized (var4_4) {
                    if ((byte)(bitmap$0$1.elem & 1) == 0) {
                        coprocessorUrl$lzy$1.elem = this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.config().coprocessorUrl().orElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Option<Path> apply() {
                                return package$HBaseSystemProperties$.MODULE$.CoprocessorPath().option().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Path apply(String x$1) {
                                        return new Path(x$1);
                                    }
                                });
                            }
                        }).orElse((Function0)new Serializable(this, conf$1){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$createTable$1 $outer;
                            private final Configuration conf$1;

                            public final Option<Path> apply() {
                                Option option;
                                try {
                                    Path dir = new Path(this.conf$1.get("hbase.dynamic.jars.dir"));
                                    option = (Option)WithClose$.MODULE$.apply((Object)dir.getFileSystem(this.conf$1), (Function1)new Serializable(this, dir){
                                        public static final long serialVersionUID = 0L;
                                        private final Path dir$1;

                                        public final Option<Path> apply(FileSystem fs) {
                                            return fs.isDirectory(this.dir$1) ? Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(this.dir$1)).collectFirst((PartialFunction)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final <A1 extends FileStatus, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                                    A1 A1 = x2;
                                                    Object object = HBaseIndexAdapter$.MODULE$.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$distributedJarNamePattern().matcher(A1.getPath().getName()).matches() ? A1.getPath() : function1.apply(x2);
                                                    return (B1)object;
                                                }

                                                public final boolean isDefinedAt(FileStatus x2) {
                                                    FileStatus fileStatus = x2;
                                                    boolean bl = HBaseIndexAdapter$.MODULE$.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$distributedJarNamePattern().matcher(fileStatus.getPath().getName()).matches();
                                                    return bl;
                                                }
                                            }) : None$.MODULE$;
                                        }
                                        {
                                            this.dir$1 = dir$1;
                                        }
                                    });
                                }
                                catch (Throwable throwable) {
                                    BoxedUnit boxedUnit;
                                    Throwable throwable2 = throwable;
                                    Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                                    if (option2.isEmpty()) {
                                        throw throwable;
                                    }
                                    Throwable e = (Throwable)option2.get();
                                    if (this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$$outer().logger().underlying().isWarnEnabled()) {
                                        this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$$outer().logger().underlying().warn("Error checking dynamic jar path:", e);
                                        boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit = BoxedUnit.UNIT;
                                    }
                                    None$ none$ = None$.MODULE$;
                                    option = none$;
                                }
                                return option;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.conf$1 = conf$1;
                            }
                        });
                        bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
                    }
                    return (Option)coprocessorUrl$lzy$1.elem;
                }
            }

            private final Option coprocessorUrl$1(Configuration conf$1, ObjectRef coprocessorUrl$lzy$1, VolatileByteRef bitmap$0$1) {
                return (byte)(bitmap$0$1.elem & 1) == 0 ? this.coprocessorUrl$lzycompute$1(conf$1, coprocessorUrl$lzy$1, bitmap$0$1) : (Option)coprocessorUrl$lzy$1.elem;
            }

            public final void org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$addCoprocessor$1(Class clazz, HTableDescriptor desc, Configuration conf$1, ObjectRef coprocessorUrl$lzy$1, VolatileByteRef bitmap$0$1) {
                String name = clazz.getCanonicalName();
                if (!desc.getCoprocessors().contains(name)) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isDebugEnabled()) {
                        this.$outer.logger().underlying().debug("Using coprocessor path {}", new Object[]{this.coprocessorUrl$1(conf$1, coprocessorUrl$lzy$1, bitmap$0$1).orNull(Predef$.MODULE$.$conforms())});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    HBaseVersions$.MODULE$.addCoprocessor(desc, name, (Option<Path>)this.coprocessorUrl$1(conf$1, coprocessorUrl$lzy$1, bitmap$0$1), HBaseVersions$.MODULE$.addCoprocessor$default$4(), HBaseVersions$.MODULE$.addCoprocessor$default$5());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.index$1 = index$1;
                this.splits$1 = splits$1;
                this.name$1 = name$1;
            }
        });
    }

    public void renameTable(String from, String to) {
        WithClose$.MODULE$.apply((Object)this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.connection().getAdmin(), (Function1)new Serializable(this, from, to){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseIndexAdapter $outer;
            private final String from$1;
            private final String to$1;

            public final void apply(Admin admin) {
                TableName existing = TableName.valueOf((String)this.from$1);
                TableName renamed = TableName.valueOf((String)this.to$1);
                if (admin.tableExists(existing)) {
                    String snapshot = StringSerialization$.MODULE$.alphaNumericSafeString(UUID.randomUUID().toString());
                    admin.disableTable(existing);
                    admin.snapshot(snapshot, existing);
                    admin.cloneSnapshot(snapshot, renamed);
                    admin.deleteSnapshot(snapshot);
                    admin.deleteTable(existing);
                    this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$waitForTable(admin, renamed);
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.from$1 = from$1;
                this.to$1 = to$1;
            }
        });
    }

    public void deleteTables(Seq<String> tables) {
        WithClose$.MODULE$.apply((Object)this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.connection().getAdmin(), (Function1)new Serializable(this, tables){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseIndexAdapter $outer;
            private final Seq tables$1;

            public final void apply(Admin admin) {
                ((ParIterableLike)this.tables$1.par()).foreach((Function1)new Serializable(this, admin){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deleteTables$1 $outer;
                    private final Admin admin$1;

                    public final void apply(String name) {
                        TableName table = TableName.valueOf((String)name);
                        if (this.admin$1.tableExists(table)) {
                            BoxedUnit boxedUnit;
                            this.admin$1.disableTableAsync(table);
                            Option timeout2 = package$HBaseSystemProperties$.MODULE$.TableAvailabilityTimeout().toDuration().filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Duration x$3) {
                                    return x$3.isFinite();
                                }
                            });
                            if (this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$$outer().logger().underlying().isDebugEnabled()) {
                                this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$$outer().logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for table '", "' to be disabled with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timeout2.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply(Duration t) {
                                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a timeout of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
                                    }
                                }).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "no timeout";
                                    }
                                })}))).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            Option stop = timeout2.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(Duration t) {
                                    return System.currentTimeMillis() + t.toMillis();
                                }
                            });
                            while (!this.admin$1.isTableDisabled(table) && stop.forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(long x$4) {
                                    return this.apply$mcZJ$sp(x$4);
                                }

                                public boolean apply$mcZJ$sp(long x$4) {
                                    return x$4 > System.currentTimeMillis();
                                }
                            })) {
                                Thread.sleep(1000L);
                            }
                            this.admin$1.deleteTable(table);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.admin$1 = admin$1;
                    }
                });
            }

            public /* synthetic */ HBaseIndexAdapter org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tables$1 = tables$1;
            }
        });
    }

    public void clearTables(Seq<String> tables, Option<byte[]> prefix) {
        ((ParIterableLike)tables.par()).foreach((Function1)new Serializable(this, prefix){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseIndexAdapter $outer;
            public final Option prefix$1;

            public final void apply(String name) {
                TableName tableName = TableName.valueOf((String)name);
                WithClose$.MODULE$.apply((Object)this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.connection().getTable(tableName), (Function1)new Serializable(this, tableName){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$clearTables$1 $outer;
                    private final TableName tableName$1;

                    public final void apply(Table table) {
                        Scan scan2 = new Scan().setFilter((Filter)new KeyOnlyFilter());
                        this.$outer.prefix$1.foreach((Function1)new Serializable(this, scan2){
                            public static final long serialVersionUID = 0L;
                            private final Scan scan$1;

                            public final Scan apply(byte[] x$1) {
                                return this.scan$1.setRowPrefixFilter(x$1);
                            }
                            {
                                this.scan$1 = scan$1;
                            }
                        });
                        this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$$outer().org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.applySecurity((Query)scan2);
                        BufferedMutatorParams mutateParams = new BufferedMutatorParams(this.tableName$1);
                        WithClose$.MODULE$.apply((Object)table.getScanner(scan2), (Function0)new Serializable(this, mutateParams){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$clearTables$1$$anonfun$apply$12 $outer;
                            private final BufferedMutatorParams mutateParams$1;

                            public final BufferedMutator apply() {
                                return this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$anonfun$$$outer().org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$$outer().org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.connection().getBufferedMutator(this.mutateParams$1);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.mutateParams$1 = mutateParams$1;
                            }
                        }, (Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(ResultScanner x0$2, BufferedMutator x1$1) {
                                Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$1);
                                if (tuple2 != null) {
                                    ResultScanner scanner = (ResultScanner)tuple2._1();
                                    BufferedMutator mutator = (BufferedMutator)tuple2._2();
                                    ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(scanner.iterator()).asScala()).grouped(10000).foreach((Function1)new Serializable(this, mutator){
                                        public static final long serialVersionUID = 0L;
                                        private final BufferedMutator mutator$1;

                                        public final void apply(Seq<Result> result) {
                                            Seq deletes = (Seq)result.map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final Delete apply(Result r) {
                                                    return new Delete(r.getRow());
                                                }
                                            }, Seq$.MODULE$.canBuildFrom());
                                            this.mutator$1.mutate((List)JavaConverters$.MODULE$.seqAsJavaListConverter(deletes).asJava());
                                        }
                                        {
                                            this.mutator$1 = mutator$1;
                                        }
                                    });
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError((Object)tuple2);
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$clearTables$1 org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.tableName$1 = tableName$1;
                    }
                });
            }

            public /* synthetic */ HBaseIndexAdapter org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.prefix$1 = prefix$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public HBaseQueryPlan createQueryPlan(package.QueryStrategy strategy) {
        HBaseQueryPlan hBaseQueryPlan;
        Tuple2 tuple2;
        Tuple4 tuple4;
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        package.QueryStrategy queryStrategy = strategy;
        if (queryStrategy == null) throw new MatchError((Object)queryStrategy);
        package.FilterStrategy filter = queryStrategy.filter();
        Seq byteRanges = queryStrategy.ranges();
        Option ecql = queryStrategy.ecql();
        Hints hints = queryStrategy.hints();
        Tuple4 tuple42 = tuple4 = new Tuple4((Object)filter, (Object)byteRanges, (Object)ecql, (Object)hints);
        package.FilterStrategy filter2 = (package.FilterStrategy)tuple42._1();
        Seq byteRanges2 = (Seq)tuple42._2();
        Option ecql2 = (Option)tuple42._3();
        Hints hints2 = (Hints)tuple42._4();
        GeoMesaFeatureIndex index = filter2.index();
        Seq ranges = (Seq)byteRanges2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Scan apply(package.ByteRange x0$3) {
                package.ByteRange byteRange;
                block4: {
                    Scan scan2;
                    block3: {
                        block2: {
                            byteRange = x0$3;
                            if (!(byteRange instanceof package.BoundedByteRange)) break block2;
                            package.BoundedByteRange boundedByteRange = (package.BoundedByteRange)byteRange;
                            byte[] start = boundedByteRange.lower();
                            byte[] end = boundedByteRange.upper();
                            scan2 = new Scan(start, end);
                            break block3;
                        }
                        if (!(byteRange instanceof package.SingleRowByteRange)) break block4;
                        package.SingleRowByteRange singleRowByteRange = (package.SingleRowByteRange)byteRange;
                        byte[] row = singleRowByteRange.row();
                        scan2 = new Scan(row, ByteArrays$.MODULE$.rowFollowingRow(row)).setSmall(true);
                    }
                    return scan2;
                }
                throw new MatchError((Object)byteRange);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq tables = (Seq)index.getTablesForQuery(filter2.filter()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TableName apply(String x$1) {
                return TableName.valueOf((String)x$1);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple22 = this.groups().group(index.sft(), QueryHints$.MODULE$.RichHints(hints2).getTransformDefinition(), ecql2);
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        byte[] colFamily = (byte[])tuple22._1();
        SimpleFeatureType schema = (SimpleFeatureType)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)colFamily, (Object)schema);
        byte[] colFamily2 = (byte[])tuple23._1();
        SimpleFeatureType schema2 = (SimpleFeatureType)tuple23._2();
        Option transform = QueryHints$.MODULE$.RichHints(hints2).getTransform();
        if (this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.config().remoteFilter()) {
            void var34_36;
            ObjectRef returnSchema$lzy = ObjectRef.zero();
            ObjectRef cqlFilter$lzy = ObjectRef.zero();
            ObjectRef cScan$lzy = ObjectRef.zero();
            ObjectRef timeout$lzy = ObjectRef.zero();
            boolean notSampling = QueryHints$.MODULE$.RichHints(hints2).getSampling().isEmpty();
            GeoMesaFeatureIndex geoMesaFeatureIndex = strategy.index();
            if (geoMesaFeatureIndex instanceof Z3Index) {
                Option option = strategy.values().map((Function1)new Serializable(this, index){
                    public static final long serialVersionUID = 0L;
                    private final GeoMesaFeatureIndex index$2;

                    public final Tuple2<Object, Z3HBaseFilter> apply(Object x0$4) {
                        Object object = x0$4;
                        if (object instanceof package.Z3IndexValues) {
                            package.Z3IndexValues z3IndexValues = (package.Z3IndexValues)object;
                            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)Z3HBaseFilter$.MODULE$.Priority()), (Object)((Object)Z3HBaseFilter$.MODULE$.apply(Z3Filter$.MODULE$.apply(z3IndexValues), this.index$2.keySpace().sharding().length())));
                            return tuple2;
                        }
                        throw new MatchError(object);
                    }
                    {
                        this.index$2 = index$2;
                    }
                });
            } else if (geoMesaFeatureIndex instanceof Z2Index) {
                Option option = strategy.values().map((Function1)new Serializable(this, index){
                    public static final long serialVersionUID = 0L;
                    private final GeoMesaFeatureIndex index$2;

                    public final Tuple2<Object, Z2HBaseFilter> apply(Object x0$5) {
                        Object object = x0$5;
                        if (object instanceof package.Z2IndexValues) {
                            package.Z2IndexValues z2IndexValues = (package.Z2IndexValues)object;
                            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)Z2HBaseFilter$.MODULE$.Priority()), (Object)((Object)Z2HBaseFilter$.MODULE$.apply(Z2Filter$.MODULE$.apply(z2IndexValues), this.index$2.keySpace().sharding().length())));
                            return tuple2;
                        }
                        throw new MatchError(object);
                    }
                    {
                        this.index$2 = index$2;
                    }
                });
            } else if (geoMesaFeatureIndex instanceof S2Index) {
                Option option = strategy.values().map((Function1)new Serializable(this, index){
                    public static final long serialVersionUID = 0L;
                    private final GeoMesaFeatureIndex index$2;

                    public final Tuple2<Object, S2HBaseFilter> apply(Object x0$6) {
                        Object object = x0$6;
                        if (object instanceof package.S2IndexValues) {
                            package.S2IndexValues s2IndexValues = (package.S2IndexValues)object;
                            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)S2HBaseFilter$.MODULE$.Priority()), (Object)((Object)S2HBaseFilter$.MODULE$.apply(S2Filter$.MODULE$.apply(s2IndexValues), this.index$2.keySpace().sharding().length())));
                            return tuple2;
                        }
                        throw new MatchError(object);
                    }
                    {
                        this.index$2 = index$2;
                    }
                });
            } else if (geoMesaFeatureIndex instanceof S3Index) {
                Option option = strategy.values().map((Function1)new Serializable(this, index){
                    public static final long serialVersionUID = 0L;
                    private final GeoMesaFeatureIndex index$2;

                    public final Tuple2<Object, S3HBaseFilter> apply(Object x0$7) {
                        Object object = x0$7;
                        if (object instanceof package.S3IndexValues) {
                            package.S3IndexValues s3IndexValues = (package.S3IndexValues)object;
                            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)S3HBaseFilter$.MODULE$.Priority()), (Object)((Object)S3HBaseFilter$.MODULE$.apply(S3Filter$.MODULE$.apply(s3IndexValues), this.index$2.keySpace().sharding().length())));
                            return tuple2;
                        }
                        throw new MatchError(object);
                    }
                    {
                        this.index$2 = index$2;
                    }
                });
            } else {
                None$ none$ = None$.MODULE$;
            }
            void indexFilter = var34_36;
            Option max = QueryHints$.MODULE$.RichHints(hints2).getMaxFeatures();
            Option projection = QueryHints$.MODULE$.RichHints(hints2).getProjection();
            if (QueryHints$.MODULE$.RichHints(hints2).isDensityQuery()) {
                hBaseQueryPlan = (HBaseQueryPlan)this.empty$1((Option)None$.MODULE$, filter2, ranges, tables).getOrElse((Function0)new Serializable(this, strategy, filter2, ecql2, hints2, index, ranges, tables, colFamily2, schema2, (Option)indexFilter, cScan$lzy, max, projection, timeout$lzy, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseIndexAdapter $outer;
                    private final package.QueryStrategy strategy$1;
                    private final package.FilterStrategy filter$1;
                    private final Option ecql$1;
                    private final Hints hints$1;
                    private final GeoMesaFeatureIndex index$2;
                    private final Seq ranges$1;
                    private final Seq tables$2;
                    private final byte[] colFamily$1;
                    private final SimpleFeatureType schema$1;
                    private final Option indexFilter$1;
                    private final ObjectRef cScan$lzy$1;
                    private final Option max$1;
                    private final Option projection$1;
                    private final ObjectRef timeout$lzy$1;
                    private final VolatileByteRef bitmap$0$2;

                    public final HBaseQueryPlan.CoprocessorPlan apply() {
                        Map<String, String> options = HBaseDensityAggregator$.MODULE$.configure(this.schema$1, this.index$2, (Option<org.opengis.filter.Filter>)this.ecql$1, this.hints$1);
                        HBaseDensityAggregator.HBaseDensityResultsToFeatures results = new HBaseDensityAggregator.HBaseDensityResultsToFeatures();
                        return new HBaseQueryPlan.CoprocessorPlan(this.filter$1, (Seq<TableName>)this.tables$2, (Seq<Scan>)this.ranges$1, this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$cScan$1(this.ranges$1, this.colFamily$1, this.indexFilter$1, this.cScan$lzy$1, this.bitmap$0$2), (Map<String, String>)options.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$timeout$1(this.strategy$1, this.timeout$lzy$1, this.bitmap$0$2))), (QueryPlan.ResultsToFeatures<byte[]>)results, (Option<QueryPlan.FeatureReducer>)None$.MODULE$, (Option<Object>)this.max$1, (Option<Reprojection.QueryReferenceSystems>)this.projection$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.strategy$1 = strategy$1;
                        this.filter$1 = filter$1;
                        this.ecql$1 = ecql$1;
                        this.hints$1 = hints$1;
                        this.index$2 = index$2;
                        this.ranges$1 = ranges$1;
                        this.tables$2 = tables$2;
                        this.colFamily$1 = colFamily$1;
                        this.schema$1 = schema$1;
                        this.indexFilter$1 = indexFilter$1;
                        this.cScan$lzy$1 = cScan$lzy$1;
                        this.max$1 = max$1;
                        this.projection$1 = projection$1;
                        this.timeout$lzy$1 = timeout$lzy$1;
                        this.bitmap$0$2 = bitmap$0$2;
                    }
                });
                return hBaseQueryPlan;
            } else if (QueryHints$.MODULE$.RichHints(hints2).isArrowQuery()) {
                Tuple2 tuple24;
                Tuple2<Map<String, String>, QueryPlan.FeatureReducer> tuple25 = HBaseArrowAggregator$.MODULE$.configure(schema2, index, this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.stats(), (Option<org.opengis.filter.Filter>)filter2.filter(), (Option<org.opengis.filter.Filter>)ecql2, hints2);
                if (tuple25 == null) throw new MatchError(tuple25);
                Map options = (Map)tuple25._1();
                QueryPlan.FeatureReducer reducer = (QueryPlan.FeatureReducer)tuple25._2();
                Tuple2 tuple26 = tuple24 = new Tuple2((Object)options, (Object)reducer);
                Map options2 = (Map)tuple26._1();
                QueryPlan.FeatureReducer reducer2 = (QueryPlan.FeatureReducer)tuple26._2();
                hBaseQueryPlan = (HBaseQueryPlan)this.empty$1((Option)new Some((Object)reducer2), filter2, ranges, tables).getOrElse((Function0)new Serializable(this, strategy, filter2, ecql2, hints2, index, ranges, tables, colFamily2, schema2, transform, returnSchema$lzy, notSampling, cqlFilter$lzy, (Option)indexFilter, cScan$lzy, max, projection, timeout$lzy, options2, reducer2, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseIndexAdapter $outer;
                    private final package.QueryStrategy strategy$1;
                    private final package.FilterStrategy filter$1;
                    private final Option ecql$1;
                    private final Hints hints$1;
                    private final GeoMesaFeatureIndex index$2;
                    private final Seq ranges$1;
                    private final Seq tables$2;
                    private final byte[] colFamily$1;
                    private final SimpleFeatureType schema$1;
                    private final Option transform$1;
                    private final ObjectRef returnSchema$lzy$1;
                    private final boolean notSampling$1;
                    private final ObjectRef cqlFilter$lzy$1;
                    private final Option indexFilter$1;
                    private final ObjectRef cScan$lzy$1;
                    private final Option max$1;
                    private final Option projection$1;
                    private final ObjectRef timeout$lzy$1;
                    private final Map options$1;
                    private final QueryPlan.FeatureReducer reducer$2;
                    private final VolatileByteRef bitmap$0$2;

                    public final HBaseQueryPlan apply() {
                        Product product;
                        if (BoxesRunTime.unboxToBoolean((Object)HBaseDataStoreFactory$.MODULE$.RemoteArrowProperty().toBoolean().getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                return true;
                            }
                        }))) {
                            HBaseArrowAggregator.HBaseArrowResultsToFeatures results = new HBaseArrowAggregator.HBaseArrowResultsToFeatures();
                            product = new HBaseQueryPlan.CoprocessorPlan(this.filter$1, (Seq<TableName>)this.tables$2, (Seq<Scan>)this.ranges$1, this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$cScan$1(this.ranges$1, this.colFamily$1, this.indexFilter$1, this.cScan$lzy$1, this.bitmap$0$2), (Map<String, String>)this.options$1.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$timeout$1(this.strategy$1, this.timeout$lzy$1, this.bitmap$0$2))), (QueryPlan.ResultsToFeatures<byte[]>)results, (Option<QueryPlan.FeatureReducer>)new Some((Object)this.reducer$2), (Option<Object>)this.max$1, (Option<Reprojection.QueryReferenceSystems>)this.projection$1);
                        } else {
                            Seq filters = (Seq)((TraversableLike)((SeqLike)this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$cqlFilter$1(this.strategy$1, this.ecql$1, this.hints$1, this.schema$1, this.transform$1, this.notSampling$1, this.cqlFilter$lzy$1, this.bitmap$0$2).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.indexFilter$1), Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final int apply(Tuple2<Object, FilterBase> x$10) {
                                    return x$10._1$mcI$sp();
                                }
                            }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final FilterBase apply(Tuple2<Object, FilterBase> x$11) {
                                    return (FilterBase)x$11._2();
                                }
                            }, Seq$.MODULE$.canBuildFrom());
                            Seq<Scan> scans = this.$outer.configureScans((Seq<Scan>)this.ranges$1, this.colFamily$1, (Seq<Filter>)filters, false);
                            HBaseResultsToFeatures results = new HBaseResultsToFeatures(this.index$2, this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$returnSchema$1(this.schema$1, this.transform$1, this.returnSchema$lzy$1, this.bitmap$0$2));
                            Some arrowHook = new Some((Object)new LocalQueryRunner.ArrowDictionaryHook(this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.stats(), this.filter$1.filter()));
                            Some reducer = new Some((Object)new LocalQueryRunner.LocalTransformReducer(this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$returnSchema$1(this.schema$1, this.transform$1, this.returnSchema$lzy$1, this.bitmap$0$2), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, this.hints$1, (Option)arrowHook));
                            product = new HBaseQueryPlan.ScanPlan(this.filter$1, (Seq<TableName>)this.tables$2, (Seq<Scan>)this.ranges$1, scans, (QueryPlan.ResultsToFeatures<Result>)results, (Option<QueryPlan.FeatureReducer>)reducer, (Option<Seq<Tuple2<String, Object>>>)None$.MODULE$, (Option<Object>)this.max$1, (Option<Reprojection.QueryReferenceSystems>)this.projection$1);
                        }
                        return product;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.strategy$1 = strategy$1;
                        this.filter$1 = filter$1;
                        this.ecql$1 = ecql$1;
                        this.hints$1 = hints$1;
                        this.index$2 = index$2;
                        this.ranges$1 = ranges$1;
                        this.tables$2 = tables$2;
                        this.colFamily$1 = colFamily$1;
                        this.schema$1 = schema$1;
                        this.transform$1 = transform$1;
                        this.returnSchema$lzy$1 = returnSchema$lzy$1;
                        this.notSampling$1 = notSampling$1;
                        this.cqlFilter$lzy$1 = cqlFilter$lzy$1;
                        this.indexFilter$1 = indexFilter$1;
                        this.cScan$lzy$1 = cScan$lzy$1;
                        this.max$1 = max$1;
                        this.projection$1 = projection$1;
                        this.timeout$lzy$1 = timeout$lzy$1;
                        this.options$1 = options$1;
                        this.reducer$2 = reducer$2;
                        this.bitmap$0$2 = bitmap$0$2;
                    }
                });
                return hBaseQueryPlan;
            } else if (QueryHints$.MODULE$.RichHints(hints2).isStatsQuery()) {
                Some reducer = new Some((Object)StatsScan.StatsReducer$.MODULE$.apply(this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$returnSchema$1(schema2, transform, returnSchema$lzy, bitmap$0), hints2));
                hBaseQueryPlan = (HBaseQueryPlan)this.empty$1((Option)reducer, filter2, ranges, tables).getOrElse((Function0)new Serializable(this, strategy, filter2, ecql2, hints2, index, ranges, tables, colFamily2, schema2, (Option)indexFilter, cScan$lzy, max, projection, timeout$lzy, reducer, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseIndexAdapter $outer;
                    private final package.QueryStrategy strategy$1;
                    private final package.FilterStrategy filter$1;
                    private final Option ecql$1;
                    private final Hints hints$1;
                    private final GeoMesaFeatureIndex index$2;
                    private final Seq ranges$1;
                    private final Seq tables$2;
                    private final byte[] colFamily$1;
                    private final SimpleFeatureType schema$1;
                    private final Option indexFilter$1;
                    private final ObjectRef cScan$lzy$1;
                    private final Option max$1;
                    private final Option projection$1;
                    private final ObjectRef timeout$lzy$1;
                    private final Some reducer$3;
                    private final VolatileByteRef bitmap$0$2;

                    public final HBaseQueryPlan.CoprocessorPlan apply() {
                        Map<String, String> options = HBaseStatsAggregator$.MODULE$.configure(this.schema$1, this.index$2, (Option<org.opengis.filter.Filter>)this.ecql$1, this.hints$1);
                        HBaseStatsAggregator.HBaseStatsResultsToFeatures results = new HBaseStatsAggregator.HBaseStatsResultsToFeatures();
                        return new HBaseQueryPlan.CoprocessorPlan(this.filter$1, (Seq<TableName>)this.tables$2, (Seq<Scan>)this.ranges$1, this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$cScan$1(this.ranges$1, this.colFamily$1, this.indexFilter$1, this.cScan$lzy$1, this.bitmap$0$2), (Map<String, String>)options.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$timeout$1(this.strategy$1, this.timeout$lzy$1, this.bitmap$0$2))), (QueryPlan.ResultsToFeatures<byte[]>)results, (Option<QueryPlan.FeatureReducer>)this.reducer$3, (Option<Object>)this.max$1, (Option<Reprojection.QueryReferenceSystems>)this.projection$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.strategy$1 = strategy$1;
                        this.filter$1 = filter$1;
                        this.ecql$1 = ecql$1;
                        this.hints$1 = hints$1;
                        this.index$2 = index$2;
                        this.ranges$1 = ranges$1;
                        this.tables$2 = tables$2;
                        this.colFamily$1 = colFamily$1;
                        this.schema$1 = schema$1;
                        this.indexFilter$1 = indexFilter$1;
                        this.cScan$lzy$1 = cScan$lzy$1;
                        this.max$1 = max$1;
                        this.projection$1 = projection$1;
                        this.timeout$lzy$1 = timeout$lzy$1;
                        this.reducer$3 = reducer$3;
                        this.bitmap$0$2 = bitmap$0$2;
                    }
                });
                return hBaseQueryPlan;
            } else {
                hBaseQueryPlan = QueryHints$.MODULE$.RichHints(hints2).isBinQuery() ? (HBaseQueryPlan)this.empty$1((Option)None$.MODULE$, filter2, ranges, tables).getOrElse((Function0)new Serializable(this, strategy, filter2, ecql2, hints2, index, ranges, tables, colFamily2, schema2, (Option)indexFilter, cScan$lzy, max, projection, timeout$lzy, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseIndexAdapter $outer;
                    private final package.QueryStrategy strategy$1;
                    private final package.FilterStrategy filter$1;
                    private final Option ecql$1;
                    private final Hints hints$1;
                    private final GeoMesaFeatureIndex index$2;
                    private final Seq ranges$1;
                    private final Seq tables$2;
                    private final byte[] colFamily$1;
                    private final SimpleFeatureType schema$1;
                    private final Option indexFilter$1;
                    private final ObjectRef cScan$lzy$1;
                    private final Option max$1;
                    private final Option projection$1;
                    private final ObjectRef timeout$lzy$1;
                    private final VolatileByteRef bitmap$0$2;

                    public final HBaseQueryPlan.CoprocessorPlan apply() {
                        Map<String, String> options = HBaseBinAggregator$.MODULE$.configure(this.schema$1, this.index$2, (Option<org.opengis.filter.Filter>)this.ecql$1, this.hints$1);
                        HBaseBinAggregator.HBaseBinResultsToFeatures results = new HBaseBinAggregator.HBaseBinResultsToFeatures();
                        return new HBaseQueryPlan.CoprocessorPlan(this.filter$1, (Seq<TableName>)this.tables$2, (Seq<Scan>)this.ranges$1, this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$cScan$1(this.ranges$1, this.colFamily$1, this.indexFilter$1, this.cScan$lzy$1, this.bitmap$0$2), (Map<String, String>)options.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$timeout$1(this.strategy$1, this.timeout$lzy$1, this.bitmap$0$2))), (QueryPlan.ResultsToFeatures<byte[]>)results, (Option<QueryPlan.FeatureReducer>)None$.MODULE$, (Option<Object>)this.max$1, (Option<Reprojection.QueryReferenceSystems>)this.projection$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.strategy$1 = strategy$1;
                        this.filter$1 = filter$1;
                        this.ecql$1 = ecql$1;
                        this.hints$1 = hints$1;
                        this.index$2 = index$2;
                        this.ranges$1 = ranges$1;
                        this.tables$2 = tables$2;
                        this.colFamily$1 = colFamily$1;
                        this.schema$1 = schema$1;
                        this.indexFilter$1 = indexFilter$1;
                        this.cScan$lzy$1 = cScan$lzy$1;
                        this.max$1 = max$1;
                        this.projection$1 = projection$1;
                        this.timeout$lzy$1 = timeout$lzy$1;
                        this.bitmap$0$2 = bitmap$0$2;
                    }
                }) : (HBaseQueryPlan)this.empty$1((Option)None$.MODULE$, filter2, ranges, tables).getOrElse((Function0)new Serializable(this, strategy, filter2, ecql2, hints2, index, ranges, tables, colFamily2, schema2, transform, returnSchema$lzy, notSampling, cqlFilter$lzy, (Option)indexFilter, max, projection, bitmap$0){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HBaseIndexAdapter $outer;
                    private final package.QueryStrategy strategy$1;
                    private final package.FilterStrategy filter$1;
                    private final Option ecql$1;
                    private final Hints hints$1;
                    private final GeoMesaFeatureIndex index$2;
                    private final Seq ranges$1;
                    private final Seq tables$2;
                    private final byte[] colFamily$1;
                    private final SimpleFeatureType schema$1;
                    private final Option transform$1;
                    private final ObjectRef returnSchema$lzy$1;
                    private final boolean notSampling$1;
                    private final ObjectRef cqlFilter$lzy$1;
                    private final Option indexFilter$1;
                    private final Option max$1;
                    private final Option projection$1;
                    private final VolatileByteRef bitmap$0$2;

                    public final HBaseQueryPlan.ScanPlan apply() {
                        Seq filters = (Seq)((TraversableLike)((SeqLike)this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$cqlFilter$1(this.strategy$1, this.ecql$1, this.hints$1, this.schema$1, this.transform$1, this.notSampling$1, this.cqlFilter$lzy$1, this.bitmap$0$2).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.indexFilter$1), Seq$.MODULE$.canBuildFrom())).sortBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Tuple2<Object, FilterBase> x$12) {
                                return x$12._1$mcI$sp();
                            }
                        }, (Ordering)Ordering.Int$.MODULE$)).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final FilterBase apply(Tuple2<Object, FilterBase> x$13) {
                                return (FilterBase)x$13._2();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq<Scan> scans = this.$outer.configureScans((Seq<Scan>)this.ranges$1, this.colFamily$1, (Seq<Filter>)filters, false);
                        HBaseResultsToFeatures results = new HBaseResultsToFeatures(this.index$2, this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$returnSchema$1(this.schema$1, this.transform$1, this.returnSchema$lzy$1, this.bitmap$0$2));
                        return new HBaseQueryPlan.ScanPlan(this.filter$1, (Seq<TableName>)this.tables$2, (Seq<Scan>)this.ranges$1, scans, (QueryPlan.ResultsToFeatures<Result>)results, (Option<QueryPlan.FeatureReducer>)None$.MODULE$, (Option<Seq<Tuple2<String, Object>>>)QueryHints$.MODULE$.RichHints(this.hints$1).getSortFields(), (Option<Object>)this.max$1, (Option<Reprojection.QueryReferenceSystems>)this.projection$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.strategy$1 = strategy$1;
                        this.filter$1 = filter$1;
                        this.ecql$1 = ecql$1;
                        this.hints$1 = hints$1;
                        this.index$2 = index$2;
                        this.ranges$1 = ranges$1;
                        this.tables$2 = tables$2;
                        this.colFamily$1 = colFamily$1;
                        this.schema$1 = schema$1;
                        this.transform$1 = transform$1;
                        this.returnSchema$lzy$1 = returnSchema$lzy$1;
                        this.notSampling$1 = notSampling$1;
                        this.cqlFilter$lzy$1 = cqlFilter$lzy$1;
                        this.indexFilter$1 = indexFilter$1;
                        this.max$1 = max$1;
                        this.projection$1 = projection$1;
                        this.bitmap$0$2 = bitmap$0$2;
                    }
                });
            }
            return hBaseQueryPlan;
        } else {
            Some arrowHook = new Some((Object)new LocalQueryRunner.ArrowDictionaryHook(this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.stats(), filter2.filter()));
            Some reducer = new Some((Object)new LocalQueryRunner.LocalTransformReducer(schema2, filter2.filter(), (Option)None$.MODULE$, transform, hints2, (Option)arrowHook));
            hBaseQueryPlan = (HBaseQueryPlan)this.empty$1((Option)reducer, filter2, ranges, tables).getOrElse((Function0)new Serializable(this, filter2, hints2, index, ranges, tables, colFamily2, schema2, reducer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HBaseIndexAdapter $outer;
                private final package.FilterStrategy filter$1;
                private final Hints hints$1;
                private final GeoMesaFeatureIndex index$2;
                private final Seq ranges$1;
                private final Seq tables$2;
                private final byte[] colFamily$1;
                private final SimpleFeatureType schema$1;
                private final Some reducer$1;

                public final HBaseQueryPlan.ScanPlan apply() {
                    Seq<Scan> scans = this.$outer.configureScans((Seq<Scan>)this.ranges$1, this.colFamily$1, (Seq<Filter>)((Seq)Seq$.MODULE$.empty()), false);
                    HBaseResultsToFeatures resultsToFeatures = new HBaseResultsToFeatures(this.index$2, this.schema$1);
                    Option sort = QueryHints$.MODULE$.RichHints(this.hints$1).getSortFields();
                    Option max = QueryHints$.MODULE$.RichHints(this.hints$1).getMaxFeatures();
                    Option project = QueryHints$.MODULE$.RichHints(this.hints$1).getProjection();
                    return new HBaseQueryPlan.ScanPlan(this.filter$1, (Seq<TableName>)this.tables$2, (Seq<Scan>)this.ranges$1, scans, (QueryPlan.ResultsToFeatures<Result>)resultsToFeatures, (Option<QueryPlan.FeatureReducer>)this.reducer$1, (Option<Seq<Tuple2<String, Object>>>)sort, (Option<Object>)max, (Option<Reprojection.QueryReferenceSystems>)project);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.filter$1 = filter$1;
                    this.hints$1 = hints$1;
                    this.index$2 = index$2;
                    this.ranges$1 = ranges$1;
                    this.tables$2 = tables$2;
                    this.colFamily$1 = colFamily$1;
                    this.schema$1 = schema$1;
                    this.reducer$1 = reducer$1;
                }
            });
        }
        return hBaseQueryPlan;
    }

    public HBaseIndexWriter createWriter(SimpleFeatureType sft, Seq<GeoMesaFeatureIndex<?, ?>> indices, Option<String> partition) {
        return new HBaseIndexWriter(this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds, indices, (WritableFeature.FeatureWrapper<WritableFeature>)WritableFeature$.MODULE$.wrapper(sft, this.groups()), partition);
    }

    public Seq<Scan> configureScans(Seq<Scan> originalRanges, byte[] colFamily, Seq<Filter> filters, boolean coprocessor) {
        Seq seq;
        BoxedUnit boxedUnit;
        boolean cacheBlocks = BoxesRunTime.unboxToBoolean((Object)package$HBaseSystemProperties$.MODULE$.ScannerBlockCaching().toBoolean().get());
        Option cacheSize = package$HBaseSystemProperties$.MODULE$.ScannerCaching().toInt();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("HBase client scanner: block caching: {}, caching: {}", new Object[]{BoxesRunTime.boxToBoolean((boolean)cacheBlocks), cacheSize});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (coprocessor) {
            Scan scan2 = new Scan();
            scan2.addFamily(colFamily);
            MultiRowRangeFilter mrrf = new MultiRowRangeFilter(HBaseIndexAdapter$.MODULE$.sortAndMerge(originalRanges));
            scan2.setFilter((Filter)new FilterList((Filter[])((TraversableOnce)filters.$plus$colon((Object)mrrf, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Filter.class))));
            scan2.setCacheBlocks(cacheBlocks);
            cacheSize.foreach((Function1)new Serializable(this, scan2){
                public static final long serialVersionUID = 0L;
                private final Scan scan$2;

                public final Scan apply(int x$1) {
                    return this.scan$2.setCaching(x$1);
                }
                {
                    this.scan$2 = scan$2;
                }
            });
            this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.applySecurity((Query)scan2);
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Scan[]{scan2}));
        } else if (originalRanges.headOption().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Scan x$14) {
                return x$14.isSmall();
            }
        })) {
            None$ none$;
            Seq<Filter> seq2 = filters;
            if (Nil$.MODULE$.equals(seq2)) {
                none$ = None$.MODULE$;
            } else {
                Some some = Seq$.MODULE$.unapplySeq(seq2);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                    Filter f = (Filter)((SeqLike)some.get()).apply(0);
                    none$ = new Some((Object)f);
                } else {
                    none$ = new Some((Object)new FilterList((Filter[])seq2.toArray(ClassTag$.MODULE$.apply(Filter.class))));
                }
            }
            None$ filter = none$;
            seq = (Seq)originalRanges.map((Function1)new Serializable(this, colFamily, cacheBlocks, cacheSize, (Option)filter){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HBaseIndexAdapter $outer;
                private final byte[] colFamily$2;
                private final boolean cacheBlocks$1;
                private final Option cacheSize$1;
                private final Option filter$2;

                /*
                 * WARNING - void declaration
                 */
                public final Scan apply(Scan s) {
                    void var2_2;
                    Scan scan2 = new Scan(s).addFamily(this.colFamily$2);
                    this.filter$2.foreach((Function1)new Serializable(this, scan2){
                        public static final long serialVersionUID = 0L;
                        private final Scan scan$3;

                        public final Scan apply(Filter x$1) {
                            return this.scan$3.setFilter(x$1);
                        }
                        {
                            this.scan$3 = scan$3;
                        }
                    });
                    scan2.setCacheBlocks(this.cacheBlocks$1);
                    this.cacheSize$1.foreach((Function1)new Serializable(this, scan2){
                        public static final long serialVersionUID = 0L;
                        private final Scan scan$3;

                        public final Scan apply(int x$1) {
                            return this.scan$3.setCaching(x$1);
                        }
                        {
                            this.scan$3 = scan$3;
                        }
                    });
                    this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.applySecurity((Query)scan2);
                    return var2_2;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.colFamily$2 = colFamily$2;
                    this.cacheBlocks$1 = cacheBlocks$1;
                    this.cacheSize$1 = cacheSize$1;
                    this.filter$2 = filter$2;
                }
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            List<MultiRowRangeFilter.RowRange> rowRanges = HBaseIndexAdapter$.MODULE$.sortAndMerge(originalRanges);
            int rangesPerThread = package$.MODULE$.min(this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.config().maxRangesPerExtendedScan(), package$.MODULE$.max(1, (int)package$.MODULE$.ceil((double)(rowRanges.size() / this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.config().queryThreads() * 2))));
            ArrayList groupedScans = new ArrayList((rowRanges.size() / rangesPerThread + 1) * 2);
            if (!rowRanges.isEmpty()) {
                int i;
                byte groupFirstByte;
                int groupStart = 0;
                int groupCount = 1;
                byte by = groupFirstByte = Predef$.MODULE$.byteArrayOps(rowRanges.get(0).getStartRow()).isEmpty() ? (byte)0 : rowRanges.get(0).getStartRow()[0];
                for (i = 1; i < rowRanges.size(); ++i) {
                    MultiRowRangeFilter.RowRange nextRange = rowRanges.get(i);
                    if (groupCount == rangesPerThread || nextRange.getStartRow().length > 0 && groupFirstByte != nextRange.getStartRow()[0]) {
                        this.addGroup$1(rowRanges.subList(groupStart, i), colFamily, filters, cacheBlocks, cacheSize, groupedScans);
                        groupFirstByte = Predef$.MODULE$.byteArrayOps(nextRange.getStopRow()).isEmpty() ? (byte)127 : nextRange.getStopRow()[0];
                        groupStart = i;
                        groupCount = 1;
                        continue;
                    }
                    ++groupCount;
                }
                this.addGroup$1(rowRanges.subList(groupStart, i), colFamily, filters, cacheBlocks, cacheSize, groupedScans);
            }
            Collections.shuffle(groupedScans);
            seq = (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(groupedScans).asScala();
        }
        return seq;
    }

    public void org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$waitForTable(Admin admin, TableName table) {
        if (!admin.isTableAvailable(table)) {
            BoxedUnit boxedUnit;
            Option timeout2 = package$HBaseSystemProperties$.MODULE$.TableAvailabilityTimeout().toDuration().filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Duration x$15) {
                    return x$15.isFinite();
                }
            });
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Waiting for table '", "' to become available with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{table}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timeout2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Duration t) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a timeout of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t}));
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "no timeout";
                    }
                })}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            Option stop = timeout2.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(Duration t) {
                    return System.currentTimeMillis() + t.toMillis();
                }
            });
            while (!admin.isTableAvailable(table) && stop.forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(long x$16) {
                    return this.apply$mcZJ$sp(x$16);
                }

                public boolean apply$mcZJ$sp(long x$16) {
                    return x$16 > System.currentTimeMillis();
                }
            })) {
                Thread.sleep(1000L);
            }
        }
    }

    private final Option empty$1(Option reducer, package.FilterStrategy filter$1, Seq ranges$1, Seq tables$2) {
        return tables$2.isEmpty() || ranges$1.isEmpty() ? new Some((Object)new HBaseQueryPlan.EmptyPlan(filter$1, (Option<QueryPlan.FeatureReducer>)reducer)) : None$.MODULE$;
    }

    private final SimpleFeatureType returnSchema$lzycompute$1(SimpleFeatureType schema$1, Option transform$1, ObjectRef returnSchema$lzy$1, VolatileByteRef bitmap$0$2) {
        HBaseIndexAdapter hBaseIndexAdapter = this;
        synchronized (hBaseIndexAdapter) {
            if ((byte)(bitmap$0$2.elem & 1) == 0) {
                returnSchema$lzy$1.elem = (SimpleFeatureType)transform$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SimpleFeatureType apply(Tuple2<String, SimpleFeatureType> x$7) {
                        return (SimpleFeatureType)x$7._2();
                    }
                }).getOrElse((Function0)new Serializable(this, schema$1){
                    public static final long serialVersionUID = 0L;
                    private final SimpleFeatureType schema$1;

                    public final SimpleFeatureType apply() {
                        return this.schema$1;
                    }
                    {
                        this.schema$1 = schema$1;
                    }
                });
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 1);
            }
            return (SimpleFeatureType)returnSchema$lzy$1.elem;
        }
    }

    public final SimpleFeatureType org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$returnSchema$1(SimpleFeatureType schema$1, Option transform$1, ObjectRef returnSchema$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 1) == 0 ? this.returnSchema$lzycompute$1(schema$1, transform$1, returnSchema$lzy$1, bitmap$0$2) : (SimpleFeatureType)returnSchema$lzy$1.elem;
    }

    private final Seq cqlFilter$lzycompute$1(package.QueryStrategy strategy$1, Option ecql$1, Hints hints$1, SimpleFeatureType schema$1, Option transform$1, boolean notSampling$1, ObjectRef cqlFilter$lzy$1, VolatileByteRef bitmap$0$2) {
        HBaseIndexAdapter hBaseIndexAdapter = this;
        synchronized (hBaseIndexAdapter) {
            if ((byte)(bitmap$0$2.elem & 2) == 0) {
                cqlFilter$lzy$1.elem = ecql$1.isEmpty() && transform$1.isEmpty() && notSampling$1 ? (Seq)Seq$.MODULE$.empty() : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)CqlTransformFilter$.MODULE$.Priority()), (Object)CqlTransformFilter$.MODULE$.apply(schema$1, strategy$1.index(), (Option<org.opengis.filter.Filter>)ecql$1, (Option<Tuple2<String, SimpleFeatureType>>)transform$1, hints$1))}));
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 2);
            }
            return (Seq)cqlFilter$lzy$1.elem;
        }
    }

    public final Seq org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$cqlFilter$1(package.QueryStrategy strategy$1, Option ecql$1, Hints hints$1, SimpleFeatureType schema$1, Option transform$1, boolean notSampling$1, ObjectRef cqlFilter$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 2) == 0 ? this.cqlFilter$lzycompute$1(strategy$1, ecql$1, hints$1, schema$1, transform$1, notSampling$1, cqlFilter$lzy$1, bitmap$0$2) : (Seq)cqlFilter$lzy$1.elem;
    }

    private final Scan cScan$lzycompute$1(Seq ranges$1, byte[] colFamily$1, Option indexFilter$1, ObjectRef cScan$lzy$1, VolatileByteRef bitmap$0$2) {
        HBaseIndexAdapter hBaseIndexAdapter = this;
        synchronized (hBaseIndexAdapter) {
            if ((byte)(bitmap$0$2.elem & 4) == 0) {
                Seq<Scan> seq = this.configureScans((Seq<Scan>)ranges$1, colFamily$1, (Seq<Filter>)((Seq)Option$.MODULE$.option2Iterable(indexFilter$1).toSeq().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final FilterBase apply(Tuple2<Object, FilterBase> x$8) {
                        return (FilterBase)x$8._2();
                    }
                }, Seq$.MODULE$.canBuildFrom())), true);
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                    Scan cScan;
                    Scan scan2 = cScan = (Scan)((SeqLike)some.get()).apply(0);
                    cScan$lzy$1.elem = scan2;
                    bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 4);
                } else {
                    throw new MatchError(seq);
                }
            }
            return (Scan)cScan$lzy$1.elem;
        }
    }

    public final Scan org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$cScan$1(Seq ranges$1, byte[] colFamily$1, Option indexFilter$1, ObjectRef cScan$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 4) == 0 ? this.cScan$lzycompute$1(ranges$1, colFamily$1, indexFilter$1, cScan$lzy$1, bitmap$0$2) : (Scan)cScan$lzy$1.elem;
    }

    private final Option timeout$lzycompute$1(package.QueryStrategy strategy$1, ObjectRef timeout$lzy$1, VolatileByteRef bitmap$0$2) {
        HBaseIndexAdapter hBaseIndexAdapter = this;
        synchronized (hBaseIndexAdapter) {
            if ((byte)(bitmap$0$2.elem & 8) == 0) {
                timeout$lzy$1.elem = strategy$1.index().ds().config().queryTimeout().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(long millis) {
                        return GeoMesaCoprocessor$.MODULE$.timeout(millis);
                    }
                });
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 8);
            }
            return (Option)timeout$lzy$1.elem;
        }
    }

    public final Option org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$timeout$1(package.QueryStrategy strategy$1, ObjectRef timeout$lzy$1, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 8) == 0 ? this.timeout$lzycompute$1(strategy$1, timeout$lzy$1, bitmap$0$2) : (Option)timeout$lzy$1.elem;
    }

    private final void addGroup$1(List group, byte[] colFamily$2, Seq filters$1, boolean cacheBlocks$1, Option cacheSize$1, ArrayList groupedScans$1) {
        BoxedUnit boxedUnit;
        Scan s = new Scan(((MultiRowRangeFilter.RowRange)group.get(0)).getStartRow(), ((MultiRowRangeFilter.RowRange)group.get(group.size() - 1)).getStopRow()).addFamily(colFamily$2);
        if (group.size() > 1) {
            MultiRowRangeFilter mrrf = new MultiRowRangeFilter(group);
            boxedUnit = s.setFilter((Filter)(filters$1.isEmpty() ? mrrf : new FilterList((Filter[])((TraversableOnce)filters$1.$plus$colon((Object)mrrf, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Filter.class)))));
        } else {
            BoxedUnit boxedUnit2;
            Seq seq = filters$1;
            if (Nil$.MODULE$.equals(seq)) {
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                    Filter f = (Filter)((SeqLike)some.get()).apply(0);
                    boxedUnit2 = s.setFilter(f);
                } else {
                    boxedUnit2 = s.setFilter((Filter)new FilterList((Filter[])seq.toArray(ClassTag$.MODULE$.apply(Filter.class))));
                }
            }
            boxedUnit = boxedUnit2;
        }
        s.setCacheBlocks(cacheBlocks$1);
        cacheSize$1.foreach((Function1)new Serializable(this, s){
            public static final long serialVersionUID = 0L;
            private final Scan s$1;

            public final Scan apply(int x$1) {
                return this.s$1.setCaching(x$1);
            }
            {
                this.s$1 = s$1;
            }
        });
        this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds.applySecurity((Query)s);
        groupedScans$1.add(s);
    }

    public HBaseIndexAdapter(HBaseDataStore ds) {
        this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$$ds = ds;
        IndexAdapter.class.$init$((IndexAdapter)this);
        StrictLogging.class.$init$((StrictLogging)this);
    }

    public static class HBaseIndexWriter
    extends IndexAdapter.BaseIndexWriter<WritableFeature> {
        public final HBaseDataStore org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$HBaseIndexWriter$$ds;
        public final Option<String> org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$HBaseIndexWriter$$partition;
        private final Option<Object> org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$HBaseIndexWriter$$batchSize;
        private final BufferedMutator[] mutators;
        private int i;

        public Option<Object> org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$HBaseIndexWriter$$batchSize() {
            return this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$HBaseIndexWriter$$batchSize;
        }

        private BufferedMutator[] mutators() {
            return this.mutators;
        }

        private int i() {
            return this.i;
        }

        private void i_$eq(int x$1) {
            this.i = x$1;
        }

        public void write(WritableFeature feature, package.RowKeyValue<?>[] values, boolean update) {
            if (update) {
                this.flush();
                Thread.sleep(1L);
            }
            this.i_$eq(0);
            while (this.i() < values.length) {
                package.RowKeyValue<?> rowKeyValue;
                block7: {
                    block6: {
                        BoxedUnit boxedUnit;
                        BufferedMutator mutator;
                        block5: {
                            mutator = this.mutators()[this.i()];
                            rowKeyValue = values[this.i()];
                            if (!(rowKeyValue instanceof package.SingleRowKeyValue)) break block5;
                            package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                            singleRowKeyValue.values().foreach((Function1)new Serializable(this, mutator, singleRowKeyValue){
                                public static final long serialVersionUID = 0L;
                                private final BufferedMutator mutator$2;
                                private final package.SingleRowKeyValue x2$1;

                                public final void apply(package.KeyValue value) {
                                    Put put = new Put(this.x2$1.row());
                                    put.addImmutable(value.cf(), value.cq(), value.value());
                                    Object object = Predef$.MODULE$.byteArrayOps(value.vis()).isEmpty() ? BoxedUnit.UNIT : put.setCellVisibility(new CellVisibility(new String(value.vis(), StandardCharsets.UTF_8)));
                                    put.setDurability(HBaseIndexAdapter$.MODULE$.durability());
                                    this.mutator$2.mutate((Mutation)put);
                                }
                                {
                                    this.mutator$2 = mutator$2;
                                    this.x2$1 = x2$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                            break block6;
                        }
                        if (!(rowKeyValue instanceof package.MultiRowKeyValue)) break block7;
                        package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                        multiRowKeyValue.rows().foreach((Function1)new Serializable(this, mutator, multiRowKeyValue){
                            public static final long serialVersionUID = 0L;
                            public final BufferedMutator mutator$2;
                            private final package.MultiRowKeyValue x3$1;

                            public final void apply(byte[] row) {
                                this.x3$1.values().foreach((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ HBaseIndexWriter$$anonfun$write$2 $outer;
                                    private final byte[] row$1;

                                    public final void apply(package.KeyValue value) {
                                        Put put = new Put(this.row$1);
                                        put.addImmutable(value.cf(), value.cq(), value.value());
                                        Object object = Predef$.MODULE$.byteArrayOps(value.vis()).isEmpty() ? BoxedUnit.UNIT : put.setCellVisibility(new CellVisibility(new String(value.vis(), StandardCharsets.UTF_8)));
                                        put.setDurability(HBaseIndexAdapter$.MODULE$.durability());
                                        this.$outer.mutator$2.mutate((Mutation)put);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.row$1 = row$1;
                                    }
                                });
                            }
                            {
                                this.mutator$2 = mutator$2;
                                this.x3$1 = x3$1;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.i_$eq(this.i() + 1);
                    continue;
                }
                throw new MatchError(rowKeyValue);
            }
        }

        public void delete(WritableFeature feature, package.RowKeyValue<?>[] values) {
            this.i_$eq(0);
            while (this.i() < values.length) {
                package.RowKeyValue<?> rowKeyValue;
                block5: {
                    block4: {
                        BoxedUnit boxedUnit;
                        BufferedMutator mutator;
                        block3: {
                            mutator = this.mutators()[this.i()];
                            rowKeyValue = values[this.i()];
                            if (!(rowKeyValue instanceof package.SingleRowKeyValue)) break block3;
                            package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                            singleRowKeyValue.values().foreach((Function1)new Serializable(this, mutator, singleRowKeyValue){
                                public static final long serialVersionUID = 0L;
                                private final BufferedMutator mutator$3;
                                private final package.SingleRowKeyValue x2$2;

                                public final void apply(package.KeyValue value) {
                                    Delete del = new Delete(this.x2$2.row());
                                    del.addFamily(value.cf());
                                    Object object = Predef$.MODULE$.byteArrayOps(value.vis()).isEmpty() ? BoxedUnit.UNIT : del.setCellVisibility(new CellVisibility(new String(value.vis(), StandardCharsets.UTF_8)));
                                    this.mutator$3.mutate((Mutation)del);
                                }
                                {
                                    this.mutator$3 = mutator$3;
                                    this.x2$2 = x2$2;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                            break block4;
                        }
                        if (!(rowKeyValue instanceof package.MultiRowKeyValue)) break block5;
                        package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                        multiRowKeyValue.rows().foreach((Function1)new Serializable(this, mutator, multiRowKeyValue){
                            public static final long serialVersionUID = 0L;
                            public final BufferedMutator mutator$3;
                            private final package.MultiRowKeyValue x3$2;

                            public final void apply(byte[] row) {
                                this.x3$2.values().foreach((Function1)new Serializable(this, row){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ HBaseIndexWriter$$anonfun$delete$2 $outer;
                                    private final byte[] row$2;

                                    public final void apply(package.KeyValue value) {
                                        Delete del = new Delete(this.row$2);
                                        del.addFamily(value.cf());
                                        Object object = Predef$.MODULE$.byteArrayOps(value.vis()).isEmpty() ? BoxedUnit.UNIT : del.setCellVisibility(new CellVisibility(new String(value.vis(), StandardCharsets.UTF_8)));
                                        this.$outer.mutator$3.mutate((Mutation)del);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.row$2 = row$2;
                                    }
                                });
                            }
                            {
                                this.mutator$3 = mutator$3;
                                this.x3$2 = x3$2;
                            }
                        });
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    this.i_$eq(this.i() + 1);
                    continue;
                }
                throw new MatchError(rowKeyValue);
            }
        }

        public void flush() {
            Throwable[] exceptions = (Throwable[])Predef$.MODULE$.refArrayOps((Object[])this.mutators()).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<Throwable> apply(Object f) {
                    return Option$.MODULE$.option2Iterable(FlushWithLogging$.MODULE$.apply(f));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Throwable.class)));
            if (Predef$.MODULE$.refArrayOps((Object[])exceptions).nonEmpty()) {
                Throwable head = (Throwable)Predef$.MODULE$.refArrayOps((Object[])exceptions).head();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])exceptions).tail()).foreach((Function1)new Serializable(this, head){
                    public static final long serialVersionUID = 0L;
                    private final Throwable head$1;

                    public final void apply(Throwable x$1) {
                        this.head$1.addSuppressed(x$1);
                    }
                    {
                        this.head$1 = head$1;
                    }
                });
                throw head;
            }
        }

        public void close() {
            Throwable[] exceptions = (Throwable[])Predef$.MODULE$.refArrayOps((Object[])this.mutators()).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Iterable<Throwable> apply(Object c) {
                    return Option$.MODULE$.option2Iterable(CloseWithLogging$.MODULE$.apply(c));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Throwable.class)));
            if (Predef$.MODULE$.refArrayOps((Object[])exceptions).nonEmpty()) {
                Throwable head = (Throwable)Predef$.MODULE$.refArrayOps((Object[])exceptions).head();
                Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])exceptions).tail()).foreach((Function1)new Serializable(this, head){
                    public static final long serialVersionUID = 0L;
                    private final Throwable head$2;

                    public final void apply(Throwable x$1) {
                        this.head$2.addSuppressed(x$1);
                    }
                    {
                        this.head$2 = head$2;
                    }
                });
                throw head;
            }
        }

        public HBaseIndexWriter(HBaseDataStore ds, Seq<GeoMesaFeatureIndex<?, ?>> indices, WritableFeature.FeatureWrapper<WritableFeature> wrapper, Option<String> partition) {
            this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$HBaseIndexWriter$$ds = ds;
            this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$HBaseIndexWriter$$partition = partition;
            super(indices, wrapper);
            this.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$HBaseIndexWriter$$batchSize = package$HBaseSystemProperties$.MODULE$.WriteBatchSize().toLong();
            this.mutators = (BufferedMutator[])Predef$.MODULE$.refArrayOps((Object[])super.indices().toArray(ClassTag$.MODULE$.apply(GeoMesaFeatureIndex.class))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ HBaseIndexWriter $outer;

                public final BufferedMutator apply(GeoMesaFeatureIndex<?, ?> index) {
                    Seq seq = index.getTableNames(this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$HBaseIndexWriter$$partition);
                    Some some = Seq$.MODULE$.unapplySeq(seq);
                    if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                        String t;
                        String string;
                        String table = string = (t = (String)((SeqLike)some.get()).apply(0));
                        BufferedMutatorParams params = new BufferedMutatorParams(TableName.valueOf((String)table));
                        this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$HBaseIndexWriter$$batchSize().foreach((Function1)new Serializable(this, params){
                            public static final long serialVersionUID = 0L;
                            private final BufferedMutatorParams params$1;

                            public final BufferedMutatorParams apply(long x$1) {
                                return this.params$1.writeBufferSize(x$1);
                            }
                            {
                                this.params$1 = params$1;
                            }
                        });
                        return this.$outer.org$locationtech$geomesa$hbase$data$HBaseIndexAdapter$HBaseIndexWriter$$ds.connection().getBufferedMutator(params);
                    }
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a single table but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq.mkString(", ")})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BufferedMutator.class)));
            this.i = 0;
        }
    }

    public static class HBaseResultsToFeatures
    extends QueryPlan.IndexResultsToFeatures<Result> {
        public SimpleFeature apply(Result result) {
            Cell cell = result.rawCells()[0];
            String id = this.index().getIdFromRow(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), null);
            return this.serializer().deserialize(id, cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        }

        public HBaseResultsToFeatures(GeoMesaFeatureIndex<?, ?> _index, SimpleFeatureType _sft) {
            super(_index, _sft);
        }

        public HBaseResultsToFeatures() {
            this(null, null);
        }
    }
}

