/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.filters;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.locationtech.geomesa.hbase.filters.S2HBaseFilter;
import org.locationtech.geomesa.index.filters.S2Filter;
import org.locationtech.geomesa.index.filters.S2Filter$;
import org.locationtech.geomesa.index.package$;
import org.locationtech.geomesa.utils.cache.ByteArrayCacheKey;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import scala.Array$;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class S2HBaseFilter$
implements StrictLogging {
    public static final S2HBaseFilter$ MODULE$;
    private final int Priority;
    private final LoadingCache<ByteArrayCacheKey, Tuple2<S2Filter, Object>> cache;
    private final Logger logger;

    static {
        new S2HBaseFilter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int Priority() {
        return this.Priority;
    }

    private LoadingCache<ByteArrayCacheKey, Tuple2<S2Filter, Object>> cache() {
        return this.cache;
    }

    public S2HBaseFilter apply(S2Filter filter, int offset) {
        byte[] filterBytes = S2Filter$.MODULE$.serializeToBytes(filter);
        byte[] serialized = (byte[])Array$.MODULE$.ofDim(filterBytes.length + 4, ClassTag$.MODULE$.Byte());
        System.arraycopy(filterBytes, 0, serialized, 0, filterBytes.length);
        ByteArrays$.MODULE$.writeInt(offset, serialized, filterBytes.length);
        return new S2HBaseFilter(filter, offset, serialized);
    }

    public Filter parseFrom(byte[] pbBytes) throws DeserializationException {
        Tuple2 tuple2 = (Tuple2)this.cache().get((Object)new ByteArrayCacheKey(pbBytes));
        if (tuple2 != null) {
            Tuple2 tuple22;
            S2Filter filter = (S2Filter)tuple2._1();
            int offset = tuple2._2$mcI$sp();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)filter, (Object)BoxesRunTime.boxToInteger((int)offset));
            S2Filter filter2 = (S2Filter)tuple23._1();
            int offset2 = tuple23._2$mcI$sp();
            return new S2HBaseFilter(filter2, offset2, pbBytes);
        }
        throw new MatchError((Object)tuple2);
    }

    private S2HBaseFilter$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.Priority = 20;
        this.cache = Caffeine.newBuilder().maximumSize((long)BoxesRunTime.unboxToInt((Object)package$.MODULE$.FilterCacheSize().toInt().get())).build((CacheLoader)new CacheLoader<ByteArrayCacheKey, Tuple2<S2Filter, Object>>(){

            public Tuple2<S2Filter, Object> load(ByteArrayCacheKey key) {
                BoxedUnit boxedUnit;
                S2Filter filter = S2Filter$.MODULE$.deserializeFromBytes(key.bytes());
                int offset = ByteArrays$.MODULE$.readInt(key.bytes(), key.bytes().length - 4);
                if (S2HBaseFilter$.MODULE$.logger().underlying().isTraceEnabled()) {
                    S2HBaseFilter$.MODULE$.logger().underlying().trace("Deserialized {}:{}", new Object[]{BoxesRunTime.boxToInteger((int)offset), filter});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new Tuple2((Object)filter, (Object)BoxesRunTime.boxToInteger((int)offset));
            }
        });
    }
}

