/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.process.analytic;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.process.GeoMesaProcessVisitor;
import org.locationtech.geomesa.index.utils.FeatureSampler$;
import org.locationtech.geomesa.process.FeatureResult;
import org.locationtech.geomesa.process.GeoMesaProcessVisitor;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.Expression;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001B\u0001\u0003\u00015\u0011qbU1na2Lgn\u001a,jg&$xN\u001d\u0006\u0003\u0007\u0011\t\u0001\"\u00198bYf$\u0018n\u0019\u0006\u0003\u000b\u0019\tq\u0001\u001d:pG\u0016\u001c8O\u0003\u0002\b\u0011\u00059q-Z8nKN\f'BA\u0005\u000b\u00031awnY1uS>tG/Z2i\u0015\u0005Y\u0011aA8sO\u000e\u00011\u0003\u0002\u0001\u000f-i\u0001\"a\u0004\u000b\u000e\u0003AQ!!\u0005\n\u0002\t1\fgn\u001a\u0006\u0002'\u0005!!.\u0019<b\u0013\t)\u0002C\u0001\u0004PE*,7\r\u001e\t\u0003/ai\u0011\u0001B\u0005\u00033\u0011\u0011QcR3p\u001b\u0016\u001c\u0018\r\u0015:pG\u0016\u001c8OV5tSR|'\u000f\u0005\u0002\u001cE5\tAD\u0003\u0002\u001e=\u0005a1oY1mC2|wmZ5oO*\u0011q\u0004I\u0001\tif\u0004Xm]1gK*\t\u0011%A\u0002d_6L!a\t\u000f\u0003\u00171\u000b'0\u001f'pO\u001eLgn\u001a\u0005\tK\u0001\u0011\t\u0011)A\u0005M\u0005Aa-Z1ukJ,7\u000f\u0005\u0002(]5\t\u0001F\u0003\u0002*U\u000511/[7qY\u0016T!a\u000b\u0017\u0002\t\u0011\fG/\u0019\u0006\u0003[)\t\u0001bZ3pi>|Gn]\u0005\u0003_!\u0012qcU5na2,g)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\t\u0011E\u0002!\u0011!Q\u0001\nI\nq\u0001]3sG\u0016tG\u000f\u0005\u00024m5\tAGC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9DGA\u0003GY>\fG\u000f\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0003%!\bN]3bI&tw\rE\u00024wuJ!\u0001\u0010\u001b\u0003\r=\u0003H/[8o!\tq\u0014I\u0004\u00024\u007f%\u0011\u0001\tN\u0001\u0007!J,G-\u001a4\n\u0005\t\u001b%AB*ue&twM\u0003\u0002Ai!)Q\t\u0001C\u0001\r\u00061A(\u001b8jiz\"BaR%K\u0017B\u0011\u0001\nA\u0007\u0002\u0005!)Q\u0005\u0012a\u0001M!)\u0011\u0007\u0012a\u0001e!)\u0011\b\u0012a\u0001u!9Q\n\u0001b\u0001\n\u0013q\u0015AE7b]V\fGNV5tSR\u0014Vm];miN,\u0012a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%*\n!bY8mY\u0016\u001cG/[8o\u0013\t!\u0016KA\u000bMSN$h)Z1ukJ,7i\u001c7mK\u000e$\u0018n\u001c8\t\rY\u0003\u0001\u0015!\u0003P\u0003Mi\u0017M\\;bYZK7/\u001b;SKN,H\u000e^:!\u0011\u001dA\u0006\u00011A\u0005\ne\u000b!B]3tk2$8)\u00197d+\u0005Q\u0006CA\f\\\u0013\taFAA\u0007GK\u0006$XO]3SKN,H\u000e\u001e\u0005\b=\u0002\u0001\r\u0011\"\u0003`\u00039\u0011Xm];mi\u000e\u000bGnY0%KF$\"\u0001Y2\u0011\u0005M\n\u0017B\u000125\u0005\u0011)f.\u001b;\t\u000f\u0011l\u0016\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\t\r\u0019\u0004\u0001\u0015)\u0003[\u0003-\u0011Xm];mi\u000e\u000bGn\u0019\u0011\t\u000f!\u0004!\u0019!C\u0005S\u0006\u0019a\u000e\u001e5\u0016\u0003)\u0004\"aM6\n\u00051$$aA%oi\"1a\u000e\u0001Q\u0001\n)\fAA\u001c;iA!9\u0001\u000f\u0001b\u0001\n\u0013\t\u0018A\u0002;ie\u0016\fG-F\u0001s!\r\u00194H\u001b\u0005\u0007i\u0002\u0001\u000b\u0011\u0002:\u0002\u000fQD'/Z1eA!9a\u000f\u0001b\u0001\n\u00139\u0018\u0001C:b[Bd\u0017N\\4\u0016\u0003a\u0004RaM=|\u0003\u0013I!A\u001f\u001b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u0001?\u0002\u00065\tQP\u0003\u0002*}*\u0019q0!\u0001\u0002\u000f\u0019,\u0017\r^;sK*\u0019\u00111\u0001\u0006\u0002\u000f=\u0004XM\\4jg&\u0019\u0011qA?\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f!\r\u0019\u00141B\u0005\u0004\u0003\u001b!$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003#\u0001\u0001\u0015!\u0003y\u0003%\u0019\u0018-\u001c9mS:<\u0007\u0005C\u0004\u0002\u0016\u0001!\t%a\u0006\u0002\u000bYL7/\u001b;\u0015\u0007\u0001\fI\u0002C\u0004\u0000\u0003'\u0001\r!a\u0007\u0011\t\u0005u\u0011qD\u0007\u0002}&\u0019\u0011\u0011\u0005@\u0003\u000f\u0019+\u0017\r^;sK\"9\u0011Q\u0005\u0001\u0005B\u0005\u001d\u0012!C4fiJ+7/\u001e7u)\u0005Q\u0006bBA\u0016\u0001\u0011\u0005\u0013QF\u0001\bKb,7-\u001e;f)\u0015\u0001\u0017qFA\u001d\u0011!\t\t$!\u000bA\u0002\u0005M\u0012AB:pkJ\u001cW\rE\u0002(\u0003kI1!a\u000e)\u0005M\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKN{WO]2f\u0011!\tY$!\u000bA\u0002\u0005u\u0012!B9vKJL\b\u0003BA \u0003\u0003j\u0011AK\u0005\u0004\u0003\u0007R#!B)vKJL\b")
public class SamplingVisitor
implements GeoMesaProcessVisitor,
LazyLogging {
    private final float percent;
    private final Option<String> threading;
    private final ListFeatureCollection manualVisitResults;
    private FeatureResult resultCalc;
    private final int nth;
    private final Option<Object> thread;
    private final Function1<SimpleFeature, Object> sampling;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        SamplingVisitor samplingVisitor = this;
        synchronized (samplingVisitor) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public List<Expression> getExpressions() {
        return GeoMesaProcessVisitor.class.getExpressions((org.locationtech.geomesa.index.process.GeoMesaProcessVisitor)this);
    }

    private ListFeatureCollection manualVisitResults() {
        return this.manualVisitResults;
    }

    private FeatureResult resultCalc() {
        return this.resultCalc;
    }

    private void resultCalc_$eq(FeatureResult x$1) {
        this.resultCalc = x$1;
    }

    private int nth() {
        return this.nth;
    }

    private Option<Object> thread() {
        return this.thread;
    }

    private Function1<SimpleFeature, Object> sampling() {
        return this.sampling;
    }

    public void visit(Feature feature) {
        SimpleFeature sf = (SimpleFeature)feature;
        if (BoxesRunTime.unboxToBoolean((Object)this.sampling().apply((Object)sf))) {
            this.manualVisitResults().add(sf);
        }
    }

    public FeatureResult getResult() {
        return this.resultCalc();
    }

    public void execute(SimpleFeatureSource source, Query query2) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running Geomesa sampling process on source type {}", new Object[]{source.getClass().getName()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        query2.getHints().put((Object)QueryHints$.MODULE$.SAMPLING(), (Object)BoxesRunTime.boxToFloat((float)this.percent));
        this.threading.foreach((Function1)new Serializable(this, query2){
            public static final long serialVersionUID = 0L;
            private final Query query$1;

            public final Object apply(String x$2) {
                return this.query$1.getHints().put((Object)QueryHints$.MODULE$.SAMPLE_BY(), (Object)x$2);
            }
            {
                this.query$1 = query$1;
            }
        });
        this.resultCalc_$eq(new FeatureResult(source.getFeatures(query2)));
    }

    public SamplingVisitor(SimpleFeatureCollection features, float percent, Option<String> threading) {
        this.percent = percent;
        this.threading = threading;
        GeoMesaProcessVisitor.class.$init$((org.locationtech.geomesa.index.process.GeoMesaProcessVisitor)this);
        LazyLogging.class.$init$((LazyLogging)this);
        this.manualVisitResults = new ListFeatureCollection((SimpleFeatureType)features.getSchema());
        this.resultCalc = new FeatureResult((SimpleFeatureCollection)this.manualVisitResults());
        this.nth = (int)(1.0f / percent);
        SimpleFeatureType simpleFeatureType = (SimpleFeatureType)features.getSchema();
        this.thread = threading.map((Function1)new Serializable(this, simpleFeatureType){
            public static final long serialVersionUID = 0L;
            private final SimpleFeatureType eta$0$1$1;

            public final int apply(String x$1) {
                return this.eta$0$1$1.indexOf(x$1);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$1) {
                return this.apply$mcZI$sp(x$1);
            }

            public boolean apply$mcZI$sp(int x$1) {
                return x$1 != -1;
            }
        });
        this.sampling = FeatureSampler$.MODULE$.sample(this.nth(), this.thread());
    }
}

