/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.map;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.KeyValuePair;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class MapNew
extends ExtensionFunctionDefinition {
    public static final StructuredQName FUNCTION_NAME = new StructuredQName("map", "http://www.w3.org/2005/xpath-functions/map", "_new");
    private static final SequenceType[] ARG_TYPES = new SequenceType[]{SequenceType.makeSequenceType(MapType.ANY_MAP_TYPE, 57344)};

    public StructuredQName getFunctionQName() {
        return FUNCTION_NAME;
    }

    public int getMinimumNumberOfArguments() {
        return 0;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return ARG_TYPES;
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return HashTrieMap.SINGLE_MAP_TYPE;
    }

    public boolean trustResultType() {
        return true;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new MapNewCall();
    }

    private class MapNewCall
    extends ExtensionFunctionCall {
        boolean selfContained = false;

        private MapNewCall() {
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            this.selfContained = arguments.length == 0 || !ExpressionTool.refersToVariableOrFunction(arguments[0]);
        }

        public void copyLocalData(ExtensionFunctionCall destination) {
            ((MapNewCall)destination).selfContained = this.selfContained;
        }

        public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
            MapItem next;
            if (arguments.length == 0) {
                return new HashTrieMap(context);
            }
            SequenceIterator iter = arguments[0].iterate();
            MapItem baseMap = (MapItem)iter.next();
            if (baseMap == null) {
                return new HashTrieMap(context);
            }
            if (!(baseMap instanceof HashTrieMap)) {
                baseMap = HashTrieMap.copy(baseMap, context);
            }
            while ((next = (MapItem)iter.next()) != null) {
                for (KeyValuePair pair : next) {
                    if (baseMap.get(pair.key) != null) {
                        throw new XPathException("Map contains more than one entry for key '" + pair.key.getStringValue() + "'", "XQDY0137");
                    }
                    baseMap = ((HashTrieMap)baseMap).addEntry(pair.key, pair.value);
                }
            }
            return baseMap;
        }
    }
}

