/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.jobs;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.data.Query;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.hbase.jobs.GeoMesaHBaseInputFormat;
import org.locationtech.geomesa.hbase.jobs.HBaseJobUtils$;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.utils.Reprojection;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.utils.io.WithStore$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;

public final class GeoMesaHBaseInputFormat$ {
    public static final GeoMesaHBaseInputFormat$ MODULE$;

    static {
        new GeoMesaHBaseInputFormat$();
    }

    public void configure(Job job, Map<String, ?> params, Query query) {
        HBaseQueryPlan.ScanPlan plan = (HBaseQueryPlan.ScanPlan)WithStore$.MODULE$.apply(params).apply((Function1)new Serializable(query){
            public static final long serialVersionUID = 0L;
            private final Query query$1;

            public final HBaseQueryPlan.ScanPlan apply(HBaseDataStore ds) {
                Predef$.MODULE$.assert(ds != null, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Invalid data store parameters";
                    }
                });
                return HBaseJobUtils$.MODULE$.getSingleScanPlan(ds, this.query$1);
            }
            {
                this.query$1 = query$1;
            }
        });
        this.configure(job, plan);
    }

    public void configure(Job job, HBaseQueryPlan.ScanPlan plan) {
        job.setInputFormatClass(GeoMesaHBaseInputFormat.class);
        this.configure(job.getConfiguration(), plan);
    }

    public void configure(Configuration conf, HBaseQueryPlan.ScanPlan plan) {
        if (plan.tables().lengthCompare(1) != 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Query requires multiple tables: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{plan.tables().mkString(", ")})));
        }
        conf.set("hbase.mapreduce.inputtable", ((TableName)plan.tables().head()).getNameAsString());
        Seq scans = (Seq)plan.scans().map((Function1)new Serializable(plan){
            public static final long serialVersionUID = 0L;
            private final HBaseQueryPlan.ScanPlan plan$1;

            public final String apply(Scan scan) {
                scan.setAttribute("scan.attributes.table.name", ((TableName)this.plan$1.tables().head()).getName());
                return Base64.encodeBytes((byte[])ProtobufUtil.toScan((Scan)scan).toByteArray());
            }
            {
                this.plan$1 = plan$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        conf.setStrings("hbase.mapreduce.scans", (String[])scans.toArray(ClassTag$.MODULE$.apply(String.class)));
        GeoMesaConfigurator$.MODULE$.setResultsToFeatures(conf, plan.resultsToFeatures());
        plan.reducer().foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(QueryPlan.FeatureReducer x$1) {
                GeoMesaConfigurator$.MODULE$.setReducer(this.conf$1, x$1);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        plan.sort().foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(Seq<Tuple2<String, Object>> x$2) {
                GeoMesaConfigurator$.MODULE$.setSorting(this.conf$1, x$2);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        plan.projection().foreach((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(Reprojection.QueryReferenceSystems x$3) {
                GeoMesaConfigurator$.MODULE$.setProjection(this.conf$1, x$3);
            }
            {
                this.conf$1 = conf$1;
            }
        });
    }

    private GeoMesaHBaseInputFormat$() {
        MODULE$ = this;
    }
}

