/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.jobs;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.locationtech.geomesa.hbase.data.HBaseConnectionPool$;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.jobs.HBaseIndexFileMapper;
import org.locationtech.geomesa.hbase.jobs.HBaseIndexFileMapper$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.WithStore$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;

public final class HBaseIndexFileMapper$ {
    public static final HBaseIndexFileMapper$ MODULE$;
    private final String TypeNameKey;

    static {
        new HBaseIndexFileMapper$();
    }

    private String TypeNameKey() {
        return this.TypeNameKey;
    }

    public void org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$setTypeName(Configuration conf, String typeName) {
        conf.set(this.TypeNameKey(), typeName);
    }

    public String org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$getTypeName(Configuration conf) {
        return conf.get(this.TypeNameKey());
    }

    public void configure(Job job, Map<String, String> params, String typeName, String index, Path output) {
        WithStore$.MODULE$.apply(params).apply((Function1)new Serializable(job, params, typeName, index, output){
            public static final long serialVersionUID = 0L;
            private final Job job$1;
            public final Map params$1;
            public final String typeName$1;
            private final String index$1;
            private final Path output$1;

            public final void apply(HBaseDataStore ds) {
                Predef$.MODULE$.require(ds != null, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.configure.1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not find data store with provided parameters ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.params$1.mkString(",")}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                SimpleFeatureType sft = ds.getSchema(this.typeName$1);
                Predef$.MODULE$.require(sft != null, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.configure.1 $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema ", " does not exist, please create it first"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.typeName$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                Predef$.MODULE$.require(!TablePartition$.MODULE$.partitioned(sft), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Writing to partitioned tables is not currently supported";
                    }
                });
                GeoMesaFeatureIndex idx = ds.manager().index(sft, this.index$1, IndexMode$.MODULE$.Write());
                Seq seq = idx.getTableNames((Option)None$.MODULE$);
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
                    TableName tableName;
                    String t = (String)((SeqLike)some.get()).apply(0);
                    TableName tableName2 = tableName = TableName.valueOf((String)t);
                    Table table = ds.connection().getTable(tableName2);
                    GeoMesaConfigurator$.MODULE$.setDataStoreOutParams(this.job$1.getConfiguration(), this.params$1);
                    GeoMesaConfigurator$.MODULE$.setIndicesOut(this.job$1.getConfiguration(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{idx.identifier()})));
                    GeoMesaConfigurator$.MODULE$.setSerialization(this.job$1.getConfiguration(), sft);
                    HBaseIndexFileMapper$.MODULE$.org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$setTypeName(this.job$1.getConfiguration(), sft.getTypeName());
                    FileOutputFormat.setOutputPath((Job)this.job$1, (Path)this.output$1);
                    this.job$1.getConfiguration().set("hbase.fs.tmp.dir", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/hbase-staging"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{System.getProperty("java.io.tmpdir")})));
                    this.job$1.getConfiguration().set("hbase.bulkload.locality.sensitive.enabled", "false");
                    this.job$1.setMapperClass(HBaseIndexFileMapper.class);
                    this.job$1.setMapOutputKeyClass(ImmutableBytesWritable.class);
                    this.job$1.setMapOutputValueClass(Put.class);
                    HBaseConfiguration.merge((Configuration)this.job$1.getConfiguration(), (Configuration)HBaseConfiguration.create((Configuration)this.job$1.getConfiguration()));
                    HBaseConnectionPool$.MODULE$.configureSecurity(this.job$1.getConfiguration());
                    String libjars = this.job$1.getConfiguration().get("tmpjars");
                    HFileOutputFormat2.configureIncrementalLoad((Job)this.job$1, (Table)table, (RegionLocator)ds.connection().getRegionLocator(tableName2));
                    this.job$1.getConfiguration().set("tmpjars", libjars);
                    return;
                }
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a single table but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq.mkString(", ")})));
            }
            {
                this.job$1 = job$1;
                this.params$1 = params$1;
                this.typeName$1 = typeName$1;
                this.index$1 = index$1;
                this.output$1 = output$1;
            }
        });
    }

    private HBaseIndexFileMapper$() {
        MODULE$ = this;
        this.TypeNameKey = "org.locationtech.geomesa.hbase.type";
    }
}

