/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xs.bindings;

import java.awt.RenderingHints;
import java.sql.Date;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.geotools.util.factory.Hints;
import org.geotools.xml.impl.DatatypeConverterImpl;
import org.geotools.xs.XS;
import org.geotools.xsd.InstanceComponent;
import org.geotools.xsd.SimpleBinding;

public class XSDateBinding
implements SimpleBinding {
    @Override
    public QName getTarget() {
        return XS.DATE;
    }

    @Override
    public int getExecutionMode() {
        return 2;
    }

    @Override
    public Class getType() {
        return Date.class;
    }

    @Override
    public Date parse(InstanceComponent instance, Object value) throws Exception {
        Calendar calendar = DatatypeConverterImpl.getInstance().parseDate((String)value);
        return new Date(calendar.getTimeInMillis());
    }

    @Override
    public String encode(Object object, String value) throws Exception {
        Date date = (Date)object;
        Object hint = Hints.getSystemDefault((RenderingHints.Key)Hints.LOCAL_DATE_TIME_HANDLING);
        Calendar calendar = Boolean.TRUE.equals(hint) ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.setTimeInMillis(date.getTime());
        return DatatypeConverterImpl.getInstance().printDate(calendar);
    }
}

