/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.jobs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseIndexAdapter$;
import org.locationtech.geomesa.hbase.jobs.HBaseIndexFileMapper$;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.WritableFeature$;
import org.locationtech.geomesa.index.api.WriteConverter;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.WithStore$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t5b\u0001\u0002\u0012$\u00019BQ!\u0019\u0001\u0005\u0002\tD\u0011\"\u001a\u0001A\u0002\u0003\u0007I\u0011\u00024\t\u0013)\u0004\u0001\u0019!a\u0001\n\u0013Y\u0007\"\u0003;\u0001\u0001\u0004\u0005\t\u0015)\u0003h\u0011%)\b\u00011AA\u0002\u0013%a\u000fC\u0006\u0002&\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0002BCA\u0016\u0001\u0001\u0007\t\u0011)Q\u0005o\"Y\u0011Q\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0018\u0011-\t\t\u0006\u0001a\u0001\u0002\u0004%I!a\u0015\t\u0017\u0005\u0005\u0003\u00011A\u0001B\u0003&\u0011\u0011\u0007\u0005\f\u0003?\u0002\u0001\u0019!a\u0001\n\u0013\t\t\u0007C\u0006\u0002j\u0001\u0001\r\u00111A\u0005\n\u0005-\u0004bCA8\u0001\u0001\u0007\t\u0011)Q\u0005\u0003GB1\"!\u001d\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002b!Y\u00111\u000f\u0001A\u0002\u0003\u0007I\u0011BA;\u0011-\tI\b\u0001a\u0001\u0002\u0003\u0006K!a\u0019\t\u0017\u0005m\u0004\u00011AA\u0002\u0013%\u0011\u0011\r\u0005\f\u0003{\u0002\u0001\u0019!a\u0001\n\u0013\ty\bC\u0006\u0002\u0004\u0002\u0001\r\u0011!Q!\n\u0005\r\u0004\"CAC\u0001\t\u0007I\u0011BAD\u0011\u001d\tI\t\u0001Q\u0001\n-Cq!a#\u0001\t\u0003\ni\tC\u0004\u0003\u001a\u0001!\tEa\u0007\t\u000f\t}\u0001\u0001\"\u0011\u0003\"\u001d9\u0011qS\u0012\t\u0002\u0005eeA\u0002\u0012$\u0011\u0003\tY\n\u0003\u0004b5\u0011\u0005\u00111U\u0003\u0007\u0003KS\u0002!a*\t\u0013\u00055&D1A\u0005\n\u0005=\u0006\u0002CAa5\u0001\u0006I!!-\t\u000f\u0005\r'\u0004\"\u0003\u0002F\"9\u0011q\u001d\u000e\u0005\n\u0005%\bbBAw5\u0011\u0005\u0011q\u001e\u0002\u0015\u0011\n\u000b7/Z%oI\u0016Dh)\u001b7f\u001b\u0006\u0004\b/\u001a:\u000b\u0005\u0011*\u0013\u0001\u00026pENT!AJ\u0014\u0002\u000b!\u0014\u0017m]3\u000b\u0005!J\u0013aB4f_6,7/\u0019\u0006\u0003U-\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0004\u0001=:\u0006C\u0002\u00198s}Z\u0015+D\u00012\u0015\t\u00114'A\u0005nCB\u0014X\rZ;dK*\u0011A'N\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005YZ\u0013AB1qC\u000eDW-\u0003\u00029c\t1Q*\u00199qKJ\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u001a\u0002\u0005%|\u0017B\u0001 <\u0005!9&/\u001b;bE2,\u0007C\u0001!J\u001b\u0005\t%B\u0001\"D\u0003\u0019\u0019\u0018.\u001c9mK*\u0011A)R\u0001\bM\u0016\fG/\u001e:f\u0015\t1u)A\u0002ba&T!\u0001S\u0016\u0002\u0011\u001d,w\u000e^8pYNL!AS!\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f!\tau*D\u0001N\u0015\tadJ\u0003\u0002'g%\u0011\u0001+\u0014\u0002\u0017\u00136lW\u000f^1cY\u0016\u0014\u0015\u0010^3t/JLG/\u00192mKB\u0011!+V\u0007\u0002'*\u0011AKT\u0001\u0007G2LWM\u001c;\n\u0005Y\u001b&a\u0001)viB\u0011\u0001lX\u0007\u00023*\u0011!lW\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u00039v\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002=\u0006\u00191m\\7\n\u0005\u0001L&a\u0003'bufdunZ4j]\u001e\fa\u0001P5oSRtD#A2\u0011\u0005\u0011\u0004Q\"A\u0012\u0002\u0007M4G/F\u0001h!\t\u0001\u0005.\u0003\u0002j\u0003\n\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\u0002\u000fM4Go\u0018\u0013fcR\u0011AN\u001d\t\u0003[Bl\u0011A\u001c\u0006\u0002_\u0006)1oY1mC&\u0011\u0011O\u001c\u0002\u0005+:LG\u000fC\u0004t\u0007\u0005\u0005\t\u0019A4\u0002\u0007a$\u0013'\u0001\u0003tMR\u0004\u0013aB<sCB\u0004XM]\u000b\u0002oB)\u00010a\u0006\u0002\u001e9\u0019\u00110!\u0005\u000f\u0007i\fiAD\u0002|\u0003\u0013q1\u0001`A\u0004\u001d\ri\u0018Q\u0001\b\u0004}\u0006\rQ\"A@\u000b\u0007\u0005\u0005Q&\u0001\u0004=e>|GOP\u0005\u0002Y%\u0011!fK\u0005\u0003Q%J1!a\u0003(\u0003\u0015Ig\u000eZ3y\u0013\r1\u0015q\u0002\u0006\u0004\u0003\u00179\u0013\u0002BA\n\u0003+\tqb\u0016:ji\u0006\u0014G.\u001a$fCR,(/\u001a\u0006\u0004\r\u0006=\u0011\u0002BA\r\u00037\u0011aBR3biV\u0014Xm\u0016:baB,'O\u0003\u0003\u0002\u0014\u0005U\u0001\u0003BA\u0010\u0003Ci!!!\u0006\n\t\u0005\r\u0012Q\u0003\u0002\u0010/JLG/\u00192mK\u001a+\u0017\r^;sK\u0006YqO]1qa\u0016\u0014x\fJ3r)\ra\u0017\u0011\u0006\u0005\bg\u001a\t\t\u00111\u0001x\u0003!9(/\u00199qKJ\u0004\u0013AB<sSR,'/\u0006\u0002\u00022A\"\u00111GA\u001f!\u0019\ty\"!\u000e\u0002:%!\u0011qGA\u000b\u000599&/\u001b;f\u0007>tg/\u001a:uKJ\u0004B!a\u000f\u0002>1\u0001AaCA \u0015\u0005\u0005\t\u0011!B\u0001\u0003\u0007\u00121a\u0018\u00132\u0003\u001d9(/\u001b;fe\u0002\nB!!\u0012\u0002LA\u0019Q.a\u0012\n\u0007\u0005%cNA\u0004O_RD\u0017N\\4\u0011\u00075\fi%C\u0002\u0002P9\u00141!\u00118z\u0003)9(/\u001b;fe~#S-\u001d\u000b\u0004Y\u0006U\u0003\u0002C:\n\u0003\u0003\u0005\r!a\u00161\t\u0005e\u0013Q\f\t\u0007\u0003?\t)$a\u0017\u0011\t\u0005m\u0012Q\f\u0003\r\u0003\u007f\t)&!A\u0001\u0002\u000b\u0005\u00111I\u0001\tM\u0016\fG/\u001e:fgV\u0011\u00111\r\t\u0004a\u0005\u0015\u0014bAA4c\t91i\\;oi\u0016\u0014\u0018\u0001\u00044fCR,(/Z:`I\u0015\fHc\u00017\u0002n!A1\u000fDA\u0001\u0002\u0004\t\u0019'A\u0005gK\u0006$XO]3tA\u00059QM\u001c;sS\u0016\u001c\u0018aC3oiJLWm]0%KF$2\u0001\\A<\u0011!\u0019x\"!AA\u0002\u0005\r\u0014\u0001C3oiJLWm\u001d\u0011\u0002\r\u0019\f\u0017\u000e\\3e\u0003)1\u0017-\u001b7fI~#S-\u001d\u000b\u0004Y\u0006\u0005\u0005\u0002C:\u0013\u0003\u0003\u0005\r!a\u0019\u0002\u000f\u0019\f\u0017\u000e\\3eA\u0005)!-\u001f;fgV\t1*\u0001\u0004csR,7\u000fI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0004Y\u0006=\u0005bBAI-\u0001\u0007\u00111S\u0001\bG>tG/\u001a=u!\r\t)\n\b\b\u0003If\tA\u0003\u0013\"bg\u0016Le\u000eZ3y\r&dW-T1qa\u0016\u0014\bC\u00013\u001b'\rQ\u0012Q\u0014\t\u0004[\u0006}\u0015bAAQ]\n1\u0011I\\=SK\u001a$\"!!'\u0003\u00155\u000b\u0007oQ8oi\u0016DH\u000fE\u00020\u0003SK1!a+8\u0005\u001d\u0019uN\u001c;fqR\f1\u0002V=qK:\u000bW.Z&fsV\u0011\u0011\u0011\u0017\t\u0005\u0003g\u000bi,\u0004\u0002\u00026*!\u0011qWA]\u0003\u0011a\u0017M\\4\u000b\u0005\u0005m\u0016\u0001\u00026bm\u0006LA!a0\u00026\n11\u000b\u001e:j]\u001e\fA\u0002V=qK:\u000bW.Z&fs\u0002\n1b]3u)f\u0004XMT1nKR)A.a2\u0002V\"9\u0011\u0011Z\u0010A\u0002\u0005-\u0017\u0001B2p]\u001a\u0004B!!4\u0002R6\u0011\u0011q\u001a\u0006\u0004\u0003\u0013\u001c\u0014\u0002BAj\u0003\u001f\u0014QbQ8oM&<WO]1uS>t\u0007bBAl?\u0001\u0007\u0011\u0011\\\u0001\tif\u0004XMT1nKB!\u00111\\Ar\u001d\u0011\ti.a8\u0011\u0005yt\u0017bAAq]\u00061\u0001K]3eK\u001aLA!a0\u0002f*\u0019\u0011\u0011\u001d8\u0002\u0017\u001d,G\u000fV=qK:\u000bW.\u001a\u000b\u0005\u00033\fY\u000fC\u0004\u0002J\u0002\u0002\r!a3\u0002\u0013\r|gNZ5hkJ,Gc\u00037\u0002r\u0006m(Q\u0001B\u0004\u0005\u0013Aq!a=\"\u0001\u0004\t)0A\u0002k_\n\u00042\u0001MA|\u0013\r\tI0\r\u0002\u0004\u0015>\u0014\u0007bBA\u007fC\u0001\u0007\u0011q`\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0011\u0005m'\u0011AAm\u00033LAAa\u0001\u0002f\n\u0019Q*\u00199\t\u000f\u0005]\u0017\u00051\u0001\u0002Z\"9\u00111B\u0011A\u0002\u0005e\u0007b\u0002B\u0006C\u0001\u0007!QB\u0001\u0007_V$\b/\u001e;\u0011\t\t=!QC\u0007\u0003\u0005#Q1Aa\u00054\u0003\t17/\u0003\u0003\u0003\u0018\tE!\u0001\u0002)bi\"\fqa\u00197fC:,\b\u000fF\u0002m\u0005;Aq!!%\u0018\u0001\u0004\t\u0019*A\u0002nCB$r\u0001\u001cB\u0012\u0005O\u0011Y\u0003\u0003\u0004\u0003&a\u0001\r!O\u0001\u0004W\u0016L\bB\u0002B\u00151\u0001\u0007q(A\u0003wC2,X\rC\u0004\u0002\u0012b\u0001\r!a%")
public class HBaseIndexFileMapper
extends Mapper<Writable, SimpleFeature, ImmutableBytesWritable, Put>
implements LazyLogging {
    private SimpleFeatureType sft;
    private WritableFeature.FeatureWrapper<WritableFeature> wrapper;
    private WriteConverter<?> writer;
    private Counter features;
    private Counter entries;
    private Counter failed;
    private final ImmutableBytesWritable bytes;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static void configure(Job job, Map<String, String> map, String string, String string2, Path path) {
        HBaseIndexFileMapper$.MODULE$.configure(job, map, string, string2, path);
    }

    private Logger logger$lzycompute() {
        HBaseIndexFileMapper hBaseIndexFileMapper = this;
        synchronized (hBaseIndexFileMapper) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private SimpleFeatureType sft() {
        return this.sft;
    }

    private void sft_$eq(SimpleFeatureType x$1) {
        this.sft = x$1;
    }

    private WritableFeature.FeatureWrapper<WritableFeature> wrapper() {
        return this.wrapper;
    }

    private void wrapper_$eq(WritableFeature.FeatureWrapper<WritableFeature> x$1) {
        this.wrapper = x$1;
    }

    private WriteConverter<?> writer() {
        return this.writer;
    }

    private void writer_$eq(WriteConverter<?> x$1) {
        this.writer = x$1;
    }

    private Counter features() {
        return this.features;
    }

    private void features_$eq(Counter x$1) {
        this.features = x$1;
    }

    private Counter entries() {
        return this.entries;
    }

    private void entries_$eq(Counter x$1) {
        this.entries = x$1;
    }

    private Counter failed() {
        return this.failed;
    }

    private void failed_$eq(Counter x$1) {
        this.failed = x$1;
    }

    private ImmutableBytesWritable bytes() {
        return this.bytes;
    }

    public void setup(Mapper.Context context) {
        WithStore$.MODULE$.apply(GeoMesaConfigurator$.MODULE$.getDataStoreOutParams(context.getConfiguration())).apply((Function1 & Serializable & scala.Serializable)ds -> {
            HBaseIndexFileMapper.$anonfun$setup$1(this, context, ds);
            return BoxedUnit.UNIT;
        });
        this.features_$eq(context.getCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat.OutputCounters$.MODULE$.Written()));
        this.entries_$eq(context.getCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), "entries"));
        this.failed_$eq(context.getCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat.OutputCounters$.MODULE$.Failed()));
    }

    public void cleanup(Mapper.Context context) {
    }

    public void map(Writable key, SimpleFeature value2, Mapper.Context context) {
        try {
            WritableFeature.FeatureWrapper<WritableFeature> qual$1 = this.wrapper();
            SimpleFeature x$1 = value2;
            boolean x$2 = qual$1.wrap$default$2();
            WritableFeature feature = qual$1.wrap(x$1, x$2);
            WriteConverter<?> qual$2 = this.writer();
            WritableFeature x$3 = feature;
            boolean x$4 = qual$2.convert$default$2();
            package.RowKeyValue rowKeyValue = qual$2.convert(x$3, x$4);
            if (rowKeyValue instanceof package.SingleRowKeyValue) {
                package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                singleRowKeyValue.values().foreach((Function1 & Serializable & scala.Serializable)value -> {
                    HBaseIndexFileMapper.$anonfun$map$1(this, singleRowKeyValue, context, value);
                    return BoxedUnit.UNIT;
                });
            } else if (rowKeyValue instanceof package.MultiRowKeyValue) {
                package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                multiRowKeyValue.rows().foreach((Function1 & Serializable & scala.Serializable)row -> {
                    HBaseIndexFileMapper.$anonfun$map$2(this, multiRowKeyValue, context, row);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError((Object)rowKeyValue);
            }
            this.features().increment(1L);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(22).append("Error writing feature ").append(Option$.MODULE$.apply((Object)value2).orNull(Predef$.MODULE$.$conforms())).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.failed().increment(1L);
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$setup$1(HBaseIndexFileMapper $this, Mapper.Context context$1, HBaseDataStore ds) {
        Some some;
        Seq seq;
        Some some2;
        Predef$.MODULE$.require(ds != null, (Function0 & Serializable & scala.Serializable)() -> "Could not find data store - check your configuration and hbase-site.xml");
        $this.sft_$eq(ds.getSchema(HBaseIndexFileMapper$.MODULE$.org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$getTypeName(context$1.getConfiguration())));
        Predef$.MODULE$.require($this.sft() != null, (Function0 & Serializable & scala.Serializable)() -> "Could not find schema - check your configuration");
        $this.wrapper_$eq((WritableFeature.FeatureWrapper<WritableFeature>)WritableFeature$.MODULE$.wrapper($this.sft(), ds.adapter().groups()));
        Option option = GeoMesaConfigurator$.MODULE$.getIndicesOut(context$1.getConfiguration());
        if (!(option instanceof Some) || (some2 = Seq$.MODULE$.unapplySeq(seq = (Seq)(some = (Some)option).value())).isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(1) != 0) {
            throw new IllegalArgumentException("Could not find write index - check your configuration");
        }
        String idx = (String)((SeqLike)some2.get()).apply(0);
        $this.writer_$eq(ds.manager().index($this.sft(), idx, IndexMode$.MODULE$.Write()).createConverter());
    }

    public static final /* synthetic */ void $anonfun$map$1(HBaseIndexFileMapper $this, package.SingleRowKeyValue x2$1, Mapper.Context context$2, package.KeyValue value) {
        Put put = new Put(x2$1.row());
        put.addImmutable(value.cf(), value.cq(), value.value());
        Object object = !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(value.vis())).isEmpty() ? put.setCellVisibility(new CellVisibility(new String(value.vis(), StandardCharsets.UTF_8))) : BoxedUnit.UNIT;
        put.setDurability(HBaseIndexAdapter$.MODULE$.durability());
        $this.bytes().set(put.getRow());
        context$2.write((Object)$this.bytes(), (Object)put);
        $this.entries().increment(1L);
    }

    public static final /* synthetic */ void $anonfun$map$3(HBaseIndexFileMapper $this, byte[] row$1, Mapper.Context context$2, package.KeyValue value) {
        Put put = new Put(row$1);
        put.addImmutable(value.cf(), value.cq(), value.value());
        Object object = !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(value.vis())).isEmpty() ? put.setCellVisibility(new CellVisibility(new String(value.vis(), StandardCharsets.UTF_8))) : BoxedUnit.UNIT;
        put.setDurability(HBaseIndexAdapter$.MODULE$.durability());
        $this.bytes().set(put.getRow());
        context$2.write((Object)$this.bytes(), (Object)put);
        $this.entries().increment(1L);
    }

    public static final /* synthetic */ void $anonfun$map$2(HBaseIndexFileMapper $this, package.MultiRowKeyValue x3$1, Mapper.Context context$2, byte[] row) {
        x3$1.values().foreach((Function1 & Serializable & scala.Serializable)value -> {
            HBaseIndexFileMapper.$anonfun$map$3($this, row, context$2, value);
            return BoxedUnit.UNIT;
        });
    }

    public HBaseIndexFileMapper() {
        LazyLogging.$init$((LazyLogging)this);
        this.bytes = new ImmutableBytesWritable();
    }
}

