/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.jobs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivilegedAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreFactory$;
import scala.Function0;
import scala.runtime.BoxedUnit;

public final class Security$
implements LazyLogging {
    public static final Security$ MODULE$ = new Security$();
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        Security$ security$ = this;
        synchronized (security$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private String asString(Configuration conf) {
        StringWriter writer = new StringWriter();
        Configuration.dumpConfiguration((Configuration)conf, (Writer)writer);
        return writer.toString();
    }

    public <A> A doAuthorized(Configuration conf, Function0<A> action) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Running doAuthorized on {} with config: {}", new Object[]{Thread.currentThread(), this.asString(conf)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String principal = conf.get(HBaseDataStoreFactory$.MODULE$.HBaseGeoMesaPrincipal());
        String keytab = conf.get(HBaseDataStoreFactory$.MODULE$.HBaseGeoMesaKeyTab());
        if (principal != null && keytab != null) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Logging in as {} using keytab {}", new Object[]{principal, keytab});
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation user = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)principal, (String)keytab);
            return (A)user.doAs(new PrivilegedAction<A>(action){
                private final Function0 action$1;

                public A run() {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit2;
                    if (Security$.MODULE$.logger().underlying().isDebugEnabled()) {
                        Security$.MODULE$.logger().underlying().debug("Execution action under {} user...", (Object)UserGroupInformation.getLoginUser());
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    Object result = this.action$1.apply();
                    if (Security$.MODULE$.logger().underlying().isDebugEnabled()) {
                        Security$.MODULE$.logger().underlying().debug("The action is complete, finishing secured session for {} user...", (Object)UserGroupInformation.getLoginUser());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return (A)result;
                }
                {
                    this.action$1 = action$1;
                }
            });
        }
        return (A)action.apply();
    }

    private Security$() {
    }
}

