/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.jobs;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat2;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.locationtech.geomesa.hbase.data.HBaseConnectionPool$;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.jobs.HBaseIndexFileMapper;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.WithStore$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;

public final class HBaseIndexFileMapper$ {
    public static final HBaseIndexFileMapper$ MODULE$ = new HBaseIndexFileMapper$();
    private static final String TypeNameKey = "org.locationtech.geomesa.hbase.type";

    private String TypeNameKey() {
        return TypeNameKey;
    }

    private void setTypeName(Configuration conf, String typeName) {
        conf.set(this.TypeNameKey(), typeName);
    }

    public String org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$getTypeName(Configuration conf) {
        return conf.get(this.TypeNameKey());
    }

    public void configure(Job job, Map<String, String> params, String typeName, String index, Path output) {
        WithStore$.MODULE$.apply(params).apply((Function1 & Serializable)ds -> {
            HBaseIndexFileMapper$.$anonfun$configure$1(params, typeName, index, job, output, ds);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$configure$1(Map params$1, String typeName$1, String index$1, Job job$1, Path output$1, HBaseDataStore ds) {
        SeqOps seqOps;
        Predef$.MODULE$.require(ds != null, (Function0 & Serializable)() -> new StringBuilder(51).append("Could not find data store with provided parameters ").append(params$1.mkString(",")).toString());
        SimpleFeatureType sft = ds.getSchema(typeName$1);
        Predef$.MODULE$.require(sft != null, (Function0 & Serializable)() -> new StringBuilder(46).append("Schema ").append(typeName$1).append(" does not exist, please create it first").toString());
        Predef$.MODULE$.require(!TablePartition$.MODULE$.partitioned(sft), (Function0 & Serializable)() -> "Writing to partitioned tables is not currently supported");
        GeoMesaFeatureIndex idx = ds.manager().index(sft, index$1, IndexMode$.MODULE$.Write());
        Seq seq = idx.getTableNames((Option)None$.MODULE$);
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0) {
            throw new IllegalStateException(new StringBuilder(33).append("Expected a single table but got: ").append(seq.mkString(", ")).toString());
        }
        String t = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        TableName tableName = TableName.valueOf((String)t);
        Table table = ds.connection().getTable(tableName);
        GeoMesaConfigurator$.MODULE$.setDataStoreOutParams(job$1.getConfiguration(), params$1);
        GeoMesaConfigurator$.MODULE$.setIndicesOut(job$1.getConfiguration(), (Seq)new .colon.colon((Object)idx.identifier(), (List)Nil$.MODULE$));
        GeoMesaConfigurator$.MODULE$.setSerialization(job$1.getConfiguration(), sft);
        MODULE$.setTypeName(job$1.getConfiguration(), sft.getTypeName());
        FileOutputFormat.setOutputPath((Job)job$1, (Path)output$1);
        job$1.getConfiguration().set("hbase.fs.tmp.dir", new StringBuilder(14).append(System.getProperty("java.io.tmpdir")).append("/hbase-staging").toString());
        job$1.getConfiguration().set("hbase.bulkload.locality.sensitive.enabled", "false");
        job$1.setMapperClass(HBaseIndexFileMapper.class);
        job$1.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job$1.setMapOutputValueClass(Put.class);
        HBaseConfiguration.merge((Configuration)job$1.getConfiguration(), (Configuration)HBaseConfiguration.create((Configuration)job$1.getConfiguration()));
        HBaseConnectionPool$.MODULE$.configureSecurity(job$1.getConfiguration());
        String libjars = job$1.getConfiguration().get("tmpjars");
        HFileOutputFormat2.configureIncrementalLoad((Job)job$1, (Table)table, (RegionLocator)ds.connection().getRegionLocator(tableName));
        job$1.getConfiguration().set("tmpjars", libjars);
    }

    private HBaseIndexFileMapper$() {
    }
}

