/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.jobs;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseIndexAdapter$;
import org.locationtech.geomesa.hbase.jobs.HBaseIndexFileMapper$;
import org.locationtech.geomesa.index.api.WritableFeature;
import org.locationtech.geomesa.index.api.WritableFeature$;
import org.locationtech.geomesa.index.api.WriteConverter;
import org.locationtech.geomesa.index.api.package;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.WithStore$;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t-b\u0001\u0002\u0012$\u00019BQa\u0018\u0001\u0005\u0002\u0001D\u0011b\u0019\u0001A\u0002\u0003\u0007I\u0011\u00023\t\u0013!\u0004\u0001\u0019!a\u0001\n\u0013I\u0007\"\u0003:\u0001\u0001\u0004\u0005\t\u0015)\u0003f\u0011%\u0019\b\u00011AA\u0002\u0013%A\u000fC\u0006\u0002$\u0001\u0001\r\u00111A\u0005\n\u0005\u0015\u0002BCA\u0015\u0001\u0001\u0007\t\u0011)Q\u0005k\"Y\u00111\u0006\u0001A\u0002\u0003\u0007I\u0011BA\u0017\u0011-\ty\u0005\u0001a\u0001\u0002\u0004%I!!\u0015\t\u0017\u0005}\u0002\u00011A\u0001B\u0003&\u0011q\u0006\u0005\f\u0003;\u0002\u0001\u0019!a\u0001\n\u0013\ty\u0006C\u0006\u0002h\u0001\u0001\r\u00111A\u0005\n\u0005%\u0004bCA7\u0001\u0001\u0007\t\u0011)Q\u0005\u0003CB1\"a\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002`!Y\u0011\u0011\u000f\u0001A\u0002\u0003\u0007I\u0011BA:\u0011-\t9\b\u0001a\u0001\u0002\u0003\u0006K!!\u0019\t\u0017\u0005e\u0004\u00011AA\u0002\u0013%\u0011q\f\u0005\f\u0003w\u0002\u0001\u0019!a\u0001\n\u0013\ti\bC\u0006\u0002\u0002\u0002\u0001\r\u0011!Q!\n\u0005\u0005\u0004\"CAB\u0001\t\u0007I\u0011BAC\u0011\u001d\t9\t\u0001Q\u0001\n%Cq!!#\u0001\t\u0003\nY\tC\u0004\u0003\u0018\u0001!\tE!\u0007\t\u000f\tu\u0001\u0001\"\u0011\u0003 \u001d9\u0011QS\u0012\t\u0002\u0005]eA\u0002\u0012$\u0011\u0003\tI\n\u0003\u0004`5\u0011\u0005\u0011\u0011U\u0003\u0007\u0003GS\u0002!!*\t\u0013\u0005-&D1A\u0005\n\u00055\u0006\u0002CA`5\u0001\u0006I!a,\t\u000f\u0005\u0005'\u0004\"\u0003\u0002D\"9\u0011Q\u001d\u000e\u0005\n\u0005\u001d\bbBAv5\u0011\u0005\u0011Q\u001e\u0002\u0015\u0011\n\u000b7/Z%oI\u0016Dh)\u001b7f\u001b\u0006\u0004\b/\u001a:\u000b\u0005\u0011*\u0013\u0001\u00026pENT!AJ\u0014\u0002\u000b!\u0014\u0017m]3\u000b\u0005!J\u0013aB4f_6,7/\u0019\u0006\u0003U-\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011\u0001L\u0001\u0004_J<7\u0001A\n\u0004\u0001=*\u0006C\u0002\u00198s}Ju*D\u00012\u0015\t\u00114'A\u0005nCB\u0014X\rZ;dK*\u0011A'N\u0001\u0007Q\u0006$wn\u001c9\u000b\u0005YZ\u0013AB1qC\u000eDW-\u0003\u00029c\t1Q*\u00199qKJ\u0004\"AO\u001f\u000e\u0003mR!\u0001P\u001a\u0002\u0005%|\u0017B\u0001 <\u0005!9&/\u001b;bE2,\u0007C\u0001!H\u001b\u0005\t%B\u0001\"D\u0003\u0019\u0019\u0018.\u001c9mK*\u0011A)R\u0001\bM\u0016\fG/\u001e:f\u0015\t15&A\u0004pa\u0016tw-[:\n\u0005!\u000b%!D*j[BdWMR3biV\u0014X\r\u0005\u0002K\u001b6\t1J\u0003\u0002=\u0019*\u0011aeM\u0005\u0003\u001d.\u0013a#S7nkR\f'\r\\3CsR,7o\u0016:ji\u0006\u0014G.\u001a\t\u0003!Nk\u0011!\u0015\u0006\u0003%2\u000baa\u00197jK:$\u0018B\u0001+R\u0005\r\u0001V\u000f\u001e\t\u0003-vk\u0011a\u0016\u0006\u00031f\u000bAb]2bY\u0006dwnZ4j]\u001eT!AW.\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001X\u0001\u0004G>l\u0017B\u00010X\u0005-a\u0015M_=M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\t\u0007C\u00012\u0001\u001b\u0005\u0019\u0013aA:giV\tQ\r\u0005\u0002AM&\u0011q-\u0011\u0002\u0012'&l\u0007\u000f\\3GK\u0006$XO]3UsB,\u0017aB:gi~#S-\u001d\u000b\u0003UB\u0004\"a\u001b8\u000e\u00031T\u0011!\\\u0001\u0006g\u000e\fG.Y\u0005\u0003_2\u0014A!\u00168ji\"9\u0011oAA\u0001\u0002\u0004)\u0017a\u0001=%c\u0005!1O\u001a;!\u0003\u001d9(/\u00199qKJ,\u0012!\u001e\t\u0006m\u0006U\u00111\u0004\b\u0004o\u0006=ab\u0001=\u0002\n9\u0019\u00110!\u0002\u000f\u0007i\f\u0019AD\u0002|\u0003\u0003q!\u0001`@\u000e\u0003uT!A`\u0017\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0013B\u0001\u0016,\u0013\tA\u0013&C\u0002\u0002\b\u001d\nQ!\u001b8eKbLA!a\u0003\u0002\u000e\u0005\u0019\u0011\r]5\u000b\u0007\u0005\u001dq%\u0003\u0003\u0002\u0012\u0005M\u0011aD,sSR\f'\r\\3GK\u0006$XO]3\u000b\t\u0005-\u0011QB\u0005\u0005\u0003/\tIB\u0001\bGK\u0006$XO]3Xe\u0006\u0004\b/\u001a:\u000b\t\u0005E\u00111\u0003\t\u0005\u0003;\ty\"\u0004\u0002\u0002\u0014%!\u0011\u0011EA\n\u0005=9&/\u001b;bE2,g)Z1ukJ,\u0017aC<sCB\u0004XM]0%KF$2A[A\u0014\u0011\u001d\th!!AA\u0002U\f\u0001b\u001e:baB,'\u000fI\u0001\u0007oJLG/\u001a:\u0016\u0005\u0005=\u0002\u0007BA\u0019\u0003w\u0001b!!\b\u00024\u0005]\u0012\u0002BA\u001b\u0003'\u0011ab\u0016:ji\u0016\u001cuN\u001c<feR,'\u000f\u0005\u0003\u0002:\u0005mB\u0002\u0001\u0003\f\u0003{Q\u0011\u0011!A\u0001\u0006\u0003\t\tEA\u0002`IE\nqa\u001e:ji\u0016\u0014\b%\u0005\u0003\u0002D\u0005%\u0003cA6\u0002F%\u0019\u0011q\t7\u0003\u000f9{G\u000f[5oOB\u00191.a\u0013\n\u0007\u00055CNA\u0002B]f\f!b\u001e:ji\u0016\u0014x\fJ3r)\rQ\u00171\u000b\u0005\tc&\t\t\u00111\u0001\u0002VA\"\u0011qKA.!\u0019\ti\"a\r\u0002ZA!\u0011\u0011HA.\t1\ti$a\u0015\u0002\u0002\u0003\u0005)\u0011AA!\u0003!1W-\u0019;ve\u0016\u001cXCAA1!\r\u0001\u00141M\u0005\u0004\u0003K\n$aB\"pk:$XM]\u0001\rM\u0016\fG/\u001e:fg~#S-\u001d\u000b\u0004U\u0006-\u0004\u0002C9\r\u0003\u0003\u0005\r!!\u0019\u0002\u0013\u0019,\u0017\r^;sKN\u0004\u0013aB3oiJLWm]\u0001\fK:$(/[3t?\u0012*\u0017\u000fF\u0002k\u0003kB\u0001\"]\b\u0002\u0002\u0003\u0007\u0011\u0011M\u0001\tK:$(/[3tA\u00051a-Y5mK\u0012\f!BZ1jY\u0016$w\fJ3r)\rQ\u0017q\u0010\u0005\tcJ\t\t\u00111\u0001\u0002b\u00059a-Y5mK\u0012\u0004\u0013!\u00022zi\u0016\u001cX#A%\u0002\r\tLH/Z:!\u0003\u0015\u0019X\r^;q)\rQ\u0017Q\u0012\u0005\b\u0003\u001f3\u0002\u0019AAI\u0003\u001d\u0019wN\u001c;fqR\u00042!a%\u001d\u001d\t\u0011\u0017$\u0001\u000bI\u0005\u0006\u001cX-\u00138eKb4\u0015\u000e\\3NCB\u0004XM\u001d\t\u0003Ej\u00192AGAN!\rY\u0017QT\u0005\u0004\u0003?c'AB!osJ+g\r\u0006\u0002\u0002\u0018\nQQ*\u00199D_:$X\r\u001f;\u0011\u0007=\n9+C\u0002\u0002*^\u0012qaQ8oi\u0016DH/A\u0006UsB,g*Y7f\u0017\u0016LXCAAX!\u0011\t\t,a/\u000e\u0005\u0005M&\u0002BA[\u0003o\u000bA\u0001\\1oO*\u0011\u0011\u0011X\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002>\u0006M&AB*ue&tw-\u0001\u0007UsB,g*Y7f\u0017\u0016L\b%A\u0006tKR$\u0016\u0010]3OC6,G#\u00026\u0002F\u0006M\u0007bBAd?\u0001\u0007\u0011\u0011Z\u0001\u0005G>tg\r\u0005\u0003\u0002L\u0006=WBAAg\u0015\r\t9mM\u0005\u0005\u0003#\fiMA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0003+|\u0002\u0019AAl\u0003!!\u0018\u0010]3OC6,\u0007\u0003BAm\u0003CtA!a7\u0002^B\u0011A\u0010\\\u0005\u0004\u0003?d\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002>\u0006\r(bAApY\u0006Yq-\u001a;UsB,g*Y7f)\u0011\t9.!;\t\u000f\u0005\u001d\u0007\u00051\u0001\u0002J\u0006I1m\u001c8gS\u001e,(/\u001a\u000b\fU\u0006=\u0018\u0011 B\u0002\u0005\u000b\u00119\u0001C\u0004\u0002r\u0006\u0002\r!a=\u0002\u0007)|'\rE\u00021\u0003kL1!a>2\u0005\rQuN\u0019\u0005\b\u0003w\f\u0003\u0019AA\u007f\u0003\u0019\u0001\u0018M]1ngBA\u0011\u0011\\A\u0000\u0003/\f9.\u0003\u0003\u0003\u0002\u0005\r(aA'ba\"9\u0011Q[\u0011A\u0002\u0005]\u0007bBA\u0004C\u0001\u0007\u0011q\u001b\u0005\b\u0005\u0013\t\u0003\u0019\u0001B\u0006\u0003\u0019yW\u000f\u001e9viB!!Q\u0002B\n\u001b\t\u0011yAC\u0002\u0003\u0012M\n!AZ:\n\t\tU!q\u0002\u0002\u0005!\u0006$\b.A\u0004dY\u0016\fg.\u001e9\u0015\u0007)\u0014Y\u0002C\u0004\u0002\u0010^\u0001\r!!%\u0002\u00075\f\u0007\u000fF\u0004k\u0005C\u0011)C!\u000b\t\r\t\r\u0002\u00041\u0001:\u0003\rYW-\u001f\u0005\u0007\u0005OA\u0002\u0019A \u0002\u000bY\fG.^3\t\u000f\u0005=\u0005\u00041\u0001\u0002\u0012\u0002")
public class HBaseIndexFileMapper
extends Mapper<Writable, SimpleFeature, ImmutableBytesWritable, Put>
implements LazyLogging {
    private SimpleFeatureType sft;
    private WritableFeature.FeatureWrapper<WritableFeature> wrapper;
    private WriteConverter<?> writer;
    private Counter features;
    private Counter entries;
    private Counter failed;
    private final ImmutableBytesWritable bytes;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static void configure(Job job, Map<String, String> params, String typeName, String index, Path output) {
        HBaseIndexFileMapper$.MODULE$.configure(job, params, typeName, index, output);
    }

    private Logger logger$lzycompute() {
        HBaseIndexFileMapper hBaseIndexFileMapper = this;
        synchronized (hBaseIndexFileMapper) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private SimpleFeatureType sft() {
        return this.sft;
    }

    private void sft_$eq(SimpleFeatureType x$1) {
        this.sft = x$1;
    }

    private WritableFeature.FeatureWrapper<WritableFeature> wrapper() {
        return this.wrapper;
    }

    private void wrapper_$eq(WritableFeature.FeatureWrapper<WritableFeature> x$1) {
        this.wrapper = x$1;
    }

    private WriteConverter<?> writer() {
        return this.writer;
    }

    private void writer_$eq(WriteConverter<?> x$1) {
        this.writer = x$1;
    }

    private Counter features() {
        return this.features;
    }

    private void features_$eq(Counter x$1) {
        this.features = x$1;
    }

    private Counter entries() {
        return this.entries;
    }

    private void entries_$eq(Counter x$1) {
        this.entries = x$1;
    }

    private Counter failed() {
        return this.failed;
    }

    private void failed_$eq(Counter x$1) {
        this.failed = x$1;
    }

    private ImmutableBytesWritable bytes() {
        return this.bytes;
    }

    public void setup(Mapper.Context context) {
        WithStore$.MODULE$.apply(GeoMesaConfigurator$.MODULE$.getDataStoreOutParams(context.getConfiguration())).apply((Function1 & Serializable)ds -> {
            HBaseIndexFileMapper.$anonfun$setup$1(this, context, ds);
            return BoxedUnit.UNIT;
        });
        this.features_$eq(context.getCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat.OutputCounters$.MODULE$.Written()));
        this.entries_$eq(context.getCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), "entries"));
        this.failed_$eq(context.getCounter(GeoMesaOutputFormat.OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat.OutputCounters$.MODULE$.Failed()));
    }

    public void cleanup(Mapper.Context context) {
    }

    public void map(Writable key, SimpleFeature value2, Mapper.Context context) {
        try {
            WritableFeature.FeatureWrapper<WritableFeature> qual$1 = this.wrapper();
            SimpleFeature x$1 = value2;
            boolean x$2 = qual$1.wrap$default$2();
            WritableFeature feature = qual$1.wrap(x$1, x$2);
            WriteConverter<?> qual$2 = this.writer();
            WritableFeature x$3 = feature;
            boolean x$4 = qual$2.convert$default$2();
            package.RowKeyValue rowKeyValue = qual$2.convert(x$3, x$4);
            if (rowKeyValue instanceof package.SingleRowKeyValue) {
                package.SingleRowKeyValue singleRowKeyValue = (package.SingleRowKeyValue)rowKeyValue;
                singleRowKeyValue.values().foreach((Function1 & Serializable)value -> {
                    HBaseIndexFileMapper.$anonfun$map$1(this, singleRowKeyValue, context, value);
                    return BoxedUnit.UNIT;
                });
            } else if (rowKeyValue instanceof package.MultiRowKeyValue) {
                package.MultiRowKeyValue multiRowKeyValue = (package.MultiRowKeyValue)rowKeyValue;
                multiRowKeyValue.rows().foreach((Function1 & Serializable)row -> {
                    HBaseIndexFileMapper.$anonfun$map$2(this, multiRowKeyValue, context, row);
                    return BoxedUnit.UNIT;
                });
            } else {
                throw new MatchError((Object)rowKeyValue);
            }
            this.features().increment(1L);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(22).append("Error writing feature ").append(Option$.MODULE$.apply((Object)value2).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString(), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.failed().increment(1L);
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$setup$1(HBaseIndexFileMapper $this, Mapper.Context context$1, HBaseDataStore ds) {
        SeqOps seqOps;
        Some some;
        Seq seq;
        Predef$.MODULE$.require(ds != null, (Function0 & Serializable)() -> "Could not find data store - check your configuration and hbase-site.xml");
        $this.sft_$eq(ds.getSchema(HBaseIndexFileMapper$.MODULE$.org$locationtech$geomesa$hbase$jobs$HBaseIndexFileMapper$$getTypeName(context$1.getConfiguration())));
        Predef$.MODULE$.require($this.sft() != null, (Function0 & Serializable)() -> "Could not find schema - check your configuration");
        $this.wrapper_$eq((WritableFeature.FeatureWrapper<WritableFeature>)WritableFeature$.MODULE$.wrapper($this.sft(), ds.adapter().groups()));
        Option option = GeoMesaConfigurator$.MODULE$.getIndicesOut(context$1.getConfiguration());
        if (!(option instanceof Some) || (seq = (Seq)(some = (Some)option).value()) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) != 0) {
            throw new IllegalArgumentException("Could not find write index - check your configuration");
        }
        String idx = (String)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        $this.writer_$eq(ds.manager().index($this.sft(), idx, IndexMode$.MODULE$.Write()).createConverter());
    }

    public static final /* synthetic */ void $anonfun$map$1(HBaseIndexFileMapper $this, package.SingleRowKeyValue x2$1, Mapper.Context context$2, package.KeyValue value) {
        Put put = new Put(x2$1.row());
        put.addImmutable(value.cf(), value.cq(), value.value());
        Object object = !ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(value.vis())) ? put.setCellVisibility(new CellVisibility(new String(value.vis(), StandardCharsets.UTF_8))) : BoxedUnit.UNIT;
        put.setDurability(HBaseIndexAdapter$.MODULE$.durability());
        $this.bytes().set(put.getRow());
        context$2.write((Object)$this.bytes(), (Object)put);
        $this.entries().increment(1L);
    }

    public static final /* synthetic */ void $anonfun$map$3(HBaseIndexFileMapper $this, byte[] row$1, Mapper.Context context$2, package.KeyValue value) {
        Put put = new Put(row$1);
        put.addImmutable(value.cf(), value.cq(), value.value());
        Object object = !ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.byteArrayOps(value.vis())) ? put.setCellVisibility(new CellVisibility(new String(value.vis(), StandardCharsets.UTF_8))) : BoxedUnit.UNIT;
        put.setDurability(HBaseIndexAdapter$.MODULE$.durability());
        $this.bytes().set(put.getRow());
        context$2.write((Object)$this.bytes(), (Object)put);
        $this.entries().increment(1L);
    }

    public static final /* synthetic */ void $anonfun$map$2(HBaseIndexFileMapper $this, package.MultiRowKeyValue x3$1, Mapper.Context context$2, byte[] row) {
        x3$1.values().foreach((Function1 & Serializable)value -> {
            HBaseIndexFileMapper.$anonfun$map$3($this, row, context$2, value);
            return BoxedUnit.UNIT;
        });
    }

    public HBaseIndexFileMapper() {
        LazyLogging.$init$((LazyLogging)this);
        this.bytes = new ImmutableBytesWritable();
    }
}

