/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.jobs;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.api.data.Query;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.hbase.jobs.GeoMesaHBaseInputFormat;
import org.locationtech.geomesa.hbase.jobs.HBaseJobUtils$;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.utils.io.WithStore$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class GeoMesaHBaseInputFormat$ {
    public static final GeoMesaHBaseInputFormat$ MODULE$ = new GeoMesaHBaseInputFormat$();

    public void configure(Job job, Map<String, ?> params, Query query) {
        HBaseQueryPlan.ScanPlan plan = (HBaseQueryPlan.ScanPlan)WithStore$.MODULE$.apply(params).apply((Function1 & Serializable)ds -> {
            Predef$.MODULE$.assert(ds != null, (Function0 & Serializable)() -> "Invalid data store parameters");
            return HBaseJobUtils$.MODULE$.getSingleScanPlan((HBaseDataStore)ds, query);
        });
        this.configure(job, plan);
    }

    public void configure(Job job, HBaseQueryPlan.ScanPlan plan) {
        job.setInputFormatClass(GeoMesaHBaseInputFormat.class);
        this.configure(job.getConfiguration(), plan);
    }

    public void configure(Configuration conf, HBaseQueryPlan.ScanPlan plan) {
        if (plan.scans().lengthCompare(1) != 0) {
            throw new IllegalArgumentException(new StringBuilder(32).append("Query requires multiple tables: ").append(((IterableOnceOps)plan.scans().map((Function1 & Serializable)x$1 -> x$1.table())).mkString(", ")).toString());
        }
        conf.set("hbase.mapreduce.inputtable", ((HBaseQueryPlan.TableScan)plan.scans().head()).table().getNameAsString());
        Seq scans = (Seq)((HBaseQueryPlan.TableScan)plan.scans().head()).scans().map((Function1 & Serializable)scan -> {
            scan.setAttribute("scan.attributes.table.name", ((HBaseQueryPlan.TableScan)plan.scans().head()).table().getName());
            return TableMapReduceUtil.convertScanToString((Scan)scan);
        });
        conf.setStrings("hbase.mapreduce.scans", (String[])scans.toArray(ClassTag$.MODULE$.apply(String.class)));
        GeoMesaConfigurator$.MODULE$.setResultsToFeatures(conf, plan.resultsToFeatures());
        plan.reducer().foreach((Function1 & Serializable)x$2 -> {
            GeoMesaConfigurator$.MODULE$.setReducer(conf, x$2);
            return BoxedUnit.UNIT;
        });
        plan.sort().foreach((Function1 & Serializable)x$3 -> {
            GeoMesaConfigurator$.MODULE$.setSorting(conf, x$3);
            return BoxedUnit.UNIT;
        });
        plan.projection().foreach((Function1 & Serializable)x$4 -> {
            GeoMesaConfigurator$.MODULE$.setProjection(conf, x$4);
            return BoxedUnit.UNIT;
        });
    }

    private GeoMesaHBaseInputFormat$() {
    }
}

