/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.jobs;

import java.io.Serializable;
import org.geotools.api.data.Query;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.index.api.QueryPlan;
import org.locationtech.geomesa.index.api.package;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;

public final class HBaseJobUtils$ {
    public static final HBaseJobUtils$ MODULE$ = new HBaseJobUtils$();

    public HBaseQueryPlan.ScanPlan getSingleScanPlan(HBaseDataStore ds, Query query) throws IllegalArgumentException {
        Seq plans = ds.getQueryPlan(query, ds.getQueryPlan$default$2(), ds.getQueryPlan$default$3());
        if (plans.lengthCompare(1) != 0) {
            throw new IllegalArgumentException(new StringBuilder(37).append("Query requires multiple query plans: ").append(plans.mkString(", ")).toString());
        }
        boolean bl = false;
        HBaseQueryPlan.ScanPlan scanPlan = null;
        HBaseQueryPlan hBaseQueryPlan = (HBaseQueryPlan)plans.head();
        if (hBaseQueryPlan instanceof HBaseQueryPlan.ScanPlan) {
            bl = true;
            scanPlan = (HBaseQueryPlan.ScanPlan)hBaseQueryPlan;
            if (scanPlan.scans().lengthCompare(1) == 0) {
                return scanPlan;
            }
        }
        if (bl) {
            throw new IllegalArgumentException(new StringBuilder(81).append("Query requires multiple tables, which is not supported through ").append("the input format: ").append(((IterableOnceOps)scanPlan.scans().map((Function1 & Serializable)x$1 -> x$1.table())).mkString(", ")).toString());
        }
        throw new IllegalArgumentException(new StringBuilder(71).append("Query requires a scan which is not supported through ").append("the input format: ").append(hBaseQueryPlan.getClass().getName()).toString());
    }

    public Seq<HBaseQueryPlan.ScanPlan> getMultiScanPlans(HBaseDataStore ds, Query query) throws IllegalArgumentException {
        return (Seq)ds.getQueryPlan(query, ds.getQueryPlan$default$2(), ds.getQueryPlan$default$3()).flatMap((Function1 & Serializable)x0$1 -> {
            boolean bl = false;
            HBaseQueryPlan.ScanPlan scanPlan = null;
            HBaseQueryPlan hBaseQueryPlan = x0$1;
            if (hBaseQueryPlan instanceof HBaseQueryPlan.ScanPlan) {
                bl = true;
                scanPlan = (HBaseQueryPlan.ScanPlan)hBaseQueryPlan;
                if (scanPlan.scans().lengthCompare(1) == 0) {
                    return new .colon.colon((Object)scanPlan, (List)Nil$.MODULE$);
                }
            }
            if (bl) {
                return (IterableOnce)scanPlan.scans().map((Function1 & Serializable)scan -> {
                    .colon.colon x$1 = new .colon.colon(scan, (List)Nil$.MODULE$);
                    package.FilterStrategy x$2 = scanPlan.copy$default$1();
                    Seq x$3 = scanPlan.copy$default$2();
                    QueryPlan.ResultsToFeatures x$4 = scanPlan.copy$default$4();
                    Option x$5 = scanPlan.copy$default$5();
                    Option x$6 = scanPlan.copy$default$6();
                    Option x$7 = scanPlan.copy$default$7();
                    Option x$8 = scanPlan.copy$default$8();
                    return scanPlan.copy(x$2, x$3, (Seq)x$1, x$4, x$5, x$6, x$7, x$8);
                });
            }
            if (hBaseQueryPlan instanceof HBaseQueryPlan.EmptyPlan) {
                return package$.MODULE$.Seq().empty();
            }
            throw new IllegalArgumentException(new StringBuilder(71).append("Query requires a scan which is not supported through ").append("the input format: ").append(hBaseQueryPlan.getClass().getName()).toString());
        });
    }

    private HBaseJobUtils$() {
    }
}

