/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.rpc.filter;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.factory.Hints;
import org.locationtech.geomesa.features.SerializationOption;
import org.locationtech.geomesa.features.kryo.KryoBufferSimpleFeature;
import org.locationtech.geomesa.features.kryo.KryoFeatureSerializer$;
import org.locationtech.geomesa.hbase.filters.JSimpleFeatureFilter;
import org.locationtech.geomesa.hbase.rpc.filter.CqlTransformFilter;
import org.locationtech.geomesa.hbase.rpc.filter.CqlTransformFilter$NullFeatureIndex$;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.index.conf.package;
import org.locationtech.geomesa.index.iterators.IteratorCache$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class CqlTransformFilter$
implements StrictLogging {
    public static final CqlTransformFilter$ MODULE$;
    private final int Priority;
    private final Logger logger;

    static {
        new CqlTransformFilter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int Priority() {
        return this.Priority;
    }

    public Filter parseFrom(byte[] pbBytes) throws DeserializationException {
        return new CqlTransformFilter(this.deserialize(pbBytes));
    }

    public CqlTransformFilter apply(SimpleFeatureType sft, GeoMesaFeatureIndex<?, ?> index, Option<org.opengis.filter.Filter> filter, Option<Tuple2<String, SimpleFeatureType>> transform, Hints hints) {
        Tuple3 tuple3;
        block10: {
            Option option;
            Some some;
            boolean bl;
            block13: {
                CqlTransformFilter cqlTransformFilter;
                block12: {
                    CqlTransformFilter.DelegateFilter delegate;
                    block11: {
                        CqlTransformFilter.DelegateFilter delegateFilter;
                        block6: {
                            Option samplingOpts;
                            KryoBufferSimpleFeature feature;
                            block9: {
                                block8: {
                                    block7: {
                                        block5: {
                                            if (filter.isEmpty() && transform.isEmpty() && QueryHints$.MODULE$.RichHints(hints).getSampling().isEmpty()) {
                                                throw new IllegalArgumentException("The filter must have a predicate and/or transform");
                                            }
                                            feature = KryoFeatureSerializer$.MODULE$.apply(sft, SerializationOption.SerializationOptions$.MODULE$.withoutId()).getReusableFeature();
                                            feature.setIdParser((Function3)new Serializable(index){
                                                public static final long serialVersionUID = 0L;
                                                private final GeoMesaFeatureIndex index$1;

                                                public final String apply(byte[] x$1, int x$2, int x$3) {
                                                    return this.index$1.getIdFromRow(x$1, x$2, x$3, null);
                                                }
                                                {
                                                    this.index$1 = index$1;
                                                }
                                            });
                                            transform.foreach((Function1)new Serializable(feature){
                                                public static final long serialVersionUID = 0L;
                                                private final KryoBufferSimpleFeature feature$1;

                                                public final void apply(Tuple2<String, SimpleFeatureType> x0$1) {
                                                    Tuple2<String, SimpleFeatureType> tuple2 = x0$1;
                                                    if (tuple2 != null) {
                                                        String tdefs = (String)tuple2._1();
                                                        SimpleFeatureType tsft = (SimpleFeatureType)tuple2._2();
                                                        this.feature$1.setTransforms(tdefs, tsft);
                                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                                        return;
                                                    }
                                                    throw new MatchError(tuple2);
                                                }
                                                {
                                                    this.feature$1 = feature$1;
                                                }
                                            });
                                            samplingOpts = QueryHints$.MODULE$.RichHints(hints).getSampling();
                                            tuple3 = new Tuple3(filter, transform, (Object)samplingOpts);
                                            if (tuple3 == null) break block5;
                                            Option option2 = (Option)tuple3._1();
                                            Option option3 = (Option)tuple3._2();
                                            Option option4 = (Option)tuple3._3();
                                            if (!None$.MODULE$.equals(option2) || !None$.MODULE$.equals(option3) || !(option4 instanceof Some)) break block5;
                                            delegateFilter = new CqlTransformFilter.FilterDelegate(sft, index, feature, (org.opengis.filter.Filter)org.opengis.filter.Filter.INCLUDE, (Option<Tuple2<Object, Option<String>>>)samplingOpts);
                                            break block6;
                                        }
                                        if (tuple3 == null) break block7;
                                        Option option5 = (Option)tuple3._1();
                                        Option option6 = (Option)tuple3._2();
                                        Option option7 = (Option)tuple3._3();
                                        if (!None$.MODULE$.equals(option5) || !(option6 instanceof Some) || !(option7 instanceof Some)) break block7;
                                        delegateFilter = new CqlTransformFilter.FilterTransformDelegate(sft, index, feature, (org.opengis.filter.Filter)org.opengis.filter.Filter.INCLUDE, (Option<Tuple2<Object, Option<String>>>)samplingOpts);
                                        break block6;
                                    }
                                    if (tuple3 == null) break block8;
                                    Option option8 = (Option)tuple3._1();
                                    Option option9 = (Option)tuple3._2();
                                    if (!(option8 instanceof Some)) break block8;
                                    Some some2 = (Some)option8;
                                    org.opengis.filter.Filter f = (org.opengis.filter.Filter)some2.x();
                                    if (!None$.MODULE$.equals(option9)) break block8;
                                    delegateFilter = new CqlTransformFilter.FilterDelegate(sft, index, feature, f, (Option<Tuple2<Object, Option<String>>>)samplingOpts);
                                    break block6;
                                }
                                if (tuple3 == null) break block9;
                                Option option10 = (Option)tuple3._1();
                                Option option11 = (Option)tuple3._2();
                                if (!(option10 instanceof Some)) break block9;
                                Some some3 = (Some)option10;
                                org.opengis.filter.Filter f = (org.opengis.filter.Filter)some3.x();
                                if (!(option11 instanceof Some)) break block9;
                                delegateFilter = new CqlTransformFilter.FilterTransformDelegate(sft, index, feature, f, (Option<Tuple2<Object, Option<String>>>)samplingOpts);
                                break block6;
                            }
                            if (tuple3 == null) break block10;
                            Option option12 = (Option)tuple3._1();
                            Option option13 = (Option)tuple3._2();
                            if (!None$.MODULE$.equals(option12) || !(option13 instanceof Some)) break block10;
                            delegateFilter = new CqlTransformFilter.TransformDelegate(sft, index, feature, (Option<Tuple2<Object, Option<String>>>)samplingOpts);
                        }
                        delegate = delegateFilter;
                        bl = false;
                        some = null;
                        option = QueryHints$.MODULE$.RichHints(hints).getFilterCompatibility();
                        if (!None$.MODULE$.equals(option)) break block11;
                        cqlTransformFilter = new CqlTransformFilter(delegate);
                        break block12;
                    }
                    if (!(option instanceof Some)) break block13;
                    bl = true;
                    some = (Some)option;
                    Enumeration.Value value = (Enumeration.Value)some.x();
                    Enumeration.Value value2 = package.FilterCompatibility$.MODULE$.2$u002E3();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block13;
                    cqlTransformFilter = new JSimpleFeatureFilter(delegate);
                }
                return cqlTransformFilter;
            }
            if (bl) {
                Enumeration.Value c = (Enumeration.Value)some.x();
                throw new NotImplementedError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Filter compatibility ", " is not implemented for this query"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c})));
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)tuple3);
    }

    /*
     * Unable to fully structure code
     */
    public byte[] org$locationtech$geomesa$hbase$rpc$filter$CqlTransformFilter$$serialize(CqlTransformFilter.DelegateFilter delegate) {
        block23: {
            block22: {
                block21: {
                    sftBytes = SimpleFeatureTypes$.MODULE$.encodeType(delegate.sft(), true).getBytes(StandardCharsets.UTF_8);
                    cqlBytes = (byte[])delegate.filter().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final byte[] apply(org.opengis.filter.Filter x$4) {
                            return ECQL.toCQL((org.opengis.filter.Filter)x$4).getBytes(StandardCharsets.UTF_8);
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final byte[] apply() {
                            return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
                        }
                    });
                    indexBytes = delegate.index().identifier().getBytes(StandardCharsets.UTF_8);
                    v0 = delegate.index();
                    var6_5 = CqlTransformFilter$NullFeatureIndex$.MODULE$;
                    if (!(v0 == null ? var6_5 != null : v0.equals((Object)var6_5) == false)) ** GOTO lbl-1000
                    v1 = delegate.index().sft();
                    var7_6 = delegate.sft();
                    if (!(v1 != null ? v1.equals(var7_6) == false : var7_6 != null)) lbl-1000:
                    // 2 sources

                    {
                        v2 = (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
                    } else {
                        v2 = SimpleFeatureTypes$.MODULE$.encodeType(delegate.index().sft(), true).getBytes(StandardCharsets.UTF_8);
                    }
                    indexSftBytes = v2;
                    samplingFactor = delegate.samplingOptions().map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final float apply(Tuple2<Object, Option<String>> s) {
                            return BoxesRunTime.unboxToFloat((Object)s._1());
                        }
                    });
                    samplingField = delegate.samplingOptions().flatMap((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Option<String> apply(Tuple2<Object, Option<String>> s) {
                            return (Option)s._2();
                        }
                    });
                    samplingFactorBytes = (byte[])samplingFactor.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final byte[] apply(float f) {
                            return ByteBuffer.allocate(4).putFloat(f).array();
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final byte[] apply() {
                            return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
                        }
                    });
                    samplingFieldBytes = (byte[])samplingField.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final byte[] apply(String field) {
                            return field.getBytes(StandardCharsets.UTF_8);
                        }
                    }).getOrElse((Function0)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final byte[] apply() {
                            return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
                        }
                    });
                    var12_12 = delegate.transform();
                    if (!None$.MODULE$.equals(var12_12)) break block21;
                    array = (byte[])Array$.MODULE$.ofDim(sftBytes.length + cqlBytes.length + indexBytes.length + indexSftBytes.length + samplingFactorBytes.length + samplingFieldBytes.length + 28, ClassTag$.MODULE$.Byte());
                    offset = 0;
                    ByteArrays$.MODULE$.writeInt(sftBytes.length, array, offset);
                    System.arraycopy(sftBytes, 0, array, offset += 4, sftBytes.length);
                    ByteArrays$.MODULE$.writeInt(cqlBytes.length, array, offset += sftBytes.length);
                    System.arraycopy(cqlBytes, 0, array, offset += 4, cqlBytes.length);
                    ByteArrays$.MODULE$.writeInt(-1, array, offset += cqlBytes.length);
                    ByteArrays$.MODULE$.writeInt(indexBytes.length, array, offset += 4);
                    System.arraycopy(indexBytes, 0, array, offset += 4, indexBytes.length);
                    offset += indexBytes.length;
                    if (Predef$.MODULE$.byteArrayOps(indexSftBytes).isEmpty()) {
                        v3 = delegate.index();
                        var16_15 = CqlTransformFilter$NullFeatureIndex$.MODULE$;
                        if (!(v3 != null ? v3.equals((Object)var16_15) == false : var16_15 != null)) {
                            ByteArrays$.MODULE$.writeInt(-1, array, offset);
                            offset += 4;
                        } else {
                            ByteArrays$.MODULE$.writeInt(0, array, offset);
                            offset += 4;
                        }
                    } else {
                        ByteArrays$.MODULE$.writeInt(indexSftBytes.length, array, offset);
                        System.arraycopy(indexSftBytes, 0, array, offset += 4, indexSftBytes.length);
                        offset += indexSftBytes.length;
                    }
                    if (Predef$.MODULE$.byteArrayOps(samplingFactorBytes).isEmpty()) {
                        ByteArrays$.MODULE$.writeInt(0, array, offset);
                        offset += 4;
                    } else {
                        ByteArrays$.MODULE$.writeInt(samplingFactorBytes.length, array, offset);
                        System.arraycopy(samplingFactorBytes, 0, array, offset += 4, samplingFactorBytes.length);
                        offset += samplingFactorBytes.length;
                    }
                    if (Predef$.MODULE$.byteArrayOps(samplingFieldBytes).isEmpty()) {
                        ByteArrays$.MODULE$.writeInt(0, array, offset);
                    } else {
                        ByteArrays$.MODULE$.writeInt(samplingFieldBytes.length, array, offset);
                        System.arraycopy(samplingFieldBytes, 0, array, offset += 4, samplingFieldBytes.length);
                    }
                    var13_16 = array;
                    break block22;
                }
                if (!(var12_12 instanceof Some) || (var18_18 = (Tuple2)(var17_17 = (Some)var12_12).x()) == null) break block23;
                tdefs = (String)var18_18._1();
                tsft = (SimpleFeatureType)var18_18._2();
                tdefsBytes = tdefs.getBytes(StandardCharsets.UTF_8);
                tsftBytes = SimpleFeatureTypes$.MODULE$.encodeType(tsft).getBytes(StandardCharsets.UTF_8);
                array = (byte[])Array$.MODULE$.ofDim(sftBytes.length + cqlBytes.length + tdefsBytes.length + tsftBytes.length + indexBytes.length + indexSftBytes.length + samplingFactorBytes.length + samplingFieldBytes.length + 32, ClassTag$.MODULE$.Byte());
                offset = 0;
                ByteArrays$.MODULE$.writeInt(sftBytes.length, array, offset);
                System.arraycopy(sftBytes, 0, array, offset += 4, sftBytes.length);
                ByteArrays$.MODULE$.writeInt(cqlBytes.length, array, offset += sftBytes.length);
                System.arraycopy(cqlBytes, 0, array, offset += 4, cqlBytes.length);
                ByteArrays$.MODULE$.writeInt(tdefsBytes.length, array, offset += cqlBytes.length);
                System.arraycopy(tdefsBytes, 0, array, offset += 4, tdefsBytes.length);
                ByteArrays$.MODULE$.writeInt(tsftBytes.length, array, offset += tdefsBytes.length);
                System.arraycopy(tsftBytes, 0, array, offset += 4, tsftBytes.length);
                ByteArrays$.MODULE$.writeInt(indexBytes.length, array, offset += tsftBytes.length);
                System.arraycopy(indexBytes, 0, array, offset += 4, indexBytes.length);
                offset += indexBytes.length;
                if (Predef$.MODULE$.byteArrayOps(indexSftBytes).isEmpty()) {
                    v4 = delegate.index();
                    var25_25 = CqlTransformFilter$NullFeatureIndex$.MODULE$;
                    if (!(v4 != null ? v4.equals((Object)var25_25) == false : var25_25 != null)) {
                        ByteArrays$.MODULE$.writeInt(-1, array, offset);
                        offset += 4;
                    } else {
                        ByteArrays$.MODULE$.writeInt(0, array, offset);
                        offset += 4;
                    }
                } else {
                    ByteArrays$.MODULE$.writeInt(indexSftBytes.length, array, offset);
                    System.arraycopy(indexSftBytes, 0, array, offset += 4, indexSftBytes.length);
                    offset += indexSftBytes.length;
                }
                if (Predef$.MODULE$.byteArrayOps(samplingFactorBytes).isEmpty()) {
                    ByteArrays$.MODULE$.writeInt(0, array, offset);
                    offset += 4;
                } else {
                    ByteArrays$.MODULE$.writeInt(samplingFactorBytes.length, array, offset);
                    System.arraycopy(samplingFactorBytes, 0, array, offset += 4, samplingFactorBytes.length);
                    offset += samplingFactorBytes.length;
                }
                if (Predef$.MODULE$.byteArrayOps(samplingFieldBytes).isEmpty()) {
                    ByteArrays$.MODULE$.writeInt(0, array, offset);
                } else {
                    ByteArrays$.MODULE$.writeInt(samplingFieldBytes.length, array, offset);
                    System.arraycopy(samplingFieldBytes, 0, array, offset += 4, samplingFieldBytes.length);
                }
                var13_16 = array;
            }
            return var13_16;
        }
        throw new MatchError(var12_12);
    }

    private CqlTransformFilter.DelegateFilter deserialize(byte[] bytes) throws DeserializationException {
        try {
            Tuple2<GeoMesaFeatureIndex<?, ?>, Object> tuple2;
            block11: {
                CqlTransformFilter.DelegateFilter delegateFilter;
                block10: {
                    int newOffset;
                    Tuple2 tuple22;
                    int tdefsLength;
                    org.opengis.filter.Filter cql;
                    KryoBufferSimpleFeature feature;
                    SimpleFeatureType sft;
                    String spec;
                    int offset;
                    block8: {
                        Tuple2<GeoMesaFeatureIndex<?, ?>, Object> tuple23;
                        block9: {
                            int newOffset2;
                            Tuple2 tuple24;
                            offset = 0;
                            int sftLength = ByteArrays$.MODULE$.readInt(bytes, offset);
                            spec = new String(bytes, offset += 4, sftLength, StandardCharsets.UTF_8);
                            sft = IteratorCache$.MODULE$.sft(spec);
                            feature = IteratorCache$.MODULE$.serializer(spec, SerializationOption.SerializationOptions$.MODULE$.withoutId()).getReusableFeature();
                            int cqlLength = ByteArrays$.MODULE$.readInt(bytes, offset += sftLength);
                            cql = cqlLength == 0 ? null : IteratorCache$.MODULE$.filter(sft, spec, new String(bytes, offset += 4, cqlLength, StandardCharsets.UTF_8));
                            tdefsLength = ByteArrays$.MODULE$.readInt(bytes, offset += cqlLength);
                            if (tdefsLength != -1) break block8;
                            if (cql == null) {
                                throw new DeserializationException("No filter or transform defined");
                            }
                            tuple23 = this.deserializeIndex(sft, spec, bytes, offset + 4);
                            if (tuple23 == null) break block9;
                            GeoMesaFeatureIndex index = (GeoMesaFeatureIndex)tuple23._1();
                            int newOffset3 = tuple23._2$mcI$sp();
                            Tuple2 tuple25 = tuple24 = new Tuple2((Object)index, (Object)BoxesRunTime.boxToInteger((int)newOffset3));
                            GeoMesaFeatureIndex index2 = (GeoMesaFeatureIndex)tuple25._1();
                            offset = newOffset2 = tuple25._2$mcI$sp();
                            feature.setIdParser((Function3)new Serializable(index2){
                                public static final long serialVersionUID = 0L;
                                private final GeoMesaFeatureIndex index$2;

                                public final String apply(byte[] x$6, int x$7, int x$8) {
                                    return this.index$2.getIdFromRow(x$6, x$7, x$8, null);
                                }
                                {
                                    this.index$2 = index$2;
                                }
                            });
                            Option<Tuple2<Object, Option<String>>> samplingOptions = this.deserializeSamplingOptions(bytes, offset);
                            delegateFilter = new CqlTransformFilter.FilterDelegate(sft, index2, feature, cql, samplingOptions);
                            break block10;
                        }
                        throw new MatchError(tuple23);
                    }
                    String tdefs = new String(bytes, offset += 4, tdefsLength, StandardCharsets.UTF_8);
                    int tsftLength = ByteArrays$.MODULE$.readInt(bytes, offset += tdefsLength);
                    SimpleFeatureType tsft = IteratorCache$.MODULE$.sft(new String(bytes, offset += 4, tsftLength, StandardCharsets.UTF_8));
                    feature.setTransforms(tdefs, tsft);
                    tuple2 = this.deserializeIndex(sft, spec, bytes, offset + tsftLength);
                    if (tuple2 == null) break block11;
                    GeoMesaFeatureIndex index = (GeoMesaFeatureIndex)tuple2._1();
                    int newOffset4 = tuple2._2$mcI$sp();
                    Tuple2 tuple26 = tuple22 = new Tuple2((Object)index, (Object)BoxesRunTime.boxToInteger((int)newOffset4));
                    GeoMesaFeatureIndex index3 = (GeoMesaFeatureIndex)tuple26._1();
                    offset = newOffset = tuple26._2$mcI$sp();
                    feature.setIdParser((Function3)new Serializable(index3){
                        public static final long serialVersionUID = 0L;
                        private final GeoMesaFeatureIndex index$3;

                        public final String apply(byte[] x$10, int x$11, int x$12) {
                            return this.index$3.getIdFromRow(x$10, x$11, x$12, null);
                        }
                        {
                            this.index$3 = index$3;
                        }
                    });
                    Option<Tuple2<Object, Option<String>>> samplingOptions = this.deserializeSamplingOptions(bytes, offset);
                    delegateFilter = cql == null ? new CqlTransformFilter.TransformDelegate(sft, index3, feature, samplingOptions) : new CqlTransformFilter.FilterTransformDelegate(sft, index3, feature, cql, samplingOptions);
                }
                return delegateFilter;
            }
            throw new MatchError(tuple2);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof DeserializationException) {
                DeserializationException deserializationException = (DeserializationException)throwable2;
                throw deserializationException;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            throw new DeserializationException("Error deserializing filter", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<Object, Option<String>>> deserializeSamplingOptions(byte[] bytes, int start) {
        void var3_3;
        Option samplingOption = Option$.MODULE$.empty();
        int offset = start;
        int factorLength = ByteArrays$.MODULE$.readInt(bytes, offset);
        offset += 4;
        if (factorLength != 0) {
            float samplingFactor = ByteBuffer.wrap(bytes, offset, factorLength).getFloat();
            int fieldNameLength = ByteArrays$.MODULE$.readInt(bytes, offset += factorLength);
            offset += 4;
            if (fieldNameLength != 0) {
                String fieldName = new String(bytes, offset, fieldNameLength, StandardCharsets.UTF_8);
                samplingOption = Option$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToFloat((float)samplingFactor), (Object)Option$.MODULE$.apply((Object)fieldName)));
            } else {
                samplingOption = Option$.MODULE$.apply((Object)new Tuple2((Object)BoxesRunTime.boxToFloat((float)samplingFactor), (Object)Option$.MODULE$.empty()));
            }
        }
        return var3_3;
    }

    private Tuple2<GeoMesaFeatureIndex<?, ?>, Object> deserializeIndex(SimpleFeatureType sft, String spec, byte[] bytes, int start) {
        Tuple2 tuple2;
        if (bytes.length <= start) {
            tuple2 = new Tuple2((Object)CqlTransformFilter$NullFeatureIndex$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)start));
        } else {
            int offset = start;
            int identifierLength = ByteArrays$.MODULE$.readInt(bytes, offset);
            String identifier = new String(bytes, offset += 4, identifierLength, StandardCharsets.UTF_8);
            int indexSftLength = ByteArrays$.MODULE$.readInt(bytes, offset += identifierLength);
            offset += 4;
            if (indexSftLength == -1) {
                tuple2 = new Tuple2((Object)CqlTransformFilter$NullFeatureIndex$.MODULE$, (Object)BoxesRunTime.boxToInteger((int)offset));
            } else if (indexSftLength == 0) {
                tuple2 = new Tuple2((Object)IteratorCache$.MODULE$.index(sft, spec, identifier), (Object)BoxesRunTime.boxToInteger((int)offset));
            } else {
                String indexSpec = new String(bytes, offset, indexSftLength, StandardCharsets.UTF_8);
                tuple2 = new Tuple2((Object)IteratorCache$.MODULE$.index(IteratorCache$.MODULE$.sft(indexSpec), indexSpec, identifier), (Object)BoxesRunTime.boxToInteger((int)(offset += indexSftLength)));
            }
        }
        return tuple2;
    }

    private CqlTransformFilter$() {
        MODULE$ = this;
        StrictLogging.class.$init$((StrictLogging)this);
        this.Priority = 30;
    }
}

