/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.rpc.filter;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.locationtech.geomesa.hbase.rpc.filter.Z2HBaseFilter;
import org.locationtech.geomesa.index.filters.Z2Filter;
import org.locationtech.geomesa.index.filters.Z2Filter$;
import org.locationtech.geomesa.index.package$;
import org.locationtech.geomesa.utils.cache.ByteArrayCacheKey;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import scala.Array$;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Z2HBaseFilter$
implements StrictLogging {
    public static Z2HBaseFilter$ MODULE$;
    private final int Priority;
    private final LoadingCache<ByteArrayCacheKey, Tuple2<Z2Filter, Object>> cache;
    private final Logger logger;

    static {
        new Z2HBaseFilter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int Priority() {
        return this.Priority;
    }

    private LoadingCache<ByteArrayCacheKey, Tuple2<Z2Filter, Object>> cache() {
        return this.cache;
    }

    public Z2HBaseFilter apply(Z2Filter filter, int offset) {
        byte[] filterBytes = Z2Filter$.MODULE$.serializeToBytes(filter);
        byte[] serialized = (byte[])Array$.MODULE$.ofDim(filterBytes.length + 4, ClassTag$.MODULE$.Byte());
        System.arraycopy(filterBytes, 0, serialized, 0, filterBytes.length);
        ByteArrays$.MODULE$.writeInt(offset, serialized, filterBytes.length);
        return new Z2HBaseFilter(filter, offset, serialized);
    }

    public Filter parseFrom(byte[] pbBytes) throws DeserializationException {
        Tuple2 tuple2 = (Tuple2)this.cache().get((Object)new ByteArrayCacheKey(pbBytes));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Z2Filter filter = (Z2Filter)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)filter, (Object)BoxesRunTime.boxToInteger((int)offset));
        Tuple2 tuple23 = tuple22;
        Z2Filter filter2 = (Z2Filter)tuple23._1();
        int offset2 = tuple23._2$mcI$sp();
        return new Z2HBaseFilter(filter2, offset2, pbBytes);
    }

    private Z2HBaseFilter$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.Priority = 20;
        this.cache = Caffeine.newBuilder().maximumSize((long)BoxesRunTime.unboxToInt((Object)package$.MODULE$.ZFilterCacheSize().toInt().get())).build((CacheLoader)new CacheLoader<ByteArrayCacheKey, Tuple2<Z2Filter, Object>>(){

            @Nonnull
            public Map<ByteArrayCacheKey, Tuple2<Z2Filter, Object>> loadAll(Iterable<? extends ByteArrayCacheKey> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            @Nonnull
            public CompletableFuture asyncLoad(Object x$1, Executor x$2) {
                return super.asyncLoad(x$1, x$2);
            }

            @Nonnull
            public CompletableFuture<Map<ByteArrayCacheKey, Tuple2<Z2Filter, Object>>> asyncLoadAll(Iterable<? extends ByteArrayCacheKey> x$1, Executor x$2) {
                return super.asyncLoadAll(x$1, x$2);
            }

            @CheckForNull
            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            @Nonnull
            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public Tuple2<Z2Filter, Object> load(ByteArrayCacheKey key) {
                BoxedUnit boxedUnit;
                Z2Filter filter = Z2Filter$.MODULE$.deserializeFromBytes(key.bytes());
                int offset = ByteArrays$.MODULE$.readInt(key.bytes(), key.bytes().length - 4);
                if (Z2HBaseFilter$.MODULE$.logger().underlying().isTraceEnabled()) {
                    Z2HBaseFilter$.MODULE$.logger().underlying().trace("Deserialized {}:{}", new Object[]{BoxesRunTime.boxToInteger((int)offset), filter});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new Tuple2((Object)filter, (Object)BoxesRunTime.boxToInteger((int)offset));
            }
        });
    }
}

