/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.rpc.filter;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.locationtech.geomesa.hbase.rpc.filter.S3HBaseFilter;
import org.locationtech.geomesa.index.filters.S3Filter;
import org.locationtech.geomesa.index.filters.S3Filter$;
import org.locationtech.geomesa.index.package$;
import org.locationtech.geomesa.utils.cache.ByteArrayCacheKey;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import scala.Array$;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class S3HBaseFilter$
implements StrictLogging {
    public static S3HBaseFilter$ MODULE$;
    private final int Priority;
    private final LoadingCache<ByteArrayCacheKey, Tuple2<S3Filter, Object>> cache;
    private final Logger logger;

    static {
        new S3HBaseFilter$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public int Priority() {
        return this.Priority;
    }

    private LoadingCache<ByteArrayCacheKey, Tuple2<S3Filter, Object>> cache() {
        return this.cache;
    }

    public S3HBaseFilter apply(S3Filter filter, int offset) {
        byte[] filterBytes = S3Filter$.MODULE$.serializeToBytes(filter);
        byte[] serialized = (byte[])Array$.MODULE$.ofDim(filterBytes.length + 4, ClassTag$.MODULE$.Byte());
        System.arraycopy(filterBytes, 0, serialized, 0, filterBytes.length);
        ByteArrays$.MODULE$.writeInt(offset, serialized, filterBytes.length);
        return new S3HBaseFilter(filter, offset, serialized);
    }

    public Filter parseFrom(byte[] pbBytes) throws DeserializationException {
        Tuple2 tuple2 = (Tuple2)this.cache().get((Object)new ByteArrayCacheKey(pbBytes));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        S3Filter filter = (S3Filter)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)filter, (Object)BoxesRunTime.boxToInteger((int)offset));
        S3Filter filter2 = (S3Filter)tuple22._1();
        int offset2 = tuple22._2$mcI$sp();
        return new S3HBaseFilter(filter2, offset2, pbBytes);
    }

    private S3HBaseFilter$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.Priority = 20;
        this.cache = Caffeine.newBuilder().maximumSize((long)BoxesRunTime.unboxToInt((Object)package$.MODULE$.FilterCacheSize().toInt().get())).build((CacheLoader)new CacheLoader<ByteArrayCacheKey, Tuple2<S3Filter, Object>>(){

            public Map<ByteArrayCacheKey, Tuple2<S3Filter, Object>> loadAll(Iterable<? extends ByteArrayCacheKey> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            public CompletableFuture asyncLoad(Object x$1, Executor x$2) {
                return super.asyncLoad(x$1, x$2);
            }

            public CompletableFuture<Map<ByteArrayCacheKey, Tuple2<S3Filter, Object>>> asyncLoadAll(Iterable<? extends ByteArrayCacheKey> x$1, Executor x$2) {
                return super.asyncLoadAll(x$1, x$2);
            }

            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public Tuple2<S3Filter, Object> load(ByteArrayCacheKey key) {
                BoxedUnit boxedUnit;
                S3Filter filter = S3Filter$.MODULE$.deserializeFromBytes(key.bytes());
                int offset = ByteArrays$.MODULE$.readInt(key.bytes(), key.bytes().length - 4);
                if (S3HBaseFilter$.MODULE$.logger().underlying().isTraceEnabled()) {
                    S3HBaseFilter$.MODULE$.logger().underlying().trace("Deserialized {}:{}", new Object[]{BoxesRunTime.boxToInteger((int)offset), filter});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new Tuple2((Object)filter, (Object)BoxesRunTime.boxToInteger((int)offset));
            }
        });
    }
}

