/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.rpc.filter;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.locationtech.geomesa.hbase.rpc.filter.S2HBaseFilter;
import org.locationtech.geomesa.index.filters.S2Filter;
import org.locationtech.geomesa.index.filters.S2Filter$;
import org.locationtech.geomesa.index.package$;
import org.locationtech.geomesa.utils.cache.ByteArrayCacheKey;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import scala.Array$;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class S2HBaseFilter$
implements StrictLogging {
    public static final S2HBaseFilter$ MODULE$ = new S2HBaseFilter$();
    private static final int Priority;
    private static final LoadingCache<ByteArrayCacheKey, Tuple2<S2Filter, Object>> cache;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        Priority = 20;
        cache = Caffeine.newBuilder().maximumSize((long)BoxesRunTime.unboxToInt((Object)package$.MODULE$.FilterCacheSize().toInt().get())).build((CacheLoader)new CacheLoader<ByteArrayCacheKey, Tuple2<S2Filter, Object>>(){

            public Map<? extends ByteArrayCacheKey, ? extends Tuple2<S2Filter, Object>> loadAll(Set<? extends ByteArrayCacheKey> x$1) throws Exception {
                return super.loadAll(x$1);
            }

            public CompletableFuture asyncLoad(Object x$1, Executor x$2) throws Exception {
                return super.asyncLoad(x$1, x$2);
            }

            public CompletableFuture<? extends Map<? extends ByteArrayCacheKey, ? extends Tuple2<S2Filter, Object>>> asyncLoadAll(Set<? extends ByteArrayCacheKey> x$1, Executor x$2) throws Exception {
                return super.asyncLoadAll(x$1, x$2);
            }

            public Object reload(Object x$1, Object x$2) throws Exception {
                return super.reload(x$1, x$2);
            }

            public CompletableFuture asyncReload(Object x$1, Object x$2, Executor x$3) throws Exception {
                return super.asyncReload(x$1, x$2, x$3);
            }

            public Tuple2<S2Filter, Object> load(ByteArrayCacheKey key) {
                BoxedUnit boxedUnit;
                S2Filter filter = S2Filter$.MODULE$.deserializeFromBytes(key.bytes());
                int offset = ByteArrays$.MODULE$.readInt(key.bytes(), key.bytes().length - 4);
                if (S2HBaseFilter$.MODULE$.logger().underlying().isTraceEnabled()) {
                    S2HBaseFilter$.MODULE$.logger().underlying().trace("Deserialized {}:{}", new Object[]{BoxesRunTime.boxToInteger((int)offset), filter});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return new Tuple2((Object)filter, (Object)BoxesRunTime.boxToInteger((int)offset));
            }
        });
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    public int Priority() {
        return Priority;
    }

    private LoadingCache<ByteArrayCacheKey, Tuple2<S2Filter, Object>> cache() {
        return cache;
    }

    public S2HBaseFilter apply(S2Filter filter, int offset) {
        byte[] filterBytes = S2Filter$.MODULE$.serializeToBytes(filter);
        byte[] serialized = (byte[])Array$.MODULE$.ofDim(filterBytes.length + 4, (ClassTag)ClassTag$.MODULE$.Byte());
        System.arraycopy(filterBytes, 0, serialized, 0, filterBytes.length);
        ByteArrays$.MODULE$.writeInt(offset, serialized, filterBytes.length);
        return new S2HBaseFilter(filter, offset, serialized);
    }

    public Filter parseFrom(byte[] pbBytes) throws DeserializationException {
        Tuple2 tuple2 = (Tuple2)this.cache().get((Object)new ByteArrayCacheKey(pbBytes));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        S2Filter filter = (S2Filter)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)filter, (Object)BoxesRunTime.boxToInteger((int)offset));
        S2Filter filter2 = (S2Filter)tuple22._1();
        int offset2 = tuple22._2$mcI$sp();
        return new S2HBaseFilter(filter2, offset2, pbBytes);
    }

    private S2HBaseFilter$() {
    }
}

