/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.server.common;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Base64;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.locationtech.geomesa.hbase.proto.GeoMesaProto;
import org.locationtech.geomesa.hbase.rpc.coprocessor.GeoMesaCoprocessor$;
import org.locationtech.geomesa.hbase.server.common.CoprocessorScan;
import org.locationtech.geomesa.hbase.server.common.CoprocessorScan$;
import org.locationtech.geomesa.hbase.server.common.HBaseAggregator;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public abstract class CoprocessorScan$class {
    public static void execute(CoprocessorScan $this, RpcController controller, GeoMesaProto.GeoMesaCoprocessorRequest request, RpcCallback done) {
        GeoMesaProto.GeoMesaCoprocessorResponse.Builder results = GeoMesaProto.GeoMesaCoprocessorResponse.newBuilder();
        if (request.getVersion() != CoprocessorScan$.MODULE$.AllowableRequestVersion()) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isErrorEnabled()) {
                $this.logger().underlying().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got a coprocessor request with version ", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)request.getVersion())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"but can only handle ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)CoprocessorScan$.MODULE$.AllowableRequestVersion())}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            results.setVersion(CoprocessorScan$.MODULE$.AllowableRequestVersion());
            done.run((Object)results.build());
        } else {
            BoxedUnit boxedUnit;
            Object object;
            try {
                Map options = GeoMesaCoprocessor$.MODULE$.deserializeOptions(request.getOptions().toByteArray());
                Option timeout = options.get((Object)GeoMesaCoprocessor$.MODULE$.TimeoutOpt()).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(String x$1) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
                    }
                });
                boolean yieldPartialResults = options.get((Object)GeoMesaCoprocessor$.MODULE$.YieldOpt()).exists((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$2) {
                        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
                    }
                });
                if (!controller.isCanceled() && timeout.forall((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(long x$3) {
                        return this.apply$mcZJ$sp(x$3);
                    }

                    public boolean apply$mcZJ$sp(long x$3) {
                        return x$3 > System.currentTimeMillis();
                    }
                })) {
                    BoxedUnit boxedUnit2;
                    String clas = (String)options.apply((Object)GeoMesaCoprocessor$.MODULE$.AggregatorClass());
                    HBaseAggregator aggregator = (HBaseAggregator)Class.forName(clas).newInstance();
                    if ($this.logger().underlying().isDebugEnabled()) {
                        $this.logger().underlying().debug("Initializing aggregator {}.", new Object[]{aggregator});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    aggregator.init(options);
                    byte[] bytes = Base64.getDecoder().decode((String)options.apply((Object)GeoMesaCoprocessor$.MODULE$.ScanOpt()));
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)ClientProtos.Scan.parseFrom((byte[])bytes));
                    object = package.WithClose$.MODULE$.apply((Object)$this.getScanner(scan), (Function1)new Serializable($this, results, timeout, yieldPartialResults, aggregator, controller){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ CoprocessorScan $outer;
                        private final GeoMesaProto.GeoMesaCoprocessorResponse.Builder results$1;
                        private final Option timeout$1;
                        private final boolean yieldPartialResults$1;
                        private final HBaseAggregator aggregator$1;
                        private final RpcController controller$1;

                        public final CoprocessorScan.CoprocessorAggregateCallback apply(RegionScanner scanner) {
                            this.aggregator$1.setScanner(scanner);
                            return (CoprocessorScan.CoprocessorAggregateCallback)this.aggregator$1.aggregate(new CoprocessorScan.CoprocessorAggregateCallback(this.$outer, this.controller$1, this.aggregator$1, this.results$1, this.yieldPartialResults$1, (Option<Object>)this.timeout$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.results$1 = results$1;
                            this.timeout$1 = timeout$1;
                            this.yieldPartialResults$1 = yieldPartialResults$1;
                            this.aggregator$1 = aggregator$1;
                            this.controller$1 = controller$1;
                        }
                    }, IsCloseable$.MODULE$.closeableIsCloseable());
                } else {
                    object = BoxedUnit.UNIT;
                }
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit3;
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof InterruptedException ? true : throwable2 instanceof InterruptedIOException;
                if (bl) {
                    boxedUnit3 = BoxedUnit.UNIT;
                } else if (throwable2 instanceof IOException) {
                    IOException iOException = (IOException)throwable2;
                    ResponseConverter.setControllerException((RpcController)controller, (IOException)iOException);
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    ResponseConverter.setControllerException((RpcController)controller, (IOException)new IOException(e));
                    boxedUnit3 = BoxedUnit.UNIT;
                }
                object = boxedUnit3;
            }
            if ($this.logger().underlying().isDebugEnabled()) {
                $this.logger().underlying().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Results total size: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(results.getPayloadList()).asScala()).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(ByteString x$4) {
                        return x$4.size();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\n\\tBatch sizes: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(results.getPayloadList()).asScala()).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(ByteString x$5) {
                        return x$5.size();
                    }
                }, Buffer$.MODULE$.canBuildFrom())).mkString(", ")}))).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            done.run((Object)results.build());
        }
    }

    public static void $init$(CoprocessorScan $this) {
    }
}

