/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.server.common;

import com.google.protobuf.ByteString;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.typesafe.scalalogging.StrictLogging;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.util.Base64;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.shaded.protobuf.ResponseConverter;
import org.locationtech.geomesa.hbase.proto.GeoMesaProto;
import org.locationtech.geomesa.hbase.rpc.coprocessor.GeoMesaCoprocessor$;
import org.locationtech.geomesa.hbase.server.common.CoprocessorScan$;
import org.locationtech.geomesa.hbase.server.common.HBaseAggregator;
import org.locationtech.geomesa.index.iterators.AggregatingScan;
import org.locationtech.geomesa.utils.index.ByteArrays$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dga\u0002\f\u0018!\u0003\r\t\u0001\n\u0005\u0006k\u0001!\tA\u000e\u0005\u0006u\u00011\tb\u000f\u0005\u0006\u001f\u0002!\t\u0002\u0015\u0004\u0005_\u0002!\u0001\u000f\u0003\u0005S\t\t\u0005\t\u0015!\u0003T\u0011)\t\u0019\u0002\u0002B\u0001B\u0003%\u0011Q\u0003\u0005\u000b\u0003C\"!\u0011!Q\u0001\n\u0005\r\u0004BCA<\t\t\u0005\t\u0015!\u0003\u0002z!Q\u0011q\u0010\u0003\u0003\u0002\u0003\u0006I!!!\t\u000f\u00055B\u0001\"\u0001\u0002\u000e\"I\u0011Q\u0014\u0003C\u0002\u0013%\u0011q\u0014\u0005\t\u0003C#\u0001\u0015!\u0003\u0002\b\"9\u00111\u0015\u0003\u0005B\u0005\u0015\u0006bBA\\\t\u0011\u0005\u0013\u0011\u0018\u0005\b\u0003\u0007$A\u0011BAc\u000f\u001d\t)c\u0006E\u0001\u0003O1aAF\f\t\u0002\u0005-\u0002bBA\u0017#\u0011\u0005\u0011qF\u0003\u0007\u0003c\t\u0002!a\r\t\u0013\u0005U\u0013C1A\u0005\u0002\u0005]\u0003\u0002CA0#\u0001\u0006I!!\u0017\u0003\u001f\r{\u0007O]8dKN\u001cxN]*dC:T!\u0001G\r\u0002\r\r|W.\\8o\u0015\tQ2$\u0001\u0004tKJ4XM\u001d\u0006\u00039u\tQ\u0001\u001b2bg\u0016T!AH\u0010\u0002\u000f\u001d,w.\\3tC*\u0011\u0001%I\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002E\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g!\ta3'D\u0001.\u0015\tqs&\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u00021c\u0005AA/\u001f9fg\u00064WMC\u00013\u0003\r\u0019w.\\\u0005\u0003i5\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u00018!\t1\u0003(\u0003\u0002:O\t!QK\\5u\u0003)9W\r^*dC:tWM\u001d\u000b\u0003y\u001d\u0003\"!P#\u000e\u0003yR!a\u0010!\u0002\u0019I,w-[8og\u0016\u0014h/\u001a:\u000b\u0005q\t%B\u0001\"D\u0003\u0019A\u0017\rZ8pa*\u0011A)I\u0001\u0007CB\f7\r[3\n\u0005\u0019s$!\u0004*fO&|gnU2b]:,'\u000fC\u0003I\u0005\u0001\u0007\u0011*\u0001\u0003tG\u0006t\u0007C\u0001&N\u001b\u0005Y%B\u0001'A\u0003\u0019\u0019G.[3oi&\u0011aj\u0013\u0002\u0005'\u000e\fg.A\u0004fq\u0016\u001cW\u000f^3\u0015\t]\n6l\u001a\u0005\u0006%\u000e\u0001\raU\u0001\u000bG>tGO]8mY\u0016\u0014\bC\u0001+Z\u001b\u0005)&B\u0001,X\u0003!\u0001(o\u001c;pEV4'B\u0001-2\u0003\u00199wn\\4mK&\u0011!,\u0016\u0002\u000e%B\u001c7i\u001c8ue>dG.\u001a:\t\u000bq\u001b\u0001\u0019A/\u0002\u000fI,\u0017/^3tiB\u0011a\f\u001a\b\u0003?\nl\u0011\u0001\u0019\u0006\u0003Cn\tQ\u0001\u001d:pi>L!a\u00191\u0002\u0019\u001d+w.T3tCB\u0013x\u000e^8\n\u0005\u00154'!G$f_6+7/Y\"paJ|7-Z:t_J\u0014V-];fgRT!a\u00191\t\u000b!\u001c\u0001\u0019A5\u0002\t\u0011|g.\u001a\t\u0004)*d\u0017BA6V\u0005-\u0011\u0006oY\"bY2\u0014\u0017mY6\u0011\u0005yk\u0017B\u00018g\u0005i9Um\\'fg\u0006\u001cu\u000e\u001d:pG\u0016\u001c8o\u001c:SKN\u0004xN\\:f\u0005q\u0019u\u000e\u001d:pG\u0016\u001c8o\u001c:BO\u001e\u0014XmZ1uK\u000e\u000bG\u000e\u001c2bG.\u001c2\u0001B\u0013r!\r\u0011\u0018Q\u0002\b\u0004g\u0006\u001dab\u0001;\u0002\u00029\u0011QO \b\u0003mvt!a\u001e?\u000f\u0005a\\X\"A=\u000b\u0005i\u001c\u0013A\u0002\u001fs_>$h(C\u0001#\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0011q0H\u0001\u0006S:$W\r_\u0005\u0005\u0003\u0007\t)!A\u0005ji\u0016\u0014\u0018\r^8sg*\u0011q0H\u0005\u0005\u0003\u0013\tY!A\bBO\u001e\u0014XmZ1uS:<7kY1o\u0015\u0011\t\u0019!!\u0002\n\t\u0005=\u0011\u0011\u0003\u0002\u0012\u0003\u001e<'/Z4bi\u0016\u001c\u0015\r\u001c7cC\u000e\\'\u0002BA\u0005\u0003\u0017\t!\"Y4he\u0016<\u0017\r^8s!\r\t9b\u0005\b\u0004\u00033\u0001b\u0002BA\u000e\u0003GqA!!\b\u0002\"9\u0019Q/a\b\n\u0005qi\u0012B\u0001\u000e\u001c\u0013\tA\u0012$A\bD_B\u0014xnY3tg>\u00148kY1o!\r\tI#E\u0007\u0002/M\u0011\u0011#J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u001d\"AC!hOJ,w-\u0019;peB\"\u0011QGA !\u0019\tI#a\u000e\u0002<%\u0019\u0011\u0011H\f\u0003\u001f!\u0013\u0015m]3BO\u001e\u0014XmZ1u_J\u0004B!!\u0010\u0002@1\u0001AaCA!'\u0005\u0005\t\u0011!B\u0001\u0003\u0007\u00121a\u0018\u00132#\u0011\t)%a\u0013\u0011\u0007\u0019\n9%C\u0002\u0002J\u001d\u0012qAT8uQ&tw\r\u0005\u0003\u0002N\u0005Ec\u0002BA(\u0003\u000fi!!a\u0003\n\t\u0005M\u0013\u0011\u0003\u0002\u0007%\u0016\u001cX\u000f\u001c;\u0002/\u0005cGn\\<bE2,'+Z9vKN$h+\u001a:tS>tWCAA-!\r1\u00131L\u0005\u0004\u0003;:#aA%oi\u0006A\u0012\t\u001c7po\u0006\u0014G.\u001a*fcV,7\u000f\u001e,feNLwN\u001c\u0011\u0002\u000fI,7/\u001e7ugB!\u0011QMA9\u001d\u0011\t9'!\u001c\u000f\u0007\u0005%$M\u0004\u0003\u0002\u001e\u0005-\u0014BA1\u001c\u0013\r\tyGZ\u0001\u001b\u000f\u0016|W*Z:b\u0007>\u0004(o\\2fgN|'OU3ta>t7/Z\u0005\u0005\u0003g\n)HA\u0004Ck&dG-\u001a:\u000b\u0007\u0005=d-A\nzS\u0016dG\rU1si&\fGNU3tk2$8\u000fE\u0002'\u0003wJ1!! (\u0005\u001d\u0011un\u001c7fC:\fq\u0001^5nK>,H\u000fE\u0003'\u0003\u0007\u000b9)C\u0002\u0002\u0006\u001e\u0012aa\u00149uS>t\u0007c\u0001\u0014\u0002\n&\u0019\u00111R\u0014\u0003\t1{gn\u001a\u000b\r\u0003\u001f\u000b\u0019*!&\u0002\u0018\u0006e\u00151\u0014\t\u0004\u0003##Q\"\u0001\u0001\t\u000bIS\u0001\u0019A*\t\u000f\u0005M!\u00021\u0001\u0002\u0016!9\u0011\u0011\r\u0006A\u0002\u0005\r\u0004bBA<\u0015\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003\u007fR\u0001\u0019AAA\u0003\u0015\u0019H/\u0019:u+\t\t9)\u0001\u0004ti\u0006\u0014H\u000fI\u0001\u0006E\u0006$8\r\u001b\u000b\u0005\u0003s\n9\u000bC\u0004\u0002*6\u0001\r!a+\u0002\u000b\tLH/Z:\u0011\u000b\u0019\ni+!-\n\u0007\u0005=vEA\u0003BeJ\f\u0017\u0010E\u0002'\u0003gK1!!.(\u0005\u0011\u0011\u0015\u0010^3\u0002\u000fA\f'\u000f^5bYR!\u0011\u0011PA^\u0011!\tIK\u0004CA\u0002\u0005u\u0006#\u0002\u0014\u0002@\u0006-\u0016bAAaO\tAAHY=oC6,g(\u0001\u0005d_:$\u0018N\\;f)\t\tI\b")
public interface CoprocessorScan
extends StrictLogging {
    public static int AllowableRequestVersion() {
        return CoprocessorScan$.MODULE$.AllowableRequestVersion();
    }

    public RegionScanner getScanner(Scan var1);

    public static /* synthetic */ void execute$(CoprocessorScan $this, RpcController controller, GeoMesaProto.GeoMesaCoprocessorRequest request, RpcCallback done) {
        $this.execute(controller, request, (RpcCallback<GeoMesaProto.GeoMesaCoprocessorResponse>)done);
    }

    default public void execute(RpcController controller, GeoMesaProto.GeoMesaCoprocessorRequest request, RpcCallback<GeoMesaProto.GeoMesaCoprocessorResponse> done) {
        GeoMesaProto.GeoMesaCoprocessorResponse.Builder results = GeoMesaProto.GeoMesaCoprocessorResponse.newBuilder();
        if (request.getVersion() != CoprocessorScan$.MODULE$.AllowableRequestVersion()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(new StringBuilder(62).append("Got a coprocessor request with version ").append(request.getVersion()).append(", ").append("but can only handle ").append(CoprocessorScan$.MODULE$.AllowableRequestVersion()).append(".").toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            results.setVersion(CoprocessorScan$.MODULE$.AllowableRequestVersion());
            done.run((Object)results.build());
        } else {
            BoxedUnit boxedUnit;
            Object object;
            try {
                Map options = GeoMesaCoprocessor$.MODULE$.deserializeOptions(request.getOptions().toByteArray());
                Option timeout = options.get((Object)GeoMesaCoprocessor$.MODULE$.TimeoutOpt()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)CoprocessorScan.$anonfun$execute$1(x$1)));
                boolean yieldPartialResults = options.get((Object)GeoMesaCoprocessor$.MODULE$.YieldOpt()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CoprocessorScan.$anonfun$execute$2(x$2)));
                if (!controller.isCanceled() && timeout.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> x$3 > System.currentTimeMillis())) {
                    BoxedUnit boxedUnit2;
                    String clas = (String)options.apply((Object)GeoMesaCoprocessor$.MODULE$.AggregatorClass());
                    HBaseAggregator aggregator = (HBaseAggregator)Class.forName(clas).newInstance();
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Initializing aggregator {}.", new Object[]{aggregator});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    aggregator.init(options);
                    byte[] bytes = Base64.getDecoder().decode((String)options.apply((Object)GeoMesaCoprocessor$.MODULE$.ScanOpt()));
                    Scan scan = ProtobufUtil.toScan((ClientProtos.Scan)ClientProtos.Scan.parseFrom((byte[])bytes));
                    object = package.WithClose$.MODULE$.apply((Object)this.getScanner(scan), (Function1 & Serializable & scala.Serializable)scanner -> {
                        aggregator.setScanner((RegionScanner)scanner);
                        return (CoprocessorAggregateCallback)aggregator.aggregate(new CoprocessorAggregateCallback(this, controller, aggregator, results, yieldPartialResults, (Option<Object>)timeout));
                    }, IsCloseable$.MODULE$.closeableIsCloseable());
                } else {
                    object = BoxedUnit.UNIT;
                }
            }
            catch (Throwable throwable) {
                BoxedUnit boxedUnit3;
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof InterruptedException ? true : throwable2 instanceof InterruptedIOException;
                if (bl) {
                    boxedUnit3 = BoxedUnit.UNIT;
                } else if (throwable2 instanceof IOException) {
                    IOException iOException = (IOException)throwable2;
                    ResponseConverter.setControllerException((RpcController)controller, (IOException)iOException);
                    boxedUnit3 = BoxedUnit.UNIT;
                } else {
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        ResponseConverter.setControllerException((RpcController)controller, (IOException)new IOException(e));
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        throw throwable;
                    }
                }
                object = boxedUnit3;
            }
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug(new StringBuilder(35).append("Results total size: ").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(results.getPayloadList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)).append("\n\tBatch sizes: ").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(results.getPayloadList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.size()), Buffer$.MODULE$.canBuildFrom())).mkString(", ")).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            done.run((Object)results.build());
        }
    }

    public static /* synthetic */ long $anonfun$execute$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toLong();
    }

    public static /* synthetic */ boolean $anonfun$execute$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
    }

    public static void $init$(CoprocessorScan $this) {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class CoprocessorAggregateCallback
    implements AggregatingScan.AggregateCallback {
        private final RpcController controller;
        private final HBaseAggregator<? extends AggregatingScan.Result> aggregator;
        private final GeoMesaProto.GeoMesaCoprocessorResponse.Builder results;
        private final boolean yieldPartialResults;
        private final Option<Object> timeout;
        private final long start;
        public final /* synthetic */ CoprocessorScan $outer;

        private long start() {
            return this.start;
        }

        public boolean batch(byte[] bytes) {
            this.results.addPayload(ByteString.copyFrom((byte[])bytes));
            return this.continue();
        }

        public boolean partial(Function0<byte[]> bytes) {
            boolean bl;
            if (this.continue()) {
                bl = true;
            } else {
                this.results.addPayload(ByteString.copyFrom((byte[])((byte[])bytes.apply())));
                bl = false;
            }
            return bl;
        }

        private boolean continue() {
            boolean bl;
            if (this.controller.isCanceled()) {
                BoxedUnit boxedUnit;
                if (this.org$locationtech$geomesa$hbase$server$common$CoprocessorScan$CoprocessorAggregateCallback$$$outer().logger().underlying().isWarnEnabled()) {
                    this.org$locationtech$geomesa$hbase$server$common$CoprocessorScan$CoprocessorAggregateCallback$$$outer().logger().underlying().warn("Stopping aggregator {} due to controller being cancelled", new Object[]{this.aggregator});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = false;
            } else if (this.timeout.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$6 -> x$6 < System.currentTimeMillis())) {
                BoxedUnit boxedUnit;
                if (this.org$locationtech$geomesa$hbase$server$common$CoprocessorScan$CoprocessorAggregateCallback$$$outer().logger().underlying().isWarnEnabled()) {
                    this.org$locationtech$geomesa$hbase$server$common$CoprocessorScan$CoprocessorAggregateCallback$$$outer().logger().underlying().warn("Stopping aggregator {} due to timeout of {}ms", new Object[]{this.aggregator, this.timeout.get()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = false;
            } else if (this.yieldPartialResults) {
                BoxedUnit boxedUnit;
                byte[] lastScanned = this.aggregator.getLastScanned();
                if (this.org$locationtech$geomesa$hbase$server$common$CoprocessorScan$CoprocessorAggregateCallback$$$outer().logger().underlying().isTraceEnabled()) {
                    this.org$locationtech$geomesa$hbase$server$common$CoprocessorScan$CoprocessorAggregateCallback$$$outer().logger().underlying().trace(new StringBuilder(63).append("Stopping aggregator ").append(this.aggregator).append(" at row ").append(ByteArrays$.MODULE$.printable(lastScanned)).append(" and ").append("returning intermediate results").toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Object object = lastScanned != null && !new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(lastScanned)).isEmpty() ? this.results.setLastScanned(ByteString.copyFrom((byte[])lastScanned)) : BoxedUnit.UNIT;
                bl = false;
            } else {
                BoxedUnit boxedUnit;
                if (this.org$locationtech$geomesa$hbase$server$common$CoprocessorScan$CoprocessorAggregateCallback$$$outer().logger().underlying().isTraceEnabled()) {
                    this.org$locationtech$geomesa$hbase$server$common$CoprocessorScan$CoprocessorAggregateCallback$$$outer().logger().underlying().trace(new StringBuilder(54).append("Running next batch on aggregator ").append(this.aggregator).append(" ").append("with elapsed time ").append(System.currentTimeMillis() - this.start()).append("ms").append(this.timeout.map((Function1 & Serializable & scala.Serializable)t -> CoprocessorAggregateCallback.$anonfun$continue$2(BoxesRunTime.unboxToLong((Object)t))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = true;
            }
            return bl;
        }

        public /* synthetic */ CoprocessorScan org$locationtech$geomesa$hbase$server$common$CoprocessorScan$CoprocessorAggregateCallback$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ String $anonfun$new$1(long t) {
            return new StringBuilder(26).append(" with remaining timeout ").append(t - System.currentTimeMillis()).append("ms").toString();
        }

        public static final /* synthetic */ String $anonfun$continue$2(long t) {
            return new StringBuilder(25).append(" and remaining timeout ").append(t - System.currentTimeMillis()).append("ms").toString();
        }

        public CoprocessorAggregateCallback(CoprocessorScan $outer, RpcController controller, HBaseAggregator<? extends AggregatingScan.Result> aggregator, GeoMesaProto.GeoMesaCoprocessorResponse.Builder results, boolean yieldPartialResults, Option<Object> timeout) {
            BoxedUnit boxedUnit;
            this.controller = controller;
            this.aggregator = aggregator;
            this.results = results;
            this.yieldPartialResults = yieldPartialResults;
            this.timeout = timeout;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.start = System.currentTimeMillis();
            if ($outer.logger().underlying().isTraceEnabled()) {
                $outer.logger().underlying().trace(new StringBuilder(34).append("Running first batch on aggregator ").append(aggregator).append(timeout.map((Function1 & Serializable & scala.Serializable)t -> CoprocessorAggregateCallback.$anonfun$new$1(BoxesRunTime.unboxToLong((Object)t))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }
}

