/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.spark.hbase;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.data.HBaseDataStoreFactory$;
import org.locationtech.geomesa.hbase.data.HBaseQueryPlan;
import org.locationtech.geomesa.hbase.jobs.GeoMesaHBaseInputFormat;
import org.locationtech.geomesa.hbase.jobs.GeoMesaHBaseInputFormat$;
import org.locationtech.geomesa.hbase.jobs.HBaseJobUtils$;
import org.locationtech.geomesa.index.conf.QueryHints$;
import org.locationtech.geomesa.spark.DataStoreConnector$;
import org.locationtech.geomesa.spark.SpatialRDD;
import org.locationtech.geomesa.spark.SpatialRDD$;
import org.locationtech.geomesa.spark.SpatialRDDProvider;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001\u0002\u0004\b\u0001IAQ!\b\u0001\u0005\u0002yAQ!\t\u0001\u0005B\tBQA\u0013\u0001\u0005\u0002-CQa\u001c\u0001\u0005\u0002ADq!!\u0005\u0001\t\u0003\t\u0019BA\fI\u0005\u0006\u001cXm\u00159bi&\fGN\u0015#E!J|g/\u001b3fe*\u0011\u0001\"C\u0001\u0006Q\n\f7/\u001a\u0006\u0003\u0015-\tQa\u001d9be.T!\u0001D\u0007\u0002\u000f\u001d,w.\\3tC*\u0011abD\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQ2$D\u0001\n\u0013\ta\u0012B\u0001\nTa\u0006$\u0018.\u00197S\t\u0012\u0003&o\u001c<jI\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\b\u0003)\u0019\u0017M\u001c)s_\u000e,7o\u001d\u000b\u0003G\u0019\u0002\"\u0001\u0006\u0013\n\u0005\u0015*\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006O\t\u0001\r\u0001K\u0001\u0007a\u0006\u0014\u0018-\\:1\u0005%r\u0004\u0003\u0002\u00160cqj\u0011a\u000b\u0006\u0003Y5\nA!\u001e;jY*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\ri\u0015\r\u001d\t\u0003eer!aM\u001c\u0011\u0005Q*R\"A\u001b\u000b\u0005Y\n\u0012A\u0002\u001fs_>$h(\u0003\u00029+\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\rM#(/\u001b8h\u0015\tAT\u0003\u0005\u0002>}1\u0001A!C '\u0003\u0003\u0005\tQ!\u0001A\u0005\ryF%M\t\u0003\u0003\u0012\u0003\"\u0001\u0006\"\n\u0005\r+\"a\u0002(pi\"Lgn\u001a\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f6\n!![8\n\u0005%3%\u0001D*fe&\fG.\u001b>bE2,\u0017a\u0001:eIR)Aj\u0014.bKB\u0011!$T\u0005\u0003\u001d&\u0011!b\u00159bi&\fGN\u0015#E\u0011\u0015\u00016\u00011\u0001R\u0003\u0011\u0019wN\u001c4\u0011\u0005ICV\"A*\u000b\u0005A#&BA+W\u0003\u0019A\u0017\rZ8pa*\u0011qkD\u0001\u0007CB\f7\r[3\n\u0005e\u001b&!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003\\\u0007\u0001\u0007A,\u0001\u0002tGB\u0011QlX\u0007\u0002=*\u0011!BV\u0005\u0003Az\u0013Ab\u00159be.\u001cuN\u001c;fqRDQAY\u0002A\u0002\r\f\u0001\u0002Z:QCJ\fWn\u001d\t\u0005e\u0011\f\u0014'\u0003\u00021w!)am\u0001a\u0001O\u0006IqN]5h#V,'/\u001f\t\u0003Q6l\u0011!\u001b\u0006\u0003U.\fA\u0001Z1uC*\u0011AnD\u0001\tO\u0016|Go\\8mg&\u0011a.\u001b\u0002\u0006#V,'/_\u0001\u0005g\u00064X\r\u0006\u0004ri\u0006%\u0011Q\u0002\t\u0003)IL!a]\u000b\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0015\u0012\u0001\r!\u001e\t\u0004mbTX\"A<\u000b\u0005)s\u0016BA=x\u0005\r\u0011F\t\u0012\t\u0004w\u0006\u0015Q\"\u0001?\u000b\u0005ut\u0018AB:j[BdWMC\u0002\u0000\u0003\u0003\tqAZ3biV\u0014XMC\u0002\u0002\u0004=\tqa\u001c9f]\u001eL7/C\u0002\u0002\bq\u0014QbU5na2,g)Z1ukJ,\u0007BBA\u0006\t\u0001\u00071-\u0001\u000bxe&$X\rR1uCN#xN]3QCJ\fWn\u001d\u0005\u0007\u0003\u001f!\u0001\u0019A\u0019\u0002\u001b]\u0014\u0018\u000e^3UsB,g*Y7f\u0003))hn]1gKN\u000bg/\u001a\u000b\bc\u0006U\u0011qCA\r\u0011\u0015QU\u00011\u0001v\u0011\u0019\tY!\u0002a\u0001G\"1\u0011qB\u0003A\u0002E\u0002")
public class HBaseSpatialRDDProvider
implements SpatialRDDProvider {
    public Option<SimpleFeatureType> sft(scala.collection.immutable.Map<String, String> params, String typeName) {
        return SpatialRDDProvider.sft$((SpatialRDDProvider)this, params, (String)typeName);
    }

    public boolean canProcess(Map<String, ? extends Serializable> params) {
        return HBaseDataStoreFactory$.MODULE$.canProcess(params);
    }

    public SpatialRDD rdd(Configuration conf, SparkContext sc, scala.collection.immutable.Map<String, String> dsParams, Query origQuery) {
        SpatialRDD spatialRDD;
        LazyRef sft$lzy = new LazyRef();
        LazyRef qps$lzy = new LazyRef();
        LazyRef rddSft$lzy = new LazyRef();
        HBaseDataStore ds = (HBaseDataStore)DataStoreConnector$.MODULE$.apply(dsParams);
        if (User.isSecurityEnabled()) {
            Token token = TokenUtil.obtainToken((Connection)ds.connection(), (User)User.getCurrent());
            UserGroupInformation.getCurrentUser().getCredentials().addToken(token.getService(), token);
        }
        if (ds == null || HBaseSpatialRDDProvider.sft$1(sft$lzy, ds, origQuery) == null || HBaseSpatialRDDProvider.qps$1(qps$lzy, origQuery, ds).isEmpty()) {
            spatialRDD = SpatialRDD$.MODULE$.apply(sc.emptyRDD(ClassTag$.MODULE$.apply(SimpleFeature.class)), HBaseSpatialRDDProvider.rddSft$1(rddSft$lzy, origQuery, sft$lzy, ds));
        } else {
            RDD head;
            Seq seq = (Seq)HBaseSpatialRDDProvider.qps$1(qps$lzy, origQuery, ds).map((Function1 & Serializable & scala.Serializable)qp -> HBaseSpatialRDDProvider.queryPlanToRdd$1(qp, conf, sc), Seq$.MODULE$.canBuildFrom());
            Some some = Seq$.MODULE$.unapplySeq(seq);
            RDD rDD = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0 ? (head = (RDD)((SeqLike)some.get()).apply(0)) : sc.union(seq, ClassTag$.MODULE$.apply(SimpleFeature.class));
            RDD rdd = rDD;
            spatialRDD = SpatialRDD$.MODULE$.apply(rdd, HBaseSpatialRDDProvider.rddSft$1(rddSft$lzy, origQuery, sft$lzy, ds));
        }
        return spatialRDD;
    }

    public void save(RDD<SimpleFeature> rdd, scala.collection.immutable.Map<String, String> writeDataStoreParams, String writeTypeName) {
        HBaseDataStore ds = (HBaseDataStore)DataStoreConnector$.MODULE$.apply(writeDataStoreParams);
        Predef$.MODULE$.require(ds.getSchema(writeTypeName) != null, (Function0 & Serializable & scala.Serializable)() -> "Feature type must exist before calling save.  Call createSchema on the DataStore first.");
        this.unsafeSave(rdd, writeDataStoreParams, writeTypeName);
    }

    public void unsafeSave(RDD<SimpleFeature> rdd, scala.collection.immutable.Map<String, String> writeDataStoreParams, String writeTypeName) {
        rdd.foreachPartition((Function1 & Serializable & scala.Serializable)iter -> {
            HBaseSpatialRDDProvider.$anonfun$unsafeSave$1(writeDataStoreParams, writeTypeName, iter);
            return BoxedUnit.UNIT;
        });
    }

    private static final /* synthetic */ SimpleFeatureType sft$lzycompute$1(LazyRef sft$lzy$1, HBaseDataStore ds$1, Query origQuery$1) {
        SimpleFeatureType simpleFeatureType;
        LazyRef lazyRef = sft$lzy$1;
        synchronized (lazyRef) {
            simpleFeatureType = sft$lzy$1.initialized() ? (SimpleFeatureType)sft$lzy$1.value() : (SimpleFeatureType)sft$lzy$1.initialize((Object)ds$1.getSchema(origQuery$1.getTypeName()));
        }
        return simpleFeatureType;
    }

    private static final SimpleFeatureType sft$1(LazyRef sft$lzy$1, HBaseDataStore ds$1, Query origQuery$1) {
        return sft$lzy$1.initialized() ? (SimpleFeatureType)sft$lzy$1.value() : HBaseSpatialRDDProvider.sft$lzycompute$1(sft$lzy$1, ds$1, origQuery$1);
    }

    private static final /* synthetic */ Seq qps$lzycompute$1(LazyRef qps$lzy$1, Query origQuery$1, HBaseDataStore ds$1) {
        Seq seq;
        LazyRef lazyRef = qps$lzy$1;
        synchronized (lazyRef) {
            Seq seq2;
            if (qps$lzy$1.initialized()) {
                seq2 = (Seq)qps$lzy$1.value();
            } else {
                origQuery$1.getHints().put((Object)QueryHints$.MODULE$.LOOSE_BBOX(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                seq2 = (Seq)qps$lzy$1.initialize((Object)HBaseJobUtils$.MODULE$.getMultiScanPlans(ds$1, origQuery$1));
            }
            seq = seq2;
        }
        return seq;
    }

    private static final Seq qps$1(LazyRef qps$lzy$1, Query origQuery$1, HBaseDataStore ds$1) {
        return qps$lzy$1.initialized() ? (Seq)qps$lzy$1.value() : HBaseSpatialRDDProvider.qps$lzycompute$1(qps$lzy$1, origQuery$1, ds$1);
    }

    private static final /* synthetic */ SimpleFeatureType rddSft$lzycompute$1(LazyRef rddSft$lzy$1, Query origQuery$1, LazyRef sft$lzy$1, HBaseDataStore ds$1) {
        SimpleFeatureType simpleFeatureType;
        LazyRef lazyRef = rddSft$lzy$1;
        synchronized (lazyRef) {
            simpleFeatureType = rddSft$lzy$1.initialized() ? (SimpleFeatureType)rddSft$lzy$1.value() : (SimpleFeatureType)rddSft$lzy$1.initialize(QueryHints$.MODULE$.RichHints(origQuery$1.getHints()).getTransformSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> HBaseSpatialRDDProvider.sft$1(sft$lzy$1, ds$1, origQuery$1)));
        }
        return simpleFeatureType;
    }

    private static final SimpleFeatureType rddSft$1(LazyRef rddSft$lzy$1, Query origQuery$1, LazyRef sft$lzy$1, HBaseDataStore ds$1) {
        return rddSft$lzy$1.initialized() ? (SimpleFeatureType)rddSft$lzy$1.value() : HBaseSpatialRDDProvider.rddSft$lzycompute$1(rddSft$lzy$1, origQuery$1, sft$lzy$1, ds$1);
    }

    private static final RDD queryPlanToRdd$1(HBaseQueryPlan.ScanPlan qp, Configuration conf$1, SparkContext sc$1) {
        Configuration config = new Configuration(conf$1);
        GeoMesaHBaseInputFormat$.MODULE$.configure(config, qp);
        return sc$1.newAPIHadoopRDD(config, GeoMesaHBaseInputFormat.class, Text.class, SimpleFeature.class).map((Function1 & Serializable & scala.Serializable)x$1 -> (SimpleFeature)x$1._2(), ClassTag$.MODULE$.apply(SimpleFeature.class));
    }

    public static final /* synthetic */ void $anonfun$unsafeSave$1(scala.collection.immutable.Map writeDataStoreParams$1, String writeTypeName$1, Iterator iter) {
        HBaseDataStore ds = (HBaseDataStore)DataStoreConnector$.MODULE$.apply(writeDataStoreParams$1);
        package.WithClose$.MODULE$.apply((Object)ds.getFeatureWriterAppend(writeTypeName$1, Transaction.AUTO_COMMIT), (Function1 & Serializable & scala.Serializable)writer -> {
            iter.foreach((Function1 & Serializable & scala.Serializable)x$2 -> FeatureUtils$.MODULE$.write((FeatureWriter)writer, x$2, true));
            return BoxedUnit.UNIT;
        }, IsCloseable$.MODULE$.closeableIsCloseable());
    }

    public HBaseSpatialRDDProvider() {
        SpatialRDDProvider.$init$((SpatialRDDProvider)this);
    }
}

