/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.config.Config;
import java.io.File;
import java.util.List;
import org.apache.hadoop.hbase.client.Connection;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$ToggleRemoteFilterParam$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$class;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InputFilesParam;
import org.locationtech.geomesa.tools.InputFormatParam;
import org.locationtech.geomesa.tools.OptionalConverterConfigParam;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.OptionalZookeepersParam;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.ingest.IngestParams;
import org.locationtech.geomesa.utils.classpath.ClassPathUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001=\u0011!\u0003\u0013\"bg\u0016LenZ3ti\u000e{W.\\1oI*\u00111\u0001B\u0001\u0007S:<Wm\u001d;\u000b\u0005\u00151\u0011!\u0002;p_2\u001c(BA\u0004\t\u0003\u0015A'-Y:f\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001bC\t\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007]QB$D\u0001\u0019\u0015\t\u0019\u0011D\u0003\u0002\u0006\u0011%\u00111\u0004\u0007\u0002\u000e\u0013:<Wm\u001d;D_6l\u0017M\u001c3\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}1\u0011\u0001\u00023bi\u0006L!!\t\u0010\u0003\u001d!\u0013\u0015m]3ECR\f7\u000b^8sKB\u00111\u0005J\u0007\u0002\t%\u0011Q\u0005\u0002\u0002\u0016\u0011\n\u000b7/\u001a#bi\u0006\u001cFo\u001c:f\u0007>lW.\u00198e\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t!\u0001C\u0004-\u0001\t\u0007I\u0011I\u0017\u0002\rA\f'/Y7t+\u0005q\u0003CA\u0018G\u001d\t\u0001tH\u0004\u00022}9\u0011!'\u0010\b\u0003gqr!\u0001N\u001e\u000f\u0005URdB\u0001\u001c:\u001b\u00059$B\u0001\u001d\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!q!\u0002!\u0003\u0011\u0003\t\u0015A\u0005%CCN,\u0017J\\4fgR\u001cu.\\7b]\u0012\u0004\"A\u000b\"\u0007\u000b\u0005\u0011\u0001\u0012A\"\u0014\u0005\t\u0003\u0002\"B\u0014C\t\u0003)E#A!\u0007\t\u001d\u0013\u0005\u0001\u0013\u0002\u0012\u0011\n\u000b7/Z%oO\u0016\u001cH\u000fU1sC6\u001c8#\u0002$\u0011\u00132\u001b\u0006CA\fK\u0013\tY\u0005D\u0001\u0007J]\u001e,7\u000f\u001e)be\u0006l7\u000f\u0005\u0002N!:\u0011\u0011GT\u0005\u0003\u001f\u0012\tQ\u0003\u0013\"bg\u0016$\u0015\r^1Ti>\u0014XmQ8n[\u0006tG-\u0003\u0002R%\nY\u0001JQ1tKB\u000b'/Y7t\u0015\tyE\u0001\u0005\u0002N)&\u0011QK\u0015\u0002\u0018)><w\r\\3SK6|G/\u001a$jYR,'\u000fU1sC6DQa\n$\u0005\u0002]#\u0012\u0001\u0017\t\u00033\u001ak\u0011A\u0011\u0015\u0005\rn+g\r\u0005\u0002]G6\tQL\u0003\u0002_?\u0006Q!nY8n[\u0006tG-\u001a:\u000b\u0005\u0001\f\u0017!\u00022fkN$(\"\u00012\u0002\u0007\r|W.\u0003\u0002e;\nQ\u0001+\u0019:b[\u0016$XM]:\u0002%\r|W.\\1oI\u0012+7o\u0019:jaRLwN\\\u0011\u0002O\u0006\u0001\u0014J\\4fgR|3m\u001c8wKJ$\bE^1sS>,8\u000f\t4jY\u0016\u0004cm\u001c:nCR\u001c\b%\u001b8u_\u0002:Um\\'fg\u0006Da!\u001b\u0001!\u0002\u0013q\u0013a\u00029be\u0006l7\u000f\t\u0005\bW\u0002\u0011\r\u0011\"\u0011m\u0003-a\u0017N\u00196beN4\u0015\u000e\\3\u0016\u00035\u0004\"A\\9\u000f\u0005Ey\u0017B\u00019\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A\u0014\u0002BB;\u0001A\u0003%Q.\u0001\u0007mS\nT\u0017M]:GS2,\u0007\u0005C\u0003x\u0001\u0011\u0005\u00030\u0001\u0007mS\nT\u0017M]:QCRD7/F\u0001z!\u0011Qx0!\u0002\u000f\u0005mlhB\u0001\u001c}\u0013\u0005\u0019\u0012B\u0001@\u0013\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0001\u0002\u0004\tA\u0011\n^3sCR|'O\u0003\u0002\u007f%A)\u0011#a\u0002\u0002\f%\u0019\u0011\u0011\u0002\n\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004#\u0002>\u0002\u000e\u0005E\u0011\u0002BA\b\u0003\u0007\u00111aU3r!\u0011\t\u0019\"!\b\u000e\u0005\u0005U!\u0002BA\f\u00033\t!![8\u000b\u0005\u0005m\u0011\u0001\u00026bm\u0006LA!a\b\u0002\u0016\t!a)\u001b7f\u0001")
public class HBaseIngestCommand
implements IngestCommand<HBaseDataStore>,
HBaseDataStoreCommand {
    private final HBaseIngestParams params;
    private final String libjarsFile;
    private final String name;

    @Override
    public Map<String, String> connection() {
        return HBaseDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        IngestCommand.class.execute((IngestCommand)this);
    }

    public Runnable createConverterIngest(SimpleFeatureType sft, Config converterConfig) {
        return IngestCommand.class.createConverterIngest((IngestCommand)this, (SimpleFeatureType)sft, (Config)converterConfig);
    }

    public Runnable createAutoIngest() {
        return IngestCommand.class.createAutoIngest((IngestCommand)this);
    }

    public Runnable createShpIngest() {
        return IngestCommand.class.createShpIngest((IngestCommand)this);
    }

    public void ensureSameFs(Seq<String> prefixes) {
        IngestCommand.class.ensureSameFs((IngestCommand)this, prefixes);
    }

    public <T> T withDataStore(Function1<HBaseDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    @Override
    public HBaseIngestParams params() {
        return this.params;
    }

    public String libjarsFile() {
        return this.libjarsFile;
    }

    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromEnvironment("GEOMESA_HBASE_HOME");
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromEnvironment("HBASE_HOME");
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromClasspath(HBaseDataStore.class);
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromClasspath(Connection.class);
            }
        }}));
    }

    public HBaseIngestCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        IngestCommand.class.$init$((IngestCommand)this);
        HBaseDataStoreCommand$class.$init$(this);
        this.params = new HBaseIngestParams();
        this.libjarsFile = "org/locationtech/geomesa/hbase/tools/ingest-libjars.list";
    }

    @Parameters(commandDescription="Ingest/convert various file formats into GeoMesa")
    public static class HBaseIngestParams
    implements IngestParams,
    HBaseDataStoreCommand.HBaseParams,
    HBaseDataStoreCommand.ToggleRemoteFilterParam {
        @Parameter(names={"--no-remote-filters"}, description="Disable remote filtering and coprocessors", arity=0)
        private boolean noRemote;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-t", "--threads"}, description="Number of threads if using local ingest")
        private Integer threads;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false, converter=DistributedRunParam.ModeConverter.class)
        private Enumeration.Value mode;
        @Parameter(names={"--input-format"}, description="File format of input files (shp, csv, tsv, avro, etc). Optional, autodetection will be attempted.")
        private String format;
        @Parameter(description="<file>...")
        private List<String> files;
        @Parameter(names={"-C", "--converter"}, description="GeoMesa converter specification as a config string, file name, or name of an available converter", required=false)
        private String config;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either")
        private String spec;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;

        @Override
        public boolean noRemote() {
            return this.noRemote;
        }

        @Override
        @TraitSetter
        public void noRemote_$eq(boolean x$1) {
            this.noRemote = x$1;
        }

        public String zookeepers() {
            return this.zookeepers;
        }

        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public Integer threads() {
            return this.threads;
        }

        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public Enumeration.Value mode() {
            return this.mode;
        }

        public void mode_$eq(Enumeration.Value x$1) {
            this.mode = x$1;
        }

        public String format() {
            return this.format;
        }

        public void format_$eq(String x$1) {
            this.format = x$1;
        }

        public Enumeration.Value fmt() {
            return InputFormatParam.class.fmt((InputFormatParam)this);
        }

        public List<String> files() {
            return this.files;
        }

        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        public String config() {
            return this.config;
        }

        public void config_$eq(String x$1) {
            this.config = x$1;
        }

        public String spec() {
            return this.spec;
        }

        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public HBaseIngestParams() {
            OptionalTypeNameParam.class.$init$((OptionalTypeNameParam)this);
            OptionalFeatureSpecParam.class.$init$((OptionalFeatureSpecParam)this);
            OptionalConverterConfigParam.class.$init$((OptionalConverterConfigParam)this);
            InputFilesParam.class.$init$((InputFilesParam)this);
            InputFormatParam.class.$init$((InputFormatParam)this);
            OptionalInputFormatParam.class.$init$((OptionalInputFormatParam)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            IngestParams.class.$init$((IngestParams)this);
            CatalogParam.class.$init$((CatalogParam)this);
            OptionalZookeepersParam.class.$init$((OptionalZookeepersParam)this);
            HBaseDataStoreCommand$ToggleRemoteFilterParam$class.$init$(this);
        }
    }
}

