/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.config.Config;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.jobs.HBaseIndexFileMapper$;
import org.locationtech.geomesa.hbase.tools.ingest.HBaseBulkIngestCommand$;
import org.locationtech.geomesa.hbase.tools.ingest.HBaseIngestCommand;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.IndexParam;
import org.locationtech.geomesa.tools.OutputPathParam;
import org.locationtech.geomesa.tools.RequiredIndexParam;
import org.locationtech.geomesa.tools.ingest.AbstractIngest;
import org.locationtech.geomesa.tools.ingest.ConverterIngest;
import org.locationtech.geomesa.tools.ingest.ConverterIngestJob;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0001\u0003\u0001=\u0011a\u0003\u0013\"bg\u0016\u0014U\u000f\\6J]\u001e,7\u000f^\"p[6\fg\u000e\u001a\u0006\u0003\u0007\u0011\ta!\u001b8hKN$(BA\u0003\u0007\u0003\u0015!xn\u001c7t\u0015\t9\u0001\"A\u0003iE\u0006\u001cXM\u0003\u0002\n\u0015\u00059q-Z8nKN\f'BA\u0006\r\u00031awnY1uS>tG/Z2i\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\t\"#D\u0001\u0003\u0013\t\u0019\"A\u0001\nI\u0005\u0006\u001cX-\u00138hKN$8i\\7nC:$\u0007\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\t\t\u0002\u0001C\u0004\u001a\u0001\t\u0007I\u0011\t\u000e\u0002\t9\fW.Z\u000b\u00027A\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005Y\u0006twMC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"AB*ue&tw\r\u0003\u0004%\u0001\u0001\u0006IaG\u0001\u0006]\u0006lW\r\t\u0005\bM\u0001\u0011\r\u0011\"\u0011(\u0003\u0019\u0001\u0018M]1ngV\t\u0001\u0006\u0005\u0002*\r:\u0011!&\u000f\b\u0003War!\u0001L\u001c\u000f\u000552dB\u0001\u00186\u001d\tyCG\u0004\u00021g5\t\u0011G\u0003\u00023\u001d\u00051AH]8pizJ\u0011!D\u0005\u0003\u00171I!!\u0003\u0006\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019AaB\u0003;\u0005!\u00051(\u0001\fI\u0005\u0006\u001cXMQ;mW&sw-Z:u\u0007>lW.\u00198e!\t\tBHB\u0003\u0002\u0005!\u0005Qh\u0005\u0002=}A\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n1\u0011I\\=SK\u001aDQ!\u0006\u001f\u0005\u0002\u0015#\u0012a\u000f\u0004\u0005\u000fr\u0002\u0001JA\u000bI\u0005\u0006\u001cXMQ;mW&sw-Z:u!\u0006\u0014\u0018-\\:\u0014\t\u0019K\u0005+\u0016\t\u0003\u00156s!AK&\n\u00051\u0013\u0011A\u0005%CCN,\u0017J\\4fgR\u001cu.\\7b]\u0012L!AT(\u0003#!\u0013\u0015m]3J]\u001e,7\u000f\u001e)be\u0006l7O\u0003\u0002M\u0005A\u0011\u0011kU\u0007\u0002%*\u0011Q\u0001C\u0005\u0003)J\u0013!CU3rk&\u0014X\rZ%oI\u0016D\b+\u0019:b[B\u0011\u0011KV\u0005\u0003/J\u0013qbT;uaV$\b+\u0019;i!\u0006\u0014\u0018-\u001c\u0005\u0006+\u0019#\t!\u0017\u000b\u00025B\u00111LR\u0007\u0002y!\"a)X4i!\tqV-D\u0001`\u0015\t\u0001\u0017-\u0001\u0006kG>lW.\u00198eKJT!AY2\u0002\u000b\t,Wo\u001d;\u000b\u0003\u0011\f1aY8n\u0013\t1wL\u0001\u0006QCJ\fW.\u001a;feN\f!cY8n[\u0006tG\rR3tGJL\u0007\u000f^5p]\u0006\n\u0011.\u0001'D_:4XM\u001d;!m\u0006\u0014\u0018n\\;tA\u0019LG.\u001a\u0011g_Jl\u0017\r^:!S:$x\u000e\t%CCN,\u0007\u0005\u0013$jY\u0016\u001c\be];ji\u0006\u0014G.\u001a\u0011g_J\u0004\u0013N\\2sK6,g\u000e^1mA1|\u0017\r\u001a\u0005\u0007W\u0002\u0001\u000b\u0011\u0002\u0015\u0002\u000fA\f'/Y7tA!)Q\u000e\u0001C)]\u0006)2M]3bi\u0016\u001cuN\u001c<feR,'/\u00138hKN$HcA8s}B\u0011A\u0004]\u0005\u0003cv\u0011\u0001BU;o]\u0006\u0014G.\u001a\u0005\u0006g2\u0004\r\u0001^\u0001\u0004g\u001a$\bCA;}\u001b\u00051(BA<y\u0003\u0019\u0019\u0018.\u001c9mK*\u0011\u0011P_\u0001\bM\u0016\fG/\u001e:f\u0015\tYH\"A\u0004pa\u0016tw-[:\n\u0005u4(!E*j[BdWMR3biV\u0014X\rV=qK\"1q\u0010\u001ca\u0001\u0003\u0003\tqbY8om\u0016\u0014H/\u001a:D_:4\u0017n\u001a\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\u0019\u0019wN\u001c4jO*\u0019\u00111B2\u0002\u0011QL\b/Z:bM\u0016LA!a\u0004\u0002\u0006\t11i\u001c8gS\u001eDq!a\u0005\u0001\t#\n)\"\u0001\tde\u0016\fG/Z!vi>LenZ3tiR\tq\u000eC\u0004\u0002\u001a\u0001!\t&!\u0006\u0002\u001f\r\u0014X-\u0019;f'\"\u0004\u0018J\\4fgR\u0004")
public class HBaseBulkIngestCommand
extends HBaseIngestCommand {
    private final String name;
    private final HBaseBulkIngestParams params = new HBaseBulkIngestParams();

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public HBaseBulkIngestParams params() {
        return this.params;
    }

    @Override
    public Runnable createConverterIngest(SimpleFeatureType sft, Config converterConfig) {
        return new ConverterIngest(this, sft, converterConfig){
            private final /* synthetic */ HBaseBulkIngestCommand $outer;
            public final SimpleFeatureType sft$1;
            public final Config converterConfig$1;

            public void run() {
                super.run();
                Command$.MODULE$.user().info(new StringBuilder().append((Object)"To load files, run:\n\tgeomesa-hbase bulk-load ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-c ", " -f ", " --index ", " --input ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.params().catalog(), this.sft$1.getTypeName(), this.$outer.params().index(), this.$outer.params().outputPath()}))).toString());
            }

            public Tuple2<Object, Object> runDistributedJob(AbstractIngest.StatusCallback statusCallback) {
                String index = this.$outer.params().loadRequiredIndex((GeoMesaDataStore<?, ?, ?>)((HBaseDataStore)this.ds()), IndexMode$.MODULE$.Write()).identifier();
                ConverterIngestJob job = new ConverterIngestJob(this, index){
                    private final /* synthetic */ $anon$1 $outer;
                    private final String index$1;

                    public void configureJob(Job job) {
                        super.configureJob(job);
                        HBaseIndexFileMapper$.MODULE$.configure(job, this.$outer.org$locationtech$geomesa$hbase$tools$ingest$HBaseBulkIngestCommand$$anon$$$outer().connection(), this.$outer.sft$1.getTypeName(), this.index$1, new Path(this.$outer.org$locationtech$geomesa$hbase$tools$ingest$HBaseBulkIngestCommand$$anon$$$outer().params().outputPath()));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.index$1 = index$1;
                        super($outer.dsParams(), $outer.sft$1, $outer.converterConfig$1, $outer.inputs(), $outer.org$locationtech$geomesa$hbase$tools$ingest$HBaseBulkIngestCommand$$anon$$$outer().libjarsFile(), $outer.org$locationtech$geomesa$hbase$tools$ingest$HBaseBulkIngestCommand$$anon$$$outer().libjarsPaths());
                    }
                };
                return job.run(statusCallback);
            }

            public void runLocal() {
                throw new NotImplementedError("Bulk ingest not implemented for local mode");
            }

            public /* synthetic */ HBaseBulkIngestCommand org$locationtech$geomesa$hbase$tools$ingest$HBaseBulkIngestCommand$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sft$1 = sft$1;
                this.converterConfig$1 = converterConfig$1;
                super(sft$1, $outer.connection(), converterConfig$1, (Seq)JavaConverters$.MODULE$.asScalaBufferConverter($outer.params().files()).asScala(), Option$.MODULE$.apply((Object)$outer.params().mode()), $outer.libjarsFile(), $outer.libjarsPaths(), Predef$.MODULE$.Integer2int($outer.params().threads()));
            }
        };
    }

    @Override
    public Runnable createAutoIngest() {
        throw new NotImplementedError("Bulk auto ingest not implemented");
    }

    @Override
    public Runnable createShpIngest() {
        throw new NotImplementedError("Bulk ShpFile ingest not implemented");
    }

    public HBaseBulkIngestCommand() {
        this.name = "bulk-ingest";
    }

    @Parameters(commandDescription="Convert various file formats into HBase HFiles suitable for incremental load")
    public static class HBaseBulkIngestParams
    extends HBaseIngestCommand.HBaseIngestParams
    implements RequiredIndexParam,
    OutputPathParam {
        @Parameter(names={"--output"}, description="Path to use for writing output", required=true)
        private String outputPath;
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=true)
        private String index;

        public String outputPath() {
            return this.outputPath;
        }

        public void outputPath_$eq(String x$1) {
            this.outputPath = x$1;
        }

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public GeoMesaFeatureIndex<?, ?, ?> loadRequiredIndex(GeoMesaDataStore<?, ?, ?> ds, IndexMode.IndexMode mode) throws ParameterException {
            return IndexParam.class.loadRequiredIndex((IndexParam)this, ds, (IndexMode.IndexMode)mode);
        }

        public Option<GeoMesaFeatureIndex<?, ?, ?>> loadIndex(GeoMesaDataStore<?, ?, ?> ds, IndexMode.IndexMode mode) throws ParameterException {
            return IndexParam.class.loadIndex((IndexParam)this, ds, (IndexMode.IndexMode)mode);
        }

        public HBaseBulkIngestParams() {
            IndexParam.class.$init$((IndexParam)this);
            RequiredIndexParam.class.$init$((RequiredIndexParam)this);
            OutputPathParam.class.$init$((OutputPathParam)this);
        }
    }
}

