/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.index.HBaseFeatureIndex;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$HBaseParams$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$RemoteFilterNotUsedParam$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$class;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.IndexParam;
import org.locationtech.geomesa.tools.OptionalZookeepersParam;
import org.locationtech.geomesa.tools.RequiredIndexParam;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001=\u0011A\u0003\u0013\"bg\u0016\u0014U\u000f\\6M_\u0006$7i\\7nC:$'BA\u0002\u0005\u0003\u0019IgnZ3ti*\u0011QAB\u0001\u0006i>|Gn\u001d\u0006\u0003\u000f!\tQ\u0001\u001b2bg\u0016T!!\u0003\u0006\u0002\u000f\u001d,w.\\3tC*\u00111\u0002D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9\u0002$D\u0001\u0005\u0013\tIBAA\u000bI\u0005\u0006\u001cX\rR1uCN#xN]3D_6l\u0017M\u001c3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%\t%I\u0001\u0005]\u0006lW-F\u0001#!\t\u0019cE\u0004\u0002\u0012I%\u0011QEE\u0001\u0007!J,G-\u001a4\n\u0005\u001dB#AB*ue&twM\u0003\u0002&%!1!\u0006\u0001Q\u0001\n\t\nQA\\1nK\u0002Bq\u0001\f\u0001C\u0002\u0013\u0005S&\u0001\u0004qCJ\fWn]\u000b\u0002]A\u0011qF\u0012\b\u0003a}r!!\r \u000f\u0005IjdBA\u001a=\u001d\t!4H\u0004\u00026u9\u0011a'O\u0007\u0002o)\u0011\u0001HD\u0001\u0007yI|w\u000e\u001e \n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!\u0003\u0002\u0004\t\u001d)\u0001I\u0001E\u0001\u0003\u0006!\u0002JQ1tK\n+Hn\u001b'pC\u0012\u001cu.\\7b]\u0012\u0004\"A\b\"\u0007\u000b\u0005\u0011\u0001\u0012A\"\u0014\u0005\t\u0003\u0002\"B\u000eC\t\u0003)E#A!\u0007\t\u001d\u0013\u0005\u0001\u0013\u0002\u000f\u0005Vd7\u000eT8bIB\u000b'/Y7t'\u00191\u0005#\u0013)V1B\u0011!*\u0014\b\u0003c-K!\u0001\u0014\u0003\u0002+!\u0013\u0015m]3ECR\f7\u000b^8sK\u000e{W.\\1oI&\u0011aj\u0014\u0002\f\u0011\n\u000b7/\u001a)be\u0006l7O\u0003\u0002M\tA\u0011\u0011kU\u0007\u0002%*\u0011Q\u0001C\u0005\u0003)J\u0013QCU3rk&\u0014X\r\u001a+za\u0016t\u0015-\\3QCJ\fW\u000e\u0005\u0002R-&\u0011qK\u0015\u0002\u0013%\u0016\fX/\u001b:fI&sG-\u001a=QCJ\fW\u000e\u0005\u0002K3&\u0011!l\u0014\u0002\u0019%\u0016lw\u000e^3GS2$XM\u001d(piV\u001bX\r\u001a)be\u0006l\u0007\"B\u000eG\t\u0003aF#A/\u0011\u0005y3U\"\u0001\"\t\u0013\u00014\u0005\u0019!a\u0001\n\u0003\t\u0013!B5oaV$\b\"\u00032G\u0001\u0004\u0005\r\u0011\"\u0001d\u0003%Ig\u000e];u?\u0012*\u0017\u000f\u0006\u0002eOB\u0011\u0011#Z\u0005\u0003MJ\u0011A!\u00168ji\"9\u0001.YA\u0001\u0002\u0004\u0011\u0013a\u0001=%c!1!N\u0012Q!\n\t\na!\u001b8qkR\u0004\u0003\u0006C5mm^T80 @\u0011\u00055$X\"\u00018\u000b\u0005=\u0004\u0018A\u00036d_6l\u0017M\u001c3fe*\u0011\u0011O]\u0001\u0006E\u0016,8\u000f\u001e\u0006\u0002g\u0006\u00191m\\7\n\u0005Ut'!\u0003)be\u0006lW\r^3s\u0003\u0015q\u0017-\\3tY\u0005A\u0018%A=\u0002\u000f5j\u0013N\u001c9vi\u0006YA-Z:de&\u0004H/[8oC\u0005a\u0018a\u0007)bi\"\u0004Co\u001c\u0011I\r&dWm\u001d\u0011u_\u0002\u0012W\r\t7pC\u0012,G-\u0001\u0005sKF,\u0018N]3e3\u0005\t\u0001\"CA\u0001\r\u0002\u0007I\u0011AA\u0002\u0003!1\u0018\r\\5eCR,WCAA\u0003!\r\t\u0012qA\u0005\u0004\u0003\u0013\u0011\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003\u001b1\u0005\u0019!C\u0001\u0003\u001f\tAB^1mS\u0012\fG/Z0%KF$2\u0001ZA\t\u0011%A\u00171BA\u0001\u0002\u0004\t)\u0001\u0003\u0005\u0002\u0016\u0019\u0003\u000b\u0015BA\u0003\u0003%1\u0018\r\\5eCR,\u0007\u0005K\u0005\u0002\u001414\u0018\u0011\u0004>\u0002 1\u0012\u00111D\u0011\u0003\u0003;\t!\"L\u0017wC2LG-\u0019;fC\t\t\t#\u0001\u0010WC2LG-\u0019;fA!3\u0015\u000e\\3tA\t,gm\u001c:fA1|\u0017\rZ5oO\":a)!\n\u0002,\u00055\u0002cA7\u0002(%\u0019\u0011\u0011\u00068\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0017EAA\u0018\u0003m\u0011U\u000f\\6!Y>\fG\r\t%GS2,7\u000fI5oi>\u0004\u0003JQ1tK\"9\u00111\u0007\u0001!\u0002\u0013q\u0013a\u00029be\u0006l7\u000f\t\u0005\b\u0003o\u0001A\u0011IA\u001d\u0003\u001d)\u00070Z2vi\u0016$\u0012\u0001\u001a\u0005\b\u0003{\u0001A\u0011AA \u0003\r\u0011XO\u001c\u000b\u0004I\u0006\u0005\u0003\u0002CA\"\u0003w\u0001\r!!\u0012\u0002\u0005\u0011\u001c\b\u0003BA$\u0003\u001bj!!!\u0013\u000b\u0007\u0005-c!\u0001\u0003eCR\f\u0017\u0002BA(\u0003\u0013\u0012a\u0002\u0013\"bg\u0016$\u0015\r^1Ti>\u0014X\r")
public class HBaseBulkLoadCommand
implements HBaseDataStoreCommand {
    private final String name;
    private final BulkLoadParams params;

    @Override
    public Map<String, String> connection() {
        return HBaseDataStoreCommand$class.connection(this);
    }

    public <T> T withDataStore(Function1<HBaseDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public String name() {
        return this.name;
    }

    @Override
    public BulkLoadParams params() {
        return this.params;
    }

    public void execute() {
        this.withDataStore((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseBulkLoadCommand $outer;

            public final void apply(HBaseDataStore ds) {
                this.$outer.run(ds);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void run(HBaseDataStore ds) {
        SimpleFeatureType sft = ds.getSchema(this.params().featureName());
        if (sft == null) {
            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().featureName()})));
        }
        HBaseFeatureIndex index = (HBaseFeatureIndex)this.params().loadRequiredIndex((GeoMesaDataStore<?, ?, ?>)ds, IndexMode$.MODULE$.Write());
        Path input = new Path(this.params().input());
        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running HBase incremental load..."})).s((Seq)Nil$.MODULE$));
        long start = System.currentTimeMillis();
        TableName tableName = TableName.valueOf((String)index.getTableName(this.params().featureName(), (GeoMesaDataStore)ds));
        Table table = ds.connection().getTable(tableName);
        RegionLocator locator = ds.connection().getRegionLocator(tableName);
        Configuration config = new Configuration();
        config.set("hbase.loadincremental.validate.hfile", ((Object)BoxesRunTime.boxToBoolean((boolean)this.params().validate())).toString());
        new LoadIncrementalHFiles(config).doBulkLoad(input, ds.connection().getAdmin(), table, locator);
        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HBase incremental load complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start)})));
    }

    public HBaseBulkLoadCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        HBaseDataStoreCommand$class.$init$(this);
        this.name = "bulk-load";
        this.params = new BulkLoadParams();
    }

    @Parameters(commandDescription="Bulk load HFiles into HBase")
    public static class BulkLoadParams
    implements HBaseDataStoreCommand.HBaseParams,
    RequiredTypeNameParam,
    RequiredIndexParam,
    HBaseDataStoreCommand.RemoteFilterNotUsedParam {
        @Parameter(names={"--input"}, description="Path to HFiles to be loaded", required=true)
        private String input;
        @Parameter(names={"--validate"}, description="Validate HFiles before loading")
        private boolean validate;
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=true)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--secure"}, description="Enable HBase security (visibilities)")
        private boolean secure;
        @Parameter(names={"--authorizations"}, description="Authorizations used for querying, comma-delimited")
        private String auths;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;

        @Override
        public boolean noRemote() {
            return HBaseDataStoreCommand$RemoteFilterNotUsedParam$class.noRemote(this);
        }

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public GeoMesaFeatureIndex<?, ?, ?> loadRequiredIndex(GeoMesaDataStore<?, ?, ?> ds, IndexMode.IndexMode mode) throws ParameterException {
            return IndexParam.class.loadRequiredIndex((IndexParam)this, ds, (IndexMode.IndexMode)mode);
        }

        public Option<GeoMesaFeatureIndex<?, ?, ?>> loadIndex(GeoMesaDataStore<?, ?, ?> ds, IndexMode.IndexMode mode) throws ParameterException {
            return IndexParam.class.loadIndex((IndexParam)this, ds, (IndexMode.IndexMode)mode);
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public boolean secure() {
            return this.secure;
        }

        @Override
        @TraitSetter
        public void secure_$eq(boolean x$1) {
            this.secure = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String zookeepers() {
            return this.zookeepers;
        }

        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public String input() {
            return this.input;
        }

        public void input_$eq(String x$1) {
            this.input = x$1;
        }

        public boolean validate() {
            return this.validate;
        }

        public void validate_$eq(boolean x$1) {
            this.validate = x$1;
        }

        public BulkLoadParams() {
            CatalogParam.class.$init$((CatalogParam)this);
            OptionalZookeepersParam.class.$init$((OptionalZookeepersParam)this);
            HBaseDataStoreCommand$HBaseParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            IndexParam.class.$init$((IndexParam)this);
            RequiredIndexParam.class.$init$((RequiredIndexParam)this);
            HBaseDataStoreCommand$RemoteFilterNotUsedParam$class.$init$(this);
            this.validate = true;
        }
    }
}

