/***********************************************************************
 * Copyright (c) 2013-2018 Commonwealth Computer Research, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Apache License, Version 2.0
 * which accompanies this distribution and is available at
 * http://www.opensource.org/licenses/apache2.0.php.
 ***********************************************************************/

package org.locationtech.geomesa.hbase.tools.export

import com.beust.jcommander.Parameters
import org.locationtech.geomesa.hbase.data.HBaseDataStore
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand.{HBaseParams, ToggleRemoteFilterParam}
import org.locationtech.geomesa.hbase.tools.export.HBaseExportCommand.HBaseExportParams
import org.locationtech.geomesa.tools.export.{ExportCommand, ExportParams}
import org.locationtech.geomesa.tools.{OptionalIndexParam, RequiredTypeNameParam}

class HBaseExportCommand extends ExportCommand[HBaseDataStore] with HBaseDataStoreCommand {
  override val params = new HBaseExportParams
}

object HBaseExportCommand {
  @Parameters(commandDescription = "Export features from a GeoMesa data store")
  class HBaseExportParams extends ExportParams with HBaseParams with RequiredTypeNameParam
      with OptionalIndexParam with ToggleRemoteFilterParam
}
