/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.util.List;
import org.apache.hadoop.hbase.client.Connection;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$HBaseParams$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$ToggleRemoteFilterParam$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$class;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.ConverterConfigParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.InputFilesParam;
import org.locationtech.geomesa.tools.InteractiveCommand;
import org.locationtech.geomesa.tools.OptionalFeatureSpecParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalInputFormatParam;
import org.locationtech.geomesa.tools.OptionalTypeNameParam;
import org.locationtech.geomesa.tools.OptionalZookeepersParam;
import org.locationtech.geomesa.tools.ingest.IngestCommand;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.classpath.ClassPathUtils$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005Eb\u0001B\u0001\u0003\u0001=\u0011!\u0003\u0013\"bg\u0016LenZ3ti\u000e{W.\\1oI*\u00111\u0001B\u0001\u0007S:<Wm\u001d;\u000b\u0005\u00151\u0011!\u0002;p_2\u001c(BA\u0004\t\u0003\u0015A'-Y:f\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001bC\t\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0007]QB$D\u0001\u0019\u0015\t\u0019\u0011D\u0003\u0002\u0006\u0011%\u00111\u0004\u0007\u0002\u000e\u0013:<Wm\u001d;D_6l\u0017M\u001c3\u0011\u0005u\u0001S\"\u0001\u0010\u000b\u0005}1\u0011\u0001\u00023bi\u0006L!!\t\u0010\u0003\u001d!\u0013\u0015m]3ECR\f7\u000b^8sKB\u00111\u0005J\u0007\u0002\t%\u0011Q\u0005\u0002\u0002\u0016\u0011\n\u000b7/\u001a#bi\u0006\u001cFo\u001c:f\u0007>lW.\u00198e\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t!\u0001C\u0004-\u0001\t\u0007I\u0011I\u0017\u0002\rA\f'/Y7t+\u0005q\u0003CA\u0018G\u001d\t\u0001tH\u0004\u00022}9\u0011!'\u0010\b\u0003gqr!\u0001N\u001e\u000f\u0005URdB\u0001\u001c:\u001b\u00059$B\u0001\u001d\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!q!\u0002!\u0003\u0011\u0003\t\u0015A\u0005%CCN,\u0017J\\4fgR\u001cu.\\7b]\u0012\u0004\"A\u000b\"\u0007\u000b\u0005\u0011\u0001\u0012A\"\u0014\u0005\t\u0003\u0002\"B\u0014C\t\u0003)E#A!\u0007\t\u001d\u0013\u0005\u0001\u0013\u0002\u0012\u0011\n\u000b7/Z%oO\u0016\u001cH\u000fU1sC6\u001c8#\u0002$\u0011\u0013R[\u0006C\u0001&R\u001d\tYuJ\u0004\u0002M\u001d:\u00111'T\u0005\u0003\u000b!I!aA\r\n\u0005AC\u0012!D%oO\u0016\u001cHoQ8n[\u0006tG-\u0003\u0002S'\na\u0011J\\4fgR\u0004\u0016M]1ng*\u0011\u0001\u000b\u0007\t\u0003+bs!!\r,\n\u0005]#\u0011!\u0006%CCN,G)\u0019;b'R|'/Z\"p[6\fg\u000eZ\u0005\u00033j\u00131\u0002\u0013\"bg\u0016\u0004\u0016M]1ng*\u0011q\u000b\u0002\t\u0003+rK!!\u0018.\u0003/Q{wm\u001a7f%\u0016lw\u000e^3GS2$XM\u001d)be\u0006l\u0007\"B\u0014G\t\u0003yF#\u00011\u0011\u0005\u00054U\"\u0001\")\t\u0019\u001bWN\u001c\t\u0003I.l\u0011!\u001a\u0006\u0003M\u001e\f!B[2p[6\fg\u000eZ3s\u0015\tA\u0017.A\u0003cKV\u001cHOC\u0001k\u0003\r\u0019w.\\\u0005\u0003Y\u0016\u0014!\u0002U1sC6,G/\u001a:t\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\"\u0003=\f\u0001'\u00138hKN$xfY8om\u0016\u0014H\u000f\t<be&|Wo\u001d\u0011gS2,\u0007EZ8s[\u0006$8\u000fI5oi>\u0004s)Z8NKN\f\u0007BB9\u0001A\u0003%a&A\u0004qCJ\fWn\u001d\u0011\t\u000fM\u0004!\u0019!C!i\u0006YA.\u001b2kCJ\u001ch)\u001b7f+\u0005)\bC\u0001<z\u001d\t\tr/\u0003\u0002y%\u00051\u0001K]3eK\u001aL!A_>\u0003\rM#(/\u001b8h\u0015\tA(\u0003\u0003\u0004~\u0001\u0001\u0006I!^\u0001\rY&\u0014'.\u0019:t\r&dW\r\t\u0005\u0007\u007f\u0002!\t%!\u0001\u0002\u00191L'M[1sgB\u000bG\u000f[:\u0016\u0005\u0005\r\u0001CBA\u0003\u0003\u001f\t)B\u0004\u0003\u0002\b\u0005-ab\u0001\u001c\u0002\n%\t1#C\u0002\u0002\u000eI\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0012\u0005M!\u0001C%uKJ\fGo\u001c:\u000b\u0007\u00055!\u0003E\u0003\u0012\u0003/\tY\"C\u0002\u0002\u001aI\u0011\u0011BR;oGRLwN\u001c\u0019\u0011\r\u0005\u0015\u0011QDA\u0011\u0013\u0011\ty\"a\u0005\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002$\u00055RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u0005%|'BAA\u0016\u0003\u0011Q\u0017M^1\n\t\u0005=\u0012Q\u0005\u0002\u0005\r&dW\r")
public class HBaseIngestCommand
implements IngestCommand<HBaseDataStore>,
HBaseDataStoreCommand {
    private final HBaseIngestParams params;
    private final String libjarsFile;
    private final String name;
    private final Logger logger;
    private Object org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    private volatile boolean bitmap$0;

    @Override
    public Map<String, String> connection() {
        return HBaseDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$ingest$IngestCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        IngestCommand.class.execute((IngestCommand)this);
    }

    public Runnable createIngest(Enumeration.Value mode, SimpleFeatureType sft, Config converter, Seq<String> inputs) {
        return IngestCommand.class.createIngest((IngestCommand)this, (Enumeration.Value)mode, (SimpleFeatureType)sft, (Config)converter, inputs);
    }

    private Logger logger$lzycompute() {
        HBaseIngestCommand hBaseIngestCommand = this;
        synchronized (hBaseIngestCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public Object org$locationtech$geomesa$tools$InteractiveCommand$$_console() {
        return this.org$locationtech$geomesa$tools$InteractiveCommand$$_console;
    }

    public void org$locationtech$geomesa$tools$InteractiveCommand$$_console_$eq(Object x$1) {
        this.org$locationtech$geomesa$tools$InteractiveCommand$$_console = x$1;
    }

    public Object console() {
        return InteractiveCommand.class.console((InteractiveCommand)this);
    }

    public void setConsole(Object c) {
        InteractiveCommand.class.setConsole((InteractiveCommand)this, (Object)c);
    }

    public <T> T withDataStore(Function1<HBaseDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public HBaseIngestParams params() {
        return this.params;
    }

    public String libjarsFile() {
        return this.libjarsFile;
    }

    public Iterator<Function0<Seq<File>>> libjarsPaths() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromEnvironment("GEOMESA_HBASE_HOME");
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromEnvironment("HBASE_HOME");
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromClasspath(HBaseDataStore.class);
            }
        }, new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<File> apply() {
                return ClassPathUtils$.MODULE$.getJarsFromClasspath(Connection.class);
            }
        }}));
    }

    public HBaseIngestCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        InteractiveCommand.class.$init$((InteractiveCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        IngestCommand.class.$init$((IngestCommand)this);
        HBaseDataStoreCommand$class.$init$(this);
        this.params = new HBaseIngestParams();
        this.libjarsFile = "org/locationtech/geomesa/hbase/tools/ingest-libjars.list";
    }

    @Parameters(commandDescription="Ingest/convert various file formats into GeoMesa")
    public static class HBaseIngestParams
    implements IngestCommand.IngestParams,
    HBaseDataStoreCommand.HBaseParams,
    HBaseDataStoreCommand.ToggleRemoteFilterParam {
        @Parameter(names={"--no-remote-filters"}, description="Disable remote filtering and coprocessors", arity=0)
        private boolean noRemote;
        @Parameter(names={"--secure"}, description="Enable HBase security (visibilities)")
        private boolean secure;
        @Parameter(names={"--authorizations"}, description="Authorizations used for querying, comma-delimited")
        private String auths;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-t", "--threads"}, description="Number of threads if using local ingest")
        private Integer threads;
        @Parameter(names={"--split-max-size"}, description="Maximum size of a split in bytes (distributed jobs)")
        private Integer maxSplitSize;
        @Parameter(names={"--src-list"}, description="Input files are text files with lists of files, one per line, to ingest.")
        private boolean srcList;
        @Parameter(names={"--no-tracking"}, description="Return immediately after submitting ingest job (distributed jobs)")
        private boolean noWaitForCompletion;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false, converter=DistributedRunParam.ModeConverter.class)
        private Enumeration.Value mode;
        @Parameter(names={"--input-format"}, description="File format of input files (shp, csv, tsv, avro, etc). Optional, auto-detection will be attempted")
        private String format;
        @Parameter(description="<file>...")
        private List<String> files;
        @Parameter(names={"-C", "--converter"}, description="GeoMesa converter specification as a config string, file name, or name of an available converter")
        private String config;
        @Parameter(names={"--converter-error-mode"}, description="Override the converter error mode - 'skip-bad-records' or 'raise-errors'", converter=ParameterConverters.ErrorModeConverter.class)
        private Enumeration.Value errorMode;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"-s", "--spec"}, description="SimpleFeatureType specification as a GeoTools spec string, SFT config, or file with either")
        private String spec;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate")
        private String featureName;

        @Override
        public boolean noRemote() {
            return this.noRemote;
        }

        @Override
        @TraitSetter
        public void noRemote_$eq(boolean x$1) {
            this.noRemote = x$1;
        }

        @Override
        public boolean secure() {
            return this.secure;
        }

        @Override
        @TraitSetter
        public void secure_$eq(boolean x$1) {
            this.secure = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String zookeepers() {
            return this.zookeepers;
        }

        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public Integer threads() {
            return this.threads;
        }

        public void threads_$eq(Integer x$1) {
            this.threads = x$1;
        }

        public Integer maxSplitSize() {
            return this.maxSplitSize;
        }

        public void maxSplitSize_$eq(Integer x$1) {
            this.maxSplitSize = x$1;
        }

        public boolean srcList() {
            return this.srcList;
        }

        public void srcList_$eq(boolean x$1) {
            this.srcList = x$1;
        }

        public boolean noWaitForCompletion() {
            return this.noWaitForCompletion;
        }

        public void noWaitForCompletion_$eq(boolean x$1) {
            this.noWaitForCompletion = x$1;
        }

        public boolean waitForCompletion() {
            return IngestCommand.IngestParams.class.waitForCompletion((IngestCommand.IngestParams)this);
        }

        public Enumeration.Value mode() {
            return this.mode;
        }

        public void mode_$eq(Enumeration.Value x$1) {
            this.mode = x$1;
        }

        public String format() {
            return this.format;
        }

        public void format_$eq(String x$1) {
            this.format = x$1;
        }

        public List<String> files() {
            return this.files;
        }

        public void files_$eq(List<String> x$1) {
            this.files = x$1;
        }

        public String config() {
            return this.config;
        }

        public void config_$eq(String x$1) {
            this.config = x$1;
        }

        public Enumeration.Value errorMode() {
            return this.errorMode;
        }

        public void errorMode_$eq(Enumeration.Value x$1) {
            this.errorMode = x$1;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public String spec() {
            return this.spec;
        }

        public void spec_$eq(String x$1) {
            this.spec = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        public HBaseIngestParams() {
            OptionalTypeNameParam.class.$init$((OptionalTypeNameParam)this);
            OptionalFeatureSpecParam.class.$init$((OptionalFeatureSpecParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ConverterConfigParam.class.$init$((ConverterConfigParam)this);
            InputFilesParam.class.$init$((InputFilesParam)this);
            OptionalInputFormatParam.class.$init$((OptionalInputFormatParam)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            IngestCommand.IngestParams.class.$init$((IngestCommand.IngestParams)this);
            CatalogParam.class.$init$((CatalogParam)this);
            OptionalZookeepersParam.class.$init$((OptionalZookeepersParam)this);
            HBaseDataStoreCommand$HBaseParams$class.$init$(this);
            HBaseDataStoreCommand$ToggleRemoteFilterParam$class.$init$(this);
        }
    }
}

