/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$HBaseParams$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$ToggleRemoteFilterParam$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$class;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DataStoreCommand;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.OptionalZookeepersParam;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.FeatureExporter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.stats.MethodProfiling;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u001f\t\u0011\u0002JQ1tK\u0016C\bo\u001c:u\u0007>lW.\u00198e\u0015\t\u0019A!\u0001\u0004fqB|'\u000f\u001e\u0006\u0003\u000b\u0019\tQ\u0001^8pYNT!a\u0002\u0005\u0002\u000b!\u0014\u0017m]3\u000b\u0005%Q\u0011aB4f_6,7/\u0019\u0006\u0003\u00171\tA\u0002\\8dCRLwN\u001c;fG\"T\u0011!D\u0001\u0004_J<7\u0001A\n\u0005\u0001A1\"\u0005\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0004/iaR\"\u0001\r\u000b\u0005\rI\"BA\u0003\t\u0013\tY\u0002DA\u0007FqB|'\u000f^\"p[6\fg\u000e\u001a\t\u0003;\u0001j\u0011A\b\u0006\u0003?\u0019\tA\u0001Z1uC&\u0011\u0011E\b\u0002\u000f\u0011\n\u000b7/\u001a#bi\u0006\u001cFo\u001c:f!\t\u0019C%D\u0001\u0005\u0013\t)CAA\u000bI\u0005\u0006\u001cX\rR1uCN#xN]3D_6l\u0017M\u001c3\t\u000b\u001d\u0002A\u0011\u0001\u0015\u0002\rqJg.\u001b;?)\u0005I\u0003C\u0001\u0016\u0001\u001b\u0005\u0011\u0001b\u0002\u0017\u0001\u0005\u0004%\t%L\u0001\u0007a\u0006\u0014\u0018-\\:\u0016\u00039\u0002\"a\f$\u000f\u0005AzdBA\u0019?\u001d\t\u0011TH\u0004\u00024y9\u0011Ag\u000f\b\u0003kir!AN\u001d\u000e\u0003]R!\u0001\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u00119Q\u0001\u0011\u0002\t\u0002\u0005\u000b!\u0003\u0013\"bg\u0016,\u0005\u0010]8si\u000e{W.\\1oIB\u0011!F\u0011\u0004\u0006\u0003\tA\taQ\n\u0003\u0005BAQa\n\"\u0005\u0002\u0015#\u0012!\u0011\u0004\u0005\u000f\n\u0003\u0001JA\tI\u0005\u0006\u001cX-\u0012=q_J$\b+\u0019:b[N\u001crA\u0012\tJ)n{&\r\u0005\u0002K#:\u00111j\u0014\b\u0003\u0019:s!aM'\n\u0005\u0015A\u0011BA\u0002\u001a\u0013\t\u0001\u0006$A\u0007FqB|'\u000f^\"p[6\fg\u000eZ\u0005\u0003%N\u0013A\"\u0012=q_J$\b+\u0019:b[NT!\u0001\u0015\r\u0011\u0005UCfBA\u0019W\u0013\t9F!A\u000bI\u0005\u0006\u001cX\rR1uCN#xN]3D_6l\u0017M\u001c3\n\u0005eS&a\u0003%CCN,\u0007+\u0019:b[NT!a\u0016\u0003\u0011\u0005qkV\"A\r\n\u0005yK\"!\u0006*fcVL'/\u001a3UsB,g*Y7f!\u0006\u0014\u0018-\u001c\t\u00039\u0002L!!Y\r\u0003%=\u0003H/[8oC2Le\u000eZ3y!\u0006\u0014\u0018-\u001c\t\u0003+\u000eL!\u0001\u001a.\u0003/Q{wm\u001a7f%\u0016lw\u000e^3GS2$XM\u001d)be\u0006l\u0007\"B\u0014G\t\u00031G#A4\u0011\u0005!4U\"\u0001\")\t\u0019SG/\u001e\t\u0003WJl\u0011\u0001\u001c\u0006\u0003[:\f!B[2p[6\fg\u000eZ3s\u0015\ty\u0007/A\u0003cKV\u001cHOC\u0001r\u0003\r\u0019w.\\\u0005\u0003g2\u0014!\u0002U1sC6,G/\u001a:t\u0003I\u0019w.\\7b]\u0012$Um]2sSB$\u0018n\u001c8\"\u0003Y\f\u0011&\u0012=q_J$\bEZ3biV\u0014Xm\u001d\u0011ge>l\u0007%\u0019\u0011HK>lUm]1!I\u0006$\u0018\rI:u_J,\u0007B\u0002=\u0001A\u0003%a&A\u0004qCJ\fWn\u001d\u0011")
public class HBaseExportCommand
implements ExportCommand<HBaseDataStore>,
HBaseDataStoreCommand {
    private final HBaseExportParams params;
    private final String name;
    private final Logger logger;
    private volatile boolean bitmap$0;

    @Override
    public scala.collection.immutable.Map<String, String> connection() {
        return HBaseDataStoreCommand$class.connection(this);
    }

    public String name() {
        return this.name;
    }

    public void org$locationtech$geomesa$tools$export$ExportCommand$_setter_$name_$eq(String x$1) {
        this.name = x$1;
    }

    public void execute() {
        ExportCommand.class.execute((ExportCommand)this);
    }

    public Option export(DataStore ds) {
        return ExportCommand.class.export((ExportCommand)this, (DataStore)ds);
    }

    public Option<Object> export(FeatureExporter exporter, SimpleFeatureCollection collection) {
        return ExportCommand.class.export((ExportCommand)this, (FeatureExporter)exporter, (SimpleFeatureCollection)collection);
    }

    public SimpleFeatureType getSchema(DataStore ds) {
        return ExportCommand.class.getSchema((ExportCommand)this, (DataStore)ds);
    }

    public SimpleFeatureCollection getFeatures(DataStore ds, Query query) {
        return ExportCommand.class.getFeatures((ExportCommand)this, (DataStore)ds, (Query)query);
    }

    public <R> R profile(Function1<Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(Function2<R, Object, BoxedUnit> onComplete, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, onComplete, code);
    }

    public <R> R profile(String message, Function0<R> code) {
        return (R)MethodProfiling.class.profile((MethodProfiling)this, (String)message, code);
    }

    private Logger logger$lzycompute() {
        HBaseExportCommand hBaseExportCommand = this;
        synchronized (hBaseExportCommand) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public <T> T withDataStore(Function1<HBaseDataStore, T> method) throws ParameterException {
        return (T)DataStoreCommand.class.withDataStore((DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return DataStoreCommand.class.loadDataStore((DataStoreCommand)this);
    }

    @Override
    public HBaseExportParams params() {
        return this.params;
    }

    public HBaseExportCommand() {
        DataStoreCommand.class.$init$((DataStoreCommand)this);
        LazyLogging.class.$init$((LazyLogging)this);
        MethodProfiling.class.$init$((MethodProfiling)this);
        ExportCommand.class.$init$((ExportCommand)this);
        HBaseDataStoreCommand$class.$init$(this);
        this.params = new HBaseExportParams();
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class HBaseExportParams
    implements ExportCommand.ExportParams,
    HBaseDataStoreCommand.HBaseParams,
    RequiredTypeNameParam,
    OptionalIndexParam,
    HBaseDataStoreCommand.ToggleRemoteFilterParam {
        @Parameter(names={"--no-remote-filters"}, description="Disable remote filtering and coprocessors", arity=0)
        private boolean noRemote;
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--secure"}, description="Enable HBase security (visibilities)")
        private boolean secure;
        @Parameter(names={"--authorizations"}, description="Authorizations used for querying, comma-delimited")
        private String auths;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|leaflet|orc|parquet|arrow)", required=false, converter=ParameterConverters.ExportFormatConverter.class)
        private Enumeration.Value outputFormat;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header", required=false)
        private boolean noHeader;
        @Parameter(names={"-m", "--max-features"}, description="Maximum number of features to return. default: Unlimited")
        private Integer maxFeatures;
        @Parameter(names={"-a", "--attributes"}, description="Attributes from feature to export (comma-separated)...Comma-separated expressions with each in the format attribute[=filter_function_expression]|derived-attribute=filter_function_expression|'id'. 'id' will export the feature ID, filter_function_expression is an expression of filter function applied to attributes, literals and filter functions, i.e. can be nested")
        private List<String> attributes;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;

        @Override
        public boolean noRemote() {
            return this.noRemote;
        }

        @Override
        @TraitSetter
        public void noRemote_$eq(boolean x$1) {
            this.noRemote = x$1;
        }

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.class.loadIndex((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public boolean secure() {
            return this.secure;
        }

        @Override
        @TraitSetter
        public void secure_$eq(boolean x$1) {
            this.secure = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String zookeepers() {
            return this.zookeepers;
        }

        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public Enumeration.Value outputFormat() {
            return this.outputFormat;
        }

        public void outputFormat_$eq(Enumeration.Value x$1) {
            this.outputFormat = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public HBaseExportParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
            CatalogParam.class.$init$((CatalogParam)this);
            OptionalZookeepersParam.class.$init$((OptionalZookeepersParam)this);
            HBaseDataStoreCommand$HBaseParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.class.$init$((OptionalIndexParam)this);
            HBaseDataStoreCommand$ToggleRemoteFilterParam$class.$init$(this);
        }
    }
}

