/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.geotools.data.DataStore;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$HBaseParams$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$RemoteFilterNotUsedParam$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$class;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.OptionalZookeepersParam;
import org.locationtech.geomesa.tools.RequiredIndexParam;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.text.TextTools$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\u0001\u0003\u0001=\u0011A\u0003\u0013\"bg\u0016\u0014U\u000f\\6M_\u0006$7i\\7nC:$'BA\u0002\u0005\u0003\u0019IgnZ3ti*\u0011QAB\u0001\u0006i>|Gn\u001d\u0006\u0003\u000f!\tQ\u0001\u001b2bg\u0016T!!\u0003\u0006\u0002\u000f\u001d,w.\\3tC*\u00111\u0002D\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\r\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001\u00027b]\u001eT\u0011!F\u0001\u0005U\u00064\u0018-\u0003\u0002\u0018%\t1qJ\u00196fGR\u0004\"!\u0007\u000e\u000e\u0003\u0011I!a\u0007\u0003\u0003+!\u0013\u0015m]3ECR\f7\u000b^8sK\u000e{W.\\1oI\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\bE\u0001\u0011\r\u0011\"\u0011$\u0003\u0011q\u0017-\\3\u0016\u0003\u0011\u0002\"!J\u0016\u000f\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0002\rA\u0013X\rZ3g\u0013\taSF\u0001\u0004TiJLgn\u001a\u0006\u0003U\u001dBaa\f\u0001!\u0002\u0013!\u0013!\u00028b[\u0016\u0004\u0003bB\u0019\u0001\u0005\u0004%\tEM\u0001\u0007a\u0006\u0014\u0018-\\:\u0016\u0003M\u0002\"\u0001\u000e(\u000f\u0005U\"eB\u0001\u001cD\u001d\t9$I\u0004\u00029\u0003:\u0011\u0011\b\u0011\b\u0003u}r!a\u000f \u000e\u0003qR!!\u0010\b\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0003\u0007\u00119Q!\u0012\u0002\t\u0002\u0019\u000bA\u0003\u0013\"bg\u0016\u0014U\u000f\\6M_\u0006$7i\\7nC:$\u0007C\u0001\u0011H\r\u0015\t!\u0001#\u0001I'\t9\u0015\n\u0005\u0002'\u0015&\u00111j\n\u0002\u0007\u0003:L(+\u001a4\t\u000bu9E\u0011A'\u0015\u0003\u00193AaT$\u0001!\nq!)\u001e7l\u0019>\fG\rU1sC6\u001c8C\u0002(J#bk\u0006\r\u0005\u0002S+:\u0011agU\u0005\u0003)\u0012\tQ\u0003\u0013\"bg\u0016$\u0015\r^1Ti>\u0014XmQ8n[\u0006tG-\u0003\u0002W/\nY\u0001JQ1tKB\u000b'/Y7t\u0015\t!F\u0001\u0005\u0002Z76\t!L\u0003\u0002\u0006\u0011%\u0011AL\u0017\u0002\u0016%\u0016\fX/\u001b:fIRK\b/\u001a(b[\u0016\u0004\u0016M]1n!\tIf,\u0003\u0002`5\n\u0011\"+Z9vSJ,G-\u00138eKb\u0004\u0016M]1n!\t\u0011\u0016-\u0003\u0002c/\nA\"+Z7pi\u00164\u0015\u000e\u001c;fe:{G/V:fIB\u000b'/Y7\t\u000buqE\u0011\u00013\u0015\u0003\u0015\u0004\"A\u001a(\u000e\u0003\u001dC\u0011\u0002\u001b(A\u0002\u0003\u0007I\u0011A\u0012\u0002\u000b%t\u0007/\u001e;\t\u0013)t\u0005\u0019!a\u0001\n\u0003Y\u0017!C5oaV$x\fJ3r)\taw\u000e\u0005\u0002'[&\u0011an\n\u0002\u0005+:LG\u000fC\u0004qS\u0006\u0005\t\u0019\u0001\u0013\u0002\u0007a$\u0013\u0007\u0003\u0004s\u001d\u0002\u0006K\u0001J\u0001\u0007S:\u0004X\u000f\u001e\u0011)\u0019E$hp`A\u0003\u0003\u000f\tY!!\u0004\u0011\u0005UdX\"\u0001<\u000b\u0005]D\u0018A\u00036d_6l\u0017M\u001c3fe*\u0011\u0011P_\u0001\u0006E\u0016,8\u000f\u001e\u0006\u0002w\u0006\u00191m\\7\n\u0005u4(!\u0003)be\u0006lW\r^3s\u0003\u0015q\u0017-\\3tY\t\t\t!\t\u0002\u0002\u0004\u00059Q&L5oaV$\u0018a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f#!!\u0003\u00027A\u000bG\u000f\u001b\u0011u_\u0002Be)\u001b7fg\u0002\"x\u000e\t2fA1|\u0017\rZ3e\u0003!\u0011X-];je\u0016$\u0017$A\u0001\t\u0013\u0005Ea\n1A\u0005\u0002\u0005M\u0011\u0001\u0003<bY&$\u0017\r^3\u0016\u0005\u0005U\u0001c\u0001\u0014\u0002\u0018%\u0019\u0011\u0011D\u0014\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\u0004(A\u0002\u0013\u0005\u0011qD\u0001\rm\u0006d\u0017\u000eZ1uK~#S-\u001d\u000b\u0004Y\u0006\u0005\u0002\"\u00039\u0002\u001c\u0005\u0005\t\u0019AA\u000b\u0011!\t)C\u0014Q!\n\u0005U\u0011!\u0003<bY&$\u0017\r^3!Q9\t\u0019\u0003\u001e@\u0002*\u0005\u0015\u0011qFA\u001a\u0003ka#!a\u000b\"\u0005\u00055\u0012AC\u0017.m\u0006d\u0017\u000eZ1uK\u0006\u0012\u0011\u0011G\u0001\u001f-\u0006d\u0017\u000eZ1uK\u0002Be)\u001b7fg\u0002\u0012WMZ8sK\u0002bw.\u00193j]\u001e\fQ!\u0019:jifl\u0012!\u0001\u0015\b\u001d\u0006e\u0012qHA!!\r)\u00181H\u0005\u0004\u0003{1(A\u0003)be\u0006lW\r^3sg\u0006\u00112m\\7nC:$G)Z:de&\u0004H/[8oC\t\t\u0019%A\u000eCk2\\\u0007\u0005\\8bI\u0002Be)\u001b7fg\u0002Jg\u000e^8!\u0011\n\u000b7/\u001a\u0005\b\u0003\u000f\u0002\u0001\u0015!\u00034\u0003\u001d\u0001\u0018M]1ng\u0002Bq!a\u0013\u0001\t\u0003\ni%A\u0004fq\u0016\u001cW\u000f^3\u0015\u00031Dq!!\u0015\u0001\t\u0003\t\u0019&A\u0002sk:$2\u0001\\A+\u0011!\t9&a\u0014A\u0002\u0005e\u0013A\u00013t!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0\r\u0005!A-\u0019;b\u0013\u0011\t\u0019'!\u0018\u0003\u001d!\u0013\u0015m]3ECR\f7\u000b^8sK\u0002")
public class HBaseBulkLoadCommand
implements HBaseDataStoreCommand {
    private final String name;
    private final BulkLoadParams params;

    @Override
    public Map<String, String> connection() {
        return HBaseDataStoreCommand$class.connection(this);
    }

    public <T> T withDataStore(Function1<HBaseDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.class.withDataStore((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.class.loadDataStore((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.class.subCommands((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.class.validate((package.Command)this);
    }

    public void run() {
        package.Command.class.run((package.Command)this);
    }

    public String name() {
        return this.name;
    }

    @Override
    public BulkLoadParams params() {
        return this.params;
    }

    public void execute() {
        this.withDataStore((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HBaseBulkLoadCommand $outer;

            public final void apply(HBaseDataStore ds) {
                this.$outer.run(ds);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void run(HBaseDataStore ds) {
        SimpleFeatureType sft = ds.getSchema(this.params().featureName());
        if (sft == null) {
            throw new ParameterException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Schema '", "' does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.params().featureName()})));
        }
        Predef$.MODULE$.require(!TablePartition$.MODULE$.partitioned(sft), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Bulk loading partitioned tables is not currently supported";
            }
        });
        GeoMesaFeatureIndex<?, ?> index = this.params().loadIndex(ds, sft.getTypeName(), IndexMode$.MODULE$.Write());
        Path input = new Path(this.params().input());
        package.Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Running HBase incremental load..."})).s((Seq)Nil$.MODULE$));
        long start = System.currentTimeMillis();
        Seq seq = index.getTableNames((Option)None$.MODULE$);
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            TableName tableName;
            String t = (String)((SeqLike)some.get()).apply(0);
            TableName tableName2 = tableName = TableName.valueOf((String)t);
            Table table = ds.connection().getTable(tableName2);
            RegionLocator locator = ds.connection().getRegionLocator(tableName2);
            Configuration config = new Configuration();
            config.set("hbase.loadincremental.validate.hfile", ((Object)BoxesRunTime.boxToBoolean((boolean)this.params().validate())).toString());
            LoadIncrementalHFiles load = new LoadIncrementalHFiles(config);
            Method method = load.getClass().getMethod("doBulkLoad", Path.class, Admin.class, Table.class, RegionLocator.class);
            method.invoke((Object)load, input, ds.connection().getAdmin(), table, locator);
            package.Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"HBase incremental load complete in ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TextTools$.MODULE$.getTime(start)})));
            return;
        }
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected a single table but got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{seq.mkString(", ")})));
    }

    public HBaseBulkLoadCommand() {
        package.Command.class.$init$((package.Command)this);
        package.DataStoreCommand.class.$init$((package.DataStoreCommand)this);
        HBaseDataStoreCommand$class.$init$(this);
        this.name = "bulk-load";
        this.params = new BulkLoadParams();
    }

    @Parameters(commandDescription="Bulk load HFiles into HBase")
    public static class BulkLoadParams
    implements HBaseDataStoreCommand.HBaseParams,
    RequiredTypeNameParam,
    RequiredIndexParam,
    HBaseDataStoreCommand.RemoteFilterNotUsedParam {
        @Parameter(names={"--input"}, description="Path to HFiles to be loaded", required=true)
        private String input;
        @Parameter(names={"--validate"}, description="Validate HFiles before loading", arity=1)
        private boolean validate;
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=true)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--secure"}, description="Enable HBase security (visibilities)")
        private boolean secure;
        @Parameter(names={"--authorizations"}, description="Authorizations used for querying, comma-delimited")
        private String auths;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;

        @Override
        public boolean noRemote() {
            return HBaseDataStoreCommand$RemoteFilterNotUsedParam$class.noRemote(this);
        }

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public <DS extends GeoMesaDataStore<DS>> GeoMesaFeatureIndex<?, ?> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return RequiredIndexParam.class.loadIndex((RequiredIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public boolean secure() {
            return this.secure;
        }

        @Override
        @TraitSetter
        public void secure_$eq(boolean x$1) {
            this.secure = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String zookeepers() {
            return this.zookeepers;
        }

        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public String input() {
            return this.input;
        }

        public void input_$eq(String x$1) {
            this.input = x$1;
        }

        public boolean validate() {
            return this.validate;
        }

        public void validate_$eq(boolean x$1) {
            this.validate = x$1;
        }

        public BulkLoadParams() {
            CatalogParam.class.$init$((CatalogParam)this);
            OptionalZookeepersParam.class.$init$((OptionalZookeepersParam)this);
            HBaseDataStoreCommand$HBaseParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            RequiredIndexParam.class.$init$((RequiredIndexParam)this);
            HBaseDataStoreCommand$RemoteFilterNotUsedParam$class.$init$(this);
            this.validate = true;
        }
    }
}

