/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.data.Query;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$HBaseParams$class;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand$ToggleRemoteFilterParam$class;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.NumReducersParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.OptionalZookeepersParam;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u0005UbaB\u0001\u0003!\u0003\r\ta\u0004\u0002\u0013\u0011\n\u000b7/Z#ya>\u0014HoQ8n[\u0006tGM\u0003\u0002\u0004\t\u00051Q\r\u001f9peRT!!\u0002\u0004\u0002\u000bQ|w\u000e\\:\u000b\u0005\u001dA\u0011!\u00025cCN,'BA\u0005\u000b\u0003\u001d9Wm\\7fg\u0006T!a\u0003\u0007\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0019!\t\tb#D\u0001\u0013\u0015\t\u0019B#\u0001\u0003mC:<'\"A\u000b\u0002\t)\fg/Y\u0005\u0003/I\u0011aa\u00142kK\u000e$\bcA\r\u001d=5\t!D\u0003\u0002\u00047)\u0011Q\u0001C\u0005\u0003;i\u0011Q\"\u0012=q_J$8i\\7nC:$\u0007CA\u0010#\u001b\u0005\u0001#BA\u0011\u0007\u0003\u0011!\u0017\r^1\n\u0005\r\u0002#A\u0004%CCN,G)\u0019;b'R|'/\u001a\u0005\u0006K\u0001!\tAJ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003\u001d\u0002\"\u0001K\u0016\u000e\u0003%R\u0011AK\u0001\u0006g\u000e\fG.Y\u0005\u0003Y%\u0012A!\u00168ji\"9a\u0006\u0001b\u0001\n\u0003z\u0013A\u00029be\u0006l7/F\u00011!\t\tTJ\u0004\u00023\u0003:\u00111\u0007\u0011\b\u0003i}r!!\u000e \u000f\u0005YjdBA\u001c=\u001d\tA4(D\u0001:\u0015\tQd\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u000f\u0015\u0011%\u0001#\u0001D\u0003IA%)Y:f\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\u0011\u0005\u0011+U\"\u0001\u0002\u0007\u000b\u0005\u0011\u0001\u0012\u0001$\u0014\u0005\u0015;\u0005C\u0001\u0015I\u0013\tI\u0015F\u0001\u0004B]f\u0014VM\u001a\u0005\u0006\u0017\u0016#\t\u0001T\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r3AAT#\u0001\u001f\n\t\u0002JQ1tK\u0016C\bo\u001c:u!\u0006\u0014\u0018-\\:\u0014\u000f5;\u0005k\u00172gSB\u0011\u0011\u000b\u0017\b\u0003%Zs!aU+\u000f\u0005U\"\u0016BA\u0003\t\u0013\t\u00191$\u0003\u0002X5\u0005iQ\t\u001f9peR\u001cu.\\7b]\u0012L!!\u0017.\u0003\u0019\u0015C\bo\u001c:u!\u0006\u0014\u0018-\\:\u000b\u0005]S\u0002C\u0001/`\u001d\t\u0019T,\u0003\u0002_\t\u0005)\u0002JQ1tK\u0012\u000bG/Y*u_J,7i\\7nC:$\u0017B\u00011b\u0005-A%)Y:f!\u0006\u0014\u0018-\\:\u000b\u0005y#\u0001CA2e\u001b\u0005Y\u0012BA3\u001c\u0005U\u0011V-];je\u0016$G+\u001f9f\u001d\u0006lW\rU1sC6\u0004\"aY4\n\u0005!\\\"AE(qi&|g.\u00197J]\u0012,\u0007\u0010U1sC6\u0004\"\u0001\u00186\n\u0005-\f'a\u0006+pO\u001edWMU3n_R,g)\u001b7uKJ\u0004\u0016M]1n\u0011\u0015YU\n\"\u0001n)\u0005q\u0007CA8N\u001b\u0005)\u0005\u0006B'rwr\u0004\"A]=\u000e\u0003MT!\u0001^;\u0002\u0015)\u001cw.\\7b]\u0012,'O\u0003\u0002wo\u0006)!-Z;ti*\t\u00010A\u0002d_6L!A_:\u0003\u0015A\u000b'/Y7fi\u0016\u00148/\u0001\nd_6l\u0017M\u001c3EKN\u001c'/\u001b9uS>t\u0017%A?\u0002S\u0015C\bo\u001c:uA\u0019,\u0017\r^;sKN\u0004cM]8nA\u0005\u0004s)Z8NKN\f\u0007\u0005Z1uC\u0002\u001aHo\u001c:f\u0011\u0019y\b\u0001)A\u0005a\u00059\u0001/\u0019:b[N\u0004\u0003bBA\u0002\u0001\u0011E\u0013QA\u0001\nG>tg-[4ve\u0016$raJA\u0004\u0003?\t\u0019\u0003\u0003\u0005\u0002\n\u0005\u0005\u0001\u0019AA\u0006\u0003\rQwN\u0019\t\u0005\u0003\u001b\tY\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0003\u0002\u0016\u0005]\u0011A\u00025bI>|\u0007OC\u0002\u0002\u001a1\ta!\u00199bG\",\u0017\u0002BA\u000f\u0003\u001f\u00111AS8c\u0011\u001d\t\t#!\u0001A\u0002y\t!\u0001Z:\t\u0011\u0005\u0015\u0012\u0011\u0001a\u0001\u0003O\tQ!];fef\u0004B!!\u000b\u000225\u0011\u00111\u0006\u0006\u0004C\u00055\"bAA\u0018\u0019\u0005Aq-Z8u_>d7/\u0003\u0003\u00024\u0005-\"!B)vKJL\b")
public interface HBaseExportCommand
extends ExportCommand<HBaseDataStore> {
    public void org$locationtech$geomesa$hbase$tools$export$HBaseExportCommand$_setter_$params_$eq(HBaseExportParams var1);

    public HBaseExportParams params();

    public void configure(Job var1, HBaseDataStore var2, Query var3);

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class HBaseExportParams
    implements ExportCommand.ExportParams,
    HBaseDataStoreCommand.HBaseParams,
    RequiredTypeNameParam,
    OptionalIndexParam,
    HBaseDataStoreCommand.ToggleRemoteFilterParam {
        @Parameter(names={"--no-remote-filters"}, description="Disable remote filtering and coprocessors", arity=0)
        private boolean noRemote;
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--secure"}, description="Enable HBase security (visibilities)")
        private boolean secure;
        @Parameter(names={"--authorizations"}, description="Authorizations used for querying, comma-delimited")
        private String auths;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"--suppress-empty"}, description="Suppress all output (headers, etc) if there are no features exported")
        private boolean suppressEmpty;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|avro-native|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private final ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed jobs)", validateWith={PositiveInteger.class})
        private Integer reducers;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private final Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        @Override
        public boolean noRemote() {
            return this.noRemote;
        }

        @Override
        @TraitSetter
        public void noRemote_$eq(boolean x$1) {
            this.noRemote = x$1;
        }

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.class.loadIndex((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public boolean secure() {
            return this.secure;
        }

        @Override
        @TraitSetter
        public void secure_$eq(boolean x$1) {
            this.secure = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        @TraitSetter
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String zookeepers() {
            return this.zookeepers;
        }

        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public boolean suppressEmpty() {
            return this.suppressEmpty;
        }

        public void suppressEmpty_$eq(boolean x$1) {
            this.suppressEmpty = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> transforms() {
            return this.transforms;
        }

        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public List<String> sortFields() {
            return this.sortFields;
        }

        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        public boolean sortDescending() {
            return this.sortDescending;
        }

        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        public Long chunkSize() {
            return this.chunkSize;
        }

        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            HBaseExportParams hBaseExportParams = this;
            synchronized (hBaseExportParams) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.class.outputFormat((ExportCommand.ExportParams)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
                return this.outputFormat;
            }
        }

        public ExportFormat outputFormat() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.outputFormat$lzycompute() : this.outputFormat;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public Integer reducers() {
            return this.reducers;
        }

        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option mode$lzycompute() {
            HBaseExportParams hBaseExportParams = this;
            synchronized (hBaseExportParams) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.class.mode((DistributedRunParam)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
                return this.mode;
            }
        }

        public Option<Enumeration.Value> mode() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.mode$lzycompute() : this.mode;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public HBaseExportParams() {
            OptionalCqlFilterParam.class.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.class.$init$((QueryHintsParams)this);
            DistributedRunParam.class.$init$((DistributedRunParam)this);
            NumReducersParam.class.$init$((NumReducersParam)this);
            OptionalForceParam.class.$init$((OptionalForceParam)this);
            ExportCommand.ExportParams.class.$init$((ExportCommand.ExportParams)this);
            CatalogParam.class.$init$((CatalogParam)this);
            OptionalZookeepersParam.class.$init$((OptionalZookeepersParam)this);
            HBaseDataStoreCommand$HBaseParams$class.$init$(this);
            RequiredTypeNameParam.class.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.class.$init$((OptionalIndexParam)this);
            HBaseDataStoreCommand$ToggleRemoteFilterParam$class.$init$(this);
        }
    }
}

