/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.tools.export;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.validators.PositiveInteger;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.mapreduce.Job;
import org.geotools.data.Query;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.jobs.GeoMesaHBaseInputFormat$;
import org.locationtech.geomesa.hbase.jobs.HBaseJobUtils$;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.DistributedRunParam;
import org.locationtech.geomesa.tools.NumReducersParam;
import org.locationtech.geomesa.tools.OptionalCqlFilterParam;
import org.locationtech.geomesa.tools.OptionalForceParam;
import org.locationtech.geomesa.tools.OptionalIndexParam;
import org.locationtech.geomesa.tools.OptionalZookeepersParam;
import org.locationtech.geomesa.tools.QueryHintsParams;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.export.ExportCommand;
import org.locationtech.geomesa.tools.export.formats.ExportFormat;
import org.locationtech.geomesa.tools.utils.NoopParameterSplitter;
import org.locationtech.geomesa.tools.utils.ParameterConverters;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.opengis.filter.Filter;
import scala.Enumeration;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005EbaB\u0005\u000b!\u0003\r\ta\u0006\u0005\u0006Y\u0001!\t!\f\u0005\bi\u0001\u0011\r\u0011\"\u00116\u0011\u0019y\b\u0001\"\u0015\u0002\u0002\u001d)qI\u0003E\u0001\u0011\u001a)\u0011B\u0003E\u0001\u0015\")a*\u0002C\u0001\u001f\u001a!\u0001+\u0002\u0001R\u0011\u0015qu\u0001\"\u0001o\u0005IA%)Y:f\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\u000b\u0005-a\u0011AB3ya>\u0014HO\u0003\u0002\u000e\u001d\u0005)Ao\\8mg*\u0011q\u0002E\u0001\u0006Q\n\f7/\u001a\u0006\u0003#I\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\u0014)\u0005aAn\\2bi&|g\u000e^3dQ*\tQ#A\u0002pe\u001e\u001c\u0001aE\u0002\u00011\u0001\u0002\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\t1\fgn\u001a\u0006\u0002;\u0005!!.\u0019<b\u0013\ty\"D\u0001\u0004PE*,7\r\u001e\t\u0004C\u00112S\"\u0001\u0012\u000b\u0005-\u0019#BA\u0007\u0011\u0013\t)#EA\u0007FqB|'\u000f^\"p[6\fg\u000e\u001a\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S9\tA\u0001Z1uC&\u00111\u0006\u000b\u0002\u000f\u0011\n\u000b7/\u001a#bi\u0006\u001cFo\u001c:f\u0003\u0019!\u0013N\\5uIQ\ta\u0006\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0003V]&$\u0018A\u00029be\u0006l7/F\u00017!\t9tA\u0004\u00029\t9\u0011\u0011H\u0012\b\u0003u\u0015s!a\u000f#\u000f\u0005q\u001aeBA\u001fC\u001d\tq\u0014)D\u0001@\u0015\t\u0001e#\u0001\u0004=e>|GOP\u0005\u0002+%\u00111\u0003F\u0005\u0003#II!a\u0004\t\n\u00055q\u0011BA\u0006\r\u0003IA%)Y:f\u000bb\u0004xN\u001d;D_6l\u0017M\u001c3\u0011\u0005%+Q\"\u0001\u0006\u0014\u0005\u0015Y\u0005CA\u0018M\u0013\ti\u0005G\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0013\u0011\u0003\u0013\"bg\u0016,\u0005\u0010]8siB\u000b'/Y7t'\u001d91JU/eQ.\u0004\"a\u0015.\u000f\u0005QCfBA+X\u001d\tYd+\u0003\u0002\u000e!%\u00111bI\u0005\u00033\n\nQ\"\u0012=q_J$8i\\7nC:$\u0017BA.]\u00051)\u0005\u0010]8siB\u000b'/Y7t\u0015\tI&\u0005\u0005\u0002_C:\u0011\u0011hX\u0005\u0003A2\tQ\u0003\u0013\"bg\u0016$\u0015\r^1Ti>\u0014XmQ8n[\u0006tG-\u0003\u0002cG\nY\u0001JQ1tKB\u000b'/Y7t\u0015\t\u0001G\u0002\u0005\u0002fM6\t1%\u0003\u0002hG\t)\"+Z9vSJ,G\rV=qK:\u000bW.\u001a)be\u0006l\u0007CA3j\u0013\tQ7E\u0001\nPaRLwN\\1m\u0013:$W\r\u001f)be\u0006l\u0007C\u00010m\u0013\ti7MA\fU_\u001e<G.\u001a*f[>$XMR5mi\u0016\u0014\b+\u0019:b[R\tq\u000e\u0005\u0002q\u000f5\tQ\u0001\u000b\u0003\berl\bCA:{\u001b\u0005!(BA;w\u0003)Q7m\\7nC:$WM\u001d\u0006\u0003ob\fQAY3vgRT\u0011!_\u0001\u0004G>l\u0017BA>u\u0005)\u0001\u0016M]1nKR,'o]\u0001\u0013G>lW.\u00198e\t\u0016\u001c8M]5qi&|g.I\u0001\u007f\u0003%*\u0005\u0010]8si\u00022W-\u0019;ve\u0016\u001c\bE\u001a:p[\u0002\n\u0007eR3p\u001b\u0016\u001c\u0018\r\t3bi\u0006\u00043\u000f^8sK\u0006I1m\u001c8gS\u001e,(/\u001a\u000b\b]\u0005\r\u00111DA\u0010\u0011\u001d\t)a\u0001a\u0001\u0003\u000f\t1A[8c!\u0011\tI!a\u0006\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\t\u0011\"\\1qe\u0016$WoY3\u000b\t\u0005E\u00111C\u0001\u0007Q\u0006$wn\u001c9\u000b\u0007\u0005UA#\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u00033\tYAA\u0002K_\nDa!!\b\u0004\u0001\u00041\u0013A\u00013t\u0011\u001d\t\tc\u0001a\u0001\u0003G\tQ!];fef\u0004B!!\n\u0002.5\u0011\u0011q\u0005\u0006\u0004S\u0005%\"bAA\u0016)\u0005Aq-Z8u_>d7/\u0003\u0003\u00020\u0005\u001d\"!B)vKJL\b")
public interface HBaseExportCommand
extends ExportCommand<HBaseDataStore> {
    public void org$locationtech$geomesa$hbase$tools$export$HBaseExportCommand$_setter_$params_$eq(HBaseExportParams var1);

    public HBaseExportParams params();

    public static /* synthetic */ void configure$(HBaseExportCommand $this, Job job, HBaseDataStore ds, Query query) {
        $this.configure(job, ds, query);
    }

    default public void configure(Job job, HBaseDataStore ds, Query query) {
        GeoMesaHBaseInputFormat$.MODULE$.configure(job, HBaseJobUtils$.MODULE$.getSingleScanPlan(ds, query));
    }

    public static void $init$(HBaseExportCommand $this) {
        $this.org$locationtech$geomesa$hbase$tools$export$HBaseExportCommand$_setter_$params_$eq(new HBaseExportParams());
    }

    @Parameters(commandDescription="Export features from a GeoMesa data store")
    public static class HBaseExportParams
    implements ExportCommand.ExportParams,
    HBaseDataStoreCommand.HBaseParams,
    RequiredTypeNameParam,
    OptionalIndexParam,
    HBaseDataStoreCommand.ToggleRemoteFilterParam {
        @Parameter(names={"--no-remote-filters"}, description="Disable remote filtering and coprocessors", arity=0)
        private boolean noRemote;
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=false)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--secure"}, description="Enable HBase security (visibilities)")
        private boolean secure;
        @Parameter(names={"--authorizations"}, description="Authorizations used for querying, comma-delimited")
        private String auths;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;
        @Parameter(names={"-o", "--output"}, description="Output to a file instead of std out")
        private String file;
        @Parameter(names={"--gzip"}, description="Level of gzip compression to apply to output, from 1-9")
        private Integer gzip;
        @Parameter(names={"--no-header"}, description="Export as a delimited text format (csv|tsv) without a type header")
        private boolean noHeader;
        @Parameter(names={"--suppress-empty"}, description="Suppress all output (headers, etc) if there are no features exported")
        private boolean suppressEmpty;
        @Parameter(names={"-m", "--max-features"}, description="Restrict the maximum number of features returned")
        private Integer maxFeatures;
        @Parameter(names={"--attribute"}, description="Attributes or derived expressions to export, or 'id' to include the feature ID", splitter=NoopParameterSplitter.class)
        private List<String> transforms;
        @Parameter(names={"-a", "--attributes"}, description="Comma-separated attributes to export, or 'id' to include the feature ID")
        private List<String> attributes;
        @Parameter(names={"--sort-by"}, description="Sort by the specified attributes (comma-delimited)")
        private List<String> sortFields;
        @Parameter(names={"--sort-descending"}, description="Sort in descending order, instead of ascending", arity=0)
        private boolean sortDescending;
        @Parameter(names={"--chunk-size"}, description="Split the output into multiple files, by specifying the rough number of bytes to store per file", converter=ParameterConverters.BytesConverter.class)
        private Long chunkSize;
        @Parameter(names={"-F", "--output-format"}, description="File format of output files (csv|tsv|gml|json|shp|avro|avro-native|leaflet|orc|parquet|arrow)", converter=ParameterConverters.ExportFormatConverter.class)
        private ExportFormat explicitOutputFormat;
        private ExportFormat outputFormat;
        @Parameter(names={"--force"}, description="Force execution without prompt")
        private boolean force;
        @Parameter(names={"--num-reducers"}, description="Number of reducers to use when sorting or merging (for distributed jobs)", validateWith={PositiveInteger.class})
        private Integer reducers;
        @Parameter(names={"--run-mode"}, description="Run locally or on a cluster", required=false)
        private String runMode;
        private Option<Enumeration.Value> mode;
        @Parameter(names={"--hints"}, description="Query hints to set, in the form key1=value1;key2=value2", required=false, converter=ParameterConverters.HintConverter.class)
        private Map<String, String> hints;
        @Parameter(names={"-q", "--cql"}, description="CQL predicate", converter=ParameterConverters.FilterConverter.class)
        private Filter cqlFilter;
        private volatile byte bitmap$0;

        public <DS extends GeoMesaDataStore<DS>> Option<GeoMesaFeatureIndex<?, ?>> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return OptionalIndexParam.loadIndex$((OptionalIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        @Override
        public boolean noRemote() {
            return this.noRemote;
        }

        @Override
        public void noRemote_$eq(boolean x$1) {
            this.noRemote = x$1;
        }

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public boolean secure() {
            return this.secure;
        }

        @Override
        public void secure_$eq(boolean x$1) {
            this.secure = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String zookeepers() {
            return this.zookeepers;
        }

        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public String file() {
            return this.file;
        }

        public void file_$eq(String x$1) {
            this.file = x$1;
        }

        public Integer gzip() {
            return this.gzip;
        }

        public void gzip_$eq(Integer x$1) {
            this.gzip = x$1;
        }

        public boolean noHeader() {
            return this.noHeader;
        }

        public void noHeader_$eq(boolean x$1) {
            this.noHeader = x$1;
        }

        public boolean suppressEmpty() {
            return this.suppressEmpty;
        }

        public void suppressEmpty_$eq(boolean x$1) {
            this.suppressEmpty = x$1;
        }

        public Integer maxFeatures() {
            return this.maxFeatures;
        }

        public void maxFeatures_$eq(Integer x$1) {
            this.maxFeatures = x$1;
        }

        public List<String> transforms() {
            return this.transforms;
        }

        public void transforms_$eq(List<String> x$1) {
            this.transforms = x$1;
        }

        public List<String> attributes() {
            return this.attributes;
        }

        public void attributes_$eq(List<String> x$1) {
            this.attributes = x$1;
        }

        public List<String> sortFields() {
            return this.sortFields;
        }

        public void sortFields_$eq(List<String> x$1) {
            this.sortFields = x$1;
        }

        public boolean sortDescending() {
            return this.sortDescending;
        }

        public void sortDescending_$eq(boolean x$1) {
            this.sortDescending = x$1;
        }

        public Long chunkSize() {
            return this.chunkSize;
        }

        public void chunkSize_$eq(Long x$1) {
            this.chunkSize = x$1;
        }

        public ExportFormat explicitOutputFormat() {
            return this.explicitOutputFormat;
        }

        public void explicitOutputFormat_$eq(ExportFormat x$1) {
            this.explicitOutputFormat = x$1;
        }

        private ExportFormat outputFormat$lzycompute() {
            HBaseExportParams hBaseExportParams = this;
            synchronized (hBaseExportParams) {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    this.outputFormat = ExportCommand.ExportParams.outputFormat$((ExportCommand.ExportParams)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                }
            }
            return this.outputFormat;
        }

        public ExportFormat outputFormat() {
            return (byte)(this.bitmap$0 & 1) == 0 ? this.outputFormat$lzycompute() : this.outputFormat;
        }

        public boolean force() {
            return this.force;
        }

        public void force_$eq(boolean x$1) {
            this.force = x$1;
        }

        public Integer reducers() {
            return this.reducers;
        }

        public void reducers_$eq(Integer x$1) {
            this.reducers = x$1;
        }

        public String runMode() {
            return this.runMode;
        }

        public void runMode_$eq(String x$1) {
            this.runMode = x$1;
        }

        private Option<Enumeration.Value> mode$lzycompute() {
            HBaseExportParams hBaseExportParams = this;
            synchronized (hBaseExportParams) {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    this.mode = DistributedRunParam.mode$((DistributedRunParam)this);
                    this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                }
            }
            return this.mode;
        }

        public Option<Enumeration.Value> mode() {
            return (byte)(this.bitmap$0 & 2) == 0 ? this.mode$lzycompute() : this.mode;
        }

        public Map<String, String> hints() {
            return this.hints;
        }

        public void hints_$eq(Map<String, String> x$1) {
            this.hints = x$1;
        }

        public Filter cqlFilter() {
            return this.cqlFilter;
        }

        public void cqlFilter_$eq(Filter x$1) {
            this.cqlFilter = x$1;
        }

        public HBaseExportParams() {
            OptionalCqlFilterParam.$init$((OptionalCqlFilterParam)this);
            QueryHintsParams.$init$((QueryHintsParams)this);
            DistributedRunParam.$init$((DistributedRunParam)this);
            NumReducersParam.$init$((NumReducersParam)this);
            OptionalForceParam.$init$((OptionalForceParam)this);
            ExportCommand.ExportParams.$init$((ExportCommand.ExportParams)this);
            CatalogParam.$init$((CatalogParam)this);
            OptionalZookeepersParam.$init$((OptionalZookeepersParam)this);
            HBaseDataStoreCommand.HBaseParams.$init$(this);
            RequiredTypeNameParam.$init$((RequiredTypeNameParam)this);
            OptionalIndexParam.$init$((OptionalIndexParam)this);
            HBaseDataStoreCommand.ToggleRemoteFilterParam.$init$(this);
        }
    }
}

