/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.hbase.tools.ingest;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.geotools.api.data.DataStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.locationtech.geomesa.hbase.data.HBaseDataStore;
import org.locationtech.geomesa.hbase.tools.HBaseDataStoreCommand;
import org.locationtech.geomesa.index.api.GeoMesaFeatureIndex;
import org.locationtech.geomesa.index.conf.partition.TablePartition$;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.tools.CatalogParam;
import org.locationtech.geomesa.tools.OptionalZookeepersParam;
import org.locationtech.geomesa.tools.RequiredIndexParam;
import org.locationtech.geomesa.tools.RequiredTypeNameParam;
import org.locationtech.geomesa.tools.package;
import org.locationtech.geomesa.utils.index.IndexMode;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.text.TextTools$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\n\u0015\u0001\u0005BQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00053\u0007\u0003\u0004B\u0001\u0001\u0006I\u0001\u000e\u0005\b\u0005\u0002\u0011\r\u0011\"\u0011D\u0011\u001d\ti\u0005\u0001Q\u0001\n\u0011Cq!a\u0014\u0001\t\u0003\n\t\u0006C\u0004\u0002T\u0001!\t!!\u0016\b\u000bI#\u0002\u0012A*\u0007\u000bM!\u0002\u0012\u0001+\t\u000b9JA\u0011A-\u0007\tiK\u0001a\u0017\u0005\u0006]-!\tA\u001c\u0005\nc.\u0001\r\u00111A\u0005\u0002MB\u0011B]\u0006A\u0002\u0003\u0007I\u0011A:\t\u0013e\\\u0001\u0019!A!B\u0013!\u0004\"CA\u000f\u0017\u0001\u0007I\u0011AA\u0010\u0011%\t9c\u0003a\u0001\n\u0003\tI\u0003\u0003\u0005\u0002.-\u0001\u000b\u0015BA\u0011\u0005QA%)Y:f\u0005Vd7\u000eT8bI\u000e{W.\\1oI*\u0011QCF\u0001\u0007S:<Wm\u001d;\u000b\u0005]A\u0012!\u0002;p_2\u001c(BA\r\u001b\u0003\u0015A'-Y:f\u0015\tYB$A\u0004hK>lWm]1\u000b\u0005uq\u0012\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011#\u0006\u0005\u0002$Q5\tAE\u0003\u0002&M\u0005!A.\u00198h\u0015\u00059\u0013\u0001\u00026bm\u0006L!!\u000b\u0013\u0003\r=\u0013'.Z2u!\tYC&D\u0001\u0017\u0013\ticCA\u000bI\u0005\u0006\u001cX\rR1uCN#xN]3D_6l\u0017M\u001c3\u0002\rqJg.\u001b;?)\u0005\u0001\u0004CA\u0019\u0001\u001b\u0005!\u0012\u0001\u00028b[\u0016,\u0012\u0001\u000e\t\u0003kyr!A\u000e\u001f\u0011\u0005]RT\"\u0001\u001d\u000b\u0005e\u0002\u0013A\u0002\u001fs_>$hHC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f;\u0003\u0015q\u0017-\\3!\u0003\u0019\u0001\u0018M]1ngV\tA\t\u0005\u0002F\u00179\u0011a\t\u0003\b\u0003\u000fFs!\u0001\u0013)\u000f\u0005%{eB\u0001&O\u001d\tYUJ\u0004\u00028\u0019&\tq$\u0003\u0002\u001e=%\u00111\u0004H\u0005\u00033iI!a\u0006\r\n\u0005U1\u0012\u0001\u0006%CCN,')\u001e7l\u0019>\fGmQ8n[\u0006tG\r\u0005\u00022\u0013M\u0011\u0011\"\u0016\t\u0003-^k\u0011AO\u0005\u00031j\u0012a!\u00118z%\u00164G#A*\u0003\u001d\t+Hn\u001b'pC\u0012\u0004\u0016M]1ngN11\"\u0016/dQ.\u0004\"!\u00181\u000f\u0005\u001ds\u0016BA0\u0017\u0003UA%)Y:f\t\u0006$\u0018m\u0015;pe\u0016\u001cu.\\7b]\u0012L!!\u00192\u0003\u0017!\u0013\u0015m]3QCJ\fWn\u001d\u0006\u0003?Z\u0001\"\u0001\u001a4\u000e\u0003\u0015T!a\u0006\u000e\n\u0005\u001d,'!\u0006*fcVL'/\u001a3UsB,g*Y7f!\u0006\u0014\u0018-\u001c\t\u0003I&L!A[3\u0003%I+\u0017/^5sK\u0012Le\u000eZ3y!\u0006\u0014\u0018-\u001c\t\u0003;2L!!\u001c2\u00031I+Wn\u001c;f\r&dG/\u001a:O_R,6/\u001a3QCJ\fW\u000eF\u0001p!\t\u00018\"D\u0001\n\u0003\u0015Ig\u000e];u\u0003%Ig\u000e];u?\u0012*\u0017\u000f\u0006\u0002uoB\u0011a+^\u0005\u0003mj\u0012A!\u00168ji\"9\u0001PDA\u0001\u0002\u0004!\u0014a\u0001=%c\u00051\u0011N\u001c9vi\u0002BcbD>\u0002\f\u00055\u00111CA\u000b\u00033\tY\u0002E\u0002}\u0003\u000fi\u0011! \u0006\u0003}~\f!B[2p[6\fg\u000eZ3s\u0015\u0011\t\t!a\u0001\u0002\u000b\t,Wo\u001d;\u000b\u0005\u0005\u0015\u0011aA2p[&\u0019\u0011\u0011B?\u0003\u0013A\u000b'/Y7fi\u0016\u0014\u0018!\u00028b[\u0016\u001cHFAA\bC\t\t\t\"A\u0004.[%t\u0007/\u001e;\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0003\u0003/\t1\u0004U1uQ\u0002\"x\u000e\t%GS2,7\u000f\t;pA\t,\u0007\u0005\\8bI\u0016$\u0017\u0001\u0003:fcVL'/\u001a3\u001a\u0003\u0005\t\u0001B^1mS\u0012\fG/Z\u000b\u0003\u0003C\u00012AVA\u0012\u0013\r\t)C\u000f\u0002\b\u0005>|G.Z1o\u000311\u0018\r\\5eCR,w\fJ3r)\r!\u00181\u0006\u0005\tqF\t\t\u00111\u0001\u0002\"\u0005Ia/\u00197jI\u0006$X\r\t\u0015\u000f%m\fY!!\r\u0002\u0014\u0005]\u00121HA\u001fY\t\t\u0019$\t\u0002\u00026\u0005QQ&\f<bY&$\u0017\r^3\"\u0005\u0005e\u0012A\b,bY&$\u0017\r^3!\u0011\u001aKG.Z:!E\u00164wN]3!Y>\fG-\u001b8h\u0003\u0015\t'/\u001b;z;\u0005\t\u0001fB\u0006\u0002B\u0005\u001d\u0013\u0011\n\t\u0004y\u0006\r\u0013bAA#{\nQ\u0001+\u0019:b[\u0016$XM]:\u0002%\r|W.\\1oI\u0012+7o\u0019:jaRLwN\\\u0011\u0003\u0003\u0017\n1DQ;mW\u0002bw.\u00193!\u0011\u001aKG.Z:!S:$x\u000e\t%CCN,\u0017a\u00029be\u0006l7\u000fI\u0001\bKb,7-\u001e;f)\u0005!\u0018a\u0001:v]R\u0019A/a\u0016\t\u000f\u0005es\u00011\u0001\u0002\\\u0005\u0011Am\u001d\t\u0005\u0003;\n\u0019'\u0004\u0002\u0002`)\u0019\u0011\u0011\r\r\u0002\t\u0011\fG/Y\u0005\u0005\u0003K\nyF\u0001\bI\u0005\u0006\u001cX\rR1uCN#xN]3")
public class HBaseBulkLoadCommand
implements HBaseDataStoreCommand {
    private final String name;
    private final BulkLoadParams params;

    @Override
    public Map<String, String> connection() {
        return HBaseDataStoreCommand.connection$(this);
    }

    public <T> T withDataStore(Function1<HBaseDataStore, T> method) throws ParameterException {
        return (T)package.DataStoreCommand.withDataStore$((package.DataStoreCommand)this, method);
    }

    public DataStore loadDataStore() throws ParameterException {
        return package.DataStoreCommand.loadDataStore$((package.DataStoreCommand)this);
    }

    public Seq<package.Command> subCommands() {
        return package.Command.subCommands$((package.Command)this);
    }

    public Option<ParameterException> validate() {
        return package.Command.validate$((package.Command)this);
    }

    public void run() {
        package.Command.run$((package.Command)this);
    }

    public String name() {
        return this.name;
    }

    @Override
    public BulkLoadParams params() {
        return this.params;
    }

    public void execute() {
        this.withDataStore((Function1 & Serializable & scala.Serializable)ds -> {
            this.run(ds);
            return BoxedUnit.UNIT;
        });
    }

    public void run(HBaseDataStore ds) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        SimpleFeatureType sft = ds.getSchema(this.params().featureName());
        if (sft == null) {
            throw new ParameterException(new StringBuilder(24).append("Schema '").append(this.params().featureName()).append("' does not exist").toString());
        }
        Predef$.MODULE$.require(!TablePartition$.MODULE$.partitioned(sft), (Function0 & Serializable & scala.Serializable)() -> "Bulk loading partitioned tables is not currently supported");
        GeoMesaFeatureIndex<?, ?> index = this.params().loadIndex(ds, sft.getTypeName(), IndexMode$.MODULE$.Write());
        Path input = new Path(this.params().input());
        if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package.Command$.MODULE$.user().underlying().info("Running HBase incremental load...");
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long start = System.currentTimeMillis();
        TableName tableName = TableName.valueOf((String)index.getTableName(index.getTableName$default$1()));
        Table table = ds.connection().getTable(tableName);
        RegionLocator locator = ds.connection().getRegionLocator(tableName);
        Configuration config = new Configuration();
        config.set("hbase.loadincremental.validate.hfile", Boolean.toString(this.params().validate()));
        LoadIncrementalHFiles load = new LoadIncrementalHFiles(config);
        Method method = load.getClass().getMethod("doBulkLoad", Path.class, Admin.class, Table.class, RegionLocator.class);
        method.invoke((Object)load, input, ds.connection().getAdmin(), table, locator);
        if (package.Command$.MODULE$.user().underlying().isInfoEnabled()) {
            package.Command$.MODULE$.user().underlying().info("HBase incremental load complete in {}", new Object[]{TextTools$.MODULE$.getTime(start)});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public HBaseBulkLoadCommand() {
        package.Command.$init$((package.Command)this);
        package.DataStoreCommand.$init$((package.DataStoreCommand)this);
        HBaseDataStoreCommand.$init$(this);
        this.name = "bulk-load";
        this.params = new BulkLoadParams();
    }

    @Parameters(commandDescription="Bulk load HFiles into HBase")
    public static class BulkLoadParams
    implements HBaseDataStoreCommand.HBaseParams,
    RequiredTypeNameParam,
    RequiredIndexParam,
    HBaseDataStoreCommand.RemoteFilterNotUsedParam {
        @Parameter(names={"--input"}, description="Path to HFiles to be loaded", required=true)
        private String input;
        @Parameter(names={"--validate"}, description="Validate HFiles before loading", arity=1)
        private boolean validate;
        @Parameter(names={"--index"}, description="Specify a particular GeoMesa index", required=true)
        private String index;
        @Parameter(names={"-f", "--feature-name"}, description="Simple Feature Type name on which to operate", required=true)
        private String featureName;
        @Parameter(names={"--secure"}, description="Enable HBase security (visibilities)")
        private boolean secure;
        @Parameter(names={"--authorizations"}, description="Authorizations used for querying, comma-delimited")
        private String auths;
        @Parameter(names={"-z", "--zookeepers"}, description="Zookeepers (host[:port], comma separated)")
        private String zookeepers;
        @Parameter(names={"-c", "--catalog"}, description="Catalog table for GeoMesa datastore", required=true)
        private String catalog;

        @Override
        public boolean noRemote() {
            return HBaseDataStoreCommand.RemoteFilterNotUsedParam.noRemote$(this);
        }

        public <DS extends GeoMesaDataStore<DS>> GeoMesaFeatureIndex<?, ?> loadIndex(DS ds, String typeName, IndexMode.IndexMode mode) throws ParameterException {
            return RequiredIndexParam.loadIndex$((RequiredIndexParam)this, ds, (String)typeName, (IndexMode.IndexMode)mode);
        }

        public String index() {
            return this.index;
        }

        public void index_$eq(String x$1) {
            this.index = x$1;
        }

        public String featureName() {
            return this.featureName;
        }

        public void featureName_$eq(String x$1) {
            this.featureName = x$1;
        }

        @Override
        public boolean secure() {
            return this.secure;
        }

        @Override
        public void secure_$eq(boolean x$1) {
            this.secure = x$1;
        }

        @Override
        public String auths() {
            return this.auths;
        }

        @Override
        public void auths_$eq(String x$1) {
            this.auths = x$1;
        }

        public String zookeepers() {
            return this.zookeepers;
        }

        public void zookeepers_$eq(String x$1) {
            this.zookeepers = x$1;
        }

        public String catalog() {
            return this.catalog;
        }

        public void catalog_$eq(String x$1) {
            this.catalog = x$1;
        }

        public String input() {
            return this.input;
        }

        public void input_$eq(String x$1) {
            this.input = x$1;
        }

        public boolean validate() {
            return this.validate;
        }

        public void validate_$eq(boolean x$1) {
            this.validate = x$1;
        }

        public BulkLoadParams() {
            CatalogParam.$init$((CatalogParam)this);
            OptionalZookeepersParam.$init$((OptionalZookeepersParam)this);
            HBaseDataStoreCommand.HBaseParams.$init$(this);
            RequiredTypeNameParam.$init$((RequiredTypeNameParam)this);
            RequiredIndexParam.$init$((RequiredIndexParam)this);
            HBaseDataStoreCommand.RemoteFilterNotUsedParam.$init$(this);
            this.validate = true;
        }
    }
}

