/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.jobs.mapreduce;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.SeekableByteChannel;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.geotools.data.FeatureReader;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.simple.DelegateSimpleFeatureReader;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.convert.EvaluationContext;
import org.locationtech.geomesa.convert.EvaluationContext$;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter;
import org.locationtech.geomesa.convert2.SimpleFeatureConverter$;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat$;
import org.locationtech.geomesa.jobs.mapreduce.ConverterInputFormat$ConverterCounters$;
import org.locationtech.geomesa.jobs.mapreduce.FileStreamInputFormat$;
import org.locationtech.geomesa.jobs.mapreduce.FileStreamRecordReader;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.collection.CloseableIterator$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.fs.package;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\u0006\r\u0001]AQA\n\u0001\u0005\u0002\u001dBQ!\u000b\u0001\u0005B)2Aa\u001b\u0001\u0001Y\"AQo\u0001B\u0001B\u0003%a\u000fC\u0003'\u0007\u0011\u0005\u0001\u0010C\u0003}\u0007\u0011\u0005S\u0010\u0003\u0004}\u0007\u0011\u0005\u0013Q\u0001\u0005\u0007\u0003#\u0019A\u0011I?\t\u000f\u0005E1\u0001\"\u0011\u0002\u0014!9\u0011qC\u0002\u0005B\u0005e!!F\"p]Z,'\u000f^3s%\u0016\u001cwN\u001d3SK\u0006$WM\u001d\u0006\u0003\u001b9\t\u0011\"\\1qe\u0016$WoY3\u000b\u0005=\u0001\u0012\u0001\u00026pENT!!\u0005\n\u0002\u000f\u001d,w.\\3tC*\u00111\u0003F\u0001\rY>\u001c\u0017\r^5p]R,7\r\u001b\u0006\u0002+\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0007\u000f\u0011\u0005eQR\"\u0001\u0007\n\u0005ma!A\u0006$jY\u0016\u001cFO]3b[J+7m\u001c:e%\u0016\fG-\u001a:\u0011\u0005u!S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001D:dC2\fGn\\4hS:<'BA\u0011#\u0003!!\u0018\u0010]3tC\u001a,'\"A\u0012\u0002\u0007\r|W.\u0003\u0002&=\tYA*\u0019>z\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002\u001a\u0001\u0005q1M]3bi\u0016LE/\u001a:bi>\u0014H\u0003B\u0016O?\u0012\u00142\u0001\f\u0018G\r\u0011i\u0003\u0001A\u0016\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007=JDH\u0004\u00021m9\u0011\u0011\u0007N\u0007\u0002e)\u00111GF\u0001\u0007yI|w\u000e\u001e \n\u0003U\nQa]2bY\u0006L!a\u000e\u001d\u0002\u000fA\f7m[1hK*\tQ'\u0003\u0002;w\tA\u0011\n^3sCR|'O\u0003\u00028qA\u0011Q\bR\u0007\u0002})\u0011q\bQ\u0001\u0007g&l\u0007\u000f\\3\u000b\u0005\u0005\u0013\u0015a\u00024fCR,(/\u001a\u0006\u0003\u0007R\tqa\u001c9f]\u001eL7/\u0003\u0002F}\ti1+[7qY\u00164U-\u0019;ve\u0016\u0004\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\u0005%|'\"A&\u0002\t)\fg/Y\u0005\u0003\u001b\"\u0013\u0011b\u00117pg\u0016\f'\r\\3\t\u000b=\u0013\u0001\u0019\u0001)\u0002\rM$(/Z1n%\r\t&+\u0016\u0004\u0005[\u0001\u0001\u0001\u000b\u0005\u0002H'&\u0011A\u000b\u0013\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0002W;6\tqK\u0003\u0002Y3\u0006\u0011am\u001d\u0006\u00035n\u000ba\u0001[1e_>\u0004(B\u0001/\u0015\u0003\u0019\t\u0007/Y2iK&\u0011al\u0016\u0002\t'\u0016,7.\u00192mK\")\u0001M\u0001a\u0001C\u0006Aa-\u001b7f!\u0006$\b\u000e\u0005\u0002WE&\u00111m\u0016\u0002\u0005!\u0006$\b\u000eC\u0003f\u0005\u0001\u0007a-A\u0004d_:$X\r\u001f;\u0011\u0005\u001dLW\"\u00015\u000b\u00055I\u0016B\u00016i\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0003!5\u000b\u0007OU3ek\u000e,7i\\;oi\u0016\u00148CA\u0002n!\tq7/D\u0001p\u0015\t\u0001\u0018/A\u0004nKR\u0014\u0018nY:\u000b\u0005I\u0014\u0013\u0001C2pI\u0006D\u0017\r\\3\n\u0005Q|'aB\"pk:$XM]\u0001\bG>,h\u000e^3s!\t9w/\u0003\u0002uQR\u0011\u0011p\u001f\t\u0003u\u000ei\u0011\u0001\u0001\u0005\u0006k\u0016\u0001\rA^\u0001\u0004S:\u001cG#\u0001@\u0011\u0007}\f\t!D\u00019\u0013\r\t\u0019\u0001\u000f\u0002\u0005+:LG\u000fF\u0002\u007f\u0003\u000fAq!!\u0003\b\u0001\u0004\tY!A\u0001o!\ry\u0018QB\u0005\u0004\u0003\u001fA$\u0001\u0002'p]\u001e\f1\u0001Z3d)\rq\u0018Q\u0003\u0005\b\u0003\u0013I\u0001\u0019AA\u0006\u0003!9W\r^\"pk:$HCAA\u0006\u0001")
public class ConverterRecordReader
extends FileStreamRecordReader {
    @Override
    public Iterator<SimpleFeature> createIterator(InputStream stream, Path filePath, TaskAttemptContext context) {
        BoxedUnit boxedUnit;
        DelegateSimpleFeatureReader featureReader;
        DelegateSimpleFeatureReader delegateSimpleFeatureReader;
        CloseableIterator closeableIterator;
        package.ArchiveFileIterator archiveFileIterator;
        LazyRef defaultEc$lzy = new LazyRef();
        String confStr = context.getConfiguration().get(ConverterInputFormat$.MODULE$.ConverterKey());
        Config conf = ConfigFactory.parseString((String)confStr);
        SimpleFeatureType sft = FileStreamInputFormat$.MODULE$.getSft(context.getConfiguration());
        SimpleFeatureConverter converter = SimpleFeatureConverter$.MODULE$.apply(sft, conf);
        Option filter = GeoMesaConfigurator$.MODULE$.getFilter(context.getConfiguration()).map((Function1 & Serializable & scala.Serializable)x$1 -> ECQL.toFilter((String)x$1));
        String retypedSpec = context.getConfiguration().get(ConverterInputFormat$.MODULE$.RetypeKey());
        String string = PathUtils$.MODULE$.getUncompressedExtension(filePath.getName()).toLowerCase(Locale.US);
        if ("tar".equals(string)) {
            ArchiveInputStream archive = new ArchiveStreamFactory().createArchiveInputStream("tar", stream);
            archiveFileIterator = new package.ArchiveFileIterator(archive, filePath.toString());
        } else if ("zip".equals(string) ? true : "jar".equals(string)) {
            SeekableInMemoryByteChannel bytes = new SeekableInMemoryByteChannel(IOUtils.toByteArray((InputStream)stream));
            archiveFileIterator = new package.ZipFileIterator(new ZipFile((SeekableByteChannel)bytes), filePath.toString());
        } else {
            archiveFileIterator = CloseableIterator$.MODULE$.single((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)None$.MODULE$), (Object)stream), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> stream.close());
        }
        package.ArchiveFileIterator streams = archiveFileIterator;
        CloseableIterator all = streams.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option name = (Option)tuple2._1();
                InputStream is = (InputStream)tuple2._2();
                return converter.process(is, (EvaluationContext)name.map((Function1 & Serializable & scala.Serializable)path -> this.ec$1((String)path, context, converter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultEc$1(defaultEc$lzy, filePath, context, converter)));
            }
            throw new MatchError((Object)tuple2);
        });
        Option option = filter;
        if (option instanceof Some) {
            Some some = (Some)option;
            Filter f = (Filter)some.value();
            closeableIterator = all.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)f.evaluate(x$1)));
        } else if (None$.MODULE$.equals(option)) {
            closeableIterator = all;
        } else {
            throw new MatchError((Object)option);
        }
        CloseableIterator iter = closeableIterator;
        if (retypedSpec != null) {
            SimpleFeatureType retypedSft = SimpleFeatureTypes$.MODULE$.createType(sft.getTypeName(), retypedSpec);
            DelegateSimpleFeatureReader reader = new DelegateSimpleFeatureReader(sft, (SimpleFeatureIterator)new DelegateSimpleFeatureIterator((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter((Iterator)iter).asJava()));
            delegateSimpleFeatureReader = new ReTypeFeatureReader((FeatureReader)reader, retypedSft);
        } else {
            delegateSimpleFeatureReader = featureReader = new DelegateSimpleFeatureReader(sft, (SimpleFeatureIterator)new DelegateSimpleFeatureIterator((java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter((Iterator)iter).asJava()));
        }
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new java.lang.StringBuilder(69).append("Initialized record reader on split ").append(filePath.toString()).append(" with ").append("type name ").append(sft.getTypeName()).append(" and convert conf ").append(confStr).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new Iterator<SimpleFeature>(null, (FeatureReader)featureReader, iter, converter){
            private final FeatureReader featureReader$1;
            private final CloseableIterator iter$1;
            private final SimpleFeatureConverter converter$1;

            public Iterator<SimpleFeature> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<SimpleFeature> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<SimpleFeature> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<SimpleFeature> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<SimpleFeature> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<SimpleFeature, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<SimpleFeature, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<SimpleFeature> filter(Function1<SimpleFeature, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<SimpleFeature, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<SimpleFeature> withFilter(Function1<SimpleFeature, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<SimpleFeature> filterNot(Function1<SimpleFeature, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<SimpleFeature, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, SimpleFeature, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<SimpleFeature, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<SimpleFeature> takeWhile(Function1<SimpleFeature, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> partition(Function1<SimpleFeature, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> span(Function1<SimpleFeature, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<SimpleFeature> dropWhile(Function1<SimpleFeature, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<SimpleFeature, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<SimpleFeature, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<SimpleFeature, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<SimpleFeature, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<SimpleFeature, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<SimpleFeature> find(Function1<SimpleFeature, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<SimpleFeature, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<SimpleFeature, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<SimpleFeature> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<SimpleFeature>, Iterator<SimpleFeature>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<SimpleFeature> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<SimpleFeature> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<SimpleFeature> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public List<SimpleFeature> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<SimpleFeature, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<SimpleFeature, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, SimpleFeature, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<SimpleFeature, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, SimpleFeature, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<SimpleFeature, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, SimpleFeature, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<SimpleFeature, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, SimpleFeature, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<SimpleFeature, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, SimpleFeature, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<SimpleFeature> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<SimpleFeature> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<SimpleFeature> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<SimpleFeature> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<SimpleFeature> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, SimpleFeature, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef$.less.colon.less<SimpleFeature, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public boolean hasNext() {
                return this.featureReader$1.hasNext();
            }

            public SimpleFeature next() {
                return (SimpleFeature)this.featureReader$1.next();
            }

            public void close() {
                package.CloseWithLogging$.MODULE$.apply((Object)this.featureReader$1, IsCloseable$.MODULE$.closeableIsCloseable());
                package.CloseWithLogging$.MODULE$.apply((Object)this.iter$1, IsCloseable$.MODULE$.closeableIsCloseable());
                package.CloseWithLogging$.MODULE$.apply((Object)this.converter$1, IsCloseable$.MODULE$.closeableIsCloseable());
            }
            {
                this.featureReader$1 = featureReader$1;
                this.iter$1 = iter$1;
                this.converter$1 = converter$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }
        };
    }

    private final EvaluationContext ec$1(String path, TaskAttemptContext context$1, SimpleFeatureConverter converter$1) {
        MapReduceCounter success = new MapReduceCounter(this, context$1.getCounter(ConverterInputFormat$ConverterCounters$.MODULE$.Group(), ConverterInputFormat$ConverterCounters$.MODULE$.Converted()));
        MapReduceCounter failure = new MapReduceCounter(this, context$1.getCounter(ConverterInputFormat$ConverterCounters$.MODULE$.Group(), ConverterInputFormat$ConverterCounters$.MODULE$.Failed()));
        return converter$1.createEvaluationContext(EvaluationContext$.MODULE$.inputFileParam(path), (com.codahale.metrics.Counter)success, (com.codahale.metrics.Counter)failure);
    }

    private final /* synthetic */ EvaluationContext defaultEc$lzycompute$1(LazyRef defaultEc$lzy$1, Path filePath$1, TaskAttemptContext context$1, SimpleFeatureConverter converter$1) {
        EvaluationContext evaluationContext;
        LazyRef lazyRef = defaultEc$lzy$1;
        synchronized (lazyRef) {
            evaluationContext = defaultEc$lzy$1.initialized() ? (EvaluationContext)defaultEc$lzy$1.value() : (EvaluationContext)defaultEc$lzy$1.initialize((Object)this.ec$1(filePath$1.toString(), context$1, converter$1));
        }
        return evaluationContext;
    }

    private final EvaluationContext defaultEc$1(LazyRef defaultEc$lzy$1, Path filePath$1, TaskAttemptContext context$1, SimpleFeatureConverter converter$1) {
        if (defaultEc$lzy$1.initialized()) {
            return (EvaluationContext)defaultEc$lzy$1.value();
        }
        return this.defaultEc$lzycompute$1(defaultEc$lzy$1, filePath$1, context$1, converter$1);
    }

    public class MapReduceCounter
    extends com.codahale.metrics.Counter {
        private final Counter counter;
        public final /* synthetic */ ConverterRecordReader $outer;

        public void inc() {
            this.counter.increment(1L);
        }

        public void inc(long n) {
            this.counter.increment(n);
        }

        public void dec() {
            this.counter.increment(-1L);
        }

        public void dec(long n) {
            this.counter.increment(-1L * n);
        }

        public long getCount() {
            return this.counter.getValue();
        }

        public /* synthetic */ ConverterRecordReader org$locationtech$geomesa$jobs$mapreduce$ConverterRecordReader$MapReduceCounter$$$outer() {
            return this.$outer;
        }

        public MapReduceCounter(ConverterRecordReader $outer, Counter counter) {
            this.counter = counter;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

