/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.geotools.api.feature.simple.SimpleFeature;
import scala.Option;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ee!\u0002\u000e\u001c\u0003\u00031\u0003\"\u0002'\u0001\t\u0003i\u0005\"\u0003)\u0001\u0001\u0004\u0005\r\u0011\"\u0003R\u0011%A\u0006\u00011AA\u0002\u0013%\u0011\fC\u0005c\u0001\u0001\u0007\t\u0011)Q\u0005%\"I1\r\u0001a\u0001\u0002\u0004%I\u0001\u001a\u0005\nk\u0002\u0001\r\u00111A\u0005\nYD\u0011B\u001f\u0001A\u0002\u0003\u0005\u000b\u0015B3\t\u0013m\u0004\u0001\u0019!a\u0001\n\u0013a\bbCA\u000f\u0001\u0001\u0007\t\u0019!C\u0005\u0003?A!\"a\n\u0001\u0001\u0004\u0005\t\u0015)\u0003~\u0011%\tI\u0003\u0001a\u0001\n\u0013\tY\u0003C\u0005\u00024\u0001\u0001\r\u0011\"\u0003\u00026!A\u0011\u0011\b\u0001!B\u0013\ti\u0003C\u0005\u0002<\u0001\u0011\r\u0011\"\u0003\u0002>!9\u0011q\b\u0001!\u0002\u0013\u0001\u0004bCA!\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007B1\"!\u0012\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002H!Q\u00111\n\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001c\t\u000f\u00055\u0003A\"\u0001\u0002P!9\u0011q\u000e\u0001\u0005B\u0005E\u0004bBA:\u0001\u0011\u0005\u0013Q\u000f\u0005\b\u0003{\u0002A\u0011IA@\u0011\u001d\t\t\t\u0001C!\u0003\u0007Cq!!%\u0001\t\u0003\n\u0019\nC\u0004\u0002\u0016\u0002!\t%a&\u0003-\u0019KG.Z*ue\u0016\fWNU3d_J$'+Z1eKJT!\u0001H\u000f\u0002\u00135\f\u0007O]3ek\u000e,'B\u0001\u0010 \u0003\u0011QwNY:\u000b\u0005\u0001\n\u0013aB4f_6,7/\u0019\u0006\u0003E\r\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0004\u0001\u001d\u0012\u0005\u0003\u0002\u0015/aYj\u0011!\u000b\u0006\u00039)R!a\u000b\u0017\u0002\r!\fGm\\8q\u0015\ti3%\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003_%\u0012ABU3d_J$'+Z1eKJ\u0004\"!\r\u001b\u000e\u0003IR!a\r\u0016\u0002\u0005%|\u0017BA\u001b3\u00051auN\\4Xe&$\u0018M\u00197f!\t9\u0004)D\u00019\u0015\tI$(\u0001\u0004tS6\u0004H.\u001a\u0006\u0003wq\nqAZ3biV\u0014XM\u0003\u0002>}\u0005\u0019\u0011\r]5\u000b\u0005}\u001a\u0013\u0001C4f_R|w\u000e\\:\n\u0005\u0005C$!D*j[BdWMR3biV\u0014X\r\u0005\u0002D\u00156\tAI\u0003\u0002F\r\u0006a1oY1mC2|wmZ5oO*\u0011q\tS\u0001\tif\u0004Xm]1gK*\t\u0011*A\u0002d_6L!a\u0013#\u0003\u00171\u000b'0\u001f'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0003\"a\u0014\u0001\u000e\u0003m\t1\u0001Z3d+\u0005\u0011\u0006CA*W\u001b\u0005!&BA+3\u0003!\u0019w.\u001c9sKN\u001c\u0018BA,U\u00051!UmY8naJ,7o]8s\u0003\u001d!WmY0%KF$\"A\u00171\u0011\u0005msV\"\u0001/\u000b\u0003u\u000bQa]2bY\u0006L!a\u0018/\u0003\tUs\u0017\u000e\u001e\u0005\bC\u000e\t\t\u00111\u0001S\u0003\rAH%M\u0001\u0005I\u0016\u001c\u0007%\u0001\u0004tiJ,\u0017-\\\u000b\u0002KJ\u0019a\r[8\u0007\t\u001d\u0004\u0001!\u001a\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0003S6l\u0011A\u001b\u0006\u0003g-T\u0011\u0001\\\u0001\u0005U\u00064\u0018-\u0003\u0002oU\nY\u0011J\u001c9viN#(/Z1n!\t\u00018/D\u0001r\u0015\t\u0011(&\u0001\u0002gg&\u0011A/\u001d\u0002\t'\u0016,7.\u00192mK\u0006Q1\u000f\u001e:fC6|F%Z9\u0015\u0005i;\bbB1\u0007\u0003\u0003\u0005\r\u0001\u001f\n\u0004s\"|g\u0001B4\u0001\u0001a\fqa\u001d;sK\u0006l\u0007%\u0001\u0003ji\u0016\u0014X#A?\u0013\ty|\u0018q\u0003\u0004\u0005O\u0002\u0001Q\u0010E\u0003\u0002\u0002\u0005EaG\u0004\u0003\u0002\u0004\u00055a\u0002BA\u0003\u0003\u0017i!!a\u0002\u000b\u0007\u0005%Q%\u0001\u0004=e>|GOP\u0005\u0002;&\u0019\u0011q\u0002/\u0002\u000fA\f7m[1hK&!\u00111CA\u000b\u0005!IE/\u001a:bi>\u0014(bAA\b9B\u0019\u0011.!\u0007\n\u0007\u0005m!NA\u0005DY>\u001cX-\u00192mK\u0006A\u0011\u000e^3s?\u0012*\u0017\u000fF\u0002[\u0003CA\u0001\"Y\u0005\u0002\u0002\u0003\u0007\u00111\u0005\n\u0006\u0003Ky\u0018q\u0003\u0004\u0006O\u0002\u0001\u00111E\u0001\u0006SR,'\u000fI\u0001\u0007Y\u0016tw\r\u001e5\u0016\u0005\u00055\u0002cA.\u00020%\u0019\u0011\u0011\u0007/\u0003\u000b\u0019cw.\u0019;\u0002\u00151,gn\u001a;i?\u0012*\u0017\u000fF\u0002[\u0003oA\u0001\"\u0019\u0007\u0002\u0002\u0003\u0007\u0011QF\u0001\bY\u0016tw\r\u001e5!\u0003\u0019\u0019WO]&fsV\t\u0001'A\u0004dkJ\\U-\u001f\u0011\u0002\u0011\r,(OV1mk\u0016,\u0012AN\u0001\rGV\u0014h+\u00197vK~#S-\u001d\u000b\u00045\u0006%\u0003bB1\u0012\u0003\u0003\u0005\rAN\u0001\nGV\u0014h+\u00197vK\u0002\nab\u0019:fCR,\u0017\n^3sCR|'\u000f\u0006\u0005\u0002R\u0005U\u00131LA3%\u0015\t\u0019f`A\f\r\u00159\u0007\u0001AA)\u0011\u0019\u00197\u00031\u0001\u0002XI!\u0011\u0011\f5p\r\u00159\u0007\u0001AA,\u0011\u001d\tif\u0005a\u0001\u0003?\n\u0001BZ5mKB\u000bG\u000f\u001b\t\u0004a\u0006\u0005\u0014bAA2c\n!\u0001+\u0019;i\u0011\u001d\t9g\u0005a\u0001\u0003S\nqaY8oi\u0016DH\u000fE\u0002)\u0003WJ1!!\u001c*\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;\u0002\u0017\u001d,G\u000f\u0015:pOJ,7o\u001d\u000b\u0003\u0003[\tAB\\3yi.+\u0017PV1mk\u0016$\"!a\u001e\u0011\u0007m\u000bI(C\u0002\u0002|q\u0013qAQ8pY\u0016\fg.A\bhKR\u001cUO\u001d:f]R4\u0016\r\\;f)\u00051\u0014AC5oSRL\u0017\r\\5{KR)!,!\"\u0002\u0010\"9\u0011qQ\fA\u0002\u0005%\u0015!B:qY&$\bc\u0001\u0015\u0002\f&\u0019\u0011QR\u0015\u0003\u0015%s\u0007/\u001e;Ta2LG\u000fC\u0004\u0002h]\u0001\r!!\u001b\u0002\u001b\u001d,GoQ;se\u0016tGoS3z)\u0005\u0001\u0014!B2m_N,G#\u0001.")
public abstract class FileStreamRecordReader
extends RecordReader<LongWritable, SimpleFeature>
implements LazyLogging {
    private Decompressor dec;
    private InputStream stream;
    private Iterator<SimpleFeature> iter;
    private float length;
    private final LongWritable curKey;
    private SimpleFeature curValue;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        FileStreamRecordReader fileStreamRecordReader = this;
        synchronized (fileStreamRecordReader) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Decompressor dec() {
        return this.dec;
    }

    private void dec_$eq(Decompressor x$1) {
        this.dec = x$1;
    }

    private InputStream stream() {
        return this.stream;
    }

    private void stream_$eq(InputStream x$1) {
        this.stream = x$1;
    }

    private Iterator<SimpleFeature> iter() {
        return this.iter;
    }

    private void iter_$eq(Iterator<SimpleFeature> x$1) {
        this.iter = x$1;
    }

    private float length() {
        return this.length;
    }

    private void length_$eq(float x$1) {
        this.length = x$1;
    }

    private LongWritable curKey() {
        return this.curKey;
    }

    private SimpleFeature curValue() {
        return this.curValue;
    }

    private void curValue_$eq(SimpleFeature x$1) {
        this.curValue = x$1;
    }

    public abstract Iterator<SimpleFeature> createIterator(InputStream var1, Path var2, TaskAttemptContext var3);

    public float getProgress() {
        float f;
        if (this.length() == 0.0f) {
            return 0.0f;
        }
        try {
            f = package$.MODULE$.min(1.0f, (float)((Seekable)this.stream()).getPos() / this.length());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error checking stream position - it may be closed? {}", new Object[]{e});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                f = 1.0f;
            }
            throw throwable;
        }
        return f;
    }

    public boolean nextKeyValue() {
        if (this.iter().hasNext()) {
            this.curKey().set(this.curKey().get() + 1L);
            this.curValue_$eq((SimpleFeature)this.iter().next());
            return true;
        }
        return false;
    }

    public SimpleFeature getCurrentValue() {
        return this.curValue();
    }

    public void initialize(InputSplit split, TaskAttemptContext context) {
        BoxedUnit boxedUnit;
        FSDataInputStream fSDataInputStream;
        Configuration job = context.getConfiguration();
        Path path = ((FileSplit)split).getPath();
        CompressionCodec codec = new CompressionCodecFactory(job).getCodec(path);
        FileSystem fs = path.getFileSystem(job);
        this.length_$eq(split.getLength());
        if (codec != null) {
            this.dec_$eq(CodecPool.getDecompressor((CompressionCodec)codec));
            fSDataInputStream = codec.createInputStream((InputStream)fs.open(path), this.dec());
        } else {
            fSDataInputStream = fs.open(path);
        }
        this.stream_$eq((InputStream)fSDataInputStream);
        this.iter_$eq(this.createIterator(this.stream(), path, context));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Initialized record reader on split {}", new Object[]{path.toString()});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public LongWritable getCurrentKey() {
        return this.curKey();
    }

    public void close() {
        IOUtils.closeQuietly((Closeable)((Closeable)this.iter()));
        IOUtils.closeQuietly((InputStream)this.stream());
        if (this.dec() != null) {
            CodecPool.returnDecompressor((Decompressor)this.dec());
            return;
        }
    }

    public FileStreamRecordReader() {
        LazyLogging.$init$((LazyLogging)this);
        this.length = 0.0f;
        this.curKey = new LongWritable(0L);
    }
}

