/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat$OutputCounters$;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t-a\u0001\u0002\u0013&\u0001ABQA\u0013\u0001\u0005\u0002-CQA\u0014\u0001\u0005B=CQ\u0001\u0017\u0001\u0005BeCQ\u0001\u001a\u0001\u0005B\u0015<QA[\u0013\t\u0002-4Q\u0001J\u0013\t\u00021DQA\u0013\u0004\u0005\u0002A<Q!\u001d\u0004\t\u0002I4Q\u0001\u001e\u0004\t\u0002UDQAS\u0005\u0005\u0002YDqa^\u0005C\u0002\u0013\u0005\u0001\u0010C\u0004\u0002\u0004%\u0001\u000b\u0011B=\t\u0011\u0005\u0015\u0011B1A\u0005\u0002aDq!a\u0002\nA\u0003%\u0011\u0010\u0003\u0005\u0002\n%\u0011\r\u0011\"\u0001y\u0011\u001d\tY!\u0003Q\u0001\neDq!!\u0004\u0007\t\u0003\ty\u0001C\u0005\u0002d\u0019\t\n\u0011\"\u0001\u0002f!9\u00111\u0010\u0004\u0005\u0002\u0005udABAH\r\u0001\t\t\n\u0003\u0006\u0002\"Q\u0011\t\u0011)A\u0005\u0003GA!\"!\u0013\u0015\u0005\u0003\u0005\u000b\u0011BA&\u0011!!FC!A!\u0002\u0013)\u0006B\u0002&\u0015\t\u0003\t9\u000bC\u0005\u00022R\u0011\r\u0011\"\u0003\u00024\"A\u0011Q\u0019\u000b!\u0002\u0013\t)\fC\u0005\u0002HR\u0011\r\u0011\"\u0003\u0002J\"A\u0011q\u001c\u000b!\u0002\u0013\tY\rC\u0005\u0002bR\u0011\r\u0011\"\u0003\u0002d\"A\u00111\u001e\u000b!\u0002\u0013\t)\u000fC\u0005\u0002nR\u0011\r\u0011\"\u0003\u0002d\"A\u0011q\u001e\u000b!\u0002\u0013\t)\u000fC\u0004\u0002rR!\t%a=\t\u000f\u0005uH\u0003\"\u0003\u0002\u0000\"9!Q\u0001\u000b\u0005B\t\u001d!aE$f_6+7/Y(viB,HOR8s[\u0006$(B\u0001\u0014(\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002)S\u0005!!n\u001c2t\u0015\tQ3&A\u0004hK>lWm]1\u000b\u00051j\u0013\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0004\u0003\u0002\u001a9u\u0001k\u0011a\r\u0006\u0003MQR!!\u000e\u001c\u0002\r!\fGm\\8q\u0015\t9T&\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003sM\u0012AbT;uaV$hi\u001c:nCR\u0004\"a\u000f \u000e\u0003qR!!\u0010\u001b\u0002\u0005%|\u0017BA =\u0005\u0011!V\r\u001f;\u0011\u0005\u0005CU\"\u0001\"\u000b\u0005\r#\u0015AB:j[BdWM\u0003\u0002F\r\u00069a-Z1ukJ,'BA$.\u0003\u001dy\u0007/\u001a8hSNL!!\u0013\"\u0003\u001bMKW\u000e\u001d7f\r\u0016\fG/\u001e:f\u0003\u0019a\u0014N\\5u}Q\tA\n\u0005\u0002N\u00015\tQ%A\bhKR\u0014VmY8sI^\u0013\u0018\u000e^3s)\t\u00016\u000b\u0005\u00033#j\u0002\u0015B\u0001*4\u00051\u0011VmY8sI^\u0013\u0018\u000e^3s\u0011\u0015!&\u00011\u0001V\u0003\u001d\u0019wN\u001c;fqR\u0004\"A\r,\n\u0005]\u001b$A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqR\f\u0001c\u00195fG.|U\u000f\u001e9viN\u0003XmY:\u0015\u0005i\u0003\u0007CA._\u001b\u0005a&\"A/\u0002\u000bM\u001c\u0017\r\\1\n\u0005}c&\u0001B+oSRDQ\u0001V\u0002A\u0002\u0005\u0004\"A\r2\n\u0005\r\u001c$A\u0003&pE\u000e{g\u000e^3yi\u0006\u0011r-\u001a;PkR\u0004X\u000f^\"p[6LG\u000f^3s)\t1\u0017\u000e\u0005\u00023O&\u0011\u0001n\r\u0002\u0010\u001fV$\b/\u001e;D_6l\u0017\u000e\u001e;fe\")A\u000b\u0002a\u0001+\u0006\u0019r)Z8NKN\fw*\u001e;qkR4uN]7biB\u0011QJB\n\u0003\r5\u0004\"a\u00178\n\u0005=d&AB!osJ+g\rF\u0001l\u00039yU\u000f\u001e9vi\u000e{WO\u001c;feN\u0004\"a]\u0005\u000e\u0003\u0019\u0011abT;uaV$8i\\;oi\u0016\u00148o\u0005\u0002\n[R\t!/A\u0003He>,\b/F\u0001z!\tQx0D\u0001|\u0015\taX0\u0001\u0003mC:<'\"\u0001@\u0002\t)\fg/Y\u0005\u0004\u0003\u0003Y(AB*ue&tw-\u0001\u0004He>,\b\u000fI\u0001\b/JLG\u000f^3o\u0003!9&/\u001b;uK:\u0004\u0013A\u0002$bS2,G-A\u0004GC&dW\r\u001a\u0011\u0002\u0013M,GoT;uaV$H#\u0003.\u0002\u0012\u0005}\u0011QHA$\u0011\u001d\t\u0019\"\u0005a\u0001\u0003+\tAaY8oMB!\u0011qCA\u000e\u001b\t\tIBC\u0002\u0002\u0014QJA!!\b\u0002\u001a\ti1i\u001c8gS\u001e,(/\u0019;j_:Dq!!\t\u0012\u0001\u0004\t\u0019#\u0001\u0004qCJ\fWn\u001d\t\t\u0003K\t\u0019$!\u000f\u0002:9!\u0011qEA\u0018!\r\tI\u0003X\u0007\u0003\u0003WQ1!!\f0\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0007/\u0002\rA\u0013X\rZ3g\u0013\u0011\t)$a\u000e\u0003\u00075\u000b\u0007OC\u0002\u00022q\u0003B!!\n\u0002<%!\u0011\u0011AA\u001c\u0011\u001d\ty$\u0005a\u0001\u0003\u0003\n1a\u001d4u!\r\t\u00151I\u0005\u0004\u0003\u000b\u0012%!E*j[BdWMR3biV\u0014X\rV=qK\"I\u0011\u0011J\t\u0011\u0002\u0003\u0007\u00111J\u0001\bS:$\u0017nY3t!\u0015Y\u0016QJA)\u0013\r\ty\u0005\u0018\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r\u0005M\u0013QLA\u001d\u001d\u0011\t)&!\u0017\u000f\t\u0005%\u0012qK\u0005\u0002;&\u0019\u00111\f/\u0002\u000fA\f7m[1hK&!\u0011qLA1\u0005\r\u0019V-\u001d\u0006\u0004\u00037b\u0016aE:fi>+H\u000f];uI\u0011,g-Y;mi\u0012\"TCAA4U\u0011\tY%!\u001b,\u0005\u0005-\u0004\u0003BA7\u0003oj!!a\u001c\u000b\t\u0005E\u00141O\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001e]\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003s\nyGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQb]3u\u001fV$\b/\u001e;KCZ\fGc\u0002.\u0002\u0000\u0005\u0005\u0015Q\u0012\u0005\b\u0003'\u0019\u0002\u0019AA\u000b\u0011\u001d\t\tc\u0005a\u0001\u0003\u0007\u0003\u0002\"!\"\u0002\f\u0006e\u0012\u0011H\u0007\u0003\u0003\u000fS1!!#~\u0003\u0011)H/\u001b7\n\t\u0005U\u0012q\u0011\u0005\b\u0003\u007f\u0019\u0002\u0019AA!\u0005M9Um\\'fg\u0006\u0014VmY8sI^\u0013\u0018\u000e^3s'\u0011!\u0002+a%\u0011\t\u0005U\u00151U\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006a1oY1mC2|wmZ5oO*!\u0011QTAP\u0003!!\u0018\u0010]3tC\u001a,'BAAQ\u0003\r\u0019w.\\\u0005\u0005\u0003K\u000b9JA\u0006MCjLHj\\4hS:<G\u0003CAU\u0003W\u000bi+a,\u0011\u0005M$\u0002bBA\u00111\u0001\u0007\u00111\u0005\u0005\b\u0003\u0013B\u0002\u0019AA&\u0011\u0015!\u0006\u00041\u0001V\u0003\t!7/\u0006\u0002\u00026B!\u0011qWAa\u001b\t\tIL\u0003\u0003\u0002<\u0006u\u0016\u0001\u00023bi\u0006T1!a0.\u0003!9Wm\u001c;p_2\u001c\u0018\u0002BAb\u0003s\u0013\u0011\u0002R1uCN#xN]3\u0002\u0007\u0011\u001c\b%A\u0004xe&$XM]:\u0016\u0005\u0005-\u0007\u0003CAg\u0003/\fI$!7\u000e\u0005\u0005='\u0002BAi\u0003'\fq!\\;uC\ndWMC\u0002\u0002Vr\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)$a4\u0011\u000f\u0005]\u00161\\A!\u0001&!\u0011Q\\A]\u000551U-\u0019;ve\u0016<&/\u001b;fe\u0006AqO]5uKJ\u001c\b%A\u0004xe&$H/\u001a8\u0016\u0005\u0005\u0015\bc\u0001\u001a\u0002h&\u0019\u0011\u0011^\u001a\u0003\u000f\r{WO\u001c;fe\u0006AqO]5ui\u0016t\u0007%\u0001\u0004gC&dW\rZ\u0001\bM\u0006LG.\u001a3!\u0003\u00159(/\u001b;f)\u0015Q\u0016Q_A}\u0011\u0019\t90\ta\u0001u\u0005\u00191.Z=\t\r\u0005m\u0018\u00051\u0001A\u0003\u00151\u0018\r\\;f\u00031\u0019'/Z1uK^\u0013\u0018\u000e^3s)\u0011\tIN!\u0001\t\u000f\t\r!\u00051\u0001\u0002:\u0005AA/\u001f9f\u001d\u0006lW-A\u0003dY>\u001cX\rF\u0002[\u0005\u0013AQ\u0001V\u0012A\u0002U\u0003")
public class GeoMesaOutputFormat
extends OutputFormat<Text, SimpleFeature> {
    public static void setOutputJava(Configuration conf, Map<String, String> params, SimpleFeatureType sft) {
        GeoMesaOutputFormat$.MODULE$.setOutputJava(conf, params, sft);
    }

    public static Option<Seq<String>> setOutput$default$4() {
        return GeoMesaOutputFormat$.MODULE$.setOutput$default$4();
    }

    public static void setOutput(Configuration conf, scala.collection.immutable.Map<String, String> params, SimpleFeatureType sft, Option<Seq<String>> indices) {
        GeoMesaOutputFormat$.MODULE$.setOutput(conf, params, sft, indices);
    }

    public RecordWriter<Text, SimpleFeature> getRecordWriter(TaskAttemptContext context) {
        scala.collection.immutable.Map<String, String> params = GeoMesaConfigurator$.MODULE$.getDataStoreOutParams(context.getConfiguration());
        Option<Seq<String>> indices = GeoMesaConfigurator$.MODULE$.getIndicesOut(context.getConfiguration());
        return new GeoMesaRecordWriter(params, indices, context);
    }

    public void checkOutputSpecs(JobContext context) {
        Map params = (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(GeoMesaConfigurator$.MODULE$.getDataStoreOutParams(context.getConfiguration())).asJava();
        if (!((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(DataStoreFinder.getAvailableDataStores()).asScala()).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canProcess(params)))) {
            throw new IOException("Data store connection parameters are not set");
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return new NullOutputFormat().getOutputCommitter(context);
    }

    public static class GeoMesaRecordWriter
    extends RecordWriter<Text, SimpleFeature>
    implements LazyLogging {
        private final Option<Seq<String>> indices;
        private final DataStore ds;
        private final scala.collection.mutable.Map<String, FeatureWriter<SimpleFeatureType, SimpleFeature>> writers;
        private final Counter written;
        private final Counter failed;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            GeoMesaRecordWriter geoMesaRecordWriter = this;
            synchronized (geoMesaRecordWriter) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private DataStore ds() {
            return this.ds;
        }

        private scala.collection.mutable.Map<String, FeatureWriter<SimpleFeatureType, SimpleFeature>> writers() {
            return this.writers;
        }

        private Counter written() {
            return this.written;
        }

        private Counter failed() {
            return this.failed;
        }

        public void write(Text key, SimpleFeature value) {
            try {
                String sftName = value.getFeatureType().getTypeName();
                FeatureWriter writer = (FeatureWriter)this.writers().getOrElseUpdate((Object)sftName, (Function0 & Serializable)() -> this.createWriter(sftName));
                FeatureUtils$.MODULE$.write(writer, value, FeatureUtils$.MODULE$.write$default$3());
                this.written().increment(1L);
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(24).append("Error writing feature '").append(DataUtilities.encodeFeature((SimpleFeature)value)).append("'").toString(), (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.failed().increment(1L);
            }
        }

        private FeatureWriter<SimpleFeatureType, SimpleFeature> createWriter(String typeName) {
            DataStore dataStore = this.ds();
            if (dataStore instanceof GeoMesaDataStore) {
                Seq seq;
                GeoMesaDataStore geoMesaDataStore = (GeoMesaDataStore)dataStore;
                SimpleFeatureType sft = geoMesaDataStore.getSchema(typeName);
                Option<Seq<String>> option = this.indices;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Seq names = (Seq)some.value();
                    seq = (Seq)names.map((Function1 & Serializable)x$3 -> geoMesaDataStore.manager().index(sft, x$3, IndexMode$.MODULE$.Write()));
                } else if (None$.MODULE$.equals(option)) {
                    seq = geoMesaDataStore.manager().indices(sft, IndexMode$.MODULE$.Write());
                } else {
                    throw new MatchError(option);
                }
                Seq i2 = seq;
                return geoMesaDataStore.getIndexWriterAppend(typeName, i2);
            }
            this.indices.foreach((Function1 & Serializable)i -> {
                GeoMesaRecordWriter.$anonfun$createWriter$2(this, i);
                return BoxedUnit.UNIT;
            });
            return this.ds().getFeatureWriterAppend(typeName, Transaction.AUTO_COMMIT);
        }

        public void close(TaskAttemptContext context) {
            this.writers().values().foreach((Function1 & Serializable)v -> package.CloseQuietly$.MODULE$.apply(v, IsCloseable$.MODULE$.closeableIsCloseable()));
            this.ds().dispose();
        }

        public static final /* synthetic */ void $anonfun$createWriter$2(GeoMesaRecordWriter $this, Seq i) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isWarnEnabled()) {
                $this.logger().underlying().warn("Ignoring index config '{}' for non-geomesa data store {}", new Object[]{i.mkString(","), $this.ds()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }

        public GeoMesaRecordWriter(scala.collection.immutable.Map<String, String> params, Option<Seq<String>> indices, TaskAttemptContext context) {
            this.indices = indices;
            LazyLogging.$init$((LazyLogging)this);
            this.ds = DataStoreFinder.getDataStore((Map)((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(params).asJava()));
            this.writers = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            this.written = context.getCounter(GeoMesaOutputFormat$OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat$OutputCounters$.MODULE$.Written());
            this.failed = context.getCounter(GeoMesaOutputFormat$OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat$OutputCounters$.MODULE$.Failed());
        }
    }
}

