/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Closeable;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.opengis.feature.simple.SimpleFeature;
import scala.Option;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue!\u0002\u000e\u001c\u0003\u00031\u0003\"\u0002&\u0001\t\u0003Y\u0005\"\u0003(\u0001\u0001\u0004\u0005\r\u0011\"\u0003P\u0011%1\u0006\u00011AA\u0002\u0013%q\u000bC\u0005a\u0001\u0001\u0007\t\u0011)Q\u0005!\"I\u0011\r\u0001a\u0001\u0002\u0004%IA\u0019\u0005\ng\u0002\u0001\r\u00111A\u0005\nQD\u0011\u0002\u001f\u0001A\u0002\u0003\u0005\u000b\u0015B2\t\u0013e\u0004\u0001\u0019!a\u0001\n\u0013Q\bbCA\r\u0001\u0001\u0007\t\u0019!C\u0005\u00037A!\"a\t\u0001\u0001\u0004\u0005\t\u0015)\u0003|\u0011%\t)\u0003\u0001a\u0001\n\u0013\t9\u0003C\u0005\u00020\u0001\u0001\r\u0011\"\u0003\u00022!A\u0011Q\u0007\u0001!B\u0013\tI\u0003C\u0005\u00028\u0001\u0011\r\u0011\"\u0003\u0002:!9\u00111\b\u0001!\u0002\u0013\u0001\u0004bCA\u001f\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u007fA1\"!\u0011\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002D!Q\u0011q\t\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001c\t\u000f\u0005%\u0003A\"\u0001\u0002L!9\u00111\u000e\u0001\u0005B\u00055\u0004bBA8\u0001\u0011\u0005\u0013\u0011\u000f\u0005\b\u0003s\u0002A\u0011IA>\u0011\u001d\ti\b\u0001C!\u0003\u007fBq!!$\u0001\t\u0003\ny\tC\u0004\u0002\u0012\u0002!\t%a%\u0003-\u0019KG.Z*ue\u0016\fWNU3d_J$'+Z1eKJT!\u0001H\u000f\u0002\u00135\f\u0007O]3ek\u000e,'B\u0001\u0010 \u0003\u0011QwNY:\u000b\u0005\u0001\n\u0013aB4f_6,7/\u0019\u0006\u0003E\r\nA\u0002\\8dCRLwN\u001c;fG\"T\u0011\u0001J\u0001\u0004_J<7\u0001A\n\u0004\u0001\u001d\u0002\u0005\u0003\u0002\u0015/aYj\u0011!\u000b\u0006\u00039)R!a\u000b\u0017\u0002\r!\fGm\\8q\u0015\ti3%\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003_%\u0012ABU3d_J$'+Z1eKJ\u0004\"!\r\u001b\u000e\u0003IR!a\r\u0016\u0002\u0005%|\u0017BA\u001b3\u00051auN\\4Xe&$\u0018M\u00197f!\t9d(D\u00019\u0015\tI$(\u0001\u0004tS6\u0004H.\u001a\u0006\u0003wq\nqAZ3biV\u0014XM\u0003\u0002>G\u00059q\u000e]3oO&\u001c\u0018BA 9\u00055\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKB\u0011\u0011\tS\u0007\u0002\u0005*\u00111\tR\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u000b\u001a\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u000f\u0006\u00191m\\7\n\u0005%\u0013%a\u0003'bufdunZ4j]\u001e\fa\u0001P5oSRtD#\u0001'\u0011\u00055\u0003Q\"A\u000e\u0002\u0007\u0011,7-F\u0001Q!\t\tF+D\u0001S\u0015\t\u0019&'\u0001\u0005d_6\u0004(/Z:t\u0013\t)&K\u0001\u0007EK\u000e|W\u000e\u001d:fgN|'/A\u0004eK\u000e|F%Z9\u0015\u0005as\u0006CA-]\u001b\u0005Q&\"A.\u0002\u000bM\u001c\u0017\r\\1\n\u0005uS&\u0001B+oSRDqaX\u0002\u0002\u0002\u0003\u0007\u0001+A\u0002yIE\nA\u0001Z3dA\u000511\u000f\u001e:fC6,\u0012a\u0019\n\u0004I\u001alg\u0001B3\u0001\u0001\r\u0014A\u0002\u0010:fM&tW-\\3oiz\u0002\"aZ6\u000e\u0003!T!aM5\u000b\u0003)\fAA[1wC&\u0011A\u000e\u001b\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0002oc6\tqN\u0003\u0002qU\u0005\u0011am]\u0005\u0003e>\u0014\u0001bU3fW\u0006\u0014G.Z\u0001\u000bgR\u0014X-Y7`I\u0015\fHC\u0001-v\u0011\u001dyf!!AA\u0002Y\u00142a\u001e4n\r\u0011)\u0007\u0001\u0001<\u0002\u000fM$(/Z1nA\u0005!\u0011\u000e^3s+\u0005Y(\u0003\u0002?~\u0003'1A!\u001a\u0001\u0001wB!a0!\u00047\u001d\ry\u0018\u0011\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011QA\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0016bAA\u00065\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003\u0017Q\u0006cA4\u0002\u0016%\u0019\u0011q\u00035\u0003\u0013\rcwn]3bE2,\u0017\u0001C5uKJ|F%Z9\u0015\u0007a\u000bi\u0002\u0003\u0005`\u0013\u0005\u0005\t\u0019AA\u0010%\u0015\t\t#`A\n\r\u0015)\u0007\u0001AA\u0010\u0003\u0015IG/\u001a:!\u0003\u0019aWM\\4uQV\u0011\u0011\u0011\u0006\t\u00043\u0006-\u0012bAA\u00175\n)a\t\\8bi\u0006QA.\u001a8hi\"|F%Z9\u0015\u0007a\u000b\u0019\u0004\u0003\u0005`\u0019\u0005\u0005\t\u0019AA\u0015\u0003\u001daWM\\4uQ\u0002\naaY;s\u0017\u0016LX#\u0001\u0019\u0002\u000f\r,(oS3zA\u0005A1-\u001e:WC2,X-F\u00017\u00031\u0019WO\u001d,bYV,w\fJ3r)\rA\u0016Q\t\u0005\b?F\t\t\u00111\u00017\u0003%\u0019WO\u001d,bYV,\u0007%\u0001\bde\u0016\fG/Z%uKJ\fGo\u001c:\u0015\u0011\u00055\u0013\u0011KA,\u0003C\u0012R!a\u0014~\u0003'1Q!\u001a\u0001\u0001\u0003\u001bBa!Y\nA\u0002\u0005M#\u0003BA+M64Q!\u001a\u0001\u0001\u0003'Bq!!\u0017\u0014\u0001\u0004\tY&\u0001\u0005gS2,\u0007+\u0019;i!\rq\u0017QL\u0005\u0004\u0003?z'\u0001\u0002)bi\"Dq!a\u0019\u0014\u0001\u0004\t)'A\u0004d_:$X\r\u001f;\u0011\u0007!\n9'C\u0002\u0002j%\u0012!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\u0006Yq-\u001a;Qe><'/Z:t)\t\tI#\u0001\u0007oKb$8*Z=WC2,X\r\u0006\u0002\u0002tA\u0019\u0011,!\u001e\n\u0007\u0005]$LA\u0004C_>dW-\u00198\u0002\u001f\u001d,GoQ;se\u0016tGOV1mk\u0016$\u0012AN\u0001\u000bS:LG/[1mSj,G#\u0002-\u0002\u0002\u0006-\u0005bBAB/\u0001\u0007\u0011QQ\u0001\u0006gBd\u0017\u000e\u001e\t\u0004Q\u0005\u001d\u0015bAAES\tQ\u0011J\u001c9viN\u0003H.\u001b;\t\u000f\u0005\rt\u00031\u0001\u0002f\u0005iq-\u001a;DkJ\u0014XM\u001c;LKf$\u0012\u0001M\u0001\u0006G2|7/\u001a\u000b\u00021\u0002")
public abstract class FileStreamRecordReader
extends RecordReader<LongWritable, SimpleFeature>
implements LazyLogging {
    private Decompressor dec;
    private InputStream stream;
    private Iterator<SimpleFeature> iter;
    private float length;
    private final LongWritable curKey;
    private SimpleFeature curValue;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        FileStreamRecordReader fileStreamRecordReader = this;
        synchronized (fileStreamRecordReader) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private Decompressor dec() {
        return this.dec;
    }

    private void dec_$eq(Decompressor x$1) {
        this.dec = x$1;
    }

    private InputStream stream() {
        return this.stream;
    }

    private void stream_$eq(InputStream x$1) {
        this.stream = x$1;
    }

    private Iterator<SimpleFeature> iter() {
        return this.iter;
    }

    private void iter_$eq(Iterator<SimpleFeature> x$1) {
        this.iter = x$1;
    }

    private float length() {
        return this.length;
    }

    private void length_$eq(float x$1) {
        this.length = x$1;
    }

    private LongWritable curKey() {
        return this.curKey;
    }

    private SimpleFeature curValue() {
        return this.curValue;
    }

    private void curValue_$eq(SimpleFeature x$1) {
        this.curValue = x$1;
    }

    public abstract Iterator<SimpleFeature> createIterator(InputStream var1, Path var2, TaskAttemptContext var3);

    public float getProgress() {
        float f;
        if (this.length() == 0.0f) {
            return 0.0f;
        }
        try {
            f = package$.MODULE$.min(1.0f, (float)((Seekable)this.stream()).getPos() / this.length());
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Error checking stream position - it may be closed? {}", (Object)e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                f = 1.0f;
            }
            throw throwable;
        }
        return f;
    }

    public boolean nextKeyValue() {
        if (this.iter().hasNext()) {
            this.curKey().set(this.curKey().get() + 1L);
            this.curValue_$eq((SimpleFeature)this.iter().next());
            return true;
        }
        return false;
    }

    public SimpleFeature getCurrentValue() {
        return this.curValue();
    }

    public void initialize(InputSplit split, TaskAttemptContext context) {
        BoxedUnit boxedUnit;
        FSDataInputStream fSDataInputStream;
        Configuration job = context.getConfiguration();
        Path path = ((FileSplit)split).getPath();
        CompressionCodec codec = new CompressionCodecFactory(job).getCodec(path);
        FileSystem fs = path.getFileSystem(job);
        this.length_$eq(split.getLength());
        if (codec != null) {
            this.dec_$eq(CodecPool.getDecompressor((CompressionCodec)codec));
            fSDataInputStream = codec.createInputStream((InputStream)fs.open(path), this.dec());
        } else {
            fSDataInputStream = fs.open(path);
        }
        this.stream_$eq((InputStream)fSDataInputStream);
        this.iter_$eq(this.createIterator(this.stream(), path, context));
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Initialized record reader on split {}", (Object)path.toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public LongWritable getCurrentKey() {
        return this.curKey();
    }

    public void close() {
        IOUtils.closeQuietly((Closeable)((Closeable)this.iter()));
        IOUtils.closeQuietly((InputStream)this.stream());
        if (this.dec() != null) {
            CodecPool.returnDecompressor((Decompressor)this.dec());
            return;
        }
    }

    public FileStreamRecordReader() {
        LazyLogging.$init$((LazyLogging)this);
        this.length = 0.0f;
        this.curKey = new LongWritable(0L);
    }
}

