/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.jobs.mapreduce;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFinder;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStore;
import org.locationtech.geomesa.jobs.GeoMesaConfigurator$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat$;
import org.locationtech.geomesa.jobs.mapreduce.GeoMesaOutputFormat$OutputCounters$;
import org.locationtech.geomesa.utils.geotools.FeatureUtils$;
import org.locationtech.geomesa.utils.index.IndexMode$;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t-a\u0001\u0002\u0013&\u0001ABQ\u0001\u0014\u0001\u0005\u00025CQ\u0001\u0015\u0001\u0005BECQA\u0017\u0001\u0005BmCQA\u001a\u0001\u0005B\u001d<Q\u0001\\\u0013\t\u000254Q\u0001J\u0013\t\u00029DQ\u0001\u0014\u0004\u0005\u0002I<Qa\u001d\u0004\t\u0002Q4QA\u001e\u0004\t\u0002]DQ\u0001T\u0005\u0005\u0002aDq!_\u0005C\u0002\u0013\u0005!\u0010C\u0004\u0002\b%\u0001\u000b\u0011B>\t\u0011\u0005%\u0011B1A\u0005\u0002iDq!a\u0003\nA\u0003%1\u0010\u0003\u0005\u0002\u000e%\u0011\r\u0011\"\u0001{\u0011\u001d\ty!\u0003Q\u0001\nmDq!!\u0005\u0007\t\u0003\t\u0019\u0002C\u0005\u0002h\u0019\t\n\u0011\"\u0001\u0002j!9\u0011q\u0010\u0004\u0005\u0002\u0005\u0005eABAJ\r\u0001\t)\n\u0003\u0006\u0002&Q\u0011\t\u0011)A\u0005\u0003OA!\"!\u0014\u0015\u0005\u0003\u0005\u000b\u0011BA(\u0011!1FC!A!\u0002\u00139\u0006B\u0002'\u0015\t\u0003\tY\u000bC\u0005\u00026R\u0011\r\u0011\"\u0003\u00028\"A\u0011Q\u0019\u000b!\u0002\u0013\tI\fC\u0005\u0002HR\u0011\r\u0011\"\u0003\u0002J\"A\u0011q\u001c\u000b!\u0002\u0013\tY\rC\u0005\u0002bR\u0011\r\u0011\"\u0003\u0002d\"A\u00111\u001e\u000b!\u0002\u0013\t)\u000fC\u0005\u0002nR\u0011\r\u0011\"\u0003\u0002d\"A\u0011q\u001e\u000b!\u0002\u0013\t)\u000fC\u0004\u0002rR!\t%a=\t\u000f\u0005uH\u0003\"\u0003\u0002\u0000\"9!Q\u0001\u000b\u0005B\t\u001d!aE$f_6+7/Y(viB,HOR8s[\u0006$(B\u0001\u0014(\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002)S\u0005!!n\u001c2t\u0015\tQ3&A\u0004hK>lWm]1\u000b\u00051j\u0013\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"\u0001\u0018\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0004\u0003\u0002\u001a9u\u0001k\u0011a\r\u0006\u0003MQR!!\u000e\u001c\u0002\r!\fGm\\8q\u0015\t9T&\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003sM\u0012AbT;uaV$hi\u001c:nCR\u0004\"a\u000f \u000e\u0003qR!!\u0010\u001b\u0002\u0005%|\u0017BA =\u0005\u0011!V\r\u001f;\u0011\u0005\u0005SU\"\u0001\"\u000b\u0005\r#\u0015AB:j[BdWM\u0003\u0002F\r\u00069a-Z1ukJ,'BA$I\u0003\r\t\u0007/\u001b\u0006\u0003\u00136\n\u0001bZ3pi>|Gn]\u0005\u0003\u0017\n\u0013QbU5na2,g)Z1ukJ,\u0017A\u0002\u001fj]&$h\bF\u0001O!\ty\u0005!D\u0001&\u0003=9W\r\u001e*fG>\u0014Hm\u0016:ji\u0016\u0014HC\u0001*V!\u0011\u00114K\u000f!\n\u0005Q\u001b$\u0001\u0004*fG>\u0014Hm\u0016:ji\u0016\u0014\b\"\u0002,\u0003\u0001\u00049\u0016aB2p]R,\u0007\u0010\u001e\t\u0003eaK!!W\u001a\u0003%Q\u000b7o[!ui\u0016l\u0007\u000f^\"p]R,\u0007\u0010^\u0001\u0011G\",7m[(viB,Ho\u00159fGN$\"\u0001\u00182\u0011\u0005u\u0003W\"\u00010\u000b\u0003}\u000bQa]2bY\u0006L!!\u00190\u0003\tUs\u0017\u000e\u001e\u0005\u0006-\u000e\u0001\ra\u0019\t\u0003e\u0011L!!Z\u001a\u0003\u0015){'mQ8oi\u0016DH/\u0001\nhKR|U\u000f\u001e9vi\u000e{W.\\5ui\u0016\u0014HC\u00015l!\t\u0011\u0014.\u0003\u0002kg\tyq*\u001e;qkR\u001cu.\\7jiR,'\u000fC\u0003W\t\u0001\u0007q+A\nHK>lUm]1PkR\u0004X\u000f\u001e$pe6\fG\u000f\u0005\u0002P\rM\u0011aa\u001c\t\u0003;BL!!\u001d0\u0003\r\u0005s\u0017PU3g)\u0005i\u0017AD(viB,HoQ8v]R,'o\u001d\t\u0003k&i\u0011A\u0002\u0002\u000f\u001fV$\b/\u001e;D_VtG/\u001a:t'\tIq\u000eF\u0001u\u0003\u00159%o\\;q+\u0005Y\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006!A.\u00198h\u0015\t\t\t!\u0001\u0003kCZ\f\u0017bAA\u0003{\n11\u000b\u001e:j]\u001e\faa\u0012:pkB\u0004\u0013aB,sSR$XM\\\u0001\t/JLG\u000f^3oA\u00051a)Y5mK\u0012\fqAR1jY\u0016$\u0007%A\u0005tKR|U\u000f\u001e9viRIA,!\u0006\u0002$\u0005\u0005\u00131\n\u0005\b\u0003/\t\u0002\u0019AA\r\u0003\u0011\u0019wN\u001c4\u0011\t\u0005m\u0011qD\u0007\u0003\u0003;Q1!a\u00065\u0013\u0011\t\t#!\b\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\t)#\u0005a\u0001\u0003O\ta\u0001]1sC6\u001c\b\u0003CA\u0015\u0003o\ti$!\u0010\u000f\t\u0005-\u00121\u0007\t\u0004\u0003[qVBAA\u0018\u0015\r\t\tdL\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005Ub,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003s\tYDA\u0002NCBT1!!\u000e_!\u0011\tI#a\u0010\n\t\u0005\u0015\u00111\b\u0005\b\u0003\u0007\n\u0002\u0019AA#\u0003\r\u0019h\r\u001e\t\u0004\u0003\u0006\u001d\u0013bAA%\u0005\n\t2+[7qY\u00164U-\u0019;ve\u0016$\u0016\u0010]3\t\u0013\u00055\u0013\u0003%AA\u0002\u0005=\u0013aB5oI&\u001cWm\u001d\t\u0006;\u0006E\u0013QK\u0005\u0004\u0003'r&AB(qi&|g\u000e\u0005\u0004\u0002X\u0005\u0005\u0014Q\b\b\u0005\u00033\niF\u0004\u0003\u0002.\u0005m\u0013\"A0\n\u0007\u0005}c,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\r\u0014Q\r\u0002\u0004'\u0016\f(bAA0=\u0006\u00192/\u001a;PkR\u0004X\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u000e\u0016\u0005\u0003\u001f\nig\u000b\u0002\u0002pA!\u0011\u0011OA>\u001b\t\t\u0019H\u0003\u0003\u0002v\u0005]\u0014!C;oG\",7m[3e\u0015\r\tIHX\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA?\u0003g\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0019X\r^(viB,HOS1wCR9A,a!\u0002\u0006\u0006E\u0005bBA\f'\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003K\u0019\u0002\u0019AAD!!\tI)a$\u0002>\u0005uRBAAF\u0015\r\tii`\u0001\u0005kRLG.\u0003\u0003\u0002:\u0005-\u0005bBA\"'\u0001\u0007\u0011Q\t\u0002\u0014\u000f\u0016|W*Z:b%\u0016\u001cwN\u001d3Xe&$XM]\n\u0005)I\u000b9\n\u0005\u0003\u0002\u001a\u0006\u001dVBAAN\u0015\u0011\ti*a(\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\t\u0005\u0005\u00161U\u0001\tif\u0004Xm]1gK*\u0011\u0011QU\u0001\u0004G>l\u0017\u0002BAU\u00037\u00131\u0002T1{s2{wmZ5oORA\u0011QVAX\u0003c\u000b\u0019\f\u0005\u0002v)!9\u0011Q\u0005\rA\u0002\u0005\u001d\u0002bBA'1\u0001\u0007\u0011q\n\u0005\u0006-b\u0001\raV\u0001\u0003IN,\"!!/\u0011\t\u0005m\u0016\u0011Y\u0007\u0003\u0003{S1!a0G\u0003\u0011!\u0017\r^1\n\t\u0005\r\u0017Q\u0018\u0002\n\t\u0006$\u0018m\u0015;pe\u0016\f1\u0001Z:!\u0003\u001d9(/\u001b;feN,\"!a3\u0011\u0011\u00055\u0017q[A\u001f\u00033l!!a4\u000b\t\u0005E\u00171[\u0001\b[V$\u0018M\u00197f\u0015\r\t)NX\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001d\u0003\u001f\u0004r!a/\u0002\\\u0006\u0015\u0003)\u0003\u0003\u0002^\u0006u&!\u0004$fCR,(/Z,sSR,'/\u0001\u0005xe&$XM]:!\u0003\u001d9(/\u001b;uK:,\"!!:\u0011\u0007I\n9/C\u0002\u0002jN\u0012qaQ8v]R,'/\u0001\u0005xe&$H/\u001a8!\u0003\u00191\u0017-\u001b7fI\u00069a-Y5mK\u0012\u0004\u0013!B<sSR,G#\u0002/\u0002v\u0006e\bBBA|C\u0001\u0007!(A\u0002lKfDa!a?\"\u0001\u0004\u0001\u0015!\u0002<bYV,\u0017\u0001D2sK\u0006$Xm\u0016:ji\u0016\u0014H\u0003BAm\u0005\u0003AqAa\u0001#\u0001\u0004\ti$\u0001\u0005usB,g*Y7f\u0003\u0015\u0019Gn\\:f)\ra&\u0011\u0002\u0005\u0006-\u000e\u0002\ra\u0016")
public class GeoMesaOutputFormat
extends OutputFormat<Text, SimpleFeature> {
    public static void setOutputJava(Configuration conf, Map<String, String> params, SimpleFeatureType sft) {
        GeoMesaOutputFormat$.MODULE$.setOutputJava(conf, params, sft);
    }

    public static Option<Seq<String>> setOutput$default$4() {
        return GeoMesaOutputFormat$.MODULE$.setOutput$default$4();
    }

    public static void setOutput(Configuration conf, scala.collection.immutable.Map<String, String> params, SimpleFeatureType sft, Option<Seq<String>> indices) {
        GeoMesaOutputFormat$.MODULE$.setOutput(conf, params, sft, indices);
    }

    public RecordWriter<Text, SimpleFeature> getRecordWriter(TaskAttemptContext context) {
        scala.collection.immutable.Map<String, String> params = GeoMesaConfigurator$.MODULE$.getDataStoreOutParams(context.getConfiguration());
        Option<Seq<String>> indices = GeoMesaConfigurator$.MODULE$.getIndicesOut(context.getConfiguration());
        return new GeoMesaRecordWriter(params, indices, context);
    }

    public void checkOutputSpecs(JobContext context) {
        Map params = (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(GeoMesaConfigurator$.MODULE$.getDataStoreOutParams(context.getConfiguration())).asJava();
        if (!((IterableOnceOps)JavaConverters$.MODULE$.asScalaIteratorConverter(DataStoreFinder.getAvailableDataStores()).asScala()).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canProcess(params)))) {
            throw new IOException("Data store connection parameters are not set");
        }
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) {
        return new NullOutputFormat().getOutputCommitter(context);
    }

    public static class GeoMesaRecordWriter
    extends RecordWriter<Text, SimpleFeature>
    implements LazyLogging {
        private final Option<Seq<String>> indices;
        private final DataStore ds;
        private final scala.collection.mutable.Map<String, FeatureWriter<SimpleFeatureType, SimpleFeature>> writers;
        private final Counter written;
        private final Counter failed;
        private transient Logger logger;
        private volatile transient boolean bitmap$trans$0;

        private Logger logger$lzycompute() {
            GeoMesaRecordWriter geoMesaRecordWriter = this;
            synchronized (geoMesaRecordWriter) {
                if (!this.bitmap$trans$0) {
                    this.logger = LazyLogging.logger$((LazyLogging)this);
                    this.bitmap$trans$0 = true;
                }
            }
            return this.logger;
        }

        public Logger logger() {
            if (!this.bitmap$trans$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        private DataStore ds() {
            return this.ds;
        }

        private scala.collection.mutable.Map<String, FeatureWriter<SimpleFeatureType, SimpleFeature>> writers() {
            return this.writers;
        }

        private Counter written() {
            return this.written;
        }

        private Counter failed() {
            return this.failed;
        }

        public void write(Text key, SimpleFeature value) {
            try {
                String sftName = value.getFeatureType().getTypeName();
                FeatureWriter writer = (FeatureWriter)this.writers().getOrElseUpdate((Object)sftName, (Function0 & Serializable)() -> this.createWriter(sftName));
                FeatureUtils$.MODULE$.write(writer, value, FeatureUtils$.MODULE$.write$default$3());
                this.written().increment(1L);
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(24).append("Error writing feature '").append(DataUtilities.encodeFeature((SimpleFeature)value)).append("'").toString(), (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.failed().increment(1L);
            }
        }

        private FeatureWriter<SimpleFeatureType, SimpleFeature> createWriter(String typeName) {
            DataStore dataStore = this.ds();
            if (dataStore instanceof GeoMesaDataStore) {
                Seq seq;
                GeoMesaDataStore geoMesaDataStore = (GeoMesaDataStore)dataStore;
                SimpleFeatureType sft = geoMesaDataStore.getSchema(typeName);
                Option<Seq<String>> option = this.indices;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Seq names = (Seq)some.value();
                    seq = (Seq)names.map((Function1 & Serializable)x$3 -> geoMesaDataStore.manager().index(sft, x$3, IndexMode$.MODULE$.Write()));
                } else if (None$.MODULE$.equals(option)) {
                    seq = geoMesaDataStore.manager().indices(sft, IndexMode$.MODULE$.Write());
                } else {
                    throw new MatchError(option);
                }
                Seq i2 = seq;
                return geoMesaDataStore.getIndexWriterAppend(typeName, i2);
            }
            this.indices.foreach((Function1 & Serializable)i -> {
                GeoMesaRecordWriter.$anonfun$createWriter$2(this, i);
                return BoxedUnit.UNIT;
            });
            return this.ds().getFeatureWriterAppend(typeName, Transaction.AUTO_COMMIT);
        }

        public void close(TaskAttemptContext context) {
            this.writers().values().foreach((Function1 & Serializable)v -> package.CloseQuietly$.MODULE$.apply(v, IsCloseable$.MODULE$.closeableIsCloseable()));
            this.ds().dispose();
        }

        public static final /* synthetic */ void $anonfun$createWriter$2(GeoMesaRecordWriter $this, Seq i) {
            BoxedUnit boxedUnit;
            if ($this.logger().underlying().isWarnEnabled()) {
                $this.logger().underlying().warn("Ignoring index config '{}' for non-geomesa data store {}", new Object[]{i.mkString(","), $this.ds()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }

        public GeoMesaRecordWriter(scala.collection.immutable.Map<String, String> params, Option<Seq<String>> indices, TaskAttemptContext context) {
            this.indices = indices;
            LazyLogging.$init$((LazyLogging)this);
            this.ds = DataStoreFinder.getDataStore((Map)((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(params).asJava()));
            this.writers = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            this.written = context.getCounter(GeoMesaOutputFormat$OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat$OutputCounters$.MODULE$.Written());
            this.failed = context.getCounter(GeoMesaOutputFormat$OutputCounters$.MODULE$.Group(), GeoMesaOutputFormat$OutputCounters$.MODULE$.Failed());
        }
    }
}

