/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.tools.data;

import org.locationtech.geomesa.kafka.KafkaDataStoreHelper$;
import org.locationtech.geomesa.kafka.tools.KafkaDataStoreCommand;
import org.locationtech.geomesa.kafka.tools.KafkaDataStoreCommand$class;
import org.locationtech.geomesa.kafka.tools.data.KafkaCreateSchemaParams;
import org.locationtech.geomesa.kafka10.KafkaDataStore;
import org.locationtech.geomesa.tools.Command$;
import org.locationtech.geomesa.tools.utils.CLArgResolver$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001\u001f\tA2*\u00194lC\u000e\u0013X-\u0019;f'\u000eDW-\\1D_6l\u0017M\u001c3\u000b\u0005\r!\u0011\u0001\u00023bi\u0006T!!\u0002\u0004\u0002\u000bQ|w\u000e\\:\u000b\u0005\u001dA\u0011!B6bM.\f'BA\u0005\u000b\u0003\u001d9Wm\\7fg\u0006T!a\u0003\u0007\u0002\u00191|7-\u0019;j_:$Xm\u00195\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011q\u0003G\u0007\u0002\t%\u0011\u0011\u0004\u0002\u0002\u0016\u0017\u000647.\u0019#bi\u0006\u001cFo\u001c:f\u0007>lW.\u00198e\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011I\u0011\u0002\t9\fW.Z\u000b\u0002EA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005Y\u0006twMC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#AB*ue&tw\r\u0003\u0004,\u0001\u0001\u0006IAI\u0001\u0006]\u0006lW\r\t\u0005\b[\u0001\u0011\r\u0011\"\u0011/\u0003\u0019\u0001\u0018M]1ngV\tq\u0006\u0005\u0002\u001fa%\u0011\u0011G\u0001\u0002\u0018\u0017\u000647.Y\"sK\u0006$XmU2iK6\f\u0007+\u0019:b[NDaa\r\u0001!\u0002\u0013y\u0013a\u00029be\u0006l7\u000f\t\u0005\u0006k\u0001!\tEN\u0001\bKb,7-\u001e;f)\u00059\u0004CA\t9\u0013\tI$C\u0001\u0003V]&$\b")
public class KafkaCreateSchemaCommand
implements KafkaDataStoreCommand {
    private final String name;
    private final KafkaCreateSchemaParams params;

    @Override
    public Map<String, String> connection() {
        return KafkaDataStoreCommand$class.connection(this);
    }

    @Override
    public <T> T withDataStore(Function1<KafkaDataStore, T> method) {
        return (T)KafkaDataStoreCommand$class.withDataStore(this, method);
    }

    public String name() {
        return this.name;
    }

    @Override
    public KafkaCreateSchemaParams params() {
        return this.params;
    }

    public void execute() {
        SimpleFeatureType sft = CLArgResolver$.MODULE$.getSft(this.params().spec(), this.params().featureName());
        String featureName = this.params().featureName();
        String sftString = SimpleFeatureTypes$.MODULE$.encodeType(sft, SimpleFeatureTypes$.MODULE$.encodeType$default$2());
        Command$.MODULE$.user().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating '", "' using a KafkaDataStore with spec "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{featureName}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'. Just a few moments..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sftString}))).toString());
        SimpleFeatureType streamingSFT = KafkaDataStoreHelper$.MODULE$.createStreamingSFT(sft, this.params().zkPath());
        try {
            this.withDataStore((Function1)new Serializable(this, featureName, sftString, streamingSFT){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KafkaCreateSchemaCommand $outer;
                private final String featureName$1;
                private final String sftString$1;
                private final SimpleFeatureType streamingSFT$1;

                public final void apply(KafkaDataStore ds) {
                    ds.createSchema(this.streamingSFT$1);
                    if (ds.getSchema(this.featureName$1) == null) {
                        Command$.MODULE$.user().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There was an error creating feature '", "' with spec "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.featureName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'. Please check that all arguments are correct "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sftString$1}))).append((Object)"in the previous command.").toString());
                    } else {
                        Command$.MODULE$.user().info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Feature '", "' with spec "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.featureName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' successfully created in Kafka with zkPath '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.sftString$1, this.$outer.params().zkPath()}))).toString());
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.featureName$1 = featureName$1;
                    this.sftString$1 = sftString$1;
                    this.streamingSFT$1 = streamingSFT$1;
                }
            });
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Command$.MODULE$.user().error(illegalArgumentException.getMessage());
        }
    }

    public KafkaCreateSchemaCommand() {
        KafkaDataStoreCommand$class.$init$(this);
        this.name = "create-schema";
        this.params = new KafkaCreateSchemaParams();
    }
}

