/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.tools.status;

import org.locationtech.geomesa.kafka.tools.KafkaDataStoreCommand;
import org.locationtech.geomesa.kafka.tools.KafkaDataStoreCommand$class;
import org.locationtech.geomesa.kafka.tools.status.KafkaDescribeSchemaParams;
import org.locationtech.geomesa.kafka10.KafkaDataStore;
import org.locationtech.geomesa.kafka10.KafkaTopicMetadata;
import org.locationtech.geomesa.kafka10.KafkaUtils10$;
import org.locationtech.geomesa.kafka10.ZkUtils10;
import org.locationtech.geomesa.tools.Command$;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001i2A!\u0001\u0002\u0001\u001f\tQ2*\u00194lC\u0012+7o\u0019:jE\u0016\u001c6\r[3nC\u000e{W.\\1oI*\u00111\u0001B\u0001\u0007gR\fG/^:\u000b\u0005\u00151\u0011!\u0002;p_2\u001c(BA\u0004\t\u0003\u0015Y\u0017MZ6b\u0015\tI!\"A\u0004hK>lWm]1\u000b\u0005-a\u0011\u0001\u00047pG\u0006$\u0018n\u001c8uK\u000eD'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/ai\u0011\u0001B\u0005\u00033\u0011\u0011QcS1gW\u0006$\u0015\r^1Ti>\u0014XmQ8n[\u0006tG\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0003\n\u0013\u0001\u00028b[\u0016,\u0012A\t\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nA\u0001\\1oO*\tq%\u0001\u0003kCZ\f\u0017BA\u0015%\u0005\u0019\u0019FO]5oO\"11\u0006\u0001Q\u0001\n\t\nQA\\1nK\u0002Bq!\f\u0001C\u0002\u0013\u0005c&\u0001\u0004qCJ\fWn]\u000b\u0002_A\u0011a\u0004M\u0005\u0003c\t\u0011\u0011dS1gW\u0006$Um]2sS\n,7k\u00195f[\u0006\u0004\u0016M]1ng\"11\u0007\u0001Q\u0001\n=\nq\u0001]1sC6\u001c\b\u0005C\u00036\u0001\u0011\u0005a'A\u0004fq\u0016\u001cW\u000f^3\u0015\u0003]\u0002\"!\u0005\u001d\n\u0005e\u0012\"\u0001B+oSR\u0004")
public class KafkaDescribeSchemaCommand
implements KafkaDataStoreCommand {
    private final String name;
    private final KafkaDescribeSchemaParams params;

    @Override
    public Map<String, String> connection() {
        return KafkaDataStoreCommand$class.connection(this);
    }

    @Override
    public <T> T withDataStore(Function1<KafkaDataStore, T> method) {
        return (T)KafkaDataStoreCommand$class.withDataStore(this, method);
    }

    public String name() {
        return this.name;
    }

    @Override
    public KafkaDescribeSchemaParams params() {
        return this.params;
    }

    public void execute() {
        this.withDataStore((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KafkaDescribeSchemaCommand $outer;

            /*
             * WARNING - void declaration
             */
            public final void apply(KafkaDataStore ds) {
                Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Describing attributes of feature type '", "' at zkPath '", "'..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.params().featureName(), this.$outer.params().zkPath()})));
                try {
                    SimpleFeatureType sft = ds.getSchema(this.$outer.params().featureName());
                    StringBuilder sb = new StringBuilder();
                    JavaConversions$.MODULE$.asScalaBuffer(sft.getAttributeDescriptors()).foreach((Function1)new Serializable(this, sft, sb){
                        public static final long serialVersionUID = 0L;
                        private final SimpleFeatureType sft$1;
                        private final StringBuilder sb$1;

                        public final void apply(AttributeDescriptor attr) {
                            this.sb$1.clear();
                            String name = attr.getLocalName();
                            this.sb$1.append(name);
                            this.sb$1.append(": ");
                            this.sb$1.append(attr.getType().getBinding().getSimpleName());
                            GeometryDescriptor geometryDescriptor = this.sft$1.getGeometryDescriptor();
                            AttributeDescriptor attributeDescriptor = attr;
                            Object object = !(geometryDescriptor != null ? !geometryDescriptor.equals(attributeDescriptor) : attributeDescriptor != null) ? this.sb$1.append(" (Default geometry)") : BoxedUnit.UNIT;
                            Object object2 = attr.getDefaultValue() == null ? BoxedUnit.UNIT : this.sb$1.append((Object)new Tuple2((Object)"- Default Value: ", attr.getDefaultValue()));
                            Command$.MODULE$.output().info(this.sb$1.toString());
                        }
                        {
                            this.sft$1 = sft$1;
                            this.sb$1 = sb$1;
                        }
                    });
                    java.util.Map userData = sft.getUserData();
                    if (!userData.isEmpty()) {
                        Command$.MODULE$.user().info("\nUser data:");
                        JavaConversions$.MODULE$.mapAsScalaMap(userData).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<Object, Object> x0$1) {
                                Tuple2<Object, Object> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    Object key = tuple2._1();
                                    Object value = tuple2._2();
                                    Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, value})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                        });
                    }
                    Command$.MODULE$.user().info("\nFetching Kafka topic metadata...");
                    ZkUtils10 zkUtils = KafkaUtils10$.MODULE$.createZkUtils(this.$outer.params().zookeepers(), Integer.MAX_VALUE, Integer.MAX_VALUE);
                    try {
                        String topicName = (String)zkUtils.zkClient().readData(ds.getTopicPath(this.$outer.params().featureName()));
                        KafkaTopicMetadata topicMetadata = zkUtils.fetchTopicMetadataFromZk(topicName);
                        Command$.MODULE$.user().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic: ", " Number of partitions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicMetadata.topicName(), BoxesRunTime.boxToInteger((int)topicMetadata.numberOfPartitions())})));
                    }
                    catch (Throwable throwable) {
                        void var12_5;
                        var12_5.close();
                        throw throwable;
                    }
                    zkUtils.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof NullPointerException) {
                        NullPointerException nullPointerException = (NullPointerException)throwable2;
                        Command$.MODULE$.user().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: feature '", "' not found. Check arguments..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.params().featureName()})), (Throwable)nullPointerException);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    if (throwable2 instanceof Exception) {
                        Exception exception = (Exception)throwable2;
                        Command$.MODULE$.user().error(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error describing feature '", "': "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.params().featureName()}))).append((Object)exception.getMessage()).toString(), (Throwable)exception);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    Command$.MODULE$.user().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Non fatal error encountered describing feature '", "': "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.params().featureName()})), e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public KafkaDescribeSchemaCommand() {
        KafkaDataStoreCommand$class.$init$(this);
        this.name = "get-schema";
        this.params = new KafkaDescribeSchemaParams();
    }
}

