/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka;

import com.github.benmanes.caffeine.cache.Ticker;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005-t!B\u0001\u0003\u0011\u0003Y\u0011!E#ya&\u0014\u0018\r^5p]6{7m[5oO*\u00111\u0001B\u0001\u0006W\u000647.\u0019\u0006\u0003\u000b\u0019\tqaZ3p[\u0016\u001c\u0018M\u0003\u0002\b\u0011\u0005aAn\\2bi&|g\u000e^3dQ*\t\u0011\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!\u0005qBA\tFqBL'/\u0019;j_:lunY6j]\u001e\u001c\"!\u0004\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011\u00159R\u0002\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t1B\u0002\u0003\u001b\u001b\u0001Y\"aD,sCB\u0004X\r\u001a*v]:\f'\r\\3\u0014\u0005e\u0001\u0002\u0002C\u000f\u001a\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u000b\u0011,G.Y=\u0016\u0003}\u0001\"!\u0005\u0011\n\u0005\u0005\u0012\"\u0001\u0002'p]\u001eD\u0001bI\r\u0003\u0002\u0003\u0006IaH\u0001\u0007I\u0016d\u0017-\u001f\u0011\t\u000b]IB\u0011A\u0013\u0015\u0005\u0019B\u0003CA\u0014\u001a\u001b\u0005i\u0001\"B\u000f%\u0001\u0004y\u0002\"\u0003\u0016\u001a\u0001\u0004\u0005\r\u0011\"\u0001,\u0003!\u0011XO\u001c8bE2,W#\u0001\u0017\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001\u00027b]\u001eT\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024]\tA!+\u001e8oC\ndW\rC\u000563\u0001\u0007\t\u0019!C\u0001m\u0005a!/\u001e8oC\ndWm\u0018\u0013fcR\u0011qG\u000f\t\u0003#aJ!!\u000f\n\u0003\tUs\u0017\u000e\u001e\u0005\bwQ\n\t\u00111\u0001-\u0003\rAH%\r\u0005\u0007{e\u0001\u000b\u0015\u0002\u0017\u0002\u0013I,hN\\1cY\u0016\u0004\u0003bB \u001a\u0001\u0004%\t\u0001Q\u0001\nG\u0006t7-\u001a7mK\u0012,\u0012!\u0011\t\u0003#\tK!a\u0011\n\u0003\u000f\t{w\u000e\\3b]\"9Q)\u0007a\u0001\n\u00031\u0015!D2b]\u000e,G\u000e\\3e?\u0012*\u0017\u000f\u0006\u00028\u000f\"91\bRA\u0001\u0002\u0004\t\u0005BB%\u001aA\u0003&\u0011)\u0001\u0006dC:\u001cW\r\u001c7fI\u0002BqaS\rA\u0002\u0013\u0005\u0001)\u0001\u0003e_:,\u0007bB'\u001a\u0001\u0004%\tAT\u0001\tI>tWm\u0018\u0013fcR\u0011qg\u0014\u0005\bw1\u000b\t\u00111\u0001B\u0011\u0019\t\u0016\u0004)Q\u0005\u0003\u0006)Am\u001c8fA\u0019!1+\u0004\u0001U\u0005=\u00196\r[3ek2,G-\u0012=qSJLXCA+d'\r\u0011f+\u0017\t\u0003[]K!\u0001\u0017\u0018\u0003\r=\u0013'.Z2u!\rQv,Y\u0007\u00027*\u0011A,X\u0001\u000bG>t7-\u001e:sK:$(B\u000101\u0003\u0011)H/\u001b7\n\u0005\u0001\\&aD*dQ\u0016$W\u000f\\3e\rV$XO]3\u0011\u0005\t\u001cG\u0002\u0001\u0003\u0006IJ\u0013\r!\u001a\u0002\u0002)F\u0011a-\u001b\t\u0003#\u001dL!\u0001\u001b\n\u0003\u000f9{G\u000f[5oOB\u0011\u0011C[\u0005\u0003WJ\u00111!\u00118z\u0011!Q#K!A!\u0002\u00131\u0003\"B\fS\t\u0003qGCA8q!\r9#+\u0019\u0005\u0006U5\u0004\rA\n\u0005\u0006eJ#\te]\u0001\tO\u0016$H)\u001a7bsR\u0011q\u0004\u001e\u0005\u0006kF\u0004\rA^\u0001\u0005k:LG\u000f\u0005\u0002[o&\u0011\u0001p\u0017\u0002\t)&lW-\u00168ji\")!P\u0015C!w\u0006I1m\\7qCJ,Gk\u001c\u000b\u0003y~\u0004\"!E?\n\u0005y\u0014\"aA%oi\"9\u0011\u0011A=A\u0002\u0005\r\u0011!A8\u0011\u0007i\u000b)!C\u0002\u0002\bm\u0013q\u0001R3mCf,G\rC\u0004\u0002\fI#\t%!\u0004\u0002\r\r\fgnY3m)\r\t\u0015q\u0002\u0005\b\u0003#\tI\u00011\u0001B\u0003Ui\u0017-_%oi\u0016\u0014(/\u001e9u\u0013\u001a\u0014VO\u001c8j]\u001eDq!!\u0006S\t\u0003\n9\"A\u0006jg\u000e\u000bgnY3mY\u0016$G#A!\t\u000f\u0005m!\u000b\"\u0011\u0002\u0018\u00051\u0011n\u001d#p]\u0016Dq!a\bS\t\u0003\n\t#A\u0002hKR$\u0012!\u0019\u0005\b\u0003?\u0011F\u0011IA\u0013)\u0015\t\u0017qEA\u0016\u0011\u001d\tI#a\tA\u0002}\tq\u0001^5nK>,H\u000f\u0003\u0004v\u0003G\u0001\rA\u001e\u0004\u0007\u0003_i\u0001!!\r\u0003\u00155{7m\u001b+jG.,'oE\u0003\u0002.Y\u000b\u0019\u0004\u0005\u0003\u00026\u0005-SBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u000b\r\f7\r[3\u000b\t\u0005u\u0012qH\u0001\tG\u00064g-Z5oK*!\u0011\u0011IA\"\u0003!\u0011WM\\7b]\u0016\u001c(\u0002BA#\u0003\u000f\naaZ5uQV\u0014'BAA%\u0003\r\u0019w.\\\u0005\u0005\u0003\u001b\n9D\u0001\u0004US\u000e\\WM\u001d\u0005\b/\u00055B\u0011AA))\t\t\u0019\u0006E\u0002(\u0003[A\u0011\"a\u0016\u0002.\u0001\u0007I\u0011\u0001\u0010\u0002\r5LG\u000e\\5t\u0011)\tY&!\fA\u0002\u0013\u0005\u0011QL\u0001\u000b[&dG.[:`I\u0015\fHcA\u001c\u0002`!A1(!\u0017\u0002\u0002\u0003\u0007q\u0004\u0003\u0005\u0002d\u00055\u0002\u0015)\u0003 \u0003\u001di\u0017\u000e\u001c7jg\u0002B\u0001\"a\u001a\u0002.\u0011\u0005\u0013\u0011N\u0001\u0005e\u0016\fG\rF\u0001 \u0001")
public final class ExpirationMocking {

    public static class MockTicker
    implements Ticker {
        private long millis = System.currentTimeMillis();

        public long millis() {
            return this.millis;
        }

        public void millis_$eq(long x$1) {
            this.millis = x$1;
        }

        public long read() {
            return this.millis() * 1000000L;
        }
    }

    public static class WrappedRunnable {
        private final long delay;
        private Runnable runnable;
        private boolean cancelled;
        private boolean done;

        public long delay() {
            return this.delay;
        }

        public Runnable runnable() {
            return this.runnable;
        }

        public void runnable_$eq(Runnable x$1) {
            this.runnable = x$1;
        }

        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancelled_$eq(boolean x$1) {
            this.cancelled = x$1;
        }

        public boolean done() {
            return this.done;
        }

        public void done_$eq(boolean x$1) {
            this.done = x$1;
        }

        public WrappedRunnable(long delay) {
            this.delay = delay;
            this.cancelled = false;
            this.done = false;
        }
    }

    public static class ScheduledExpiry<T>
    implements ScheduledFuture<T> {
        private final WrappedRunnable runnable;

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.runnable.delay(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed o) {
            return Long.compare(this.runnable.delay(), o.getDelay(TimeUnit.MILLISECONDS));
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.runnable.cancelled_$eq(true);
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.runnable.cancelled();
        }

        @Override
        public boolean isDone() {
            return this.runnable.done();
        }

        @Override
        public T get() {
            this.runnable.runnable().run();
            return (T)BoxedUnit.UNIT;
        }

        @Override
        public T get(long timeout, TimeUnit unit) {
            this.runnable.runnable().run();
            return (T)BoxedUnit.UNIT;
        }

        public ScheduledExpiry(WrappedRunnable runnable) {
            this.runnable = runnable;
        }
    }
}

