/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.data;

import com.typesafe.scalalogging.LazyLogging;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.kafka.consumer.ThreadedConsumer;
import org.locationtech.geomesa.kafka.consumer.ThreadedConsumer$;
import org.locationtech.geomesa.kafka.data.KafkaCacheLoader$LoaderStatus$;
import org.locationtech.geomesa.kafka.data.KafkaDataStore;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCache;
import org.locationtech.geomesa.kafka.index.KafkaFeatureCache$;
import org.locationtech.geomesa.kafka.utils.GeoMessage;
import org.locationtech.geomesa.kafka.utils.GeoMessageSerializer;
import org.locationtech.geomesa.kafka.versions.KafkaConsumerVersions$;
import org.locationtech.geomesa.kafka.versions.RecordVersions$;
import org.locationtech.geomesa.utils.concurrent.CachedThreadPool$;
import org.locationtech.geomesa.utils.io.IsCloseable;
import org.locationtech.geomesa.utils.io.IsCloseable$;
import org.locationtech.geomesa.utils.io.package;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rUdaB&M!\u0003\r\na\u0016\u0005\u0006a\u00021\t!]\u0004\u0006q2C\t!\u001f\u0004\u0006\u00172C\ta\u001f\u0005\b\u0003\u000b\u0019A\u0011AA\u0004\u000f\u001d\tIa\u0001E\u0001\u0003\u00171q!a\u0004\u0004\u0011\u0003\t\t\u0002C\u0004\u0002\u0006\u0019!\t!a\u0005\t\u0013\u0005UaA1A\u0005\n\u0005]\u0001\u0002CA\u0013\r\u0001\u0006I!!\u0007\t\u0013\u0005\u001dbA1A\u0005\n\u0005%\u0002\u0002CA\u001e\r\u0001\u0006I!a\u000b\t\u000f\u0005ub\u0001\"\u0001\u0002@!9\u00111\n\u0004\u0005\u0002\u00055\u0003bBA,\r\u0011\u0005\u0011\u0011L\u0004\b\u00037\u001a\u0001\u0012AA/\r\u001d\tyf\u0001E\u0001\u0003CBq!!\u0002\u0011\t\u0003\t)\u0007C\u0004q!\t\u0007I\u0011I9\t\u000f\u0005\u001d\u0004\u0003)A\u0005e\"9\u0011\u0011\u000e\t\u0005B\u0005-dABA7\u0007\u0001\ty\u0007\u0003\u0006\u0002~U\u0011\t\u0011)A\u0005\u0003\u007fB\u0001\u0002]\u000b\u0003\u0006\u0004%\t%\u001d\u0005\n\u0003O*\"\u0011!Q\u0001\nID!\"a&\u0016\u0005\u0003\u0005\u000b\u0011BAM\u0011)\t\t.\u0006B\u0001B\u0003%\u00111\u001b\u0005\u000b\u0003G,\"\u0011!Q\u0001\n\u0005\u0015\bBCAy+\t\u0005\t\u0015!\u0003\u0002t\"Q\u0011q`\u000b\u0003\u0002\u0003\u0006IA!\u0001\t\u0015\tMQC!A!\u0002\u0013\u0011)\u0002C\u0004\u0002\u0006U!\tAa\u000e\t\u0013\t-SC1A\u0005\n\t5\u0003\u0002CB8+\u0001\u0006IAa\u0014\t\u000f\r\u001dS\u0003\"\u0001\u0002l!9\u0011\u0011N\u000b\u0005B\u0005-\u0004\u0002CB\u001d+\u0011E3a!\u001d\u0007\r\tM3\u0001\u0002B+\u0011)\ti(\nB\u0001B\u0003%\u0011q\u0010\u0005\u000b\u0003/+#\u0011!Q\u0001\n\u0005e\u0005BCAiK\t\u0005\t\u0015!\u0003\u0002T\"Q\u00111]\u0013\u0003\u0002\u0003\u0006I!!:\t\u0015\u0005EXE!A!\u0002\u0013\t\u0019\u0010\u0003\u0006\u0003d\u0015\u0012\t\u0011)A\u0005\u0005\u000fA!B!\u001a&\u0005\u0003\u0005\u000b\u0011\u0002B\u000b\u0011)\u00119'\nB\u0001B\u0003%!\u0011\b\u0005\b\u0003\u000b)C\u0011\u0001B5\u0011\u001d\u0001XE1A\u0005\nEDq!a\u001a&A\u0003%!\u000fC\u0005\u0003|\u0015\u0012\r\u0011\"\u0003\u0003~!A!1S\u0013!\u0002\u0013\u0011y\bC\u0005\u0003\u0016\u0016\u0012\r\u0011\"\u0003\u0003\u0018\"A!1T\u0013!\u0002\u0013\u0011I\nC\u0005\u0003\u001e\u0016\u0002\r\u0011\"\u0003\u0003 \"I!\u0011U\u0013A\u0002\u0013%!1\u0015\u0005\t\u0005S+\u0003\u0015)\u0003\u0002B!Y!1W\u0013A\u0002\u0003\u0007I\u0011\u0002B[\u0011-\u0011i,\na\u0001\u0002\u0004%IAa0\t\u0017\t\rW\u00051A\u0001B\u0003&!q\u0017\u0005\f\u0005\u000b,\u0003\u0019!a\u0001\n\u0013\u00119\rC\u0006\u0003l\u0016\u0002\r\u00111A\u0005\n\t5\bb\u0003BmK\u0001\u0007\t\u0011)Q\u0005\u0005\u0013DqA!?&\t\u0003\u0012Y\u0010C\u0004\u0004\u0014\u0015\"\te!\u0006\t\u000f\reQ\u0005\"\u0015\u0004\u001c!91\u0011H\u0013\u0005R\rm\u0002bBB$K\u0011\u0005\u00111\u000e\u0005\b\u0007\u0013*C\u0011IA6\u0011\u001d\tI'\nC!\u0003W2aaa\u0013&\t\r5\u0003BCB\u0010\u000b\n\u0005\t\u0015!\u0003\u0002T\"Q\u0011qO#\u0003\u0002\u0003\u0006I!!-\t\u0015\r\u0015RI!A!\u0002\u0013\u00199\u0003C\u0004\u0002\u0006\u0015#\taa\u0016\t\u000f\r\u0005T\t\"\u0015\u0004d\t\u00012*\u00194lC\u000e\u000b7\r[3M_\u0006$WM\u001d\u0006\u0003\u001b:\u000bA\u0001Z1uC*\u0011q\nU\u0001\u0006W\u000647.\u0019\u0006\u0003#J\u000bqaZ3p[\u0016\u001c\u0018M\u0003\u0002T)\u0006aAn\\2bi&|g\u000e^3dQ*\tQ+A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u00011\u00024\u0007CA-_\u001b\u0005Q&BA.]\u0003\u0011a\u0017M\\4\u000b\u0003u\u000bAA[1wC&\u0011qL\u0017\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005\u0005$W\"\u00012\u000b\u0005\rd\u0016AA5p\u0013\t)'MA\u0005DY>\u001cX-\u00192mKB\u0011qM\\\u0007\u0002Q*\u0011\u0011N[\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003W2\f\u0001\u0002^=qKN\fg-\u001a\u0006\u0002[\u0006\u00191m\\7\n\u0005=D'a\u0003'bufdunZ4j]\u001e\fQaY1dQ\u0016,\u0012A\u001d\t\u0003gZl\u0011\u0001\u001e\u0006\u0003k:\u000bQ!\u001b8eKbL!a\u001e;\u0003#-\u000bgm[1GK\u0006$XO]3DC\u000eDW-\u0001\tLC\u001a\\\u0017mQ1dQ\u0016du.\u00193feB\u0011!pA\u0007\u0002\u0019N\u00191\u0001 4\u0011\u0007u\f\t!D\u0001\u007f\u0015\u0005y\u0018!B:dC2\f\u0017bAA\u0002}\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A=\u0002\u00191{\u0017\rZ3s'R\fG/^:\u0011\u0007\u00055a!D\u0001\u0004\u00051au.\u00193feN#\u0018\r^;t'\t1A\u0010\u0006\u0002\u0002\f\u00059An\\1eS:<WCAA\r!\u0015\tY\"!\t}\u001b\t\tiBC\u0002\u0002 q\u000bA!\u001e;jY&!\u00111EA\u000f\u0005\r\u0019V\r^\u0001\tY>\fG-\u001b8hA\u0005\u0011b-\u001b:ti2{\u0017\rZ*uCJ$H+[7f+\t\tY\u0003\u0005\u0003\u0002.\u0005]RBAA\u0018\u0015\u0011\t\t$a\r\u0002\r\u0005$x.\\5d\u0015\u0011\t)$!\b\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002:\u0005=\"AC!u_6L7\rT8oO\u0006\u0019b-\u001b:ti2{\u0017\rZ*uCJ$H+[7fA\u0005I1\u000f^1si2{\u0017\r\u001a\u000b\u0005\u0003\u0003\n9\u0005E\u0002~\u0003\u0007J1!!\u0012\u007f\u0005\u001d\u0011un\u001c7fC:Da!!\u0013\r\u0001\u0004a\u0018A\u00027pC\u0012,'/A\u0007d_6\u0004H.\u001a;fI2{\u0017\r\u001a\u000b\u0005\u0003\u001f\n)\u0006E\u0002~\u0003#J1!a\u0015\u007f\u0005\u0011)f.\u001b;\t\r\u0005%S\u00021\u0001}\u0003%\tG\u000e\u001c'pC\u0012,G\r\u0006\u0002\u0002B\u0005Qaj\\(q\u0019>\fG-\u001a:\u0011\u0007\u00055\u0001C\u0001\u0006O_>\u0003Hj\\1eKJ\u001cB\u0001\u0005-\u0002dA\u0011!\u0010\u0001\u000b\u0003\u0003;\naaY1dQ\u0016\u0004\u0013!B2m_N,GCAA(\u0005QY\u0015MZ6b\u0007\u0006\u001c\u0007.\u001a'pC\u0012,'/S7qYN)Q#!\u001d\u0002dA!\u00111OA=\u001b\t\t)HC\u0002\u0002x9\u000b\u0001bY8ogVlWM]\u0005\u0005\u0003w\n)H\u0001\tUQJ,\u0017\rZ3e\u0007>t7/^7fe\u0006\u00191O\u001a;\u0011\t\u0005\u0005\u00151S\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u000611/[7qY\u0016TA!!#\u0002\f\u00069a-Z1ukJ,'\u0002BAG\u0003\u001f\u000b1!\u00199j\u0015\r\t\t\nV\u0001\tO\u0016|Go\\8mg&!\u0011QSAB\u0005E\u0019\u0016.\u001c9mK\u001a+\u0017\r^;sKRK\b/Z\u0001\nG>t7/^7feN\u0004b!a'\u0002,\u0006Ef\u0002BAO\u0003OsA!a(\u0002&6\u0011\u0011\u0011\u0015\u0006\u0004\u0003G3\u0016A\u0002\u001fs_>$h(C\u0001\u0000\u0013\r\tIK`\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti+a,\u0003\u0007M+\u0017OC\u0002\u0002*z\u0004\u0002\"a-\u0002B\u0006\u0015\u0017QY\u0007\u0003\u0003kSA!a\u001e\u00028*!\u0011\u0011XA^\u0003\u001d\u0019G.[3oiNT1aTA_\u0015\r\ty\fV\u0001\u0007CB\f7\r[3\n\t\u0005\r\u0017Q\u0017\u0002\t\u0007>t7/^7feB)Q0a2\u0002L&\u0019\u0011\u0011\u001a@\u0003\u000b\u0005\u0013(/Y=\u0011\u0007u\fi-C\u0002\u0002Pz\u0014AAQ=uK\u0006)Ao\u001c9jGB!\u0011Q[Ao\u001d\u0011\t9.!7\u0011\u0007\u0005}e0C\u0002\u0002\\z\fa\u0001\u0015:fI\u00164\u0017\u0002BAp\u0003C\u0014aa\u0015;sS:<'bAAn}\u0006IaM]3rk\u0016t7-\u001f\t\u0005\u0003O\fi/\u0004\u0002\u0002j*\u0019\u00111\u001e/\u0002\tQLW.Z\u0005\u0005\u0003_\fIO\u0001\u0005EkJ\fG/[8o\u0003)\u0019XM]5bY&TXM\u001d\t\u0005\u0003k\fY0\u0004\u0002\u0002x*\u0019\u0011\u0011 (\u0002\u000bU$\u0018\u000e\\:\n\t\u0005u\u0018q\u001f\u0002\u0015\u000f\u0016|W*Z:tC\u001e,7+\u001a:jC2L'0\u001a:\u0002\u0017%t\u0017\u000e^5bY2{\u0017\r\u001a\t\u0006{\n\r!qA\u0005\u0004\u0005\u000bq(AB(qi&|g\u000e\u0005\u0003\u0003\n\tEQB\u0001B\u0006\u0015\u0011\u0011iAa\u0004\u0002\u0011\u0011,(/\u0019;j_:T1!!\u000e\u007f\u0013\u0011\tyOa\u0003\u0002#%t\u0017\u000e^5bY2{\u0017\rZ\"p]\u001aLw\r\u0005\u0003\u0003\u0018\tEb\u0002\u0002B\r\u0005[qAAa\u0007\u0003,9!!Q\u0004B\u0015\u001d\u0011\u0011yBa\n\u000f\t\t\u0005\"Q\u0005\b\u0005\u0003?\u0013\u0019#C\u0001V\u0013\t\u0019F+\u0003\u0002R%&\u0011q\nU\u0005\u0003\u001b:K1Aa\fM\u00039Y\u0015MZ6b\t\u0006$\u0018m\u0015;pe\u0016LAAa\r\u00036\t\u0001R\t\u001f9jef$\u0016.\\3D_:4\u0017n\u001a\u0006\u0004\u0005_aEC\u0005B\u001d\u0005w\u0011iDa\u0010\u0003B\t\r#Q\tB$\u0005\u0013\u00022!!\u0004\u0016\u0011\u001d\tih\ba\u0001\u0003\u007fBQ\u0001]\u0010A\u0002IDq!a& \u0001\u0004\tI\nC\u0004\u0002R~\u0001\r!a5\t\u000f\u0005\rx\u00041\u0001\u0002f\"9\u0011\u0011_\u0010A\u0002\u0005M\bbBA\u0000?\u0001\u0007!\u0011\u0001\u0005\b\u0005'y\u0002\u0019\u0001B\u000b\u00035Ig.\u001b;jC2du.\u00193feV\u0011!q\n\t\u0006{\n\r!\u0011\u000b\t\u0004\u0003\u001b)#!D%oSRL\u0017\r\u001c'pC\u0012,'oE\u0004&\u0003c\u00129F!\u0018\u0011\u0007e\u0013I&C\u0002\u0003\\i\u0013\u0001BU;o]\u0006\u0014G.\u001a\t\u0005\u0003g\u0013y&\u0003\u0003\u0003b\u0005U&!G\"p]N,X.\u001a:SK\n\fG.\u00198dK2K7\u000f^3oKJ\f\u0001B]3bI\n\u000b7m[\u0001\t_J$WM]5oO\u00061Ao\u001c'pC\u0012$\"C!\u0015\u0003l\t5$q\u000eB9\u0005g\u0012)Ha\u001e\u0003z!9\u0011Q\u0010\u0018A\u0002\u0005}\u0004bBAL]\u0001\u0007\u0011\u0011\u0014\u0005\b\u0003#t\u0003\u0019AAj\u0011\u001d\t\u0019O\fa\u0001\u0003KDq!!=/\u0001\u0004\t\u0019\u0010C\u0004\u0003d9\u0002\rAa\u0002\t\u000f\t\u0015d\u00061\u0001\u0003\u0016!9!q\r\u0018A\u0002\te\u0012aB8gMN,Go]\u000b\u0003\u0005\u007f\u0002\u0002B!!\u0003\u0004\n\u001d%QR\u0007\u0003\u0003gIAA!\"\u00024\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u0007u\u0014I)C\u0002\u0003\fz\u00141!\u00138u!\ri(qR\u0005\u0004\u0005#s(\u0001\u0002'p]\u001e\f\u0001b\u001c4gg\u0016$8\u000fI\u0001\u000bCN\u001c\u0018n\u001a8nK:$XC\u0001BM!\u0019\tY\"!\t\u0003\b\u0006Y\u0011m]:jO:lWM\u001c;!\u0003\u0011!wN\\3\u0016\u0005\u0005\u0005\u0013\u0001\u00033p]\u0016|F%Z9\u0015\t\u0005=#Q\u0015\u0005\n\u0005O3\u0014\u0011!a\u0001\u0003\u0003\n1\u0001\u001f\u00132\u0003\u0015!wN\\3!Q\r9$Q\u0016\t\u0004{\n=\u0016b\u0001BY}\nAao\u001c7bi&dW-A\u0003mCR\u001c\u0007.\u0006\u0002\u00038B!!\u0011\u0011B]\u0013\u0011\u0011Y,a\r\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\u0006IA.\u0019;dQ~#S-\u001d\u000b\u0005\u0003\u001f\u0012\t\rC\u0005\u0003(f\n\t\u00111\u0001\u00038\u00061A.\u0019;dQ\u0002\n!b];c[&\u001c8/[8o+\t\u0011I\r\r\u0003\u0003L\nU\u0007C\u0002BA\u0005\u001b\u0014\t.\u0003\u0003\u0003P\u0006M\"A\u0002$viV\u0014X\r\u0005\u0003\u0003T\nUG\u0002\u0001\u0003\f\u0005/l\u0014\u0011!A\u0001\u0006\u0003\u0011iNA\u0002`IE\n1b];c[&\u001c8/[8oA!\u001aQH!,\u0012\t\t}'Q\u001d\t\u0004{\n\u0005\u0018b\u0001Br}\n9aj\u001c;iS:<\u0007cA?\u0003h&\u0019!\u0011\u001e@\u0003\u0007\u0005s\u00170\u0001\btk\nl\u0017n]:j_:|F%Z9\u0015\t\u0005=#q\u001e\u0005\n\u0005Oc\u0014\u0011!a\u0001\u0005c\u0004DAa=\u0003xB1!\u0011\u0011Bg\u0005k\u0004BAa5\u0003x\u0012a!q\u001bBx\u0003\u0003\u0005\tQ!\u0001\u0003^\u0006\u0019rN\u001c)beRLG/[8ogJ+go\\6fIR!\u0011q\nB\u007f\u0011\u001d\u0011yP\u0010a\u0001\u0007\u0003\tq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u00037\u0019\u0019aa\u0002\n\t\r\u0015\u0011Q\u0004\u0002\u000b\u0007>dG.Z2uS>t\u0007\u0003BB\u0005\u0007\u001fi!aa\u0003\u000b\t\r5\u00111X\u0001\u0007G>lWn\u001c8\n\t\rE11\u0002\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003Qyg\u000eU1si&$\u0018n\u001c8t\u0003N\u001c\u0018n\u001a8fIR!\u0011qJB\f\u0011\u001d\u0011yp\u0010a\u0001\u0007\u0003\tac\u0019:fCR,7i\u001c8tk6,'OU;o]\u0006\u0014G.\u001a\u000b\t\u0005/\u001aib!\t\u0004$!91q\u0004!A\u0002\u0005M\u0017AA5e\u0011\u001d\t9\b\u0011a\u0001\u0003cCqa!\nA\u0001\u0004\u00199#A\u0004iC:$G.\u001a:\u0011\t\r%21\u0007\b\u0005\u0007W\u0019yC\u0004\u0003\u0003\u001c\r5\u0012bAA<\u001d&!1\u0011GA;\u0003A!\u0006N]3bI\u0016$7i\u001c8tk6,'/\u0003\u0003\u00046\r]\"\u0001F\"p]N,X.\u001a:FeJ|'\u000fS1oI2,'O\u0003\u0003\u00042\u0005U\u0014aB2p]N,X.\u001a\u000b\u0005\u0003\u001f\u001ai\u0004C\u0004\u0004@\u0005\u0003\ra!\u0011\u0002\rI,7m\u001c:e!!\t\u0019la\u0011\u0002F\u0006\u0015\u0017\u0002BB#\u0003k\u0013abQ8ogVlWM\u001d*fG>\u0014H-A\u0003ti\u0006\u0014H/A\u0002sk:\u0014Q$\u00138ji&\fG\u000eT8bI\u0016\u00148i\u001c8tk6,'OU;o]\u0006\u0014G.Z\n\u0004\u000b\u000e=\u0003\u0003BB)\u0007'j\u0011!J\u0005\u0005\u0007+\nIH\u0001\tD_:\u001cX/\\3s%Vtg.\u00192mKRA1\u0011LB.\u0007;\u001ay\u0006E\u0002\u0004R\u0015Cqaa\bJ\u0001\u0004\t\u0019\u000eC\u0004\u0002x%\u0003\r!!-\t\u000f\r\u0015\u0012\n1\u0001\u0004(\u0005Y\u0001O]8dKN\u001c\bk\u001c7m)\u0011\tye!\u001a\t\u000f\r\u001d$\n1\u0001\u0004j\u00051!/Z:vYR\u0004\u0002\"a-\u0004l\u0005\u0015\u0017QY\u0005\u0005\u0007[\n)LA\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3t\u00039Ig.\u001b;jC2du.\u00193fe\u0002\"B!a\u0014\u0004t!91q\b\u0013A\u0002\r\u0005\u0003")
public interface KafkaCacheLoader
extends Closeable,
LazyLogging {
    public KafkaFeatureCache cache();

    private static class InitialLoader
    extends ThreadedConsumer
    implements Runnable,
    ConsumerRebalanceListener {
        private final Seq<Consumer<byte[], byte[]>> consumers;
        public final String org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$topic;
        private final GeoMessageSerializer serializer;
        private final Duration readBack;
        private final KafkaCacheLoaderImpl toLoad;
        private final KafkaFeatureCache cache;
        private final ConcurrentHashMap<Object, Object> org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$offsets;
        private final Set<Object> assignment;
        private volatile boolean done;
        private CountDownLatch org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$latch;
        private volatile Future<?> submission;

        public void onPartitionsLost(Collection<TopicPartition> x$1) {
            super.onPartitionsLost(x$1);
        }

        private KafkaFeatureCache cache() {
            return this.cache;
        }

        public ConcurrentHashMap<Object, Object> org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$offsets() {
            return this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$offsets;
        }

        private Set<Object> assignment() {
            return this.assignment;
        }

        private boolean done() {
            return this.done;
        }

        private void done_$eq(boolean x$1) {
            this.done = x$1;
        }

        public CountDownLatch org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$latch() {
            return this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$latch;
        }

        private void latch_$eq(CountDownLatch x$1) {
            this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$latch = x$1;
        }

        private Future<?> submission() {
            return this.submission;
        }

        private void submission_$eq(Future<?> x$1) {
            this.submission = x$1;
        }

        public void onPartitionsRevoked(Collection<TopicPartition> topicPartitions) {
        }

        public void onPartitionsAssigned(Collection<TopicPartition> topicPartitions) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Partitions assigned: {}", (Object)((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(topicPartitions).asScala()).mkString(", "));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(topicPartitions).asScala()).foreach((Function1 & Serializable)tp -> {
                InitialLoader.$anonfun$onPartitionsAssigned$1(this, tp);
                return BoxedUnit.UNIT;
            });
        }

        public Runnable createConsumerRunnable(String id, Consumer<byte[], byte[]> consumer, ThreadedConsumer.ConsumerErrorHandler handler) {
            return new InitialLoaderConsumerRunnable(this, id, consumer, handler);
        }

        public void consume(ConsumerRecord<byte[], byte[]> record) {
            BoxedUnit boxedUnit;
            if (this.done()) {
                this.toLoad.consume(record);
                return;
            }
            Map headers = RecordVersions$.MODULE$.getHeaders(record);
            long timestamp = RecordVersions$.MODULE$.getTimestamp(record);
            GeoMessage message = this.serializer.deserialize((byte[])record.key(), (byte[])record.value(), (Map<String, byte[]>)headers, timestamp);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Consumed message [{}:{}:{}] {}", new Object[]{this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$topic, BoxesRunTime.boxToInteger((int)record.partition()), BoxesRunTime.boxToLong((long)record.offset()), message});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            GeoMessage geoMessage = message;
            if (geoMessage instanceof GeoMessage.Change) {
                GeoMessage.Change change = (GeoMessage.Change)geoMessage;
                this.toLoad.cache().fireChange(timestamp, change.feature());
                this.cache().put(change.feature());
            } else if (geoMessage instanceof GeoMessage.Delete) {
                GeoMessage.Delete delete = (GeoMessage.Delete)geoMessage;
                this.toLoad.cache().fireDelete(timestamp, delete.id(), (Function0<SimpleFeature>)(Function0 & Serializable)() -> (SimpleFeature)this.cache().query(delete.id()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                this.cache().remove(delete.id());
            } else if (geoMessage instanceof GeoMessage.Clear) {
                this.toLoad.cache().fireClear(timestamp);
                this.cache().clear();
            } else {
                throw new IllegalArgumentException(new StringBuilder(17).append("Unknown message: ").append(geoMessage).toString());
            }
            if (record.offset() > 0L && record.offset() % 0x100000L == 0L) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Initial load: consumed [{}:{}:{}]", new Object[]{this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$topic, BoxesRunTime.boxToInteger((int)record.partition()), BoxesRunTime.boxToLong((long)record.offset())});
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                return;
            }
        }

        public void start() {
            KafkaCacheLoader$LoaderStatus$.MODULE$.startLoad(this);
            try {
                BoxedUnit boxedUnit;
                Buffer partitions = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(((Consumer)this.consumers.head()).partitionsFor(this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$topic)).asScala()).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.partition()));
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Starting initial load for [{}] with {} partitions", new Object[]{this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$topic, BoxesRunTime.boxToInteger((int)partitions.size())});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.latch_$eq(new CountDownLatch(partitions.size()));
                this.startConsumers(this.startConsumers$default$1());
                this.submission_$eq(CachedThreadPool$.MODULE$.submit((Runnable)this));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    KafkaCacheLoader$LoaderStatus$.MODULE$.completedLoad(this);
                    throw e;
                }
                throw throwable;
            }
        }

        @Override
        public void run() {
            try {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                try {
                    this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$latch().await();
                }
                finally {
                    super.close();
                }
                this.done_$eq(true);
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Finished initial load, transferring to indexed cache for [{}]", (Object)this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$topic);
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                this.cache().query((Filter)Filter.INCLUDE).foreach((Function1 & Serializable)feature -> {
                    InitialLoader.$anonfun$run$1(this, feature);
                    return BoxedUnit.UNIT;
                });
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("Finished transfer for [{}], starting normal load", (Object)this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$topic);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.toLoad.startConsumers(this.toLoad.startConsumers$default$1());
            }
            finally {
                KafkaCacheLoader$LoaderStatus$.MODULE$.completedLoad(this);
            }
        }

        public void close() {
            try {
                super.close();
            }
            finally {
                if (this.submission() != null && !this.submission().isDone()) {
                    this.submission().cancel(true);
                }
            }
        }

        public static final /* synthetic */ boolean $anonfun$onPartitionsAssigned$2(TopicPartition tp$1, Consumer x$5) {
            return x$5.assignment().contains(tp$1);
        }

        public static final /* synthetic */ void $anonfun$onPartitionsAssigned$1(InitialLoader $this, TopicPartition tp) {
            if ($this.assignment().add(BoxesRunTime.boxToInteger((int)tp.partition()))) {
                block21: {
                    Consumer consumer = (Consumer)$this.consumers.find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)InitialLoader.$anonfun$onPartitionsAssigned$2(tp, x$5))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    if (consumer == null) {
                        BoxedUnit boxedUnit;
                        if ($this.logger().underlying().isWarnEnabled()) {
                            $this.logger().underlying().warn("Partition assigned but no consumer contains the assignment");
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    KafkaConsumerVersions$.MODULE$.pause(consumer, tp);
                    try {
                        Option option;
                        BoxedUnit boxedUnit;
                        BoxedUnit boxedUnit2;
                        if ($this.logger().underlying().isDebugEnabled()) {
                            $this.logger().underlying().debug("Checking offsets for [{}:{}]", new Object[]{tp.topic(), BoxesRunTime.boxToInteger((int)tp.partition())});
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        consumer.seekToEnd(Collections.singleton(tp));
                        long end = consumer.position(tp);
                        if ($this.logger().underlying().isDebugEnabled()) {
                            $this.logger().underlying().debug("Setting max offset to [{}:{}:{}]", new Object[]{tp.topic(), BoxesRunTime.boxToInteger((int)tp.partition()), BoxesRunTime.boxToLong((long)(end - 1L))});
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        $this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$offsets().put(BoxesRunTime.boxToInteger((int)tp.partition()), BoxesRunTime.boxToLong((long)(end - 1L)));
                        if (!$this.readBack.isFinite()) {
                            KafkaConsumerVersions$.MODULE$.seekToBeginning(consumer, tp);
                            break block21;
                        }
                        Try offset = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                            long time = System.currentTimeMillis() - $this.readBack.toMillis();
                            return KafkaConsumerVersions$.MODULE$.offsetsForTimes(consumer, tp.topic(), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{tp.partition()})), time).get((Object)BoxesRunTime.boxToInteger((int)tp.partition()));
                        });
                        boolean bl = false;
                        Success success = null;
                        Try try_ = offset;
                        if (try_ instanceof Success) {
                            bl = true;
                            success = (Success)try_;
                            Option option2 = (Option)success.value();
                            if (option2 instanceof Some) {
                                BoxedUnit boxedUnit3;
                                Some some = (Some)option2;
                                long o = BoxesRunTime.unboxToLong((Object)some.value());
                                if ($this.logger().underlying().isDebugEnabled()) {
                                    $this.logger().underlying().debug("Seeking to offset {} for read-back {} on [{}:{}]", new Object[]{BoxesRunTime.boxToLong((long)o), $this.readBack, tp.topic(), BoxesRunTime.boxToInteger((int)tp.partition())});
                                    boxedUnit3 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit3 = BoxedUnit.UNIT;
                                }
                                consumer.seek(tp, o);
                                break block21;
                            }
                        }
                        if (bl && None$.MODULE$.equals(option = (Option)success.value())) {
                            if ($this.logger().underlying().isDebugEnabled()) {
                                $this.logger().underlying().debug(new StringBuilder(71).append("No prior offset found for read-back ").append($this.readBack).append(" on [").append(tp.topic()).append(":").append(tp.partition()).append("], ").append("reading from head of queue").toString());
                            }
                            break block21;
                        }
                        if (try_ instanceof Failure) {
                            BoxedUnit boxedUnit4;
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            if ($this.logger().underlying().isWarnEnabled()) {
                                $this.logger().underlying().warn(new StringBuilder(55).append("Error finding initial offset: [").append(tp.topic()).append(":").append(tp.partition()).append("], seeking to beginning").toString(), e);
                                boxedUnit4 = BoxedUnit.UNIT;
                            } else {
                                boxedUnit4 = BoxedUnit.UNIT;
                            }
                            KafkaConsumerVersions$.MODULE$.seekToBeginning(consumer, tp);
                            break block21;
                        }
                        throw new MatchError((Object)try_);
                    }
                    finally {
                        KafkaConsumerVersions$.MODULE$.resume(consumer, tp);
                    }
                }
                return;
            }
        }

        public static final /* synthetic */ void $anonfun$run$1(InitialLoader $this, SimpleFeature feature) {
            $this.toLoad.cache().put(feature);
        }

        public InitialLoader(SimpleFeatureType sft, Seq<Consumer<byte[], byte[]>> consumers, String topic, java.time.Duration frequency, GeoMessageSerializer serializer, Duration readBack, KafkaDataStore.ExpiryTimeConfig ordering, KafkaCacheLoaderImpl toLoad) {
            this.consumers = consumers;
            this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$topic = topic;
            this.serializer = serializer;
            this.readBack = readBack;
            this.toLoad = toLoad;
            super(consumers, frequency, false);
            this.cache = KafkaFeatureCache$.MODULE$.nonIndexing(sft, ordering);
            this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$offsets = new ConcurrentHashMap();
            this.assignment = Collections.newSetFromMap(new ConcurrentHashMap());
            this.done = false;
        }

        private class InitialLoaderConsumerRunnable
        extends ThreadedConsumer.ConsumerRunnable {
            private final Consumer<byte[], byte[]> consumer;

            public void processPoll(ConsumerRecords<byte[], byte[]> result) {
                try {
                    super.processPoll(result);
                }
                finally {
                    ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(result.partitions()).asScala()).foreach((Function1 & Serializable)tp -> {
                        InitialLoaderConsumerRunnable.$anonfun$processPoll$1(this, tp);
                        return BoxedUnit.UNIT;
                    });
                }
            }

            public /* synthetic */ InitialLoader org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$InitialLoaderConsumerRunnable$$$outer() {
                return (InitialLoader)this.$outer;
            }

            public static final /* synthetic */ void $anonfun$processPoll$1(InitialLoaderConsumerRunnable $this, TopicPartition tp) {
                long position = $this.consumer.position(tp);
                if (position >= BoxesRunTime.unboxToLong((Object)$this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$InitialLoaderConsumerRunnable$$$outer().org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$offsets().getOrDefault(BoxesRunTime.boxToInteger((int)tp.partition()), BoxesRunTime.boxToLong((long)Long.MAX_VALUE)))) {
                    BoxedUnit boxedUnit;
                    BoxedUnit boxedUnit2;
                    $this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$InitialLoaderConsumerRunnable$$$outer().org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$offsets().remove(BoxesRunTime.boxToInteger((int)tp.partition()));
                    $this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$InitialLoaderConsumerRunnable$$$outer().org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$latch().countDown();
                    if ($this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$InitialLoaderConsumerRunnable$$$outer().logger().underlying().isInfoEnabled()) {
                        $this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$InitialLoaderConsumerRunnable$$$outer().logger().underlying().info("Initial load: consumed [{}:{}:{}]", new Object[]{$this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$InitialLoaderConsumerRunnable$$$outer().org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$topic, BoxesRunTime.boxToInteger((int)tp.partition()), BoxesRunTime.boxToLong((long)(position - 1L))});
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    if ($this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$InitialLoaderConsumerRunnable$$$outer().logger().underlying().isInfoEnabled()) {
                        $this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$InitialLoaderConsumerRunnable$$$outer().logger().underlying().info("Initial load completed for [{}:{}], {} partitions remaining", new Object[]{$this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$InitialLoaderConsumerRunnable$$$outer().org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$topic, BoxesRunTime.boxToInteger((int)tp.partition()), BoxesRunTime.boxToLong((long)$this.org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$InitialLoaderConsumerRunnable$$$outer().org$locationtech$geomesa$kafka$data$KafkaCacheLoader$InitialLoader$$latch().getCount())});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
            }

            public InitialLoaderConsumerRunnable(InitialLoader $outer, String id, Consumer<byte[], byte[]> consumer, ThreadedConsumer.ConsumerErrorHandler handler) {
                this.consumer = consumer;
                super((ThreadedConsumer)$outer, id, consumer, handler);
            }
        }
    }

    public static class KafkaCacheLoaderImpl
    extends ThreadedConsumer
    implements KafkaCacheLoader {
        private final SimpleFeatureType sft;
        private final KafkaFeatureCache cache;
        private final Seq<Consumer<byte[], byte[]>> consumers;
        private final String topic;
        private final java.time.Duration frequency;
        private final GeoMessageSerializer serializer;
        private final KafkaDataStore.ExpiryTimeConfig initialLoadConfig;
        private final Option<InitialLoader> initialLoader;

        @Override
        public KafkaFeatureCache cache() {
            return this.cache;
        }

        private Option<InitialLoader> initialLoader() {
            return this.initialLoader;
        }

        public void start() {
            Option<InitialLoader> option = this.initialLoader();
            if (None$.MODULE$.equals(option)) {
                this.consumers.foreach((Function1 & Serializable)x$1 -> {
                    KafkaConsumerVersions$.MODULE$.subscribe(x$1, this.topic);
                    return BoxedUnit.UNIT;
                });
                this.startConsumers(this.startConsumers$default$1());
                return;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                InitialLoader loader = (InitialLoader)some.value();
                this.consumers.foreach((Function1 & Serializable)x$2 -> {
                    KafkaConsumerVersions$.MODULE$.subscribe(x$2, this.topic, (ConsumerRebalanceListener)loader);
                    return BoxedUnit.UNIT;
                });
                loader.start();
                return;
            }
            throw new MatchError(option);
        }

        @Override
        public void close() {
            try {
                super.close();
            }
            finally {
                package.CloseWithLogging$.MODULE$.apply(this.initialLoader(), (IsCloseable)IsCloseable$.MODULE$.optionIsCloseable());
                this.cache().close();
            }
        }

        public void consume(ConsumerRecord<byte[], byte[]> record) {
            BoxedUnit boxedUnit;
            Map headers = RecordVersions$.MODULE$.getHeaders(record);
            long timestamp = RecordVersions$.MODULE$.getTimestamp(record);
            GeoMessage message = this.serializer.deserialize((byte[])record.key(), (byte[])record.value(), (Map<String, byte[]>)headers, timestamp);
            if (this.logger().underlying().isTraceEnabled()) {
                this.logger().underlying().trace("Consumed message [{}:{}:{}] {}", new Object[]{this.topic, BoxesRunTime.boxToInteger((int)record.partition()), BoxesRunTime.boxToLong((long)record.offset()), message});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            GeoMessage geoMessage = message;
            if (geoMessage instanceof GeoMessage.Change) {
                GeoMessage.Change change = (GeoMessage.Change)geoMessage;
                this.cache().fireChange(timestamp, change.feature());
                this.cache().put(change.feature());
                return;
            }
            if (geoMessage instanceof GeoMessage.Delete) {
                GeoMessage.Delete delete = (GeoMessage.Delete)geoMessage;
                this.cache().fireDelete(timestamp, delete.id(), (Function0<SimpleFeature>)(Function0 & Serializable)() -> (SimpleFeature)this.cache().query(delete.id()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                this.cache().remove(delete.id());
                return;
            }
            if (geoMessage instanceof GeoMessage.Clear) {
                this.cache().fireClear(timestamp);
                this.cache().clear();
                return;
            }
            throw new IllegalArgumentException(new StringBuilder(17).append("Unknown message: ").append(geoMessage).toString());
        }

        public KafkaCacheLoaderImpl(SimpleFeatureType sft, KafkaFeatureCache cache, Seq<Consumer<byte[], byte[]>> consumers, String topic, java.time.Duration frequency, GeoMessageSerializer serializer, Option<Duration> initialLoad, KafkaDataStore.ExpiryTimeConfig initialLoadConfig) {
            Method method;
            this.sft = sft;
            this.cache = cache;
            this.consumers = consumers;
            this.topic = topic;
            this.frequency = frequency;
            this.serializer = serializer;
            this.initialLoadConfig = initialLoadConfig;
            super(consumers, frequency, ThreadedConsumer$.MODULE$.$lessinit$greater$default$3());
            try {
                method = ConsumerRecord.class.getMethod("timestamp", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("This version of Kafka doesn't support timestamps, using system time");
                    method = BoxedUnit.UNIT;
                }
                method = BoxedUnit.UNIT;
            }
            this.initialLoader = initialLoad.map((Function1 & Serializable)readBack -> new InitialLoader($this.sft, $this.consumers, $this.topic, $this.frequency, $this.serializer, (Duration)readBack, $this.initialLoadConfig, this));
        }
    }
}

