/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.data;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Properties;
import java.util.UUID;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.locationtech.geomesa.filter.factory.FastFilterFactory$;
import org.locationtech.geomesa.kafka.data.KafkaDataStore;
import org.locationtech.geomesa.kafka.utils.GeoMessageSerializer;
import org.locationtech.geomesa.utils.conf.GeoMesaSystemProperties;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.geotools.Transform;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class KafkaDataStore$
implements LazyLogging {
    public static final KafkaDataStore$ MODULE$ = new KafkaDataStore$();
    private static final String TopicKey;
    private static final String TopicConfigKey;
    private static final String PartitioningKey;
    private static final String MetadataPath;
    private static final String TransactionStateKey;
    private static final String PartitioningDefault;
    private static final GeoMesaSystemProperties.SystemProperty LoadIntervalProperty;
    private static final Tuple2<String, Enumeration.Value> CqIndexFlag;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        TopicKey = "geomesa.kafka.topic";
        TopicConfigKey = "kafka.topic.config";
        PartitioningKey = "geomesa.kafka.partitioning";
        MetadataPath = "metadata";
        TransactionStateKey = "geomesa.kafka.state";
        PartitioningDefault = "default";
        LoadIntervalProperty = new GeoMesaSystemProperties.SystemProperty("geomesa.kafka.load.interval", "1s");
        CqIndexFlag = null;
    }

    private Logger logger$lzycompute() {
        KafkaDataStore$ kafkaDataStore$ = this;
        synchronized (kafkaDataStore$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    public String TopicKey() {
        return TopicKey;
    }

    public String TopicConfigKey() {
        return TopicConfigKey;
    }

    public String PartitioningKey() {
        return PartitioningKey;
    }

    public String MetadataPath() {
        return MetadataPath;
    }

    public String TransactionStateKey() {
        return TransactionStateKey;
    }

    public String PartitioningDefault() {
        return PartitioningDefault;
    }

    public GeoMesaSystemProperties.SystemProperty LoadIntervalProperty() {
        return LoadIntervalProperty;
    }

    public Tuple2<String, Enumeration.Value> CqIndexFlag() {
        return CqIndexFlag;
    }

    public String topic(SimpleFeatureType sft) {
        return (String)sft.getUserData().get(this.TopicKey());
    }

    public void setTopic(SimpleFeatureType sft, String topic) {
        sft.getUserData().put(this.TopicKey(), topic);
    }

    public java.util.Map<String, String> topicConfig(SimpleFeatureType sft) {
        Properties props;
        block0: {
            props = new Properties();
            String config = (String)sft.getUserData().get(this.TopicConfigKey());
            if (config == null) break block0;
            props.load(new StringReader(config));
        }
        return props;
    }

    public boolean usesDefaultPartitioning(SimpleFeatureType sft) {
        Object v = sft.getUserData().get(this.PartitioningKey());
        String string = this.PartitioningDefault();
        return !(v != null ? !v.equals(string) : string != null);
    }

    public Producer<byte[], byte[]> producer(KafkaDataStore.KafkaDataStoreConfig config) {
        Map props = config.producers().properties().contains((Object)"partitioner.class") ? config.producers().properties() : (Map)config.producers().properties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partitioner.class"), (Object)GeoMessageSerializer.GeoMessagePartitioner.class.getName()));
        return this.producer(config.brokers(), props);
    }

    public Producer<byte[], byte[]> producer(String bootstrapServers, Map<String, String> properties) {
        Properties props = new Properties();
        props.put("acks", "1");
        props.put("retries", BoxesRunTime.boxToInteger((int)3));
        props.put("linger.ms", BoxesRunTime.boxToInteger((int)3));
        props.put("key.serializer", ByteArraySerializer.class.getName());
        props.put("value.serializer", ByteArraySerializer.class.getName());
        props.put("bootstrap.servers", bootstrapServers);
        properties.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return props.put(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        return new KafkaProducer(props);
    }

    public Consumer<byte[], byte[]> consumer(KafkaDataStore.KafkaDataStoreConfig config, String group) {
        return this.consumer(config.brokers(), (Map<String, String>)((Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)group)}))).$plus$plus(config.consumers().properties())));
    }

    public Consumer<byte[], byte[]> consumer(String brokers, Map<String, String> properties) {
        Properties props = new Properties();
        props.put("bootstrap.servers", brokers);
        props.put("enable.auto.commit", "false");
        props.put("key.deserializer", ByteArrayDeserializer.class.getName());
        props.put("value.deserializer", ByteArrayDeserializer.class.getName());
        properties.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return props.put(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        return new KafkaConsumer(props);
    }

    public Seq<Consumer<byte[], byte[]>> consumers(String brokers, String topic, KafkaDataStore.ConsumerConfig config) {
        BoxedUnit boxedUnit;
        Predef$.MODULE$.require(config.count() > 0, (Function0 & Serializable)() -> "Number of consumers must be greater than 0");
        Map props = (Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group.id"), (Object)new StringBuilder(0).append(config.groupPrefix()).append(UUID.randomUUID()).toString())}))).$plus$plus(config.properties());
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Creating {} consumers for topic [{}] with group-id [{}]", new Object[]{BoxesRunTime.boxToInteger((int)config.count()), topic, props.apply((Object)"group.id")});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (Seq)package$.MODULE$.Seq().fill(config.count(), (Function0 & Serializable)() -> MODULE$.consumer(brokers, (Map<String, String>)props));
    }

    public KafkaDataStore.LayerView createLayerView(SimpleFeatureType sft, KafkaDataStore.LayerViewConfig config) {
        SimpleFeatureType viewSft = SimpleFeatureTypes$.MODULE$.renameSft(sft, config.typeName());
        Option filter = config.filter().map((Function1 & Serializable)x$7 -> FastFilterFactory$.MODULE$.optimize(viewSft, x$7));
        Option transform = config.transform().map((Function1 & Serializable)x$8 -> Transform.Transforms$.MODULE$.apply(viewSft, x$8));
        SimpleFeatureType finalSft = (SimpleFeatureType)transform.map((Function1 & Serializable)x$9 -> Transform.Transforms$.MODULE$.schema(viewSft, x$9)).getOrElse((Function0 & Serializable)() -> viewSft);
        return new KafkaDataStore.LayerView(finalSft, (Option<Filter>)filter, (Option<Seq<Transform>>)transform);
    }

    private KafkaDataStore$() {
    }
}

