/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.kafka.data;

import com.github.benmanes.caffeine.cache.Ticker;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.commons.lang3.StringUtils;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.filter.text.ecql.ECQL;
import org.locationtech.geomesa.features.SerializationOption$;
import org.locationtech.geomesa.index.audit.AuditWriter;
import org.locationtech.geomesa.index.geotools.GeoMesaDataStoreFactory;
import org.locationtech.geomesa.kafka.data.KafkaDataStore;
import org.locationtech.geomesa.kafka.data.KafkaDataStore$;
import org.locationtech.geomesa.kafka.data.KafkaDataStore$ImmediatelyExpireConfig$;
import org.locationtech.geomesa.kafka.data.KafkaDataStore$NeverExpireConfig$;
import org.locationtech.geomesa.kafka.data.KafkaDataStoreParams$;
import org.locationtech.geomesa.kafka.data.KafkaDataStoreParams$SerializationTypes$;
import org.locationtech.geomesa.kafka.data.package$;
import org.locationtech.geomesa.kafka.utils.GeoMessageSerializer;
import org.locationtech.geomesa.memory.cqengine.utils.CQIndexType$;
import org.locationtech.geomesa.metrics.core.GeoMesaMetrics;
import org.locationtech.geomesa.metrics.core.GeoMesaMetrics$;
import org.locationtech.geomesa.security.AuthUtils$;
import org.locationtech.geomesa.security.AuthorizationsProvider;
import org.locationtech.geomesa.utils.audit.AuditProvider;
import org.locationtech.geomesa.utils.geotools.GeoMesaParam;
import org.locationtech.geomesa.utils.index.SizeSeparatedBucketIndex$;
import pureconfig.ConfigCursor;
import pureconfig.ConfigReader;
import pureconfig.ConfigReader$;
import pureconfig.ConfigSource$;
import pureconfig.error.CannotConvert;
import pureconfig.error.ConfigReaderFailures;
import pureconfig.error.FailureReason;
import scala.;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class KafkaDataStoreFactory$
implements GeoMesaDataStoreFactory.GeoMesaDataStoreInfo,
LazyLogging {
    public static final KafkaDataStoreFactory$ MODULE$ = new KafkaDataStoreFactory$();
    private static final ConfigReader<KafkaDataStore.LayerViewConfig> LayerViewReader;
    private static final ClassTag<KafkaDataStore.LayerViewConfig> LayerViewClassTag;
    private static final String DefaultCatalog;
    private static final String DefaultZkPath;
    private static final String DisplayName;
    private static final String Description;
    private static final GeoMesaParam<?>[] ParameterInfo;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
        LayerViewReader = ConfigReader$.MODULE$.fromCursor((Function1 & Serializable)cur -> MODULE$.readLayerViewConfig((ConfigCursor)cur));
        LayerViewClassTag = ClassTag$.MODULE$.apply(KafkaDataStore.LayerViewConfig.class);
        DefaultCatalog = package$.MODULE$.DefaultCatalog();
        DefaultZkPath = package$.MODULE$.DefaultZkPath();
        DisplayName = "Kafka (GeoMesa)";
        Description = "Apache Kafka\u2122 distributed log";
        ParameterInfo = (GeoMesaParam[])((Object[])new GeoMesaParam[]{KafkaDataStoreParams$.MODULE$.Brokers(), KafkaDataStoreParams$.MODULE$.Catalog(), KafkaDataStoreParams$.MODULE$.Zookeepers(), KafkaDataStoreParams$.MODULE$.ZkPath(), KafkaDataStoreParams$.MODULE$.ConsumerCount(), KafkaDataStoreParams$.MODULE$.ConsumerGroupPrefix(), KafkaDataStoreParams$.MODULE$.ConsumerConfig(), KafkaDataStoreParams$.MODULE$.ConsumerReadBack(), KafkaDataStoreParams$.MODULE$.CacheExpiry(), KafkaDataStoreParams$.MODULE$.DynamicCacheExpiry(), KafkaDataStoreParams$.MODULE$.EventTime(), KafkaDataStoreParams$.MODULE$.SerializationType(), KafkaDataStoreParams$.MODULE$.CqEngineIndices(), KafkaDataStoreParams$.MODULE$.IndexResolutionX(), KafkaDataStoreParams$.MODULE$.IndexResolutionY(), KafkaDataStoreParams$.MODULE$.IndexTiers(), KafkaDataStoreParams$.MODULE$.EventTimeOrdering(), KafkaDataStoreParams$.MODULE$.LazyLoad(), KafkaDataStoreParams$.MODULE$.LazyFeatures(), KafkaDataStoreParams$.MODULE$.LayerViews(), KafkaDataStoreParams$.MODULE$.MetricsReporters(), KafkaDataStoreParams$.MODULE$.AuditQueries(), KafkaDataStoreParams$.MODULE$.LooseBBox(), KafkaDataStoreParams$.MODULE$.Authorizations()});
    }

    private Logger logger$lzycompute() {
        KafkaDataStoreFactory$ kafkaDataStoreFactory$ = this;
        synchronized (kafkaDataStoreFactory$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private ConfigReader<KafkaDataStore.LayerViewConfig> LayerViewReader() {
        return LayerViewReader;
    }

    private ClassTag<KafkaDataStore.LayerViewConfig> LayerViewClassTag() {
        return LayerViewClassTag;
    }

    public String DefaultCatalog() {
        return DefaultCatalog;
    }

    public String DefaultZkPath() {
        return DefaultZkPath;
    }

    public String DisplayName() {
        return DisplayName;
    }

    public String Description() {
        return Description;
    }

    public GeoMesaParam<?>[] ParameterInfo() {
        return ParameterInfo;
    }

    public boolean canProcess(Map<String, ?> params) {
        return KafkaDataStoreParams$.MODULE$.Brokers().exists(params) && !params.containsKey("kafka.schema.registry.url");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public KafkaDataStore.KafkaDataStoreConfig buildConfig(Map<String, ?> params) {
        block23: {
            block22: {
                block21: {
                    block20: {
                        brokers = this.checkBrokerPorts((String)KafkaDataStoreParams$.MODULE$.Brokers().lookup(params));
                        zookeepers = KafkaDataStoreParams$.MODULE$.Zookeepers().lookupOpt(params);
                        catalog = zookeepers.isEmpty() != false ? this.createCatalogTopic(params) : this.createZkNamespace(params);
                        topics = new KafkaDataStore.TopicConfig((Integer)KafkaDataStoreParams$.MODULE$.TopicPartitions().lookup(params), (Integer)KafkaDataStoreParams$.MODULE$.TopicReplication().lookup(params));
                        count = (Integer)KafkaDataStoreParams$.MODULE$.ConsumerCount().lookup(params);
                        var13_7 = false;
                        var14_8 = null;
                        var15_9 = KafkaDataStoreParams$.MODULE$.ConsumerGroupPrefix().lookupOpt(params);
                        if (!None$.MODULE$.equals(var15_9)) break block20;
                        v0 = "";
                        break block21;
                    }
                    if (!(var15_9 instanceof Some)) ** GOTO lbl-1000
                    var13_7 = true;
                    var14_8 = (Some)var15_9;
                    p = (String)var14_8.value();
                    if (p.endsWith("-")) {
                        v0 = p;
                    } else if (var13_7) {
                        p = (String)var14_8.value();
                        v0 = new StringBuilder(1).append(p).append("-").toString();
                    } else {
                        throw new MatchError((Object)var15_9);
                    }
                }
                prefix = v0;
                props = (scala.collection.immutable.Map)KafkaDataStoreParams$.MODULE$.ConsumerConfig().lookupOpt(params).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildConfig$1(java.util.Properties ), (Ljava/util/Properties;)Lscala/collection/immutable/Map;)()).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$buildConfig$2(), ()Lscala/collection/immutable/Map;)());
                readBack = KafkaDataStoreParams$.MODULE$.ConsumerReadBack().lookupOpt(params);
                consumers = new KafkaDataStore.ConsumerConfig(count, prefix, (scala.collection.immutable.Map<String, String>)props, (Option<Duration>)readBack);
                props = (scala.collection.immutable.Map)KafkaDataStoreParams$.MODULE$.ProducerConfig().lookupOpt(params).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildConfig$3(java.util.Properties ), (Ljava/util/Properties;)Lscala/collection/immutable/Map;)()).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$buildConfig$4(), ()Lscala/collection/immutable/Map;)());
                producers = new KafkaDataStore.ProducerConfig((scala.collection.immutable.Map<String, String>)props);
                clearOnStart = (Boolean)KafkaDataStoreParams$.MODULE$.ClearOnStart().lookup(params);
                serialization = KafkaDataStoreParams$SerializationTypes$.MODULE$.fromName((String)KafkaDataStoreParams$.MODULE$.SerializationType().lookup(params));
                var26_20 = KafkaDataStoreParams$.MODULE$.CqEngineIndices().lookupOpt(params);
                if (var26_20 instanceof Some) {
                    var27_21 = (Some)var26_20;
                    attributes = (String)var27_21.value();
                    v1 = (scala.collection.immutable.Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])attributes.split(","))).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildConfig$5(java.lang.String ), (Ljava/lang/String;)Lscala/Tuple2;)());
                } else if (None$.MODULE$.equals(var26_20)) {
                    if (!((Boolean)KafkaDataStoreParams$.MODULE$.CqEngineCache().lookup(params)).booleanValue()) {
                        v1 = (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty();
                    } else {
                        if (this.logger().underlying().isWarnEnabled()) {
                            this.logger().underlying().warn("Parameter '{}' is deprecated, please use '{}' instead", new Object[]{KafkaDataStoreParams$.MODULE$.CqEngineCache().key, KafkaDataStoreParams$.MODULE$.CqEngineIndices().key});
                            v2 = BoxedUnit.UNIT;
                        } else {
                            v2 = BoxedUnit.UNIT;
                        }
                        v1 = new .colon.colon(KafkaDataStore$.MODULE$.CqIndexFlag(), (List)Nil$.MODULE$);
                    }
                } else {
                    throw new MatchError((Object)var26_20);
                }
                cqEngine = v1;
                buckets = new KafkaDataStore.IndexResolution(Predef$.MODULE$.Integer2int((Integer)KafkaDataStoreParams$.MODULE$.IndexResolutionX().lookup(params)), Predef$.MODULE$.Integer2int((Integer)KafkaDataStoreParams$.MODULE$.IndexResolutionY().lookup(params)));
                ssiTiers = this.parseSsiTiers(params);
                lazyDeserialization = (Boolean)KafkaDataStoreParams$.MODULE$.LazyFeatures().lookup(params);
                simple = KafkaDataStoreParams$.MODULE$.CacheExpiry().lookupOpt(params);
                advanced = this.parseDynamicExpiry(params);
                eventTime = KafkaDataStoreParams$.MODULE$.EventTime().lookupOpt(params);
                v3 = ordered = eventTime.isDefined() != false && (Boolean)KafkaDataStoreParams$.MODULE$.EventTimeOrdering().lookup(params) != false;
                if (!advanced.isEmpty()) ** GOTO lbl80
                var37_31 = false;
                var38_32 = null;
                var39_33 = simple.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildConfig$6$adapted(scala.concurrent.duration.Duration ), (Lscala/concurrent/duration/Duration;)Ljava/lang/Object;)());
                if (!None$.MODULE$.equals(var39_33)) break block22;
                v4 /* !! */  = KafkaDataStore$NeverExpireConfig$.MODULE$;
                break block23;
            }
            if (!(var39_33 instanceof Some)) ** GOTO lbl-1000
            var37_31 = true;
            var38_32 = (Some)var39_33;
            e = (Duration)var38_32.value();
            if (e.length() == 0L) {
                v4 /* !! */  = KafkaDataStore$ImmediatelyExpireConfig$.MODULE$;
            } else if (var37_31) {
                e = (Duration)var38_32.value();
                v4 /* !! */  = (Product)eventTime.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildConfig$7(scala.concurrent.duration.Duration boolean java.lang.String ), (Ljava/lang/String;)Lorg/locationtech/geomesa/kafka/data/KafkaDataStore$EventTimeConfig;)((Duration)e, (boolean)ordered)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$buildConfig$8(scala.concurrent.duration.Duration ), ()Lorg/locationtech/geomesa/kafka/data/KafkaDataStore$IngestTimeConfig;)((Duration)e));
            } else {
                throw new MatchError((Object)var39_33);
lbl80:
                // 1 sources

                withDefault = ((String)((Tuple2)advanced.last())._1()).equalsIgnoreCase("INCLUDE") != false ? advanced : (scala.collection.immutable.Seq)advanced.$colon$plus((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"INCLUDE"), simple.getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$buildConfig$9(), ()Lscala/concurrent/duration/Duration$Infinite;)())));
                var44_37 = eventTime;
                if (None$.MODULE$.equals(var44_37)) {
                    v5 = (scala.collection.immutable.Seq)withDefault.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildConfig$10(scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)());
                } else if (var44_37 instanceof Some) {
                    var45_38 = (Some)var44_37;
                    ev = (String)var45_38.value();
                    v5 = (scala.collection.immutable.Seq)withDefault.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildConfig$11(java.lang.String boolean scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Tuple2;)((String)ev, (boolean)ordered));
                } else {
                    throw new MatchError((Object)var44_37);
                }
                configs = v5;
                v4 /* !! */  = new KafkaDataStore.FilteredExpiryConfig((scala.collection.immutable.Seq<Tuple2<String, KafkaDataStore.ExpiryTimeConfig>>)configs);
            }
        }
        expiry = v4 /* !! */ ;
        executor = KafkaDataStoreParams$.MODULE$.ExecutorTicker().lookupOpt(params);
        indices = new KafkaDataStore.IndexConfig(expiry, buckets, ssiTiers, (scala.collection.immutable.Seq<Tuple2<String, Enumeration.Value>>)cqEngine, lazyDeserialization, (Option<Tuple2<ScheduledExecutorService, Ticker>>)executor);
        looseBBox = (Boolean)KafkaDataStoreParams$.MODULE$.LooseBBox().lookup(params);
        audit = Predef$.MODULE$.Boolean2boolean((Boolean)KafkaDataStoreParams$.MODULE$.AuditQueries().lookup(params)) == false ? None$.MODULE$ : new Some((Object)new AuditWriter.AuditLogger("kafka", AuditProvider.Loader.loadOrNone(params)));
        authProvider = this.buildAuthProvider(params);
        layerViews = this.parseLayerViewConfig(params);
        metrics = KafkaDataStoreParams$.MODULE$.MetricsReporters().lookupOpt(params).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildConfig$12(java.lang.String java.lang.String ), (Ljava/lang/String;)Lorg/locationtech/geomesa/metrics/core/GeoMesaMetrics;)((String)catalog));
        ns = Option$.MODULE$.apply((Object)((String)KafkaDataStoreParams$.MODULE$.NamespaceParam().lookUp(params)));
        new .colon.colon(KafkaDataStoreParams$.MODULE$.CacheCleanup(), (List)new .colon.colon(KafkaDataStoreParams$.MODULE$.CacheConsistency(), (List)new .colon.colon(KafkaDataStoreParams$.MODULE$.CacheTicker(), (List)Nil$.MODULE$))).foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$buildConfig$13$adapted(java.util.Map org.locationtech.geomesa.utils.geotools.GeoMesaParam ), (Lorg/locationtech/geomesa/utils/geotools/GeoMesaParam;)Ljava/lang/Object;)(params));
        return new KafkaDataStore.KafkaDataStoreConfig(catalog, brokers, (Option<String>)zookeepers, consumers, producers, Predef$.MODULE$.Boolean2boolean(clearOnStart), topics, serialization, indices, looseBBox, layerViews, authProvider, (Option<AuditWriter>)audit, (Option<GeoMesaMetrics>)metrics, (Option<String>)ns);
    }

    public GeoMessageSerializer.GeoMessageSerializerFactory buildSerializer(Map<String, ?> params) {
        String serialization = (String)KafkaDataStoreParams$.MODULE$.SerializationType().lookup(params);
        Enumeration.Value serializationType = KafkaDataStoreParams$SerializationTypes$.MODULE$.fromName(serialization);
        scala.collection.immutable.Set<Enumeration.Value> nativeOpts = KafkaDataStoreParams$SerializationTypes$.MODULE$.opts(serialization);
        scala.collection.immutable.Set lazyOpts = (Boolean)KafkaDataStoreParams$.MODULE$.LazyFeatures().lookup(params) != false ? (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Enumeration.Value[]{SerializationOption$.MODULE$.Lazy()})) : Predef$.MODULE$.Set().empty();
        return new GeoMessageSerializer.GeoMessageSerializerFactory(serializationType, (scala.collection.immutable.Set<Enumeration.Value>)((scala.collection.immutable.Set)nativeOpts.$plus$plus((IterableOnce)lazyOpts)));
    }

    private AuthorizationsProvider buildAuthProvider(Map<String, ?> params) {
        scala.collection.immutable.Seq auths = (scala.collection.immutable.Seq)KafkaDataStoreParams$.MODULE$.Authorizations().lookupOpt(params).map((Function1 & Serializable)x$7 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filterNot$extension(Predef$.MODULE$.refArrayOps((Object[])x$7.split(",")), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.isEmpty()))))).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)scala.package$.MODULE$.Seq().empty());
        return AuthUtils$.MODULE$.getProvider(params, auths);
    }

    public scala.collection.immutable.Seq<Tuple2<Object, Object>> parseSsiTiers(Map<String, ?> params) {
        return (scala.collection.immutable.Seq)KafkaDataStoreParams$.MODULE$.IndexTiers().lookupOpt(params).flatMap((Function1 & Serializable)tiers -> this.parse$1((String)tiers)).getOrElse((Function0 & Serializable)() -> SizeSeparatedBucketIndex$.MODULE$.DefaultTiers());
    }

    public scala.collection.immutable.Seq<Tuple2<String, Duration>> parseDynamicExpiry(Map<String, ?> params) {
        LazyRef key$lzy = new LazyRef();
        scala.collection.immutable.Seq expiry = (scala.collection.immutable.Seq)Option$.MODULE$.option2Iterable(KafkaDataStoreParams$.MODULE$.DynamicCacheExpiry().lookupOpt(params)).toSeq().flatMap((Function1 & Serializable)value -> (scala.collection.immutable.Seq)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(ConfigFactory.parseString((String)value).resolve().root().unwrapped()).asScala()).toSeq().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String filter = (String)tuple2._1();
                Object exp = tuple2._2();
                if (exp instanceof String) {
                    Duration duration;
                    String string = (String)exp;
                    try {
                        ECQL.toFilter((String)filter);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            throw new IOException(new StringBuilder(33).append(KafkaDataStoreFactory$.key$1(key$lzy)).append(", expected a CQL filter but got: ").append(filter).toString(), e);
                        }
                        throw throwable;
                    }
                    try {
                        duration = Duration$.MODULE$.apply(string);
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && !(option = NonFatal$.MODULE$.unapply(throwable3)).isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            throw new IOException(new StringBuilder(42).append(KafkaDataStoreFactory$.key$1(key$lzy)).append(", expected a duration for key '").append(filter).append("' but got: ").append(string).toString(), e);
                        }
                        throw throwable;
                    }
                    Duration duration2 = duration;
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)filter), (Object)duration2);
                }
            }
            if (tuple2 != null) {
                String filter = (String)tuple2._1();
                Object exp = tuple2._2();
                throw new IOException(new StringBuilder(45).append(KafkaDataStoreFactory$.key$1(key$lzy)).append(", expected a JSON string for key '").append(filter).append("' but got: ").append(exp).toString());
            }
            throw new MatchError((Object)tuple2);
        }));
        if (((IterableOnceOps)expiry.dropRight(1)).exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)KafkaDataStoreFactory$.$anonfun$parseDynamicExpiry$3(x$10)))) {
            throw new IOException(new StringBuilder(70).append(KafkaDataStoreFactory$.key$1(key$lzy)).append(", defined a filter after Filter.INCLUDE (which would never be invoked)").toString());
        }
        return expiry;
    }

    public scala.collection.immutable.Map<String, scala.collection.immutable.Seq<KafkaDataStore.LayerViewConfig>> parseLayerViewConfig(Map<String, ?> params) {
        Option option = KafkaDataStoreParams$.MODULE$.LayerViews().lookupOpt(params);
        if (None$.MODULE$.equals(option)) {
            return Predef$.MODULE$.Map().empty();
        }
        if (option instanceof Some) {
            scala.collection.immutable.Seq typeNames;
            Some some = (Some)option;
            String conf = (String)some.value();
            Config config = ConfigFactory.parseString((String)conf).resolve();
            Set entries = (Set)((IterableOps)JavaConverters$.MODULE$.asScalaSetConverter(config.entrySet()).asScala()).map((Function1 & Serializable)e -> {
                .colon.colon colon2;
                ConfigValue configValue = (ConfigValue)e.getValue();
                if (configValue instanceof ConfigList) {
                    ConfigList configList = (ConfigList)configValue;
                    colon2 = (Seq)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)configList).asScala()).map((Function1 & Serializable)o -> KafkaDataStoreFactory$.asConfigObject$1(o));
                } else {
                    colon2 = new .colon.colon((Object)KafkaDataStoreFactory$.asConfigObject$1(configValue), (List)Nil$.MODULE$);
                }
                .colon.colon views = colon2;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(e.getKey()), views.map((Function1 & Serializable)c -> (KafkaDataStore.LayerViewConfig)ConfigSource$.MODULE$.fromConfig(c.toConfig()).loadOrThrow(MODULE$.LayerViewClassTag(), MODULE$.LayerViewReader())));
            });
            Set configs = (Set)entries.map((Function1 & Serializable)f -> new Tuple2(f._1(), (Object)((IterableOnceOps)f._2()).toSeq()));
            scala.collection.immutable.Seq seq = typeNames = (scala.collection.immutable.Seq)configs.toSeq().flatMap((Function1 & Serializable)x$11 -> (scala.collection.immutable.Seq)((IterableOps)x$11._2()).map((Function1 & Serializable)x$12 -> x$12.typeName()));
            Object object = typeNames.distinct();
            if (seq == null ? object != null : !seq.equals(object)) {
                throw new IllegalArgumentException(new StringBuilder(51).append("Detected duplicate type name in layer view config: ").append(config.root().render(ConfigRenderOptions.concise())).toString());
            }
            return configs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        throw new MatchError((Object)option);
    }

    private Either<ConfigReaderFailures, KafkaDataStore.LayerViewConfig> readLayerViewConfig(ConfigCursor cur) {
        Either config = cur.asObjectCursor().right().flatMap((Function1 & Serializable)obj -> obj.atKey("type-name").right().flatMap((Function1 & Serializable)x$13 -> x$13.asString()).right().flatMap((Function1 & Serializable)typeName -> MODULE$.readFilter(obj.atKeyOrUndefined("filter")).right().flatMap((Function1 & Serializable)filter -> MODULE$.readTransform(obj.atKeyOrUndefined("transform")).right().map((Function1 & Serializable)transform -> new KafkaDataStore.LayerViewConfig((String)typeName, (Option<Filter>)filter, (Option<scala.collection.immutable.Seq<String>>)transform)))));
        return config.right().flatMap((Function1 & Serializable)c -> {
            if (c.filter().isEmpty() && c.transform().isEmpty()) {
                String err = "LayerViews must define at least one of 'filter' or 'transform'";
                return cur.failed(new FailureReason(err){
                    private final String err$1;

                    public String description() {
                        return this.err$1;
                    }
                    {
                        this.err$1 = err$1;
                    }
                });
            }
            return scala.package$.MODULE$.Right().apply(c);
        });
    }

    private Either<ConfigReaderFailures, Option<Filter>> readFilter(ConfigCursor cur) {
        if (cur.isUndefined()) {
            return scala.package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        return cur.asString().right().flatMap((Function1 & Serializable)ecql -> {
            Right right;
            try {
                right = scala.package$.MODULE$.Right().apply((Object)new Some((Object)ECQL.toFilter((String)ecql)).filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)KafkaDataStoreFactory$.$anonfun$readFilter$2(x$14))));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    right = cur.failed((FailureReason)new CannotConvert(ecql, "Filter", e.toString()));
                }
                throw throwable;
            }
            return right;
        });
    }

    private Either<ConfigReaderFailures, Option<scala.collection.immutable.Seq<String>>> readTransform(ConfigCursor cur) {
        if (cur.isUndefined()) {
            return scala.package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        Either transforms = cur.asList().right().flatMap((Function1 & Serializable)list -> (Either)list.foldLeft((Object)scala.package$.MODULE$.Right().apply((Object)scala.package$.MODULE$.Seq().empty()), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Either res = (Either)tuple2._1();
                ConfigCursor elem = (ConfigCursor)tuple2._2();
                return res.right().flatMap((Function1 & Serializable)r -> elem.asString().right().map((Function1 & Serializable)x$15 -> (scala.collection.immutable.Seq)r.$colon$plus(x$15)));
            }
            throw new MatchError((Object)tuple2);
        }));
        return transforms.right().map((Function1 & Serializable)t -> {
            if (t.isEmpty()) {
                return None$.MODULE$;
            }
            return new Some(t);
        });
    }

    public String createCatalogTopic(Map<String, ?> params) {
        return (String)KafkaDataStoreParams$.MODULE$.Catalog().lookupOpt(params).map((Function1 & Serializable)p -> StringUtils.strip((String)p, (String)" /").replace("/", "-")).filterNot((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.isEmpty())).getOrElse((Function0 & Serializable)() -> MODULE$.DefaultCatalog());
    }

    public String createZkNamespace(Map<String, ?> params) {
        return (String)KafkaDataStoreParams$.MODULE$.ZkPath().lookupOpt(params).map((Function1 & Serializable)x$17 -> x$17.trim()).filterNot((Function1 & Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isEmpty())).map((Function1 & Serializable)p -> {
            if (p.startsWith("/")) {
                return p.substring(1).trim();
            }
            return p;
        }).map((Function1 & Serializable)p -> {
            if (p.endsWith("/")) {
                return p.substring(0, p.length() - 1).trim();
            }
            return p;
        }).filterNot((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)x$19.isEmpty())).getOrElse((Function0 & Serializable)() -> MODULE$.DefaultZkPath());
    }

    private String checkBrokerPorts(String brokers) {
        String string;
        if (brokers.indexOf(58) != -1) {
            return brokers;
        }
        try {
            string = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])brokers.split(",")), (Function1 & Serializable)b -> new StringBuilder(5).append(b.trim()).append(":9092").toString(), ClassTag$.MODULE$.apply(String.class))).mkString(",");
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                string = brokers;
            }
            throw throwable;
        }
        return string;
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$buildConfig$1(Properties x$2) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(x$2).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$buildConfig$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$buildConfig$3(Properties x$3) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(x$3).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$buildConfig$4() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ Tuple2 $anonfun$buildConfig$5(String attribute) {
        Tuple2 tuple2;
        try {
            Object object;
            String[] stringArray = attribute.split(":", 2);
            if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                throw new MatchError((Object)stringArray);
            }
            String name = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
            String indexType = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
            Tuple2 tuple22 = new Tuple2((Object)name, (Object)indexType);
            String name2 = (String)tuple22._1();
            String indexType2 = (String)tuple22._2();
            tuple2 = new Tuple2((Object)name2, (Object)CQIndexType$.MODULE$.withName(indexType2));
        }
        catch (MatchError matchError) {
            throw new IllegalArgumentException(new StringBuilder(30).append("Invalid CQEngine index value: ").append(attribute).toString());
        }
        return tuple2;
    }

    public static final /* synthetic */ KafkaDataStore.EventTimeConfig $anonfun$buildConfig$7(Duration e$1, boolean ordered$1, String x$6) {
        return new KafkaDataStore.EventTimeConfig(e$1, x$6, ordered$1);
    }

    public static final /* synthetic */ KafkaDataStore.IngestTimeConfig $anonfun$buildConfig$8(Duration e$1) {
        return new KafkaDataStore.IngestTimeConfig(e$1);
    }

    public static final /* synthetic */ Duration.Infinite $anonfun$buildConfig$9() {
        return Duration$.MODULE$.Inf();
    }

    public static final /* synthetic */ Tuple2 $anonfun$buildConfig$10(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String f = (String)tuple2._1();
            Duration e = (Duration)tuple2._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f), (Object)new KafkaDataStore.IngestTimeConfig(e));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Tuple2 $anonfun$buildConfig$11(String ev$1, boolean ordered$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String f = (String)tuple2._1();
            Duration e = (Duration)tuple2._2();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f), (Object)new KafkaDataStore.EventTimeConfig(e, ev$1, ordered$1));
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ GeoMesaMetrics $anonfun$buildConfig$12(String catalog$1, String conf) {
        Config config = ConfigFactory.parseString((String)conf).resolve();
        .colon.colon reporters = config.hasPath("reporters") ? (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(config.getConfigList("reporters")).asScala() : new .colon.colon((Object)config, (List)Nil$.MODULE$);
        return GeoMesaMetrics$.MODULE$.apply(catalog$1, reporters.toSeq());
    }

    public static final /* synthetic */ void $anonfun$buildConfig$13(Map params$1, GeoMesaParam p) {
        if (params$1.containsKey(p.key)) {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isWarnEnabled()) {
                MODULE$.logger().underlying().warn("Parameter '{}' is deprecated, and no longer has any effect", (Object)p.key);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    private final Option parse$1(String tiers) {
        Some some;
        try {
            Tuple2[] parsed = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])tiers.split(",")), (Function1 & Serializable)xy -> {
                Object object;
                String[] stringArray = xy.split(":");
                if (stringArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)stringArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String x = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
                String y = (String)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
                Tuple2 tuple2 = new Tuple2((Object)x, (Object)y);
                String x2 = (String)tuple2._1();
                String y2 = (String)tuple2._2();
                return new Tuple2.mcDD.sp(StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x2)), StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(y2)));
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            some = new Some(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])parsed)).sorted(Ordering$.MODULE$.Tuple2((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$, (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("Ignoring invalid index tiers '{}': {}", new Object[]{tiers, e.toString()});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    private static final /* synthetic */ String key$lzycompute$1(LazyRef key$lzy$1) {
        String string;
        LazyRef lazyRef = key$lzy$1;
        synchronized (lazyRef) {
            string = key$lzy$1.initialized() ? (String)key$lzy$1.value() : (String)key$lzy$1.initialize((Object)new StringBuilder(33).append("Invalid property for parameter '").append(KafkaDataStoreParams$.MODULE$.DynamicCacheExpiry().key).append("'").toString());
        }
        return string;
    }

    private static final String key$1(LazyRef key$lzy$1) {
        if (key$lzy$1.initialized()) {
            return (String)key$lzy$1.value();
        }
        return KafkaDataStoreFactory$.key$lzycompute$1(key$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$parseDynamicExpiry$3(Tuple2 x$10) {
        return ((String)x$10._1()).equalsIgnoreCase("INCLUDE");
    }

    private static final ConfigObject asConfigObject$1(Object o) {
        Object object = o;
        if (object instanceof ConfigObject) {
            ConfigObject configObject = (ConfigObject)object;
            return configObject;
        }
        throw new IllegalArgumentException(new StringBuilder(54).append("Invalid layer view, expected a config object but got: ").append(o).toString());
    }

    public static final /* synthetic */ boolean $anonfun$readFilter$2(Filter x$14) {
        Filter filter = x$14;
        IncludeFilter includeFilter = Filter.INCLUDE;
        return filter == null ? includeFilter != null : !filter.equals(includeFilter);
    }

    private KafkaDataStoreFactory$() {
    }

    public static final /* synthetic */ Object $anonfun$buildConfig$6$adapted(Duration x$5) {
        return BoxesRunTime.boxToBoolean((boolean)x$5.isFinite());
    }

    public static final /* synthetic */ Object $anonfun$buildConfig$13$adapted(Map params$1, GeoMesaParam p) {
        KafkaDataStoreFactory$.$anonfun$buildConfig$13(params$1, p);
        return BoxedUnit.UNIT;
    }
}

